/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotCreateOptions;
import org.dasein.cloud.compute.SnapshotFilterOptions;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulSnapshotTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String provisionedSnapshotId;
    private String testShareAccount;
    private String testSnapshotId;
    private String testSourceRegion;
    private String testVolumeId;
    private String testDataCenterId;
    private String testVmId;
    private String snapshotId;
    private static int postfix;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulSnapshotTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        try {
            this.testDataCenterId = System.getProperty("test.dataCenter");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            if (this.testDataCenterId == null) {
                this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        ComputeServices services = tm.getProvider().getComputeServices();
        SnapshotSupport support = null;
        if (services != null) {
            support = services.getSnapshotSupport();
        }
        if (this.name.getMethodName().equals("createSnapshot")) {
            this.testVolumeId = tm.getTestVolumeId("stateful", true, null, this.testDataCenterId);
            if (this.testVolumeId == null || support == null) return;
            try {
                VolumeSupport volumeSupport;
                VirtualMachine vm;
                String vmId;
                if (!support.getCapabilities().identifyAttachmentRequirement().equals((Object)Requirement.REQUIRED) || (vmId = tm.getTestVMId("stateful" + postfix++, VmState.RUNNING, true, this.testDataCenterId)) == null || (vm = services.getVirtualMachineSupport().getVirtualMachine(vmId)) == null || (volumeSupport = services.getVolumeSupport()) == null) return;
                for (String deviceId : volumeSupport.getCapabilities().listPossibleDeviceIds(vm.getPlatform())) {
                    try {
                        volumeSupport.attach(this.testVolumeId, vmId, deviceId);
                        return;
                    }
                    catch (Throwable ignore) {
                    }
                }
                return;
            }
            catch (Throwable ignore) {
                return;
            }
        }
        if (this.name.getMethodName().equals("copySnapshot")) {
            if (support == null) return;
            Snapshot sourceSnapshot = null;
            try {
                block23: for (Region r : tm.getProvider().getDataCenterServices().listRegions()) {
                    if (r.getProviderRegionId().equals(tm.getContext().getRegionId())) continue;
                    for (Snapshot snapshot : support.listSnapshots()) {
                        if (!snapshot.getCurrentState().equals((Object)SnapshotState.AVAILABLE)) continue;
                        sourceSnapshot = snapshot;
                        continue block23;
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (sourceSnapshot == null) return;
            this.testSnapshotId = sourceSnapshot.getProviderSnapshotId();
            this.testSourceRegion = sourceSnapshot.getRegionId();
            return;
        }
        if (this.name.getMethodName().equals("filterSnapshots")) {
            if (support == null) return;
            try {
                this.testSnapshotId = DaseinTestManager.getComputeResources().provisionSnapshot(support, "filter", "dsnfilter", null);
                return;
            }
            catch (Throwable t) {
                tm.warn("Failed to provision test VM for snapshot filter test: " + t.getMessage());
            }
            return;
        }
        if (this.name.getMethodName().equals("removeSnapshot")) {
            this.testSnapshotId = tm.getTestSnapshotId("removed", true);
            if (this.testSnapshotId == null) return;
            long timeout = System.currentTimeMillis() + 300000L;
            while (timeout > System.currentTimeMillis()) {
                block34: {
                    try {
                        Snapshot s = support.getSnapshot(this.testSnapshotId);
                        if (s != null && SnapshotState.PENDING.equals((Object)s.getCurrentState())) break block34;
                        return;
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
            return;
        }
        this.testSnapshotId = tm.getTestSnapshotId("stateful", true);
        this.testShareAccount = System.getProperty("shareAccount");
        if ((this.name.getMethodName().equals("addPrivateShare") || this.name.getMethodName().equals("addPublicShare") || this.name.getMethodName().equals("removePrivateShare") || this.name.getMethodName().equals("removePublicShare") || this.name.getMethodName().equals("removeAllShares")) && support != null) {
            try {
                support.removeAllSnapshotShares(this.testSnapshotId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (this.testShareAccount != null && (this.name.getMethodName().equals("removePrivateShare") || this.name.getMethodName().equals("removeAllShares")) && support != null) {
            try {
                support.addSnapshotShare(this.testSnapshotId, this.testShareAccount);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (!this.name.getMethodName().equals("removePublicShare") && !this.name.getMethodName().equals("removeAllShares") || support == null) return;
        try {
            support.addPublicShare(this.testSnapshotId);
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            SnapshotSupport support;
            ComputeServices services;
            if (this.provisionedSnapshotId != null && (services = tm.getProvider().getComputeServices()) != null && (support = services.getSnapshotSupport()) != null) {
                try {
                    support.remove(this.provisionedSnapshotId);
                }
                catch (Throwable t) {
                    tm.warn("Failed to clean up provisioned test snapshot " + this.provisionedSnapshotId + ": " + t.getMessage());
                }
            }
            this.provisionedSnapshotId = null;
            this.testSnapshotId = null;
            this.testSourceRegion = null;
            this.testVolumeId = null;
            this.testShareAccount = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void filterSnapshots() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable snapshots = support.listSnapshots(SnapshotFilterOptions.getInstance((String)".*[Ff][Ii][Ll][Tt][Ee][Rr].*"));
        boolean found = false;
        int count = 0;
        Assert.assertNotNull((String)"Filtering must return at least an empty collections and may not be null", (Object)snapshots);
        for (Snapshot snapshot : snapshots) {
            ++count;
            if (snapshot.getProviderSnapshotId().equals(this.testSnapshotId)) {
                found = true;
            }
            tm.out("Snapshot", snapshot);
        }
        tm.out("Total Snapshot Count", count);
        if (count < 1 && support.isSubscribed()) {
            if (this.testSnapshotId == null) {
                tm.warn("No snapshots were listed and thus the test may be in error");
            } else {
                Snapshot snapshot = support.getSnapshot(this.testSnapshotId);
                if (snapshot == null || !snapshot.getName().contains("dsnfilter")) {
                    tm.warn("This cloud did not retain the snapshot meta-data, so no snapshots match");
                    found = true;
                } else {
                    Assert.fail((String)("Should have found test snapshot " + this.testSnapshotId + ", but none were found"));
                }
            }
        }
        if (this.testSnapshotId != null) {
            Assert.assertTrue((String)("Did not find the test filter snapshot " + this.testSnapshotId + " among the filtered snapshots"), (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.warn("No test snapshots existed for filter test due to a lack of snapshot subscription, so results may not be valid");
        } else {
            Assert.fail((String)"Cannot test snapshot filtering without a test snapshot");
        }
    }

    @Test
    public void createSnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testVolumeId != null) {
            SnapshotCreateOptions options = SnapshotCreateOptions.getInstanceForCreate((String)this.testVolumeId, (String)("dsnsnap" + System.currentTimeMillis() % 10000L), (String)"Test Dasein Cloud Snapshot");
            if (support.isSubscribed()) {
                this.provisionedSnapshotId = options.build(tm.getProvider());
                tm.out("New Snapshot", this.provisionedSnapshotId);
                if (this.provisionedSnapshotId == null) {
                    tm.warn("It is possible to get null when making new snapshots, but this test is not truly valid");
                }
            } else {
                try {
                    this.provisionedSnapshotId = options.build(tm.getProvider());
                    Assert.fail((String)"Account claims not to be subscribed, but the snapshot creation succeeded");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException for unsubscribed account");
                }
            }
        } else if (support.isSubscribed()) {
            Assert.fail((String)"No test volume exists for creating a test snapshot");
        } else {
            tm.ok("The account is not subscribed for snapshot services");
        }
    }

    @Test
    public void copySnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (!support.getCapabilities().supportsSnapshotCopying()) {
            if (this.testSnapshotId == null) {
                this.testSnapshotId = "nonsense";
            }
            if (this.testSourceRegion == null) {
                this.testSourceRegion = "nonsense";
            }
            try {
                this.provisionedSnapshotId = support.createSnapshot(SnapshotCreateOptions.getInstanceForCopy((String)this.testSourceRegion, (String)this.testSnapshotId, (String)("dsnsnap" + System.currentTimeMillis() % 10000L), (String)"Test Dasein Cloud Snapshot"));
                Assert.fail((String)"No error occurred copying even though copying is not supported");
            }
            catch (OperationNotSupportedException e) {
                tm.ok("Snapshot copy unsupported");
            }
        } else if (this.testSnapshotId == null) {
            tm.warn("Unable to identify a source snapshot for test copy");
        } else {
            this.provisionedSnapshotId = support.createSnapshot(SnapshotCreateOptions.getInstanceForCopy((String)this.testSourceRegion, (String)this.testSnapshotId, (String)("dsnsnap" + System.currentTimeMillis() % 10000L), (String)"Test Dasein Cloud Snapshot"));
            tm.out("Snapshot Copy", this.provisionedSnapshotId);
            Assert.assertNotNull((String)"Copy must result in the creation of a new snapshot", (Object)this.provisionedSnapshotId);
        }
    }

    @Test
    public void removeSnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            Snapshot snapshot = support.getSnapshot(this.testSnapshotId);
            Assert.assertNotNull((String)"No test snapshot exists for removal test", (Object)snapshot);
            tm.out("Before", snapshot.getCurrentState());
            support.remove(this.testSnapshotId);
            snapshot = support.getSnapshot(this.testSnapshotId);
            tm.out("After", snapshot == null ? SnapshotState.DELETED : snapshot.getCurrentState());
            Assert.assertTrue((String)"The test snapshot still exists", (snapshot == null || SnapshotState.DELETED.equals((Object)snapshot.getCurrentState()) ? 1 : 0) != 0);
        } else if (!support.isSubscribed()) {
            tm.ok("This account is not subscribed for snapshot support, so this test cannot be run");
        } else {
            Assert.fail((String)"No test snapshot exists for executing this test");
        }
    }

    @Test
    public void listShares() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (support.getCapabilities().supportsSnapshotSharing()) {
            if (this.testSnapshotId != null) {
                Snapshot snapshot = support.getSnapshot(this.testSnapshotId);
                Assert.assertNotNull((String)"Failed to find the test snapshot among possible snapshots", (Object)snapshot);
                Iterable shares = support.listShares(this.testSnapshotId);
                tm.out("Image Shares", shares);
                Assert.assertNotNull((String)"Snapshot shares may not be null", (Object)shares);
            } else if (!support.isSubscribed()) {
                tm.warn("No snapshot ID was identified, so this test is not valid");
            } else {
                Assert.fail((String)("No test snapshot exists for " + this.name.getMethodName()));
            }
        } else {
            Iterable shares = support.listShares(this.testSnapshotId);
            Assert.assertTrue((String)"Snapshot sharing not supported, result should be empty list", (!shares.iterator().hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void addPrivateShare() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            if (this.testShareAccount != null) {
                Iterable shares = support.listShares(this.testSnapshotId);
                tm.out("Before", shares);
                if (support.getCapabilities().supportsSnapshotSharing()) {
                    support.addSnapshotShare(this.testSnapshotId, this.testShareAccount);
                    boolean found = false;
                    shares = support.listShares(this.testSnapshotId);
                    tm.out("After", shares);
                    for (String share : shares) {
                        if (!share.equals(this.testShareAccount)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((String)"Did not find the new share among the listed shares", (boolean)found);
                } else {
                    try {
                        support.addSnapshotShare(this.testSnapshotId, this.testShareAccount);
                        Assert.fail((String)"Private snapshot sharing is not supported, but the operation completed without error");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Caught OperationNotSupportedException while attempting to share a snapshot");
                    }
                }
            } else {
                tm.warn("Unable to test account sharing due to no shareAccount property having been set (test invalid)");
            }
        } else if (!support.isSubscribed()) {
            tm.warn("No snapshot ID was identified because snapshots are not subscribed, so this test is not valid");
        } else {
            Assert.fail((String)("No test snapshot exists for the " + this.name.getMethodName() + " test"));
        }
    }

    @Test
    public void removePrivateShare() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            if (this.testShareAccount != null) {
                Iterable shares = support.listShares(this.testSnapshotId);
                tm.out("Before", shares);
                if (support.getCapabilities().supportsSnapshotSharing()) {
                    support.removeSnapshotShare(this.testSnapshotId, this.testShareAccount);
                    boolean found = false;
                    shares = support.listShares(this.testSnapshotId);
                    tm.out("After", shares);
                    for (String share : shares) {
                        if (!share.equals(this.testShareAccount)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertFalse((String)"The test account remains among the shared accounts", (boolean)found);
                } else {
                    try {
                        support.removeSnapshotShare(this.testSnapshotId, this.testShareAccount);
                        Assert.fail((String)"Private image sharing is not supported, but the operation completed without error");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Caught OperationNotSupportedException while attempting to remove a snapshot share");
                    }
                }
            } else {
                tm.warn("Unable to test account share removal due to no shareAccount property having been set (test invalid)");
            }
        } else if (!support.isSubscribed()) {
            tm.warn("No snapshot ID was identified because snapshots are not subscribed, so this test is not valid");
        } else {
            Assert.fail((String)("No test snapshot exists for the " + this.name.getMethodName() + " test"));
        }
    }

    @Test
    public void addPublicShare() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            if (support.getCapabilities().supportsSnapshotSharingWithPublic()) {
                tm.out("Before", support.isPublic(this.testSnapshotId));
                support.addPublicShare(this.testSnapshotId);
                boolean shared = support.isPublic(this.testSnapshotId);
                tm.out("After", shared);
                Assert.assertTrue((String)"Image remains private", (boolean)shared);
            } else {
                try {
                    support.addPublicShare(this.testSnapshotId);
                    Assert.fail((String)"Public snapshot sharing is not supported, but the public share operation succeeded");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException while attempting to add a public snapshot share");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.warn("No snapshot ID was identified due to lack of subscription, so this test is not valid");
        } else {
            Assert.fail((String)("No test snapshot exists for the " + this.name.getMethodName() + " test"));
        }
    }

    @Test
    public void removePublicShare() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            if (support.getCapabilities().supportsSnapshotSharingWithPublic()) {
                tm.out("Before", support.isPublic(this.testSnapshotId));
                support.removePublicShare(this.testSnapshotId);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                boolean shared = support.isPublic(this.testSnapshotId);
                tm.out("After", shared);
                Assert.assertFalse((String)"Snapshot remains public", (boolean)shared);
            } else {
                try {
                    support.removePublicShare(this.testSnapshotId);
                    Assert.fail((String)"Public snapshot sharing is not supported, but the public share operation succeeded");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException while attempting to remove a public snapshot share");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.warn("No snapshot ID was identified due to lack of subscription, so this test is not valid");
        } else {
            Assert.fail((String)("No test snapshot exists for the " + this.name.getMethodName() + " test"));
        }
    }

    @Test
    public void removeAllShares() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId != null) {
            tm.out("Before [Public]", support.isPublic(this.testSnapshotId));
            tm.out("Before [Private]", support.listShares(this.testSnapshotId));
            try {
                support.removeAllSnapshotShares(this.testSnapshotId);
            }
            catch (OperationNotSupportedException e) {
                Assert.fail((String)"This operation should not throw an OperationNotSupportedException (just a NO-OP in clouds without sharing)");
            }
            boolean shared = support.isPublic(this.testSnapshotId);
            Iterable shares = support.listShares(this.testSnapshotId);
            tm.out("After [Public]", shared);
            tm.out("After [Private]", shares);
            Assert.assertFalse((String)"Snapshot remains public", (boolean)shared);
            Assert.assertFalse((String)"Snapshot still has private shares", (boolean)shares.iterator().hasNext());
        } else if (!support.isSubscribed()) {
            tm.warn("No snapshot ID was identified due to lack of subscription, so this test is not valid");
        } else {
            Assert.fail((String)("No test snapshot exists for the " + this.name.getMethodName() + " test"));
        }
    }

    static {
        postfix = 1;
    }
}

