/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.AffinityGroupFilterOptions;
import org.dasein.cloud.compute.AffinityGroupSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.VMFilterOptions;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.compute.ComputeResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulVMTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testVmId = null;
    private String testDataCenterId;
    private String testResourcePoolId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulVMTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Nullable
    private VirtualMachine awaitState(@Nonnull VirtualMachine vm, @Nonnull VmState targetState, @Nonnegative long timeout) {
        VmState currentState = vm.getCurrentState();
        VirtualMachine v = vm;
        int gone = 0;
        while (System.currentTimeMillis() < timeout) {
            if (targetState.equals((Object)currentState)) {
                return v;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                v = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(vm.getProviderVirtualMachineId());
                if (v == null && !targetState.equals((Object)VmState.TERMINATED)) {
                    if (++gone <= 10) continue;
                    return null;
                }
                if (v == null) {
                    return null;
                }
                currentState = v.getCurrentState();
            }
            catch (Throwable ignore) {}
        }
        return v;
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        try {
            this.testDataCenterId = System.getProperty("test.dataCenter");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            if (this.testDataCenterId == null) {
                this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("filterVMs")) {
            VirtualMachineSupport support;
            ComputeServices services = tm.getProvider().getComputeServices();
            if (services != null && (support = services.getVirtualMachineSupport()) != null) {
                try {
                    this.testVmId = DaseinTestManager.getComputeResources().provisionVM(support, "filter", "Dasein Filter Test", "dsnfilter", this.testDataCenterId);
                }
                catch (Throwable t) {
                    tm.warn("Failed to provisionKeypair VM for filter test: " + t.getMessage());
                }
            }
        } else if (this.name.getMethodName().equals("terminate")) {
            this.testVmId = tm.getTestVMId("removed", VmState.RUNNING, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("start")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.STOPPED, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("stop")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("modifyInstance")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.STOPPED, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("pause")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("unpause")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.PAUSED, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("suspend")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
        } else if (this.name.getMethodName().equals("resume")) {
            this.testVmId = tm.getTestVMId("stateful", VmState.SUSPENDED, true, this.testDataCenterId);
        } else if (!this.name.getMethodName().startsWith("launchVMWith")) {
            this.testVmId = tm.getTestVMId("stateful", null, true, this.testDataCenterId);
        }
    }

    @After
    public void after() {
        this.testVmId = null;
        tm.end();
    }

    @Test
    public void disableAnalytics() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    support.disableAnalytics(this.testVmId);
                } else {
                    tm.warn("No test virtual machine was found for testing enabling analytics");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void enableAnalytics() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    support.enableAnalytics(this.testVmId);
                } else {
                    tm.warn("No test virtual machine was found for testing enabling analytics");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void launch() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (support.isSubscribed()) {
                    String id = DaseinTestManager.getComputeResources().provisionVM(support, "testLaunch", "dasein-test-launch", tm.getUserName() + "dsnlaunch", this.testDataCenterId);
                    tm.out("Launched", id);
                    Assert.assertNotNull((String)"Attempts to provisionVM a virtual machine MUST return a valid ID", (Object)id);
                    Assert.assertNotNull((String)"Could not find the newly created virtual machine", (Object)support.getVirtualMachine(id));
                } else {
                    try {
                        DaseinTestManager.getComputeResources().provisionVM(support, "failure", "Should Fail", "failure", this.testDataCenterId);
                        Assert.fail((String)"Attempt to launch VM should not succeed when the account is not subscribed to virtual machine services");
                    }
                    catch (CloudException ok) {
                        tm.ok("Got exception when not subscribed: " + ok.getMessage());
                    }
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void launchMany() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (support.isSubscribed()) {
                    Iterable<String> ids = DaseinTestManager.getComputeResources().provisionManyVMs(support, "testLaunch", "dasein-test-launch", tm.getUserName() + "dsnlaunch", this.testDataCenterId, 2);
                    int count = 0;
                    for (String id : ids) {
                        tm.out("Launched", id);
                        Assert.assertNotNull((String)"Attempts to provisionVM a virtual machine MUST return a valid ID", (Object)id);
                        Assert.assertNotNull((String)"Could not find the newly created virtual machine", (Object)support.getVirtualMachine(id));
                        ++count;
                    }
                    Assert.assertEquals((String)"Two virtual machines were not launched", (long)2L, (long)count);
                } else {
                    try {
                        DaseinTestManager.getComputeResources().provisionVM(support, "failure", "Should Fail", "failure", this.testDataCenterId);
                        Assert.fail((String)"Attempt to launch VM should not succeed when the account is not subscribed to virtual machine services");
                    }
                    catch (CloudException ok) {
                        tm.ok("Got exception when not subscribed: " + ok.getMessage());
                    }
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void launchVMWithResourcePool() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices dcServices = tm.getProvider().getDataCenterServices();
        if (dcServices != null) {
            if (dcServices.getCapabilities().supportsResourcePools()) {
                ComputeServices services = tm.getProvider().getComputeServices();
                if (services != null) {
                    VirtualMachineSupport support = services.getVirtualMachineSupport();
                    if (support != null) {
                        if (support.isSubscribed()) {
                            ComputeResources compute = DaseinTestManager.getComputeResources();
                            String productId = null;
                            if (compute != null) {
                                boolean foundResourcePool = false;
                                for (Architecture a : support.getCapabilities().listSupportedArchitectures()) {
                                    Iterable products = support.listProducts(a);
                                    for (VirtualMachineProduct p : products) {
                                        if (p.getProviderProductId().split(":").length != 3) continue;
                                        productId = p.getProviderProductId();
                                        foundResourcePool = true;
                                        break;
                                    }
                                    if (!foundResourcePool) continue;
                                    break;
                                }
                                if (foundResourcePool) {
                                    this.testResourcePoolId = productId.split(":")[0];
                                }
                                Assert.assertNotNull((String)"Unable to identify a VM product for test launch", productId);
                                Assert.assertNotNull((String)"Unable to identify a resource pool for test launch", (Object)this.testResourcePoolId);
                                String imageId = tm.getTestImageId("stateless", false);
                                Assert.assertNotNull((String)"Unable to identify a test image for test launch", (Object)imageId);
                                VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnrespool" + System.currentTimeMillis() % 10000L), (String)("Dasein Resource Pool Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a resource pool");
                                options.inDataCenter(this.testDataCenterId);
                                options.withResourcePoolId(this.testResourcePoolId);
                                String id = compute.provisionVM(support, "resourcePoolLaunch", options, options.getDataCenterId());
                                tm.out("Launched", id);
                                Assert.assertNotNull((String)"Attempts to provisionVM a virtual machine MUST return a valid ID", (Object)id);
                                VirtualMachine virtualMachine = support.getVirtualMachine(id);
                                tm.out("In resource pool", virtualMachine.getResourcePoolId());
                                Assert.assertNotNull((String)"Could not find the newly created virtual machine", (Object)virtualMachine);
                                Assert.assertEquals((String)("Expected resource pool not found " + this.testResourcePoolId), (Object)this.testResourcePoolId, (Object)virtualMachine.getResourcePoolId());
                            }
                        } else {
                            try {
                                DaseinTestManager.getComputeResources().provisionVM(support, "failure", "Should Fail", "failure", null);
                                Assert.fail((String)"Attempt to launch VM should not succeed when the account is not subscribed to virtual machine services");
                            }
                            catch (CloudException ok) {
                                tm.ok("Got exception when not subscribed: " + ok.getMessage());
                            }
                        }
                    } else {
                        tm.ok("No virtual machine support in this cloud");
                    }
                } else {
                    tm.ok("No compute services in this cloud");
                }
            } else {
                tm.ok("Resource pools not supported in this cloud");
            }
        } else {
            tm.ok("No datacenter services in this cloud");
        }
    }

    @Test
    public void launchVMWithAffinityGroup() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices dcServices = tm.getProvider().getDataCenterServices();
        if (dcServices != null) {
            if (dcServices.getCapabilities().supportsAffinityGroups()) {
                ComputeServices services = tm.getProvider().getComputeServices();
                if (services != null) {
                    AffinityGroupFilterOptions agFilterOptions;
                    AffinityGroupSupport affinityGroupSupport = services.getAffinityGroupSupport();
                    Iterable affinityGroup = affinityGroupSupport.list(agFilterOptions = AffinityGroupFilterOptions.getInstance().withDataCenterId(this.testDataCenterId));
                    if (affinityGroup.iterator().hasNext()) {
                        String testAffinityGroupId = ((AffinityGroup)affinityGroup.iterator().next()).getAffinityGroupId();
                        VirtualMachineSupport support = services.getVirtualMachineSupport();
                        if (support != null) {
                            if (support.isSubscribed()) {
                                ComputeResources compute = DaseinTestManager.getComputeResources();
                                if (compute != null) {
                                    String productId = tm.getTestVMProductId();
                                    Assert.assertNotNull((String)"Unable to identify a VM product for test launch", (Object)productId);
                                    String imageId = tm.getTestImageId("stateless", false);
                                    Assert.assertNotNull((String)"Unable to identify a test image for test launch", (Object)imageId);
                                    VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnAffinity" + System.currentTimeMillis() % 10000L), (String)("Dasein Affinity Group Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in an affinity group");
                                    options.inDataCenter(this.testDataCenterId);
                                    options.withAffinityGroupId(testAffinityGroupId);
                                    String id = compute.provisionVM(support, "affinityGroupLaunch", options, options.getDataCenterId());
                                    tm.out("Launched", id);
                                    Assert.assertNotNull((String)"Attempts to provisionVM a virtual machine MUST return a valid ID", (Object)id);
                                    VirtualMachine vm = support.getVirtualMachine(id);
                                    Assert.assertNotNull((String)"Could not find the newly created virtual machine", (Object)vm);
                                    long timeout = System.currentTimeMillis() + 300000L;
                                    while (timeout > System.currentTimeMillis() && vm != null && vm.getAffinityGroupId() == null) {
                                        try {
                                            Thread.sleep(15000L);
                                        }
                                        catch (InterruptedException ignore) {
                                            // empty catch block
                                        }
                                        try {
                                            vm = support.getVirtualMachine(id);
                                        }
                                        catch (Throwable ignore) {}
                                    }
                                    tm.out("In affinity group", vm.getAffinityGroupId());
                                    Assert.assertNotNull((String)"Launched VM does not exist", (Object)vm);
                                    Assert.assertEquals((String)("Expected affinity group not found " + testAffinityGroupId), (Object)testAffinityGroupId, (Object)vm.getAffinityGroupId());
                                }
                            } else {
                                try {
                                    DaseinTestManager.getComputeResources().provisionVM(support, "failure", "Should Fail", "failure", null);
                                    Assert.fail((String)"Attempt to launch VM should not succeed when the account is not subscribed to virtual machine services");
                                }
                                catch (CloudException ok) {
                                    tm.ok("Got exception when not subscribed: " + ok.getMessage());
                                }
                            }
                        } else {
                            tm.ok("No virtual machine support in this cloud");
                        }
                    } else {
                        Assert.fail((String)"No test affinity group found: test invalid");
                    }
                } else {
                    tm.ok("No compute services in this cloud");
                }
            } else {
                tm.ok("Affinity groups not supported in this cloud");
            }
        } else {
            tm.ok("No datacenter services in this cloud");
        }
    }

    @Test
    public void launchVMWithStoragePool() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices dcServices = tm.getProvider().getDataCenterServices();
        if (dcServices != null) {
            if (dcServices.getCapabilities().supportsStoragePools()) {
                Collection pools = dcServices.listStoragePools();
                if (pools.iterator().hasNext()) {
                    String testStoragePoolId = "";
                    for (StoragePool pool : pools) {
                        String dataCenterId = pool.getDataCenterId();
                        if (dataCenterId != null && !dataCenterId.equals(this.testDataCenterId)) continue;
                        testStoragePoolId = pool.getStoragePoolName();
                        break;
                    }
                    if (!testStoragePoolId.equals("")) {
                        ComputeServices services = tm.getProvider().getComputeServices();
                        if (services != null) {
                            VirtualMachineSupport support = services.getVirtualMachineSupport();
                            if (support != null) {
                                if (support.isSubscribed()) {
                                    ComputeResources compute = DaseinTestManager.getComputeResources();
                                    if (compute != null) {
                                        Map tags;
                                        String productId = tm.getTestVMProductId();
                                        Assert.assertNotNull((String)"Unable to identify a VM product for test launch", (Object)productId);
                                        String imageId = tm.getTestImageId("stateless", false);
                                        Assert.assertNotNull((String)"Unable to identify a test image for test launch", (Object)imageId);
                                        VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnStorage" + System.currentTimeMillis() % 10000L), (String)("Dasein Storage Pool Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a storage pool");
                                        options.inDataCenter(this.testDataCenterId);
                                        options.withStoragePoolId(testStoragePoolId);
                                        String id = compute.provisionVM(support, "storagePoolLaunch", options, options.getDataCenterId());
                                        tm.out("Launched", id);
                                        Assert.assertNotNull((String)"Attempts to provisionVM a virtual machine MUST return a valid ID", (Object)id);
                                        VirtualMachine vm = support.getVirtualMachine(id);
                                        Assert.assertNotNull((String)"Could not find the newly created virtual machine", (Object)vm);
                                        long timeout = System.currentTimeMillis() + 300000L;
                                        while (timeout > System.currentTimeMillis() && vm != null && !(tags = vm.getTags()).containsKey("datastore0")) {
                                            try {
                                                Thread.sleep(15000L);
                                            }
                                            catch (InterruptedException ignore) {
                                                // empty catch block
                                            }
                                            try {
                                                vm = support.getVirtualMachine(id);
                                            }
                                            catch (Throwable ignore) {}
                                        }
                                        boolean foundStoragePool = false;
                                        Map tags2 = vm.getTags();
                                        for (Map.Entry entry : tags2.entrySet()) {
                                            if (!((String)entry.getKey()).startsWith("datastore")) continue;
                                            tm.out("In storage pool " + (String)entry.getValue());
                                            if (!((String)entry.getValue()).equals(testStoragePoolId)) continue;
                                            foundStoragePool = true;
                                        }
                                        Assert.assertNotNull((String)"Launched VM does not exist", (Object)vm);
                                        Assert.assertTrue((String)("Expected storage pool not found " + testStoragePoolId), (boolean)foundStoragePool);
                                    }
                                } else {
                                    try {
                                        DaseinTestManager.getComputeResources().provisionVM(support, "failure", "Should Fail", "failure", null);
                                        Assert.fail((String)"Attempt to launch VM should not succeed when the account is not subscribed to virtual machine services");
                                    }
                                    catch (CloudException ok) {
                                        tm.ok("Got exception when not subscribed: " + ok.getMessage());
                                    }
                                }
                            } else {
                                tm.ok("No virtual machine support in this cloud");
                            }
                        } else {
                            tm.ok("No compute services in this cloud");
                        }
                    } else {
                        Assert.fail((String)("Couldn't find valid storage pool for datacenter " + this.testDataCenterId));
                    }
                } else {
                    Assert.fail((String)"No test storage pool was found");
                }
            } else {
                tm.ok("Storage pools not supported in this cloud");
            }
        } else {
            tm.ok("No datacenter services in this cloud");
        }
    }

    @Test
    public void filterVMs() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Iterable vms = support.listVirtualMachines(VMFilterOptions.getInstance((String)".*[Ff][Ii][Ll][Tt][Ee][Rr].*"));
                boolean found = false;
                int count = 0;
                Assert.assertNotNull((String)"Filtering must return at least an empty collections and may not be null", (Object)vms);
                for (VirtualMachine vm : vms) {
                    ++count;
                    if (vm.getProviderVirtualMachineId().equals(this.testVmId)) {
                        found = true;
                    }
                    tm.out("VM", vm);
                }
                tm.out("Total VM Count", count);
                if (count < 1 && support.isSubscribed()) {
                    if (this.testVmId == null) {
                        tm.warn("No virtual machines were listed and thus the test may be in error");
                    } else {
                        Assert.fail((String)("Should have found test virtual machine " + this.testVmId + ", but none were found"));
                    }
                }
                if (this.testVmId != null) {
                    Assert.assertTrue((String)("Did not find the test filter VM " + this.testVmId + " among the filtered VMs"), (boolean)found);
                } else {
                    tm.warn("No test VM existed for filter test, so results may not be valid");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void stop() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canStop(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.stop(this.testVmId, true);
                            vm = this.awaitState(vm, VmState.STOPPED, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.STOPPED, (Object)currentState);
                        } else {
                            try {
                                support.stop(this.testVmId);
                                Assert.fail((String)"Start/stop is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("STOP -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void modifyInstance() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canAlter(vm.getCurrentState())) {
                            tm.out("Before", vm.getProductId());
                            String modifiedProductId = null;
                            Iterable products = support.listProducts(vm.getArchitecture());
                            if (products.iterator().hasNext()) {
                                modifiedProductId = ((VirtualMachineProduct)products.iterator().next()).getProviderProductId();
                            }
                            support.alterVirtualMachine(this.testVmId, VMScalingOptions.getInstance(modifiedProductId));
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            vm = support.getVirtualMachine(this.testVmId);
                            if (vm != null) {
                                tm.out("After", vm.getProductId());
                                Assert.assertEquals((String)"Current product id does not match the target product id", (Object)modifiedProductId, (Object)vm.getProductId());
                            }
                        } else {
                            tm.ok("Alter vm not supported for vm state " + vm.getCurrentState());
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void start() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canStart(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.start(this.testVmId);
                            vm = this.awaitState(vm, VmState.RUNNING, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.RUNNING, (Object)currentState);
                        } else {
                            try {
                                support.start(this.testVmId);
                                Assert.fail((String)"Start/stop is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("START -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void pause() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canPause(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.pause(this.testVmId);
                            vm = this.awaitState(vm, VmState.PAUSED, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.PAUSED, (Object)currentState);
                        } else {
                            try {
                                support.pause(this.testVmId);
                                Assert.fail((String)"Pause/unpause is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("PAUSE -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void unpause() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canUnpause(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.unpause(this.testVmId);
                            vm = this.awaitState(vm, VmState.RUNNING, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.RUNNING, (Object)currentState);
                        } else {
                            try {
                                support.unpause(this.testVmId);
                                Assert.fail((String)"Pause/unpause is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("UNPAUSE -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void suspend() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canSuspend(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.suspend(this.testVmId);
                            vm = this.awaitState(vm, VmState.SUSPENDED, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.SUSPENDED, (Object)currentState);
                        } else {
                            try {
                                support.suspend(this.testVmId);
                                Assert.fail((String)"Suspend/resume is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("SUSPEND -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void resume() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        if (support.getCapabilities().canResume(vm.getCurrentState())) {
                            tm.out("Before", vm.getCurrentState());
                            support.resume(this.testVmId);
                            vm = this.awaitState(vm, VmState.RUNNING, System.currentTimeMillis() + 1200000L);
                            VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                            tm.out("After", currentState);
                            Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.RUNNING, (Object)currentState);
                        } else {
                            try {
                                support.resume(this.testVmId);
                                Assert.fail((String)"Suspend/resume is unsupported, yet the method completed without an error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("RESUME -> Operation not supported exception");
                            }
                        }
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void terminate() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVmId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVmId);
                    if (vm != null) {
                        tm.out("Before", vm.getCurrentState());
                        support.terminate(vm.getProviderVirtualMachineId());
                        vm = this.awaitState(vm, VmState.TERMINATED, System.currentTimeMillis() + 1200000L);
                        VmState currentState = vm == null ? VmState.TERMINATED : vm.getCurrentState();
                        tm.out("After", currentState);
                        Assert.assertEquals((String)"Current state does not match the target state", (Object)VmState.TERMINATED, (Object)currentState);
                    } else {
                        tm.warn("Test virtual machine " + this.testVmId + " no longer exists");
                    }
                } else {
                    tm.warn("No test virtual machine was found for this test");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

