/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFilterOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulVolumeTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String provisionedVolume;
    private String testSnapshotId;
    private String testVLANId;
    private String testVMId;
    private String testVolumeId;
    private String testDataCenterId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulVolumeTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        block60: {
            Volume v;
            String dc;
            tm.begin(this.name.getMethodName());
            Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
            try {
                this.testDataCenterId = System.getProperty("test.dataCenter");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (this.testDataCenterId == null) {
                    this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (this.name.getMethodName().equals("createNFSVolume")) {
                this.testVLANId = tm.getTestVLANId("stateless", false, this.testDataCenterId);
                if (this.testVLANId == null) {
                    this.testVLANId = tm.getTestVLANId("stateful", true, this.testDataCenterId);
                }
            } else if (this.name.getMethodName().equals("createFromSnapshot")) {
                this.testSnapshotId = tm.getTestSnapshotId("stateless", false);
                if (this.testSnapshotId == null) {
                    this.testSnapshotId = tm.getTestSnapshotId("stateful", true);
                }
            } else if (this.name.getMethodName().equals("removeVolume")) {
                this.testVolumeId = tm.getTestVolumeId("removed", true, null, this.testDataCenterId);
            } else if (this.name.getMethodName().equals("filterVolumes")) {
                VolumeSupport support;
                ComputeServices services = tm.getProvider().getComputeServices();
                if (services != null && (support = services.getVolumeSupport()) != null) {
                    try {
                        this.testVolumeId = DaseinTestManager.getComputeResources().provisionVolume(support, "filter", "dsnfilter", null, this.testDataCenterId);
                    }
                    catch (Throwable t) {
                        tm.warn("Failed to provisionKeypair VM for filter test: " + t.getMessage());
                    }
                }
            } else if (this.name.getMethodName().equals("attach")) {
                this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
                dc = null;
                if (this.testVMId != null) {
                    try {
                        VirtualMachine vm = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                        if (vm != null) {
                            dc = vm.getProviderDataCenterId();
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                this.testVolumeId = tm.getTestVolumeId("stateful", true, null, dc);
                if (this.testVolumeId != null) {
                    try {
                        Volume v2 = tm.getProvider().getComputeServices().getVolumeSupport().getVolume(this.testVolumeId);
                        if (v2 == null || v2.getProviderVirtualMachineId() == null) break block60;
                        tm.getProvider().getComputeServices().getVolumeSupport().detach(this.testVolumeId, true);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException ignore) {
                        }
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("detach")) {
                this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
                dc = null;
                if (this.testVMId != null) {
                    try {
                        VirtualMachine vm = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                        if (vm != null) {
                            dc = vm.getProviderDataCenterId();
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                this.testVolumeId = tm.getTestVolumeId("stateful", true, null, dc);
                if (this.testVolumeId != null && this.testVMId != null) {
                    try {
                        Volume volume;
                        VolumeSupport support = tm.getProvider().getComputeServices().getVolumeSupport();
                        VirtualMachine vm = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                        if (vm != null) {
                            String a;
                            Volume v3 = support.getVolume(this.testVolumeId);
                            String string = a = v3 == null ? null : v3.getProviderVirtualMachineId();
                            if (a == null) {
                                for (String deviceId : support.getCapabilities().listPossibleDeviceIds(vm.getPlatform())) {
                                    try {
                                        support.attach(this.testVolumeId, this.testVMId, deviceId);
                                        break;
                                    }
                                    catch (Throwable ignore) {
                                    }
                                }
                            }
                        }
                        long timeout = System.currentTimeMillis() + 300000L;
                        while (timeout > System.currentTimeMillis() && (volume = support.getVolume(this.testVolumeId)) != null && volume.getProviderVirtualMachineId() == null) {
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("attachToBogusVM")) {
                this.testVolumeId = tm.getTestVolumeId("stateful", true, null, this.testDataCenterId);
                if (this.testVolumeId != null) {
                    try {
                        v = tm.getProvider().getComputeServices().getVolumeSupport().getVolume(this.testVolumeId);
                        if (v == null || v.getProviderVirtualMachineId() == null) break block60;
                        tm.getProvider().getComputeServices().getVolumeSupport().detach(this.testVolumeId, true);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException ignore) {
                        }
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("detachUnattachedVolume")) {
                this.testVolumeId = tm.getTestVolumeId("stateful", true, null, this.testDataCenterId);
                if (this.testVolumeId != null) {
                    try {
                        v = tm.getProvider().getComputeServices().getVolumeSupport().getVolume(this.testVolumeId);
                        if (v != null && v.getProviderVirtualMachineId() != null) {
                            tm.getProvider().getComputeServices().getVolumeSupport().detach(this.testVolumeId, true);
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            VolumeSupport support;
            ComputeServices services = tm.getProvider().getComputeServices();
            if (services != null && (support = services.getVolumeSupport()) != null) {
                if (this.testVolumeId != null) {
                    try {
                        Volume v = support.getVolume(this.testVolumeId);
                        if (v != null && v.getProviderVirtualMachineId() != null) {
                            support.detach(this.testVolumeId, true);
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if (this.provisionedVolume != null) {
                    try {
                        support.detach(this.provisionedVolume, true);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    try {
                        support.remove(this.provisionedVolume);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.provisionedVolume = null;
            this.testSnapshotId = null;
            this.testVolumeId = null;
            this.testVLANId = null;
            this.testDataCenterId = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void filterVolumes() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Iterable volumes = support.listVolumes(VolumeFilterOptions.getInstance((String)".*[Ff][Ii][Ll][Tt][Ee][Rr].*"));
                boolean found = false;
                int count = 0;
                Assert.assertNotNull((String)"Filtering must return at least an empty collections and may not be null", (Object)volumes);
                for (Volume volume : volumes) {
                    ++count;
                    if (volume.getProviderVolumeId().equals(this.testVolumeId)) {
                        found = true;
                    }
                    tm.out("Volume", volume);
                }
                tm.out("Total Volume Count", count);
                if (count < 1 && support.isSubscribed()) {
                    if (this.testVolumeId == null) {
                        tm.warn("No volumes were listed and thus the test may be in error");
                    } else {
                        Assert.fail((String)("Should have found test volume " + this.testVolumeId + ", but none were found"));
                    }
                }
                if (this.testVolumeId != null) {
                    Assert.assertTrue((String)("Did not find the test filter volume " + this.testVolumeId + " among the filtered volumes"), (boolean)found);
                } else if (!support.isSubscribed()) {
                    tm.warn("No test volumes existed for filter test, so results may not be valid");
                } else {
                    Assert.fail((String)"Cannot test volume filtering without a test volume");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void createBlockVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                boolean supported = support.isSubscribed();
                if (supported) {
                    supported = false;
                    for (VolumeFormat fmt : support.getCapabilities().listSupportedFormats()) {
                        if (!fmt.equals((Object)VolumeFormat.BLOCK)) continue;
                        supported = true;
                    }
                }
                String productId = tm.getTestVolumeProductId();
                VolumeCreateOptions options = null;
                if (productId != null) {
                    Storage size = null;
                    if (support.getCapabilities().isVolumeSizeDeterminedByProduct()) {
                        VolumeProduct product = null;
                        for (VolumeProduct prd : support.listVolumeProducts()) {
                            if (!prd.getProviderProductId().equals(productId)) continue;
                            product = prd;
                            break;
                        }
                        if (product != null) {
                            size = product.getVolumeSize();
                        }
                    }
                    if (size == null) {
                        size = support.getCapabilities().getMinimumVolumeSize();
                    }
                    options = VolumeCreateOptions.getInstance((String)productId, (Storage)size, (String)("dsnvolprv" + System.currentTimeMillis() % 10000L), (String)"Volume Provisioning Test", (int)0);
                }
                if (options == null) {
                    options = VolumeCreateOptions.getInstance((Storage)support.getCapabilities().getMinimumVolumeSize(), (String)("dsnvolprv" + System.currentTimeMillis() % 10000L), (String)"Volume Provisioning Test");
                }
                if (this.testDataCenterId != null) {
                    options.setDataCenterId(this.testDataCenterId);
                }
                if (supported) {
                    this.provisionedVolume = options.build(tm.getProvider());
                    tm.out("New Block Volume", this.provisionedVolume);
                } else {
                    try {
                        this.provisionedVolume = options.build(tm.getProvider());
                        Assert.fail((String)"Block volumes are either not subscribed or supported, yet the operation completed");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Got an OperationNotSupportedException from " + this.name.getMethodName() + " as expected");
                    }
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void createNFSVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                boolean supported = support.isSubscribed();
                if (supported) {
                    supported = false;
                    for (VolumeFormat fmt : support.getCapabilities().listSupportedFormats()) {
                        if (!fmt.equals((Object)VolumeFormat.NFS)) continue;
                        supported = true;
                    }
                }
                if (this.testVLANId != null) {
                    String productId = tm.getTestVolumeProductId();
                    VolumeCreateOptions options = null;
                    if (productId != null) {
                        Storage size = null;
                        if (support.getCapabilities().isVolumeSizeDeterminedByProduct()) {
                            VolumeProduct product = null;
                            for (VolumeProduct prd : support.listVolumeProducts()) {
                                if (!prd.getProviderProductId().equals(productId)) continue;
                                product = prd;
                                break;
                            }
                            if (product != null) {
                                size = product.getVolumeSize();
                            }
                        }
                        if (size == null) {
                            size = support.getCapabilities().getMinimumVolumeSize();
                        }
                        options = VolumeCreateOptions.getNetworkInstance((String)productId, (String)this.testVLANId, (Storage)size, (String)("dsnnfsvol" + System.currentTimeMillis() % 10000L), (String)"Dasein NFS volume test");
                    }
                    if (options == null) {
                        options = VolumeCreateOptions.getNetworkInstance((String)this.testVLANId, (Storage)support.getCapabilities().getMinimumVolumeSize(), (String)("dsnvolprv" + System.currentTimeMillis() % 10000L), (String)"Volume Provisioning Test");
                    }
                    if (this.testDataCenterId != null) {
                        options.setDataCenterId(this.testDataCenterId);
                    }
                    if (supported) {
                        this.provisionedVolume = options.build(tm.getProvider());
                        tm.out("New NFS Volume", this.provisionedVolume);
                    } else {
                        try {
                            this.provisionedVolume = options.build(tm.getProvider());
                            Assert.fail((String)"NFS volumes are either not subscribed or supported, yet the operation completed");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Got an OperationNotSupportedException from " + this.name.getMethodName() + " as expected");
                        }
                    }
                } else if (!supported) {
                    tm.ok("Either network volumes are not supported or volumes are not subscribed");
                } else {
                    Assert.fail((String)"Unable to test network volume provisioning due to a lack of a network in which to test");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void createFromSnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                boolean supported = true;
                if (this.testSnapshotId == null) {
                    SnapshotSupport snapSupport = services.getSnapshotSupport();
                    if (snapSupport == null || !snapSupport.isSubscribed()) {
                        supported = false;
                        this.testSnapshotId = UUID.randomUUID().toString();
                    } else {
                        Assert.fail((String)"No test snapshot ID even though snapshots are supported");
                    }
                }
                String productId = tm.getTestVolumeProductId();
                VolumeCreateOptions options = null;
                if (productId != null) {
                    Storage size = null;
                    if (support.getCapabilities().isVolumeSizeDeterminedByProduct()) {
                        VolumeProduct product = null;
                        for (VolumeProduct prd : support.listVolumeProducts()) {
                            if (!prd.getProviderProductId().equals(productId)) continue;
                            product = prd;
                            break;
                        }
                        if (product != null) {
                            size = product.getVolumeSize();
                        }
                    }
                    if (size == null) {
                        size = support.getCapabilities().getMinimumVolumeSize();
                    }
                    options = VolumeCreateOptions.getInstanceForSnapshot((String)productId, (String)this.testSnapshotId, (Storage)size, (String)("dsnvolprv" + System.currentTimeMillis() % 10000L), (String)"Volume Provisioning Test", (int)0);
                }
                if (options == null) {
                    options = VolumeCreateOptions.getInstanceForSnapshot((String)this.testSnapshotId, (Storage)new Storage((Number)10, (StorageUnit)Storage.GIGABYTE), (String)("dsnvolprv" + System.currentTimeMillis() % 10000L), (String)"Volume Provisioning Test");
                    if (this.testDataCenterId != null) {
                        options.setDataCenterId(this.testDataCenterId);
                    }
                }
                if (support.isSubscribed() && supported) {
                    this.provisionedVolume = options.build(tm.getProvider());
                    tm.out("New Volume from Snapshot", this.provisionedVolume);
                } else {
                    try {
                        this.provisionedVolume = options.build(tm.getProvider());
                        Assert.fail((String)"Volume snapshots are either not subscribed or supported, yet the operation completed");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Got an OperationNotSupportedException from " + this.name.getMethodName() + " as expected");
                    }
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void attach() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (!support.isSubscribed()) {
                    tm.warn("Not subscribed to volume services, test will not run properly");
                    return;
                }
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    Assert.assertNotNull((String)"Test volume is null and so the test cannot be run", (Object)volume);
                    tm.out("Attachment Before", volume.getProviderVirtualMachineId());
                    Assert.assertNull((String)"Attachment must be null before running this test", (Object)volume.getProviderVirtualMachineId());
                    if (this.testVMId != null) {
                        VirtualMachine vm = services.getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                        Assert.assertNotNull((String)"Virtual machine for test went away", (Object)vm);
                        boolean attached = false;
                        for (String device : support.getCapabilities().listPossibleDeviceIds(vm.getPlatform())) {
                            try {
                                if (volume.getFormat().equals((Object)VolumeFormat.NFS)) {
                                    try {
                                        support.attach(this.testVolumeId, this.testVMId, device);
                                        Assert.fail((String)"Attachment to NFS volume succeeded even though it should not");
                                    }
                                    catch (OperationNotSupportedException expected) {
                                        tm.ok("NFS volumes cannot be attached");
                                        return;
                                    }
                                } else {
                                    support.attach(this.testVolumeId, this.testVMId, device);
                                }
                                attached = true;
                                break;
                            }
                            catch (CloudException e) {
                                tm.warn("Failed to mount using " + device + ", will hopefully try again");
                            }
                        }
                        Assert.assertTrue((String)"Unable to attach using any available device", (boolean)attached);
                        long timeout = System.currentTimeMillis() + 300000L;
                        while (timeout > System.currentTimeMillis()) {
                            volume = support.getVolume(this.testVolumeId);
                            Assert.assertNotNull((String)"Volume disappeared during attachment", (Object)volume);
                            tm.out("---> Attachment", volume.getProviderVirtualMachineId());
                            if (volume.getProviderVirtualMachineId() != null) {
                                Assert.assertEquals((String)"Volume attachment does not match target server", (Object)this.testVMId, (Object)volume.getProviderVirtualMachineId());
                                return;
                            }
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        Assert.fail((String)"System timed out verifying attachment");
                    } else {
                        Assert.fail((String)"No test VM exists for this test");
                    }
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test volume for " + this.name.getMethodName()));
                } else {
                    tm.ok("Volume service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void detach() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (!support.isSubscribed()) {
                    tm.warn("Not subscribed to volume services, test will not run properly");
                    return;
                }
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    Assert.assertNotNull((String)"Test volume is null and so the test cannot be run", (Object)volume);
                    tm.out("Attachment Before", volume.getProviderVirtualMachineId());
                    Assert.assertNotNull((String)"Volume must be attached to something before attempting to detach it", (Object)volume.getProviderVirtualMachineId());
                    support.detach(this.testVolumeId, true);
                    long timeout = System.currentTimeMillis() + 300000L;
                    while (timeout > System.currentTimeMillis()) {
                        volume = support.getVolume(this.testVolumeId);
                        Assert.assertNotNull((String)"Volume disappeared during detachment", (Object)volume);
                        tm.out("---> Attachment", volume.getProviderVirtualMachineId());
                        if (volume.getProviderVirtualMachineId() == null) {
                            return;
                        }
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    Assert.fail((String)"System timed out verifying attachment");
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test volume for " + this.name.getMethodName()));
                } else {
                    tm.ok("Volume service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void attachToBogusVM() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (!support.isSubscribed()) {
                    tm.warn("Not subscribed to volume services, test will not run properly");
                    return;
                }
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    Assert.assertNotNull((String)"Test volume is null and so the test cannot be run", (Object)volume);
                    tm.out("Attachment Before", volume.getProviderVirtualMachineId());
                    Assert.assertNull((String)"Attachment must be null before running this test", (Object)volume.getProviderVirtualMachineId());
                    String id = UUID.randomUUID().toString();
                    boolean succeeded = false;
                    for (String device : support.getCapabilities().listPossibleDeviceIds(Platform.UBUNTU)) {
                        if (volume.getFormat().equals((Object)VolumeFormat.NFS)) {
                            try {
                                support.attach(this.testVolumeId, id, device);
                                Assert.fail((String)"Attachment to NFS volume succeeded even though it should not");
                                continue;
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("NFS volumes cannot be attached");
                                return;
                            }
                        }
                        try {
                            support.attach(this.testVolumeId, id, device);
                            succeeded = true;
                            break;
                        }
                        catch (CloudException expected) {
                            tm.ok("--> Failed with " + device);
                        }
                    }
                    Assert.assertFalse((String)"The system reported that it successfully attached to a server that does not exist", (boolean)succeeded);
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test volume for " + this.name.getMethodName()));
                } else {
                    tm.ok("Volume service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void detachUnattachedVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (!support.isSubscribed()) {
                    tm.warn("Not subscribed to volume services, test will not run properly");
                    return;
                }
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    Assert.assertNotNull((String)"Test volume is null and so the test cannot be run", (Object)volume);
                    tm.out("Attachment Before", volume.getProviderVirtualMachineId());
                    Assert.assertNull((String)"Volume must be unattached before attempting this test", (Object)volume.getProviderVirtualMachineId());
                    try {
                        support.detach(this.testVolumeId, true);
                        Assert.fail((String)"Detachment should have failed for an unattached volume");
                    }
                    catch (CloudException expected) {
                        tm.ok("Caught a CloudException: " + expected.getMessage());
                    }
                } else {
                    Assert.fail((String)("No test volume for " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void removeVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    tm.out("Before", volume);
                    Assert.assertNotNull((String)"Test volume no longer exists, cannot test removing it", (Object)volume);
                    tm.out("State", volume.getCurrentState());
                    Assert.assertFalse((String)"Test volume is deleted, cannot test removing it", (boolean)VolumeState.DELETED.equals((Object)volume.getCurrentState()));
                    support.remove(this.testVolumeId);
                    volume = support.getVolume(this.testVolumeId);
                    tm.out("After", volume);
                    tm.out("State", volume == null ? VolumeState.DELETED : volume.getCurrentState());
                    Assert.assertTrue((String)"The volume remains available", (volume == null || VolumeState.DELETED.equals((Object)volume.getCurrentState()) ? 1 : 0) != 0);
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test volume for deletion test");
                } else {
                    tm.ok("Volume service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

