/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Map;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.AffinityGroupFilterOptions;
import org.dasein.cloud.compute.AffinityGroupSupport;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessAffinityGroupTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testAffinityGroupId;
    private String testDataCenterId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessAffinityGroupTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        try {
            ComputeServices computeServices;
            DataCenterServices services = tm.getProvider().getDataCenterServices();
            for (DataCenter dc : services.listDataCenters(tm.getContext().getRegionId())) {
                if (this.testDataCenterId != null && !dc.isActive()) continue;
                this.testDataCenterId = dc.getProviderDataCenterId();
            }
            if (this.testDataCenterId != null && (computeServices = tm.getProvider().getComputeServices()).hasAffinityGroupSupport()) {
                AffinityGroupSupport support = computeServices.getAffinityGroupSupport();
                AffinityGroupFilterOptions options = AffinityGroupFilterOptions.getInstance().withDataCenterId(this.testDataCenterId);
                for (AffinityGroup ag : support.list(options)) {
                    if (this.testAffinityGroupId != null) continue;
                    this.testAffinityGroupId = ag.getAffinityGroupId();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void getBogusAffinityGroup() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices.hasAffinityGroupSupport()) {
            AffinityGroupSupport services = computeServices.getAffinityGroupSupport();
            AffinityGroup ag = services.get(UUID.randomUUID().toString());
            tm.out("Bogus Affinity Group", ag);
            Assert.assertNull((String)"Dummy affinity group must be null, but one was found", (Object)ag);
        } else {
            tm.ok("Affinity groups not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void getAffinityGroup() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices.hasAffinityGroupSupport()) {
            if (this.testAffinityGroupId != null) {
                AffinityGroupSupport services = computeServices.getAffinityGroupSupport();
                AffinityGroup ag = services.get(this.testAffinityGroupId);
                tm.out("Affinity Group", ag);
                Assert.assertNotNull((String)"Failed to find the test affinity group", (Object)ag);
            } else {
                Assert.fail((String)"No testAffinityGroup found for getAffinityGroup test");
            }
        } else {
            tm.ok("Affinity groups not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void affinityGroupContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices.hasAffinityGroupSupport()) {
            if (this.testAffinityGroupId != null) {
                AffinityGroupSupport services = computeServices.getAffinityGroupSupport();
                AffinityGroup ag = services.get(this.testAffinityGroupId);
                Assert.assertNotNull((String)"Failed to find the test affinity group", (Object)ag);
                tm.out("Affinity Group ID", ag.getAffinityGroupId());
                tm.out("Name", ag.getAffinityGroupName());
                tm.out("Description", ag.getDescription());
                tm.out("Datacenter ID", ag.getDataCenterId());
                tm.out("Created", ag.getCreationTimestamp());
                Map tags = ag.getTags();
                Assert.assertNotNull((String)"Tags may not be null", (Object)ag.getTags());
                for (Map.Entry entry : tags.entrySet()) {
                    tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                }
                Assert.assertNotNull((String)"Affinity Group ID must not be null", (Object)ag.getAffinityGroupId());
                Assert.assertNotNull((String)"Affinity group name must not be null", (Object)ag.getAffinityGroupName());
                Assert.assertNotNull((String)"Datacenter id must not be null", (Object)ag.getDataCenterId());
            } else {
                Assert.fail((String)"No testAffinityGroup found for affinityGroupContent test");
            }
        } else {
            tm.ok("Affinity groups not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listAffinityGroups() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices.hasAffinityGroupSupport()) {
            if (this.testDataCenterId != null) {
                if (this.testAffinityGroupId != null) {
                    AffinityGroupSupport services = computeServices.getAffinityGroupSupport();
                    AffinityGroupFilterOptions options = AffinityGroupFilterOptions.getInstance().withDataCenterId(this.testDataCenterId);
                    Iterable affinityGroups = services.list(options);
                    boolean found = false;
                    int count = 0;
                    Assert.assertNotNull((String)"Null set of affinity groups returned from listAffinityGroups()", (Object)affinityGroups);
                    for (AffinityGroup affinityGroup : affinityGroups) {
                        ++count;
                        tm.out("Affinity group", affinityGroup);
                        if (!affinityGroup.getAffinityGroupId().equals(this.testAffinityGroupId)) continue;
                        found = true;
                    }
                    tm.out("Total Affinity Group Count", count);
                    Assert.assertTrue((String)"Did not find the test affinity group ID among returned affinity groups", (boolean)found);
                } else {
                    Assert.fail((String)"No testAffinityGroup found for affinityGroupContent test");
                }
            } else {
                Assert.fail((String)"Unable to find datacenter id for listAffinityGroups test");
            }
        } else {
            tm.ok("Affinity groups not supported in " + tm.getProvider().getCloudName());
        }
    }
}

