/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessImageTests {
    private static final Random random = new Random();
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testImageId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessImageTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testImageId = tm.getTestImageId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertImageContent(@Nonnull MachineImage image, @Nullable ImageClass expectedClass) {
        Assert.assertNotNull((String)"The image ID may not be null", (Object)image.getProviderMachineImageId());
        Assert.assertNotNull((String)"Image name may not be null", (Object)image.getName());
        Assert.assertNotNull((String)"Image description may not be null", (Object)image.getDescription());
        Assert.assertNotNull((String)"Image state may not be null", (Object)image.getCurrentState());
        Assert.assertNotNull((String)"Image class may not be null", (Object)image.getImageClass());
        if (expectedClass != null) {
            Assert.assertEquals((String)"The image was not of the expected image class", (Object)expectedClass, (Object)image.getImageClass());
        }
        if (!ImageClass.MACHINE.equals((Object)image.getImageClass())) {
            Assert.assertNull((String)"Kernel image ID makes sense only for machine images in certain clouds", (Object)image.getKernelImageId());
        }
        Assert.assertNotNull((String)"Image owner ID may not be null", (Object)image.getProviderOwnerId());
        Assert.assertNotNull((String)"Image region may not be null", (Object)image.getProviderRegionId());
        Assert.assertNotNull((String)"Image architecture may not be null", (Object)image.getArchitecture());
        Assert.assertNotNull((String)"Image platform may not be null", (Object)image.getPlatform());
        Assert.assertTrue((String)"Creation timestamp may not be negative", (image.getCreationTimestamp() >= 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Image type may not be null", (Object)image.getType());
        Assert.assertNotNull((String)"Image software may not be null", (Object)image.getSoftware());
        if (MachineImageType.STORAGE.equals((Object)image.getType())) {
            Assert.assertNotNull((String)"Storage format must not be null for STORAGE-based images", (Object)image.getStorageFormat());
        } else {
            Assert.assertNull((String)"Storage format must be null for VOLUME-based images", (Object)image.getStorageFormat());
        }
        Map tags = image.getTags();
        Assert.assertNotNull((String)"Image meta-data (tags) must not be null", (Object)tags);
        if (Platform.UNKNOWN.equals((Object)image.getPlatform())) {
            Platform p = Platform.guess((String)image.getName());
            Assert.assertTrue((String)"There is a better guess for platform than UNKNOWN based on the image name", (boolean)p.equals((Object)Platform.UNKNOWN));
            p = Platform.guess((String)image.getDescription());
            Assert.assertTrue((String)"There is a better guess for platform than UNKNOWN based on the image description", (boolean)p.equals((Object)Platform.UNKNOWN));
            for (Map.Entry entry : tags.entrySet()) {
                p = Platform.guess((String)((String)entry.getValue()));
                Assert.assertTrue((String)("There is a better guess for platform than UNKNOWN based on the image tag " + (String)entry.getKey()), (boolean)p.equals((Object)Platform.UNKNOWN));
            }
        }
    }

    private void assertImageContent(@Nonnull Iterable<MachineImage> images, @Nonnull ImageClass expectedClass) {
        for (MachineImage image : images) {
            this.assertImageContent(image, expectedClass);
        }
    }

    private void assertListEquals(@Nonnull String errorMessage, @Nonnull Iterable<MachineImage> expected, @Nonnull Iterable<MachineImage> actual) {
        boolean found;
        int expectedCount = 0;
        int actualCount = 0;
        for (MachineImage img : expected) {
            found = false;
            for (MachineImage test : actual) {
                if (!test.getProviderMachineImageId().equals(img.getProviderMachineImageId())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)(errorMessage + " [" + img + "]"), (boolean)found);
            ++expectedCount;
        }
        for (MachineImage test : actual) {
            found = false;
            for (MachineImage img : expected) {
                if (!test.getProviderMachineImageId().equals(img.getProviderMachineImageId())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)(errorMessage + " [" + test + "]"), (boolean)found);
            ++actualCount;
        }
        Assert.assertTrue((String)(errorMessage + " [" + expectedCount + " vs " + actualCount + "]"), (expectedCount == actualCount ? 1 : 0) != 0);
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                tm.out("Subscribed", support.isSubscribed());
                tm.out("Image Upload Support", support.getCapabilities().supportsDirectImageUpload());
                tm.out("Image Sharing with Accounts", support.getCapabilities().supportsImageSharing());
                tm.out("Image Sharing with Public", support.getCapabilities().supportsImageSharingWithPublic());
                Iterable supportedClasses = support.getCapabilities().listSupportedImageClasses();
                tm.out("Supported Image Classes", supportedClasses);
                Iterable supportedFormats = support.getCapabilities().listSupportedFormats();
                tm.out("Supported Formats", supportedFormats);
                for (ImageClass cls : ImageClass.values()) {
                    tm.out("Term for " + cls + " Images", support.getCapabilities().getProviderTermForImage(Locale.getDefault(), cls));
                    tm.out("Term for Custom " + cls + " Images", support.getCapabilities().getProviderTermForCustomImage(Locale.getDefault(), cls));
                    tm.out("Public " + cls + " Library", support.getCapabilities().supportsPublicLibrary(cls));
                }
                tm.out("Must Bundle on VM (Not Remote)", support.getCapabilities().identifyLocalBundlingRequirement());
                Iterable bundlingFormats = support.getCapabilities().listSupportedFormatsForBundling();
                tm.out("Supported Bundling Formats", bundlingFormats);
                Iterable types = support.getCapabilities().listSupportedImageTypes();
                tm.out("Supported Image Types", types);
                for (MachineImageType type : types) {
                    tm.out("Image Capture of VMs", support.getCapabilities().supportsImageCapture(type));
                }
                if (!support.isSubscribed()) {
                    tm.warn("Because this account is not subscribed for image services, this test cannot verify functionality against image services");
                }
                Assert.assertNotNull((String)"Supported image classes must be non-null", (Object)supportedClasses);
                Assert.assertTrue((String)"At least one image class must be supported", (boolean)supportedClasses.iterator().hasNext());
                boolean machine = false;
                for (ImageClass cls : supportedClasses) {
                    if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                    machine = true;
                }
                Assert.assertTrue((String)"Machine images must be supported in any cloud with image support", (boolean)machine);
                Assert.assertNotNull((String)"Supported formats must be non-null", (Object)supportedFormats);
                for (ImageClass cls : ImageClass.values()) {
                    Assert.assertNotNull((String)("Term for " + cls + " images must not be null whether or not supported"), (Object)support.getCapabilities().getProviderTermForImage(Locale.getDefault(), cls));
                    Assert.assertNotNull((String)("Term for custom " + cls + " images must not be null whether or not supported"), (Object)support.getCapabilities().getProviderTermForCustomImage(Locale.getDefault(), cls));
                }
                Assert.assertNotNull((String)"Local bundling requirement must not be null", (Object)support.getCapabilities().identifyLocalBundlingRequirement());
                Assert.assertNotNull((String)"The list of bundling formats must not be null", (Object)bundlingFormats);
                Assert.assertNotNull((String)"The list of image types must not be null", (Object)types);
                Assert.assertTrue((String)"At least one image type must be supported", (boolean)types.iterator().hasNext());
            } else {
                tm.ok(tm.getProvider().getCloudName() + " does not support images/templates");
            }
        } else {
            tm.ok(tm.getProvider().getCloudName() + " does not support compute services");
        }
    }

    @Test
    public void getBogusImage() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                MachineImage image = support.getImage(UUID.randomUUID().toString());
                tm.out("Bogus Image", image);
                Assert.assertNull((String)"Bogus image was supposed to be none, but got a valid image.", (Object)image);
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getImage() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    MachineImage image = support.getImage(this.testImageId);
                    tm.out("Image", image);
                    Assert.assertNotNull((String)"Failed to find the test image among possible images", (Object)image);
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else {
                    Assert.fail((String)"No test image exists for the getImage test");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void imageContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    MachineImage image = support.getImage(this.testImageId);
                    Assert.assertNotNull((String)"Failed to find the test image among possible images", (Object)image);
                    tm.out("Image ID", image.getProviderMachineImageId());
                    tm.out("Current State", image.getCurrentState());
                    tm.out("Name", image.getName());
                    tm.out("Created", new Date(image.getCreationTimestamp()));
                    tm.out("Owner Account", image.getProviderOwnerId());
                    tm.out("Region ID", image.getProviderRegionId());
                    tm.out("Data Center ID", image.getProviderDataCenterId());
                    tm.out("Image Class", image.getImageClass());
                    tm.out("Architecture", image.getArchitecture());
                    tm.out("Platform", image.getPlatform());
                    tm.out("Kernel Image ID", image.getKernelImageId());
                    tm.out("Software", image.getSoftware());
                    tm.out("Type", image.getType());
                    tm.out("Storage Format", image.getStorageFormat());
                    Map tags = image.getTags();
                    if (tags != null) {
                        for (Map.Entry entry : tags.entrySet()) {
                            tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    tm.out("Description", image.getDescription());
                    this.assertImageContent(image, null);
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else {
                    Assert.fail((String)"No test image exists for the getImage test");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listMachineImages() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                    supported = true;
                }
                Iterable images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE));
                int count = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++count;
                    tm.out("Image", image);
                }
                tm.out("Total Machine Image Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                }
                if (count > 0) {
                    this.assertImageContent(images, ImageClass.MACHINE);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listKernelImages() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.KERNEL)) continue;
                    supported = true;
                }
                Iterable images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.KERNEL));
                int count = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++count;
                    tm.out("Image", image);
                }
                tm.out("Total Kernel Image Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because kernel images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No kernel images were returned and so this test may not be valid");
                }
                if (count > 0) {
                    this.assertImageContent(images, ImageClass.KERNEL);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listRamdiskImages() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.RAMDISK)) continue;
                    supported = true;
                }
                Iterable images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.RAMDISK));
                int count = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++count;
                    tm.out("Image", image);
                }
                tm.out("Total Ramdisk Image Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because ramdisk images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No ramdisk images were returned and so this test may not be valid");
                }
                if (count > 0) {
                    this.assertImageContent(images, ImageClass.RAMDISK);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listMachineImageStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                    supported = true;
                }
                Iterable images = support.listImageStatus(ImageClass.MACHINE);
                int count = 0;
                Assert.assertNotNull((String)"listImageStatus() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (ResourceStatus status : images) {
                    ++count;
                    tm.out("Image Status", status);
                }
                tm.out("Total Machine Image Status Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listKernelImageStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.KERNEL)) continue;
                    supported = true;
                }
                Iterable images = support.listImageStatus(ImageClass.KERNEL);
                int count = 0;
                Assert.assertNotNull((String)"listImageStatus() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (ResourceStatus status : images) {
                    ++count;
                    tm.out("Image Status", status);
                }
                tm.out("Total Kernel Image Status Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because kernel images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listRamdiskImageStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.RAMDISK)) continue;
                    supported = true;
                }
                Iterable images = support.listImageStatus(ImageClass.RAMDISK);
                int count = 0;
                Assert.assertNotNull((String)"listImageStatus() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (ResourceStatus status : images) {
                    ++count;
                    tm.out("Image Status", status);
                }
                tm.out("Total Ramdisk Image Status Count", count);
                if (!supported) {
                    Assert.assertTrue((String)"Because ramdisk images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void compareImageListAndStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Iterable images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE));
                Iterable status = support.listImageStatus(ImageClass.MACHINE);
                Assert.assertNotNull((String)"listImages() must return at least an empty collections and may not be null", (Object)images);
                Assert.assertNotNull((String)"listImageStatus() must return at least an empty collections and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (MachineImage machineImage : images) {
                    current = (Map)map.get(machineImage.getProviderMachineImageId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(machineImage.getProviderMachineImageId(), current);
                    }
                    current.put("image", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean i = (Boolean)((Map)entry.getValue()).get("image");
                    Assert.assertTrue((String)("Status and image lists do not match for " + (String)entry.getKey()), (s != null && i != null && s != false && i != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void findTestUbuntuOrWindowsOrRHELInPrivateLibrary() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                    supported = true;
                }
                Iterable images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.UBUNTU));
                int ubuntu = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++ubuntu;
                    tm.out("Ubuntu Image", image);
                }
                tm.out("Total Ubuntu Image Count", ubuntu);
                if (!supported) {
                    Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (ubuntu == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not Ubuntu"), (Object)Platform.UBUNTU, (Object)image.getPlatform());
                }
                images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.RHEL));
                int rhel = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++rhel;
                    tm.out("RHEL Image", image);
                }
                tm.out("Total RHEL Image Count", rhel);
                if (!supported) {
                    Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (rhel == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not RHEL"), (Object)Platform.RHEL, (Object)image.getPlatform());
                }
                images = support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.WINDOWS));
                int windows = 0;
                Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++windows;
                    tm.out("Windows Image", image);
                }
                tm.out("Total Windows Image Count", windows);
                if (!supported) {
                    Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (windows == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not Windows"), (Object)Platform.WINDOWS, (Object)image.getPlatform());
                }
                if (windows == 0 && ubuntu == 0) {
                    boolean shouldHave = false;
                    for (MachineImageType type : MachineImageType.values()) {
                        if (!support.getCapabilities().supportsImageCapture(type)) continue;
                        shouldHave = true;
                    }
                    if (shouldHave || !support.getCapabilities().supportsPublicLibrary(ImageClass.MACHINE)) {
                        tm.warn("No private Ubuntu or Windows images were found; the test may have failed or there may be nothing to find");
                    }
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void findAllPublicImages() throws CloudException, InternalException {
        MachineImageSupport support;
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null && (support = services.getImageSupport()) != null) {
            boolean supported = false;
            for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                supported = true;
            }
            Iterable images = support.searchPublicImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).matchingAny());
            int count = 0;
            Assert.assertNotNull((String)"listImages() must return a non-null list of images even if the image class is not supported", (Object)images);
            for (MachineImage image : images) {
                ++count;
                tm.out("Image", image);
            }
            tm.out("Total Machine Image Count", count);
            if (!supported) {
                Assert.assertTrue((String)"Because machine images are not supported, the list of images should be empty", (count == 0 ? 1 : 0) != 0);
            }
            if (count > 0) {
                this.assertImageContent(images, ImageClass.MACHINE);
            }
        }
    }

    @Test
    public void findUbuntuOrWindowsOrRHELInPublicLibrary() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                boolean supported = false;
                for (ImageClass cls : support.getCapabilities().listSupportedImageClasses()) {
                    if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                    supported = true;
                }
                Iterable images = support.searchPublicImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.UBUNTU));
                int ubuntu = 0;
                Assert.assertNotNull((String)"searchPublicImages() must return a non-null list of images even if the image class is not supported or public libraries are not supported", (Object)images);
                for (MachineImage image : images) {
                    ++ubuntu;
                    tm.out("Ubuntu Public Image", image);
                }
                tm.out("Total Public Ubuntu Image Count", ubuntu);
                if (!supported || !support.getCapabilities().supportsPublicLibrary(ImageClass.MACHINE)) {
                    Assert.assertTrue((String)"Because public machine image libraries are not supported, the list of images should be empty", (ubuntu == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    if (ubuntu >= 100 && random.nextInt(100) >= 20) continue;
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not Ubuntu"), (Object)Platform.UBUNTU, (Object)image.getPlatform());
                    Assert.assertTrue((String)("The image " + image.getProviderMachineImageId() + " is actually private"), (boolean)support.isImageSharedWithPublic(image.getProviderMachineImageId()));
                }
                images = support.searchPublicImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.RHEL));
                int rhel = 0;
                Assert.assertNotNull((String)"searchPublicIMages() must return a non-null list of images even if the image class is not supported", (Object)images);
                for (MachineImage image : images) {
                    ++rhel;
                    tm.out("RHEL Image", image);
                }
                tm.out("Total Public RHEL Image Count", rhel);
                if (!supported || !support.getCapabilities().supportsPublicLibrary(ImageClass.MACHINE)) {
                    Assert.assertTrue((String)"Because public machine image libraries are not supported, the list of images should be empty", (ubuntu == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    if (rhel >= 100 && random.nextInt(100) >= 20) continue;
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not RHEL"), (Object)Platform.RHEL, (Object)image.getPlatform());
                    Assert.assertTrue((String)("The image " + image.getProviderMachineImageId() + " is actually private"), (boolean)support.isImageSharedWithPublic(image.getProviderMachineImageId()));
                }
                images = support.searchPublicImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.WINDOWS));
                int windows = 0;
                Assert.assertNotNull((String)"searchPublicImages() must return a non-null list of images even if the image class is not supported or public libraries are not supported", (Object)images);
                for (MachineImage image : images) {
                    ++windows;
                    tm.out("Windows Public Image", image);
                }
                tm.out("Total Public Windows Image Count", windows);
                if (!supported || !support.getCapabilities().supportsPublicLibrary(ImageClass.MACHINE)) {
                    Assert.assertTrue((String)"Because public machine images libraries are not supported, the list of images should be empty", (windows == 0 ? 1 : 0) != 0);
                }
                for (MachineImage image : images) {
                    if (windows >= 100 && random.nextInt(100) >= 20) continue;
                    Assert.assertEquals((String)("The platform for the image " + image.getProviderMachineImageId() + " is not Windows"), (Object)Platform.WINDOWS, (Object)image.getPlatform());
                    Assert.assertTrue((String)("The image " + image.getProviderMachineImageId() + " is actually private"), (boolean)support.isImageSharedWithPublic(image.getProviderMachineImageId()));
                }
                if (windows == 0 && ubuntu == 0 && supported && support.getCapabilities().supportsPublicLibrary(ImageClass.MACHINE)) {
                    tm.warn("No private Ubuntu or Windows images were found; the test may have failed or there may be nothing to find");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void deprecation() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                this.assertListEquals("The deprecated listImages(ImageClass) method should match listImages(ImageFilterOptions=ImageClass)", support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE)), support.listImages(ImageClass.MACHINE));
                tm.out("listImages(ImageClass)", "Matches listImages(ImageFilterOptions)");
                this.assertListEquals("The deprecated listImages(ImageClass,String) method should match listImages(ImageFilterOptions=ImageClass,Account=String)", support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).withAccountNumber(tm.getContext().getAccountNumber())), support.listImages(ImageClass.MACHINE, tm.getContext().getAccountNumber()));
                tm.out("listImages(ImageClass,String)", "Matches listImages(ImageFilterOptions)");
                this.assertListEquals("The deprecated listMachineImages() method should match listImages(ImageFilterOptions=ImageClass.MACHINE)", support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE)), support.listMachineImages());
                tm.out("listMachineImages", "Matches listImages(ImageFilterOptions)");
                this.assertListEquals("The deprecated listMachineImagesOwnedBy(null) method should match listImages(ImageFilterOptions=ImageClass.MACHINE)", support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE)), support.listMachineImagesOwnedBy(null));
                tm.out("listMachineImagesOwnedBy(null)", "Matches listImages(ImageFilterOptions)");
                this.assertListEquals("The deprecated listMachineImagesOwnedBy(me) method should match listImages(ImageFilterOptions=ImageClass.MACHINE,Account=me)", support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).withAccountNumber(tm.getContext().getAccountNumber())), support.listMachineImagesOwnedBy(tm.getContext().getAccountNumber()));
                tm.out("listMachineImagesOwnedBy(String)", "Matches listImages(ImageFilterOptions)");
                ArrayList<MachineImage> expected = new ArrayList<MachineImage>();
                for (MachineImage img : support.searchPublicImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.UBUNTU))) {
                    expected.add(img);
                }
                for (MachineImage img : support.listImages(ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).onPlatform(Platform.UBUNTU))) {
                    if (expected.contains(img)) continue;
                    expected.add(img);
                }
                this.assertListEquals("The deprecated searchMachineImages(null,UBUNTU,null) method should match listImages(ImageFilterOptions=Platform.UBUNTU,ImageClass=MACHINE) + searchPublicImage(ImageFilterOptions=Platform.UBUNTU,ImageClass=MACHINE)", expected, support.searchMachineImages(null, Platform.UBUNTU, null));
                tm.out("searchMachineImages(String)", "Matches listImages(ImageFilterOptions=Platform.UBUNTU,ImageClass=MACHINE) + searchPublicImage(ImageFilterOptions=Platform.UBUNTU,ImageClass=MACHINE)");
                boolean customSupported = support.supportsDirectImageUpload();
                if (!customSupported) {
                    for (MachineImageType type : MachineImageType.values()) {
                        if (!support.supportsImageCapture(type)) continue;
                        customSupported = true;
                        break;
                    }
                }
                tm.out("supportsCustomImages()", support.supportsCustomImages() == customSupported ? "Matches supportsDirectImageUpload() || supportsImageCapture()" : "Does not match");
                Assert.assertEquals((String)"The deprecated support.supportsCustomImages() should match supportsDirectImageUpload() || supportsImageCapture() for any image type", (Object)customSupported, (Object)support.supportsCustomImages());
                if (this.testImageId != null) {
                    MachineImage actualImage = support.getMachineImage(this.testImageId);
                    MachineImage expectedImage = support.getImage(this.testImageId);
                    tm.out("getMachineImage(" + this.testImageId + ")", "Expected " + expectedImage + " ; Actual " + actualImage);
                    Assert.assertEquals((String)"The results did not match", (Object)expectedImage, (Object)actualImage);
                }
                Assert.assertEquals((String)"Term for old getProviderTermForImage() does not match the term for a machine image", (Object)support.getProviderTermForImage(Locale.getDefault(), ImageClass.MACHINE), (Object)support.getProviderTermForImage(Locale.getDefault()));
                tm.out("getProviderTermForImage(Locale)", "Matches getProviderTermForImage(Locale,ImageClass.MACHINE)");
                boolean pl = false;
                for (ImageClass cls : ImageClass.values()) {
                    if (!support.getCapabilities().supportsPublicLibrary(cls)) continue;
                    pl = true;
                    break;
                }
                tm.out("hasPublicLibrary()/supportsPublicLibrary()", "Expected " + pl + " ; Got " + support.hasPublicLibrary());
                Assert.assertEquals((String)"hasPublicLibrary() should match supportsPublicLibrary(ImageClass) across image classes", (Object)pl, (Object)support.hasPublicLibrary());
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

