/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessSnapshotTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testSnapshotId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessSnapshotTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testSnapshotId = tm.getTestSnapshotId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Snapshot", support.getCapabilities().getProviderTermForSnapshot(Locale.getDefault()));
        tm.out("Volume Attached During Snapshot", support.getCapabilities().identifyAttachmentRequirement());
        tm.out("Snapshot Creation", support.getCapabilities().supportsSnapshotCreation());
        tm.out("Snapshot Copying", support.getCapabilities().supportsSnapshotCopying());
        tm.out("Snapshot Sharing", support.getCapabilities().supportsSnapshotSharing());
        tm.out("    -> with Public?", support.getCapabilities().supportsSnapshotSharingWithPublic());
        Assert.assertNotNull((String)"The provider term for a snapshot may not be null", (Object)support.getCapabilities().getProviderTermForSnapshot(Locale.getDefault()));
    }

    @Test
    public void getBogusSnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Snapshot s = support.getSnapshot(UUID.randomUUID().toString());
        tm.out("Bogus Snapshot", s);
        Assert.assertNull((String)"Found a valid snapshot under the random UUID generated for this test", (Object)s);
    }

    @Test
    public void getSnapshot() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId == null) {
            if (!support.isSubscribed()) {
                tm.ok("Snapshot support is not subscribed, so this functionality cannot be tested");
            } else {
                Assert.fail((String)"No test snapshot is in place to execute this test");
            }
            return;
        }
        Snapshot s = support.getSnapshot(this.testSnapshotId);
        tm.out("Snapshot", s);
        Assert.assertNotNull((String)("The test snapshot was not found in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName()), (Object)s);
    }

    private void assertSnapshot(@Nonnull Snapshot snapshot) {
        Assert.assertNotNull((String)"Snapshot ID may not be null", (Object)snapshot.getProviderSnapshotId());
        Assert.assertNotNull((String)"The current state of the snapshot must not be null", (Object)snapshot.getCurrentState());
        Assert.assertNotNull((String)"The snapshot name may not be null", (Object)snapshot.getName());
        Assert.assertNotNull((String)"The snapshot description may not be null", (Object)snapshot.getDescription());
        if (snapshot.getSnapshotTimestamp() < 2L) {
            tm.warn("Meaningless creation timestamp with snapshot; does the cloud provider support this information?");
        }
        Assert.assertNotNull((String)"Snapshot owner may not be null", (Object)snapshot.getOwner());
        Assert.assertNotNull((String)"Snapshot region may not be null", (Object)snapshot.getRegionId());
        Assert.assertTrue((String)"Snapshot size must be greater than 0", (snapshot.getSizeInGb() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Snapshot tags may not be null", (Object)snapshot.getTags());
    }

    @Test
    public void snapshotContent() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSnapshotId == null) {
            if (!support.isSubscribed()) {
                tm.ok("Snapshot support is not subscribed, so this functionality cannot be tested");
            } else {
                Assert.fail((String)"No test snapshot is in place to execute this test");
            }
            return;
        }
        Snapshot s = support.getSnapshot(this.testSnapshotId);
        Assert.assertNotNull((String)("The test snapshot was not found in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName()), (Object)s);
        Iterable shares = support.listShares(s.getProviderSnapshotId());
        tm.out("Snapshot ID", s.getProviderSnapshotId());
        tm.out("Current State", s.getCurrentState());
        tm.out("Name", s.getName());
        tm.out("Created", new Date(s.getSnapshotTimestamp()));
        tm.out("Owner Account", s.getOwner());
        tm.out("Region ID", s.getRegionId());
        tm.out("Volume ID", s.getVolumeId());
        tm.out("Size (GB)", s.getSizeInGb());
        tm.out("Progress", s.getProgress());
        tm.out("Shares", shares);
        Map tags = s.getTags();
        if (tags != null) {
            for (Map.Entry entry : tags.entrySet()) {
                tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        tm.out("Description", s.getDescription());
        this.assertSnapshot(s);
    }

    @Test
    public void listSnapshots() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable snapshots = support.listSnapshots();
        int count = 0;
        Assert.assertNotNull((Object)"Snapshot list may be empty, but it cannot be null");
        for (Snapshot snapshot : snapshots) {
            ++count;
            tm.out("Snapshot", snapshot);
        }
        tm.out("Total Snapshot Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The account is not subscribed for snapshots, but the snapshot count was non-zero", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("No snapshots were found in the cloud so this test may not be valid");
        } else {
            for (Snapshot snapshot : snapshots) {
                this.assertSnapshot(snapshot);
            }
        }
    }

    @Test
    public void listSnapshotStatus() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable snapshots = support.listSnapshotStatus();
        int count = 0;
        Assert.assertNotNull((Object)"Snapshot status list may be empty, but it cannot be null");
        for (ResourceStatus snapshot : snapshots) {
            ++count;
            tm.out("Snapshot Status", snapshot);
        }
        tm.out("Total Snapshot Status Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The account is not subscribed for snapshots, but the snapshot status count was non-zero", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("No snapshot status instances were found in the cloud so this test may not be valid");
        }
    }

    @Test
    public void compareVSnapshotListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("Compute services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SnapshotSupport support = services.getSnapshotSupport();
        if (support == null) {
            tm.ok("Snapshots are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Iterable snapshots = support.listSnapshots();
        Iterable status = support.listSnapshotStatus();
        Assert.assertNotNull((String)"listSnapshots() must return at least an empty collections and may not be null", (Object)snapshots);
        Assert.assertNotNull((String)"listSnapshotStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (Snapshot snapshot : snapshots) {
            current = (Map)map.get(snapshot.getProviderSnapshotId());
            if (current == null) {
                current = new HashMap();
                map.put(snapshot.getProviderSnapshotId(), current);
            }
            current.put("snapshot", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean v = (Boolean)((Map)entry.getValue()).get("snapshot");
            Assert.assertTrue((String)("Status and snapshot lists do not match for " + (String)entry.getKey()), (s != null && v != null && s != false && v != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }
}

