/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Date;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessVMMonitoringTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testVMId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessVMMonitoringTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testVMId = tm.getTestVMId("stateless", null, false, null);
    }

    @After
    public void after() {
        this.testVMId = null;
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                tm.out("Basic Analytics", support.getCapabilities().isBasicAnalyticsSupported());
                tm.out("Extended Analytics", support.getCapabilities().isExtendedAnalyticsSupported());
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getConsoleOutput() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    String output = support.getConsoleOutput(this.testVMId);
                    tm.out("Console", output);
                    Assert.assertNotNull((String)"Console output may be empty, but it cannot be null", (Object)output);
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test virtual machine exists and thus no test could be run for " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getStatisticsForLastHour() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    VmStatistics stats = support.getVMStatistics(this.testVMId, System.currentTimeMillis() - 3600000L, System.currentTimeMillis());
                    tm.out("Statistics", stats);
                    Assert.assertNotNull((String)"Statistics object may be empty, but it cannot be null", (Object)stats);
                    tm.out("Sample Count", stats.getSamples());
                    tm.out("Sample Start", new Date(stats.getStartTimestamp()));
                    tm.out("Sample End", new Date(stats.getEndTimestamp()));
                    tm.out("Min CPU", stats.getMinimumCpuUtilization());
                    tm.out("Max CPU", stats.getMaximumCpuUtilization());
                    tm.out("Avg CPU", stats.getAverageCpuUtilization());
                    tm.out("Min Disk Read Bytes", stats.getMinimumDiskReadBytes());
                    tm.out("Max Disk Read Bytes", stats.getMaximumDiskReadBytes());
                    tm.out("Avg Disk Read Bytes", stats.getAverageDiskReadBytes());
                    tm.out("Min Disk Read Ops", stats.getMinimumDiskReadOperations());
                    tm.out("Max Disk Read Ops", stats.getMaximumDiskReadOperations());
                    tm.out("Avg Disk Read Ops", stats.getAverageDiskReadOperations());
                    tm.out("Min Disk Write Bytes", stats.getMinimumDiskWriteBytes());
                    tm.out("Max Disk Write Bytes", stats.getMaximumDiskWriteBytes());
                    tm.out("Avg Disk Write Bytes", stats.getAverageDiskWriteBytes());
                    tm.out("Min Disk Write Ops", stats.getMinimumDiskWriteOperations());
                    tm.out("Max Disk Write Ops", stats.getMaximumDiskWriteOperations());
                    tm.out("Avg Disk Write Ops", stats.getAverageDiskWriteOperations());
                    tm.out("Min Network In", stats.getMinimumNetworkIn());
                    tm.out("Max Network In", stats.getMaximumNetworkIn());
                    tm.out("Avg Network In", stats.getAverageNetworkIn());
                    tm.out("Min Network Out", stats.getMinimumNetworkOut());
                    tm.out("Max Network Out", stats.getMaximumNetworkOut());
                    tm.out("Avg Network Out", stats.getAverageNetworkOut());
                    if (stats.getSamples() > 0) {
                        Assert.assertTrue((String)"Sample start must be an hour ago", (stats.getStartTimestamp() >= System.currentTimeMillis() - 3660000L ? 1 : 0) != 0);
                        Assert.assertTrue((String)"Sample end must be greater than the sample start", (stats.getEndTimestamp() >= stats.getStartTimestamp() ? 1 : 0) != 0);
                    }
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test virtual machine exists and thus no test could be run for " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getSamplesForLastHour() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    Iterable samples = support.getVMStatisticsForPeriod(this.testVMId, System.currentTimeMillis() - 3600000L, System.currentTimeMillis());
                    tm.out("Has Samples", samples != null);
                    Assert.assertNotNull((String)"Samples may be empty, but they may not be null", (Object)samples);
                    VmStatistics lastSample = null;
                    for (VmStatistics sample : samples) {
                        tm.out(new Date(sample.getStartTimestamp()).toString(), sample);
                        if (lastSample != null) {
                            Assert.assertTrue((String)"Samples must be ordered from oldest to newest", (lastSample.getStartTimestamp() < sample.getStartTimestamp() ? 1 : 0) != 0);
                        }
                        lastSample = sample;
                    }
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test virtual machine exists and thus no test could be run for " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

