/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.SpotPrice;
import org.dasein.cloud.compute.SpotPriceHistory;
import org.dasein.cloud.compute.SpotPriceHistoryFilterOptions;
import org.dasein.cloud.compute.SpotVirtualMachineRequest;
import org.dasein.cloud.compute.SpotVirtualMachineRequestCreateOptions;
import org.dasein.cloud.compute.SpotVirtualMachineRequestFilterOptions;
import org.dasein.cloud.compute.SpotVirtualMachineRequestType;
import org.dasein.cloud.compute.VMFilterOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineLifecycle;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.test.DaseinTestManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.junit.rules.TestName;

public class StatelessVMTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testVMId;
    private String testImageId;
    private String testProductId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessVMTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testVMId = tm.getTestVMId("stateless", null, false, null);
        this.testImageId = tm.getTestImageId("stateless", false);
        this.testProductId = tm.getTestVMProductId();
    }

    @After
    public void after() {
        this.testVMId = null;
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Requirement r;
                HashMap<String, Requirement> requirements = new HashMap<String, Requirement>();
                tm.out("Subscribed", support.isSubscribed());
                String termForServer = support.getCapabilities().getProviderTermForVirtualMachine(Locale.getDefault());
                tm.out("Term for VM", termForServer);
                int maxVmCount = support.getCapabilities().getMaximumVirtualMachineCount();
                if (maxVmCount == -2) {
                    tm.out("Max VM Count", "Unknown");
                } else if (maxVmCount == -1) {
                    tm.out("Max VM Count", "Unlimited");
                } else {
                    tm.out("Max VM Count", maxVmCount);
                }
                Iterable architectures = support.getCapabilities().listSupportedArchitectures();
                if (architectures == null) {
                    tm.out("Supported Architectures", null);
                } else {
                    ArrayList<Architecture> tmp = new ArrayList<Architecture>();
                    for (Architecture a : architectures) {
                        tmp.add(a);
                    }
                    tm.out("Supported Architectures", tmp);
                }
                for (ImageClass imageClass : ImageClass.values()) {
                    r = support.getCapabilities().identifyImageRequirement(imageClass);
                    tm.out("Image Class Req [" + imageClass.name() + "]", r);
                    requirements.put("Launch with Image Class " + imageClass.name() + " Requirement", r);
                }
                for (ImageClass imageClass : Platform.values()) {
                    r = support.getCapabilities().identifyPasswordRequirement((Platform)imageClass);
                    tm.out("Password Req [" + imageClass.name() + "]", r);
                    requirements.put("Password for Platform " + imageClass.name() + " Requirement", r);
                }
                for (ImageClass imageClass : Platform.values()) {
                    r = support.getCapabilities().identifyShellKeyRequirement((Platform)imageClass);
                    tm.out("Shell Key Req [" + imageClass.name() + "]", r);
                    requirements.put("Shell Key for Platform " + imageClass.name() + " Requirement", r);
                }
                r = support.getCapabilities().identifyRootVolumeRequirement();
                tm.out("Root Volume Req", r);
                requirements.put("Root Volume Requirement", r);
                r = support.getCapabilities().identifyStaticIPRequirement();
                tm.out("Static IP Req", r);
                r = support.getCapabilities().identifyVlanRequirement();
                requirements.put("Static IP Requirement", r);
                tm.out("VLAN Req", r);
                requirements.put("VLAN Requirement", r);
                tm.out("Prevent API Termination", support.getCapabilities().isAPITerminationPreventable());
                tm.out("User Data", support.getCapabilities().isUserDataSupported());
                VMScalingCapabilities capabilities = support.getCapabilities().getVerticalScalingCapabilities();
                if (capabilities == null) {
                    tm.out("VM Scaling Capabilities", "None");
                } else {
                    tm.out("SCALE [Creates New VM]", capabilities.isCreatesNewVirtualMachine());
                    tm.out("SCALE [Product Changes]", capabilities.isSupportsProductChanges());
                    r = capabilities.getAlterVmForNewVolume();
                    tm.out("SCALE [Alter for New Volume]", r);
                    requirements.put("Scaling [Alter VM for New Vol]", r);
                    r = capabilities.getAlterVmForVolumeChange();
                    tm.out("SCALE [Alter for Change Vol]", r);
                    requirements.put("Scaling [Alter VM for Change Volume]", r);
                }
                HashMap<VmState, Float> costFactors = new HashMap<VmState, Float>();
                for (VmState state : VmState.values()) {
                    float costFactor = support.getCapabilities().getCostFactor(state);
                    tm.out("Cost Factor [" + state.name() + "]", costFactor);
                    costFactors.put(state, Float.valueOf(costFactor));
                }
                Assert.assertTrue((String)"Max VM count must be -2, -1, or non-negative", (maxVmCount >= -2 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Supported architectures may not be null", (Object)architectures);
                Assert.assertNotNull((String)("Term for VM may not be null for any locale (Used " + Locale.getDefault() + ")"), (Object)termForServer);
                for (Map.Entry entry : requirements.entrySet()) {
                    Assert.assertNotNull((String)((String)entry.getKey() + " may not be null"), entry.getValue());
                }
                for (Map.Entry entry : costFactors.entrySet()) {
                    Assert.assertTrue((String)("Cost factor for " + ((VmState)entry.getKey()).name() + " must be at least 0.0f"), (((Float)entry.getValue()).floatValue() >= 0.0f ? 1 : 0) != 0);
                    Assert.assertTrue((String)("Cost factor for " + ((VmState)entry.getKey()).name() + " must be no more than 100.0f"), (((Float)entry.getValue()).floatValue() <= 100.0f ? 1 : 0) != 0);
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getBogusVMProduct() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                VirtualMachineProduct prd = support.getProduct(UUID.randomUUID().toString());
                tm.out("Bogus Product", prd);
                Assert.assertNull((String)"Bogus product was supposed to be none, but got a valid product.", (Object)prd);
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getVMProduct() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Assert.assertNotNull((String)"No test product was setup during configuration and so there's no test product to fetch", (Object)this.testProductId);
                VirtualMachineProduct prd = support.getProduct(this.testProductId);
                tm.out("Product", prd);
                Assert.assertNotNull((String)"Test product was not found in the request", (Object)prd);
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void productContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Assert.assertNotNull((String)"No test product was setup during configuration and so there's no test product to fetch", (Object)this.testProductId);
                VirtualMachineProduct prd = support.getProduct(this.testProductId);
                Assert.assertNotNull((String)"Test product was not found in the request", (Object)prd);
                tm.out("Product ID", prd.getProviderProductId());
                tm.out("Name", prd.getName());
                tm.out("CPU Count", prd.getCpuCount());
                tm.out("RAM", prd.getRamSize());
                tm.out("Root Volume", prd.getRootVolumeSize());
                tm.out("Hourly Rate", prd.getStandardHourlyRate());
                tm.out("Description", prd.getDescription());
                Assert.assertNotNull((String)"Product ID must not be null", (Object)prd.getProviderProductId());
                Assert.assertNotNull((String)"Product name may not be null", (Object)prd.getName());
                Assert.assertNotNull((String)"Product description may not be null", (Object)prd.getDescription());
                Assert.assertTrue((String)"Product CPU count must be greater than 0", (prd.getCpuCount() > 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Product RAM size must not be null", (Object)prd.getRamSize());
                Assert.assertTrue((String)"Product RAM size must be greater than 0", (prd.getRamSize().intValue() > 0 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Product root volume size may not be null", (Object)prd.getRootVolumeSize());
                Assert.assertTrue((String)"Product root volume size must be greater than 0", (prd.getRootVolumeSize().intValue() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Product hourly rate may not be negative", (prd.getStandardHourlyRate() >= 0.0f ? 1 : 0) != 0);
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listVMProducts() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                boolean found = false;
                int total = 0;
                for (Architecture architecture : support.getCapabilities().listSupportedArchitectures()) {
                    Iterable products = support.listProducts(architecture);
                    int count = 0;
                    Assert.assertNotNull((String)"listProducts() must return at least an empty collections and may not be null", (Object)products);
                    for (VirtualMachineProduct product : products) {
                        ++count;
                        ++total;
                        tm.out("VM Product [" + architecture.name() + "]", product);
                        if (this.testProductId == null || !this.testProductId.equals(product.getProviderProductId())) continue;
                        found = true;
                    }
                    tm.out("Total " + architecture.name() + " Product Count", count);
                }
                if (total < 1 && support.isSubscribed()) {
                    if (this.testProductId == null) {
                        tm.warn("No products were listed and thus the test may be in error");
                    } else {
                        Assert.fail((String)("Should have found test product " + this.testProductId + ", but none were found"));
                    }
                } else if (this.testProductId != null) {
                    Assert.assertTrue((String)("Failed to find test product " + this.testProductId + " among the listed products"), (boolean)found);
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getBogusVM() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                VirtualMachine vm = support.getVirtualMachine(UUID.randomUUID().toString());
                tm.out("Bogus VM", vm);
                Assert.assertNull((String)"Bogus VM was supposed to be none, but got a valid virtual machine.", (Object)vm);
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getVMPassword() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    String pass = support.getPassword(this.testVMId);
                    tm.out("Password for vm: ", pass);
                    Assert.assertNotNull((String)("Did not find the password for test virtual machine " + this.testVMId), (Object)pass);
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test virtual machine exists and thus no test could be run for getVMPassword");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getVirtualMachine() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVMId);
                    tm.out("Test Virtual Machine", vm);
                    Assert.assertNotNull((String)("Did not find the test virtual machine " + this.testVMId), (Object)vm);
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test virtual machine exists and thus no test could be run for getVirtualMachine");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void virtualMachineContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                if (this.testVMId != null) {
                    VirtualMachine vm = support.getVirtualMachine(this.testVMId);
                    Assert.assertNotNull((String)("Did not find the test virtual machine " + this.testVMId), (Object)vm);
                    tm.out("Virtual Machine ID", vm.getProviderVirtualMachineId());
                    tm.out("Current State", vm.getCurrentState());
                    tm.out("Name", vm.getName());
                    tm.out("Created", new Date(vm.getCreationTimestamp()));
                    tm.out("Owner Account", vm.getProviderOwnerId());
                    tm.out("Region ID", vm.getProviderRegionId());
                    tm.out("Data Center ID", vm.getProviderDataCenterId());
                    tm.out("VLAN ID", vm.getProviderVlanId());
                    tm.out("Subnet ID", vm.getProviderSubnetId());
                    tm.out("Product ID", vm.getProductId());
                    tm.out("Architecture", vm.getArchitecture());
                    tm.out("Platform", vm.getPlatform());
                    tm.out("Machine Image ID", vm.getProviderMachineImageId());
                    tm.out("Kernel Image ID", vm.getProviderKernelImageId());
                    tm.out("Ramdisk Image ID", vm.getProviderRamdiskImageId());
                    tm.out("Assigned IP ID", vm.getProviderAssignedIpAddressId());
                    tm.out("Public IPs", Arrays.toString(vm.getPublicAddresses()));
                    tm.out("Public DNS", vm.getPublicDnsAddress());
                    tm.out("Private IPs", Arrays.toString(vm.getPrivateAddresses()));
                    tm.out("Private DNS", vm.getPrivateDnsAddress());
                    tm.out("Shell Key IDs", Arrays.toString(vm.getProviderShellKeyIds()));
                    tm.out("Firewall IDs", Arrays.toString(vm.getProviderFirewallIds()));
                    tm.out("Root User", vm.getRootUser());
                    tm.out("Root Password", vm.getRootPassword());
                    tm.out("Pause", support.getCapabilities().canPause(vm.getCurrentState()));
                    tm.out("Unpause", support.getCapabilities().canUnpause(vm.getCurrentState()));
                    tm.out("Start", support.getCapabilities().canStart(vm.getCurrentState()));
                    tm.out("Stop", support.getCapabilities().canStop(vm.getCurrentState()));
                    tm.out("Suspend", support.getCapabilities().canSuspend(vm.getCurrentState()));
                    tm.out("Resume", support.getCapabilities().canResume(vm.getCurrentState()));
                    tm.out("Clonable", vm.isClonable());
                    tm.out("Imageable", vm.isImagable());
                    tm.out("Rebootable", vm.isRebootable());
                    tm.out("Description", vm.getDescription());
                    Map tags = vm.getTags();
                    Assert.assertNotNull((String)"Tags may not be null", (Object)vm.getTags());
                    for (Map.Entry entry : tags.entrySet()) {
                        tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                    }
                    Assert.assertNotNull((String)"VM ID may not be null", (Object)vm.getProviderVirtualMachineId());
                    Assert.assertNotNull((String)"VM state may not be null", (Object)vm.getCurrentState());
                    Assert.assertNotNull((String)"VM name may not be null", (Object)vm.getName());
                    Assert.assertNotNull((String)"VM description may not be null", (Object)vm.getDescription());
                    Assert.assertTrue((String)"VM creation may not be negative", (vm.getCreationTimestamp() >= 0L ? 1 : 0) != 0);
                    Assert.assertNotNull((String)"Owning account may not be null", (Object)vm.getProviderOwnerId());
                    Assert.assertNotNull((String)"VM region may not null", (Object)vm.getProviderRegionId());
                    Assert.assertEquals((String)"VM region must match current search region", (Object)tm.getContext().getRegionId(), (Object)vm.getProviderRegionId());
                    Assert.assertNotNull((String)"VM data center ID may not be null", (Object)vm.getProviderDataCenterId());
                    Assert.assertNotNull((String)"VM product ID may not be null", (Object)vm.getProductId());
                    Assert.assertNotNull((String)"VM architecture may not be null", (Object)vm.getArchitecture());
                    Assert.assertNotNull((String)"VM platform may not be null", (Object)vm.getPlatform());
                    Assert.assertNotNull((String)"Public IP addresses must not be null", (Object)vm.getPublicAddresses());
                    Assert.assertNotNull((String)"Private IP addresses must not be null", (Object)vm.getPrivateAddresses());
                    Assert.assertNotNull((String)"Shell key ID list may not be null", (Object)vm.getProviderShellKeyIds());
                    Assert.assertNotNull((String)"Firewall ID list may not be null", (Object)vm.getProviderFirewallIds());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test virtual machine exists and thus no test could be run for getVirtualMachine");
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listVMs() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Iterable vms = support.listVirtualMachines();
                boolean found = false;
                int count = 0;
                Assert.assertNotNull((String)"listVirtualMachines() must return at least an empty collections and may not be null", (Object)vms);
                for (VirtualMachine vm : vms) {
                    ++count;
                    tm.out("VM", vm);
                    if (this.testVMId == null || !this.testVMId.equals(vm.getProviderVirtualMachineId())) continue;
                    found = true;
                }
                tm.out("Total VM Count", count);
                if (count < 1 && support.isSubscribed()) {
                    if (this.testVMId == null) {
                        tm.warn("No virtual machines were listed and thus the test may be in error");
                    } else {
                        Assert.fail((String)("Should have found test virtual machine " + this.testVMId + ", but none were found"));
                    }
                } else if (this.testVMId != null) {
                    Assert.assertTrue((String)("Failed to find test VM " + this.testVMId + " among the listed virtual machines"), (boolean)found);
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listSpotPriceHistories() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services == null) {
            tm.ok("No compute services in this cloud");
            return;
        }
        VirtualMachineSupport support = services.getVirtualMachineSupport();
        if (support == null) {
            tm.ok("No virtual machine support in this cloud");
            return;
        }
        if (!support.getCapabilities().supportsSpotVirtualMachines()) {
            tm.ok("Spot Virtual Machines are not supported in this cloud");
            return;
        }
        long timeEnd = System.currentTimeMillis();
        long timeStart = System.currentTimeMillis() - 0x6DDD00L;
        SpotPriceHistoryFilterOptions options = SpotPriceHistoryFilterOptions.getInstance().matchingAny().matchingInterval(timeStart, timeEnd);
        Iterable histories = support.listSpotPriceHistories(options);
        int count = 0;
        int prices = 0;
        Assert.assertNotNull((String)"listSpotPriceHistories() must return at least an empty collection and never a null", (Object)histories);
        for (SpotPriceHistory h : histories) {
            ++count;
            tm.out("SpotPriceHistory", h);
            for (SpotPrice price : h.getPriceHistory()) {
                Assert.assertThat((String)"SpotPrice timestamp outside requested bounds", (Object)price.getTimestamp(), (Matcher)CoreMatchers.is((Matcher)JUnitMatchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(timeStart))).and(Matchers.lessThan((Comparable)Long.valueOf(timeEnd)))));
                ++prices;
            }
        }
        tm.out("Total SpotPriceHistory Count", count);
        tm.out("Total SpotPrice Count", prices);
        if (count > 0) {
            SpotPriceHistory sph = (SpotPriceHistory)histories.iterator().next();
            VirtualMachineProduct prod = support.getProduct(sph.getProductId());
            Assert.assertNotNull((String)("SpotPriceHistory belongs to an unknown product (" + sph.getProductId() + ")"), (Object)prod);
        } else {
            tm.warn("SpotPriceHistory is empty, the test is likely INVALID");
        }
    }

    @Test
    public void listVMStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Iterable vms = support.listVirtualMachineStatus();
                boolean found = false;
                int count = 0;
                Assert.assertNotNull((String)"listVirtualMachineStatus() must return at least an empty collections and may not be null", (Object)vms);
                for (ResourceStatus vm : vms) {
                    ++count;
                    tm.out("VM Status", vm);
                    if (this.testVMId == null || !this.testVMId.equals(vm.getProviderResourceId())) continue;
                    found = true;
                }
                tm.out("Total VM Count", count);
                if (count < 1 && support.isSubscribed()) {
                    if (this.testVMId == null) {
                        tm.warn("No virtual machines were listed and thus the test may be in error");
                    } else {
                        Assert.fail((String)("Should have found test virtual machine " + this.testVMId + ", but none were found"));
                    }
                } else if (this.testVMId != null) {
                    Assert.assertTrue((String)("Failed to find test VM " + this.testVMId + " in the listed virtual machine status"), (boolean)found);
                }
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void compareVMListAndStatus() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VirtualMachineSupport support = services.getVirtualMachineSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Iterable vms = support.listVirtualMachines();
                Iterable status = support.listVirtualMachineStatus();
                Assert.assertNotNull((String)"listVirtualMachines() must return at least an empty collections and may not be null", (Object)vms);
                Assert.assertNotNull((String)"listVirtualMachineStatus() must return at least an empty collections and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (VirtualMachine virtualMachine : vms) {
                    current = (Map)map.get(virtualMachine.getProviderVirtualMachineId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(virtualMachine.getProviderVirtualMachineId(), current);
                    }
                    current.put("vm", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean v = (Boolean)((Map)entry.getValue()).get("vm");
                    Assert.assertTrue((String)("Status and VM lists do not match for " + (String)entry.getKey()), (s != null && v != null && s != false && v != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No virtual machine support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void requestSpotVm() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices == null) {
            tm.ok("No compute services in this cloud");
            return;
        }
        VirtualMachineSupport vmSupport = computeServices.getVirtualMachineSupport();
        if (vmSupport == null) {
            tm.ok("No virtual machine support in this cloud");
            return;
        }
        if (!vmSupport.getCapabilities().supportsSpotVirtualMachines()) {
            tm.ok("Spot Virtual Machines are not supported in this cloud");
            return;
        }
        Assert.assertNotNull((String)"Test imageId is null", (Object)this.testImageId);
        Assert.assertNotNull((String)"Test productId is null", (Object)this.testProductId);
        ArrayList<VirtualMachine> before = new ArrayList<VirtualMachine>();
        for (VirtualMachine vm : vmSupport.listVirtualMachines(VMFilterOptions.getInstance().withLifecycles(new VirtualMachineLifecycle[]{VirtualMachineLifecycle.SPOT}))) {
            before.add(vm);
        }
        if (before.size() > 0) {
            tm.warn("There are " + before.size() + " spot VMs already running, test may not be clean or you may have leaking resources.");
        }
        long validFrom = System.currentTimeMillis() / 1000L * 1000L + 15000L;
        long validUntil = validFrom + 600000L;
        float price = 0.05f;
        SpotVirtualMachineRequest request = vmSupport.createSpotVirtualMachineRequest(SpotVirtualMachineRequestCreateOptions.getInstance((String)this.testProductId, (String)this.testImageId, (float)price).validFrom(validFrom).validUntil(validUntil).ofType(SpotVirtualMachineRequestType.ONE_TIME));
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((String)"Created Spot VM request has an invalid product", (Object)this.testProductId, (Object)request.getProductId());
        Assert.assertEquals((String)"Created Spot VM request has an invalid image", (Object)this.testImageId, (Object)request.getProviderMachineImageId());
        Assert.assertEquals((String)"Created Spot VM request has an invalid price", (double)price, (double)request.getSpotPrice(), (double)0.01);
        Assert.assertEquals((String)"Created Spot VM request has an incorrect valid-from time", (long)validFrom, (long)request.getValidFromTimestamp());
        Assert.assertEquals((String)"Created Spot VM request has an incorrect valid-until time", (long)validUntil, (long)request.getValidUntilTimestamp());
        Assert.assertEquals((String)"Created Spot VM request has an incorrect type", (Object)SpotVirtualMachineRequestType.ONE_TIME, (Object)request.getType());
        if (System.currentTimeMillis() < validFrom) {
            Assert.assertNull((String)"Created Spot VM request indicates a fulfilled DC but it is too soon", (Object)request.getFulfillmentDataCenterId());
            Assert.assertEquals((String)"Created Spot VM request indicates a fulfillment time but it is too soon", (long)0L, (long)request.getFulfillmentTimestamp());
        }
        VirtualMachine launchedVm = null;
        while (launchedVm == null) {
            Iterator vms = vmSupport.listVirtualMachines(VMFilterOptions.getInstance().withSpotRequestId(request.getProviderSpotVmRequestId())).iterator();
            if (vms.hasNext()) {
                launchedVm = (VirtualMachine)vms.next();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= validUntil) continue;
            break;
        }
        if (launchedVm != null) {
            Assert.assertEquals((String)"Found Spot VM is an incorrect product", (Object)this.testProductId, (Object)launchedVm.getProductId());
            Assert.assertEquals((String)"Found Spot VM is launched from incorrect image", (Object)this.testImageId, (Object)launchedVm.getProviderMachineImageId());
        } else {
            tm.warn("Spot VM has failed to run within the allotted time, perhaps price is too low?");
        }
        Iterator requests = vmSupport.listSpotVirtualMachineRequests(SpotVirtualMachineRequestFilterOptions.getInstance().withSpotRequestIds(new String[]{request.getProviderSpotVmRequestId()})).iterator();
        SpotVirtualMachineRequest verifyRequest = null;
        if (requests.hasNext()) {
            verifyRequest = (SpotVirtualMachineRequest)requests.next();
        }
        Assert.assertNotNull((String)"Expected to be able to list the known spot request, but failed", verifyRequest);
        Assert.assertEquals((String)"Found Spot VM request indicates an incorrect image", (Object)this.testImageId, (Object)verifyRequest.getProviderMachineImageId());
        Assert.assertEquals((String)"Found Spot VM request indicates an incorrect product", (Object)this.testProductId, (Object)verifyRequest.getProductId());
        Assert.assertEquals((String)"Found Spot VM request indicates incorrect valid-from time", (long)validFrom, (long)verifyRequest.getValidFromTimestamp());
        Assert.assertEquals((String)"Found Spot VM request indicates incorrect valid-until time", (long)validUntil, (long)verifyRequest.getValidUntilTimestamp());
        Assert.assertThat((String)"Found Spot VM request indicates an incorrect fulfillment time", (Object)verifyRequest.getFulfillmentTimestamp(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((String)"Found Spot VM request indicates an incorrect datacenter", (Object)launchedVm.getProviderDataCenterId(), (Object)verifyRequest.getFulfillmentDataCenterId());
        vmSupport.cancelSpotVirtualMachineRequest(request.getProviderSpotVmRequestId());
        if (launchedVm != null) {
            vmSupport.terminate(launchedVm.getName());
        }
    }
}

