/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.util.uom.storage.Storage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessVolumeTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testProductId;
    private String testVolumeId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessVolumeTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    private void assertProductContent(@Nonnull VolumeSupport support, @Nonnull VolumeProduct product) throws CloudException, InternalException {
        Assert.assertNotNull((String)"Volume product ID may not be null", (Object)product.getProviderProductId());
        Assert.assertNotNull((String)"Volume product name may not be null", (Object)product.getName());
        Assert.assertNotNull((String)"Volume product description may not be null", (Object)product.getDescription());
        Assert.assertNotNull((String)"Volume product type may not be null", (Object)product.getType());
        Assert.assertTrue((String)"Volume product max IOPS must be greater than or equal to the min IOPS", (product.getMaxIops() >= product.getMinIops() ? 1 : 0) != 0);
        Float f = product.getIopsCost();
        if (f != null) {
            Assert.assertTrue((String)"Volume product IOPS cost must be non-negative", (f.floatValue() >= 0.0f ? 1 : 0) != 0);
        }
        if ((f = product.getMonthlyGigabyteCost()) != null) {
            Assert.assertTrue((String)"Volume product monthly per-GB cost must be non-negative", (f.floatValue() >= 0.0f ? 1 : 0) != 0);
        }
        Storage size = product.getVolumeSize();
        if (support.getCapabilities().isVolumeSizeDeterminedByProduct()) {
            Assert.assertNotNull((String)"Volume size may not be null when the volume size is determined by the product", (Object)size);
            Assert.assertTrue((String)"Volume size must be a positive number when the volume size is determined by the product", (size.floatValue() >= 0.01f ? 1 : 0) != 0);
        } else if (size != null) {
            Assert.assertTrue((String)"Volume size must be non-negative", (size.floatValue() >= 0.0f ? 1 : 0) != 0);
        }
    }

    private void assertVolumeContent(@Nonnull VolumeSupport support, @Nonnull Volume volume) throws CloudException, InternalException {
        Assert.assertNotNull((String)"Volume ID may not be null", (Object)volume.getProviderVolumeId());
        Assert.assertNotNull((String)"Volume state may not be null", (Object)volume.getCurrentState());
        Assert.assertNotNull((String)"Volume name may not be null", (Object)volume.getName());
        Assert.assertNotNull((String)"Volume description may not be null", (Object)volume.getDescription());
        Assert.assertTrue((String)"Volume creation date must be non-negative", (volume.getCreationTimestamp() > -1L ? 1 : 0) != 0);
        if (volume.getCreationTimestamp() < 2L) {
            tm.warn("Meaningless creation timestamp with volumes; does the cloud provider support this information?");
        }
        Assert.assertNotNull((String)"Volume region ID may not be null", (Object)volume.getProviderRegionId());
        Assert.assertNotNull((String)"Volume data center ID may not be null", (Object)volume.getProviderDataCenterId());
        if (support.getCapabilities().getVolumeProductRequirement().equals((Object)Requirement.REQUIRED)) {
            Assert.assertNotNull((String)"Volume product may not be null when a product requirement is REQUIRED", (Object)volume.getProviderProductId());
        }
        if (volume.isAttached()) {
            Assert.assertNotNull((String)"The volume virtual machine ID may not be null when attached", (Object)volume.getProviderVirtualMachineId());
        } else {
            Assert.assertNull((String)"The volume virtual machine ID mustbe null when not attached", (Object)volume.getProviderVirtualMachineId());
        }
        Storage size = volume.getSize();
        Assert.assertNotNull((String)"The volume size may not be null", (Object)size);
        Assert.assertTrue((String)"The volume size must be greater than 0", (size.floatValue() > 0.0f ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Volume type may not be null", (Object)volume.getType());
        Assert.assertNotNull((String)"Volume format may not be null", (Object)volume.getFormat());
        if (volume.isRootVolume()) {
            Assert.assertNotNull((String)"Guest OS may not be null for root volumes", (Object)volume.getGuestOperatingSystem());
        }
        Assert.assertNotNull((String)"Tags may be empty, but they may not be null", (Object)volume.getTags());
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testVolumeId = tm.getTestVolumeId("stateless", false, null, null);
        this.testProductId = tm.getTestVolumeProductId();
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Iterable deviceIds;
                boolean subscribed = support.isSubscribed();
                tm.out("Subscribed", subscribed);
                tm.out("Term for Volume", support.getCapabilities().getProviderTermForVolume(Locale.getDefault()));
                int maxVolumes = support.getCapabilities().getMaximumVolumeCount();
                tm.out("Max Volume Count", maxVolumes == -2 ? "Unknown" : (maxVolumes == -1 ? "Unlimited" : String.valueOf(maxVolumes)));
                Storage maxSize = support.getCapabilities().getMaximumVolumeSize();
                tm.out("Max Volume Size", (Object)(maxSize == null ? "Unknown" : maxSize));
                tm.out("Min Volume Size", support.getCapabilities().getMinimumVolumeSize());
                tm.out("Product Required", support.getCapabilities().getVolumeProductRequirement());
                tm.out("Product Determines Size", support.getCapabilities().isVolumeSizeDeterminedByProduct());
                Iterable formats = support.getCapabilities().listSupportedFormats();
                tm.out("Supported Formats", formats);
                for (Platform platform : Platform.values()) {
                    deviceIds = support.getCapabilities().listPossibleDeviceIds(platform);
                    tm.out("Device IDs [" + platform + "]", deviceIds);
                }
                Assert.assertNotNull((String)"The provider term for a volume must not be null", (Object)support.getCapabilities().getProviderTermForVolume(Locale.getDefault()));
                Assert.assertTrue((String)"Maximum volumes must be -2 or greater", (maxVolumes >= -2 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Maximum volume size must be non-negative", (maxSize == null || maxSize.intValue() > -1 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Minimum volume size may not be null", (Object)support.getCapabilities().getMinimumVolumeSize());
                Assert.assertTrue((String)"Minimum volume size must be at least 1K", ((float)support.getCapabilities().getMinimumVolumeSize().intValue() >= 0.01f ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Product requirement must not be null", (Object)support.getCapabilities().getVolumeProductRequirement());
                Assert.assertNotNull((String)"Supported formats must be non-null and have at least one member when subscribed", (Object)formats);
                Assert.assertTrue((String)"There must be at least one supported format when subscribed", (!subscribed || formats.iterator().hasNext() ? 1 : 0) != 0);
                for (Platform platform : Platform.values()) {
                    deviceIds = support.getCapabilities().listPossibleDeviceIds(platform);
                    Assert.assertNotNull((String)("The list of device IDs for " + platform + " may not be null"), (Object)deviceIds);
                    Assert.assertTrue((String)("There must be at least one device ID for " + platform), (boolean)deviceIds.iterator().hasNext());
                }
            } else {
                tm.ok(tm.getProvider().getCloudName() + " does not support volumes");
            }
        } else {
            tm.ok(tm.getProvider().getCloudName() + " does not support compute services");
        }
    }

    @Test
    public void volumeProductContent() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (this.testProductId != null) {
                    VolumeProduct product = null;
                    for (VolumeProduct p : support.listVolumeProducts()) {
                        if (!p.getProviderProductId().equals(this.testProductId)) continue;
                        product = p;
                        break;
                    }
                    Assert.assertNotNull((String)("Unable to find the test volume product " + this.testProductId), product);
                    tm.out("Volume Product ID", product.getProviderProductId());
                    tm.out("Name", product.getName());
                    tm.out("Type", product.getType());
                    tm.out("Size", product.getVolumeSize());
                    tm.out("Min IOPS", product.getMinIops());
                    tm.out("Max IOPS", product.getMaxIops());
                    tm.out("Currency", product.getCurrency());
                    tm.out("IOPS Cost", product.getIopsCost());
                    tm.out("Storage Cost", product.getMonthlyGigabyteCost());
                    tm.out("Description", product.getDescription());
                    this.assertProductContent(support, product);
                } else if (support.getCapabilities().getVolumeProductRequirement().equals((Object)Requirement.REQUIRED)) {
                    Assert.fail((String)"No test product exists for this test even though products are supported");
                } else {
                    tm.ok("Volume products are not required in this cloud");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listVolumeProducts() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Iterable products = support.listVolumeProducts();
                int count = 0;
                Assert.assertNotNull((String)"The volume product list may possibly be empty, but it may not be null", (Object)products);
                for (VolumeProduct product : products) {
                    ++count;
                    tm.out("Volume Product", product);
                }
                tm.out("Total Volume Product Count", count);
                if (!support.isSubscribed()) {
                    Assert.assertTrue((String)"The account is not subscribed, but the volume count is non-zero", (count == 0 ? 1 : 0) != 0);
                } else if (support.getCapabilities().getVolumeProductRequirement().equals((Object)Requirement.NONE)) {
                    Assert.assertEquals((String)"This cloud does not support volume products, but there's at least one product", (long)0L, (long)count);
                } else if (support.getCapabilities().getVolumeProductRequirement().equals((Object)Requirement.REQUIRED)) {
                    Assert.assertTrue((String)"There must be at least one product in this cloud", (count > 0 ? 1 : 0) != 0);
                }
                for (VolumeProduct product : products) {
                    this.assertProductContent(support, product);
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getBogusVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Volume volume = support.getVolume(UUID.randomUUID().toString());
                tm.out("Bogus Volume", volume);
                Assert.assertNull((String)"Bogus volume was supposed to be none, but got a valid volume.", (Object)volume);
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getVolume() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    tm.out("Volume", volume);
                    Assert.assertNotNull((String)"Unable to find the test volume in the cloud", (Object)volume);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test volume exists, but the account is not subscribed");
                } else {
                    Assert.fail((String)("No test volume exists in support for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void volumeContent() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                if (this.testVolumeId != null) {
                    Volume volume = support.getVolume(this.testVolumeId);
                    Assert.assertNotNull((String)"Unable to find the test volume in the cloud", (Object)volume);
                    tm.out("Volume ID", volume.getProviderVolumeId());
                    tm.out("Current State", volume.getCurrentState());
                    tm.out("Name", volume.getName());
                    tm.out("Created", new Date(volume.getCreationTimestamp()));
                    tm.out("Region ID", volume.getProviderRegionId());
                    tm.out("Data Center ID", volume.getProviderDataCenterId());
                    tm.out("Product ID", volume.getProviderProductId());
                    tm.out("IIOPS", volume.getIops());
                    tm.out("Size", volume.getSize());
                    tm.out("Snapshot ID", volume.getProviderSnapshotId());
                    tm.out("Attached", volume.isAttached());
                    tm.out("Attached To", volume.getProviderVirtualMachineId());
                    tm.out("Device ID", volume.getDeviceId());
                    tm.out("Type", volume.getType());
                    tm.out("Format", volume.getFormat());
                    tm.out("In VLAN", volume.getProviderVlanId());
                    tm.out("Is Root", volume.isRootVolume());
                    tm.out("Guest OS", volume.getGuestOperatingSystem());
                    tm.out("Media Link", volume.getMediaLink());
                    Map tags = volume.getTags();
                    if (tags != null) {
                        for (Map.Entry entry : tags.entrySet()) {
                            tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    tm.out("Description", volume.getDescription());
                    this.assertVolumeContent(support, volume);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test volume exists, but the account is not subscribed");
                } else {
                    Assert.fail((String)("No test volume exists in support for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listVolumes() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Iterable volumes = support.listVolumes();
                int count = 0;
                Assert.assertNotNull((String)"The volumes list may be empty, but it may not be null", (Object)volumes);
                for (Volume volume : volumes) {
                    ++count;
                    tm.out("Volume", volume);
                }
                tm.out("Total Volume Count", count);
                if (!support.isSubscribed()) {
                    Assert.assertTrue((String)"The account is not subscribed, but the volume count is non-zero", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No volumes were returned from the list request so the results of this test are questionable");
                }
                if (count > 0) {
                    for (Volume volume : volumes) {
                        this.assertVolumeContent(support, volume);
                    }
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listVolumeStatus() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Iterable volumes = support.listVolumeStatus();
                int count = 0;
                Assert.assertNotNull((String)"The volume status list may be empty, but it may not be null", (Object)volumes);
                for (ResourceStatus volume : volumes) {
                    ++count;
                    tm.out("Volume Status", volume);
                }
                tm.out("Total Volume Status Count", count);
                if (!support.isSubscribed()) {
                    Assert.assertTrue((String)"The account is not subscribed, but the volume status count is non-zero", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No volume status instances were returned from the list request so the results of this test are questionable");
                }
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void compareVolumeListAndStatus() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            VolumeSupport support = services.getVolumeSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Iterable volumes = support.listVolumes();
                Iterable status = support.listVolumeStatus();
                Assert.assertNotNull((String)"listVolumes() must return at least an empty collections and may not be null", (Object)volumes);
                Assert.assertNotNull((String)"listVolumeStatus() must return at least an empty collection and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (Volume volume : volumes) {
                    current = (Map)map.get(volume.getProviderVolumeId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(volume.getProviderVolumeId(), current);
                    }
                    current.put("volume", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean v = (Boolean)((Map)entry.getValue()).get("volume");
                    Assert.assertTrue((String)("Status and volume lists do not match for " + (String)entry.getKey()), (s != null && v != null && s != false && v != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No volume support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

