/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.identity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.CloudGroup;
import org.dasein.cloud.identity.CloudUser;
import org.dasein.cloud.identity.IdentityAndAccessSupport;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.test.DaseinTestManager;

public class IdentityResources {
    private static final Logger logger = Logger.getLogger(IdentityResources.class);
    private static final Random random = new Random();
    private final HashMap<String, String> testGroups = new HashMap();
    private final HashMap<String, String> testKeys = new HashMap();
    private final HashMap<String, String> testUsers = new HashMap();
    private CloudProvider provider;

    public IdentityResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    public int close() {
        int count = 0;
        try {
            IdentityServices identityServices = this.provider.getIdentityServices();
            if (identityServices != null) {
                IdentityAndAccessSupport iamSupport;
                ShellKeySupport keySupport = identityServices.getShellKeySupport();
                if (keySupport != null) {
                    for (Map.Entry<String, String> entry : this.testKeys.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            keySupport.deleteKeypair(entry.getValue());
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test keypair " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                }
                if ((iamSupport = identityServices.getIdentityAndAccessSupport()) != null) {
                    for (Map.Entry<String, String> entry : this.testUsers.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            iamSupport.removeUser(entry.getValue());
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test user " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                    for (Map.Entry<String, String> entry : this.testGroups.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            iamSupport.removeGroup(entry.getValue());
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test group " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testKeys.remove("stateless");
        if (!this.testKeys.isEmpty()) {
            logger.info((Object)"Provisioned Identity Resources:");
            header = true;
            count += this.testKeys.size();
            DaseinTestManager.out(logger, null, "---> SSH Keypairs", this.testKeys.size() + " " + this.testKeys);
        }
        this.testGroups.remove("stateless");
        if (!this.testGroups.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Identity Resources:");
                header = true;
            }
            count += this.testGroups.size();
            DaseinTestManager.out(logger, null, "---> Groups", this.testGroups.size() + " " + this.testGroups);
        }
        this.testUsers.remove("stateless");
        if (!this.testUsers.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Identity Resources:");
            }
            count += this.testUsers.size();
            DaseinTestManager.out(logger, null, "---> Users", this.testUsers.size() + " " + this.testUsers);
        }
        return count;
    }

    @Nullable
    public String getTestGroupId(@Nonnull String label, boolean provisionIfNull) {
        IdentityAndAccessSupport support;
        IdentityServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testGroups.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessGroup();
        }
        String id = this.testGroups.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getIdentityServices()) != null && (support = services.getIdentityAndAccessSupport()) != null) {
            try {
                return this.provisionGroup(support, label, "dsngroup");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestKeypairId(@Nonnull String label, boolean provisionIfNull) {
        ShellKeySupport support;
        IdentityServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testKeys.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessKeypair();
        }
        String id = this.testKeys.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getIdentityServices()) != null && (support = services.getShellKeySupport()) != null) {
            try {
                return this.provisionKeypair(support, label, "dsnkp");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestUserId(@Nonnull String label, boolean provisionIfNull, @Nullable String groupToJoin) {
        IdentityAndAccessSupport support;
        IdentityServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testUsers.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessUser(groupToJoin);
        }
        String id = this.testUsers.get(label);
        if (id != null) {
            IdentityAndAccessSupport support2;
            IdentityServices services2;
            if (groupToJoin != null && (services2 = this.provider.getIdentityServices()) != null && (support2 = services2.getIdentityAndAccessSupport()) != null) {
                try {
                    support2.addUserToGroups(id, new String[]{groupToJoin});
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            return id;
        }
        if (provisionIfNull && (services = this.provider.getIdentityServices()) != null && (support = services.getIdentityAndAccessSupport()) != null) {
            try {
                return this.provisionUser(support, label, "dsnuser", groupToJoin);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessGroup() {
        IdentityServices services = this.provider.getIdentityServices();
        if (services != null) {
            IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
            try {
                Iterator groups;
                if (support != null && support.isSubscribed() && (groups = support.listGroups(null).iterator()).hasNext()) {
                    String id = ((CloudGroup)groups.next()).getProviderGroupId();
                    this.testGroups.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessKeypair() {
        IdentityServices identityServices = this.provider.getIdentityServices();
        if (identityServices != null) {
            ShellKeySupport keySupport = identityServices.getShellKeySupport();
            try {
                Iterator keypairs;
                if (keySupport != null && keySupport.isSubscribed() && (keypairs = keySupport.list().iterator()).hasNext()) {
                    String id = ((SSHKeypair)keypairs.next()).getProviderKeypairId();
                    this.testKeys.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessUser(@Nullable String preferredGroupId) {
        IdentityServices services = this.provider.getIdentityServices();
        if (services != null) {
            IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Iterator users;
                    if (preferredGroupId != null && (users = support.listUsersInGroup(preferredGroupId).iterator()).hasNext()) {
                        String id = ((CloudUser)users.next()).getProviderUserId();
                        this.testUsers.put("stateless", id);
                        return id;
                    }
                    users = support.listUsersInPath(null).iterator();
                    if (users.hasNext()) {
                        String id = ((CloudUser)users.next()).getProviderUserId();
                        this.testUsers.put("stateless", id);
                        return id;
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionGroup(@Nonnull IdentityAndAccessSupport support, @Nonnull String label, @Nonnull String namePrefix) throws CloudException, InternalException {
        String id = support.createGroup(namePrefix + " " + System.currentTimeMillis(), "/dsntest", false).getProviderGroupId();
        if (id == null) {
            throw new CloudException("No group was created");
        }
        HashMap<String, String> hashMap = this.testGroups;
        synchronized (hashMap) {
            while (this.testGroups.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testGroups.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionKeypair(@Nonnull ShellKeySupport support, @Nonnull String label, @Nonnull String namePrefix) throws CloudException, InternalException {
        String id = null;
        if (support.getKeyImportSupport().equals((Object)Requirement.REQUIRED)) {
            String publicKey = null;
            if (publicKey != null) {
                id = support.importKeypair(namePrefix + System.currentTimeMillis() % 10000L, publicKey).getProviderKeypairId();
            }
        } else {
            id = support.createKeypair(namePrefix + System.currentTimeMillis() % 10000L).getProviderKeypairId();
        }
        if (id == null) {
            throw new CloudException("No keypair was generated");
        }
        HashMap<String, String> hashMap = this.testKeys;
        synchronized (hashMap) {
            while (this.testKeys.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testKeys.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionUser(@Nonnull IdentityAndAccessSupport support, @Nonnull String label, @Nonnull String namePrefix, String ... preferredGroups) throws CloudException, InternalException {
        String id = support.createUser(namePrefix + System.currentTimeMillis() % 10000L, "/dsntest", preferredGroups == null ? new String[]{} : preferredGroups).getProviderUserId();
        if (id == null) {
            throw new CloudException("No user was created");
        }
        HashMap<String, String> hashMap = this.testUsers;
        synchronized (hashMap) {
            while (this.testUsers.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testUsers.put(label, id);
        }
        return id;
    }
}

