/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.identity;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.identity.CloudGroup;
import org.dasein.cloud.identity.CloudPermission;
import org.dasein.cloud.identity.CloudPolicy;
import org.dasein.cloud.identity.CloudUser;
import org.dasein.cloud.identity.IdentityAndAccessSupport;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.identity.IdentityResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulIAMTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testGroupId;
    private String testPolicyId;
    private String testUserId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulIAMTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        IdentityServices services = tm.getProvider().getIdentityServices();
        IdentityAndAccessSupport support = null;
        if (services != null) {
            support = services.getIdentityAndAccessSupport();
        }
        if (this.name.getMethodName().equals("joinGroup")) {
            this.testGroupId = tm.getTestGroupId("stateful", true);
            this.testUserId = tm.getTestUserId("stateful", true, null);
            if (this.testUserId != null && this.testGroupId != null && support != null) {
                try {
                    Iterable groups = support.listGroupsForUser(this.testUserId);
                    boolean present = false;
                    for (CloudGroup group : groups) {
                        if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                        present = true;
                        break;
                    }
                    if (present) {
                        support.removeUserFromGroup(this.testUserId, this.testGroupId);
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("leaveGroup")) {
            this.testGroupId = tm.getTestGroupId("stateful", true);
            this.testUserId = tm.getTestUserId("stateful", true, null);
            if (this.testUserId != null && this.testGroupId != null && support != null) {
                try {
                    Iterable groups = support.listGroupsForUser(this.testUserId);
                    boolean present = false;
                    for (CloudGroup group : groups) {
                        if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                        present = true;
                        break;
                    }
                    if (!present) {
                        support.addUserToGroups(this.testUserId, new String[]{this.testGroupId});
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("removeGroup")) {
            this.testGroupId = tm.getTestGroupId("removed", true);
        } else if (this.name.getMethodName().equals("removeUser")) {
            this.testUserId = tm.getTestUserId("removed", true, null);
        } else if (this.name.getMethodName().equals("removeGroupPolicy")) {
            this.testGroupId = tm.getTestGroupId("stateful", true);
            if (this.testGroupId != null && support != null) {
                try {
                    for (CloudPolicy policy : support.listPoliciesForGroup(this.testGroupId)) {
                        try {
                            support.removeGroupPolicy(this.testGroupId, policy.getProviderPolicyId());
                        }
                        catch (Throwable ignore) {}
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    String[] ids = support.saveGroupPolicy(this.testGroupId, "DSN" + System.currentTimeMillis(), CloudPermission.ALLOW, FirewallSupport.CREATE_FIREWALL, null);
                    if (ids.length > 0) {
                        this.testPolicyId = ids[0];
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("removeUserPolicy")) {
            this.testUserId = tm.getTestUserId("stateful", true, null);
            if (this.testUserId != null && support != null) {
                try {
                    for (CloudPolicy policy : support.listPoliciesForUser(this.testUserId)) {
                        try {
                            support.removeUserPolicy(this.testUserId, policy.getProviderPolicyId());
                        }
                        catch (Throwable ignore) {}
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    String[] ids = support.saveUserPolicy(this.testUserId, "DSN" + System.currentTimeMillis(), CloudPermission.ALLOW, FirewallSupport.CREATE_FIREWALL, null);
                    if (ids.length > 0) {
                        this.testPolicyId = ids[0];
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("saveGroupPolicy")) {
            this.testGroupId = tm.getTestGroupId("stateful", true);
            if (this.testGroupId != null && support != null) {
                try {
                    for (CloudPolicy policy : support.listPoliciesForGroup(this.testGroupId)) {
                        try {
                            support.removeGroupPolicy(this.testGroupId, policy.getProviderPolicyId());
                        }
                        catch (Throwable ignore) {}
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("saveUserPolicy")) {
            this.testUserId = tm.getTestUserId("stateful", true, null);
            if (this.testUserId != null && support != null) {
                try {
                    for (CloudPolicy policy : support.listPoliciesForUser(this.testUserId)) {
                        try {
                            support.removeUserPolicy(this.testUserId, policy.getProviderPolicyId());
                        }
                        catch (Throwable ignore) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testGroupId = null;
            this.testPolicyId = null;
            this.testUserId = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void createGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityResources identity = DaseinTestManager.getIdentityResources();
        Assert.assertNotNull((String)"The tests failed to initialize a proper set of identity services", (Object)identity);
        String groupId = identity.provisionGroup(support, "provision", "dsncgrp");
        tm.out("New Group", groupId);
        Assert.assertNotNull((String)"The newly created group ID may not be null", (Object)groupId);
        CloudGroup group = support.getGroup(groupId);
        Assert.assertNotNull((String)("No group exists in the cloud for the new ID " + groupId), (Object)group);
        Assert.assertEquals((String)"The IDs for the requested group and the created group do not match", (Object)groupId, (Object)group.getProviderGroupId());
    }

    @Test
    public void saveGroupPolicy() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            Iterable policies = support.listPoliciesForGroup(this.testGroupId);
            boolean found = false;
            tm.out("Before", policies);
            for (CloudPolicy policy : policies) {
                if (!policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"Test policy exists before the start of the test", (boolean)found);
            String policyName = "DSN" + System.currentTimeMillis();
            String[] ids = support.saveGroupPolicy(this.testGroupId, policyName, CloudPermission.ALLOW, FirewallSupport.CREATE_FIREWALL, null);
            policies = support.listPoliciesForGroup(this.testGroupId);
            tm.out("After", policies);
            for (CloudPolicy policy : policies) {
                boolean matches = false;
                for (String id : ids) {
                    if (!id.equals(policy.getProviderPolicyId())) continue;
                    matches = true;
                    break;
                }
                if (!matches || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Unable to find new group permission", (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeGroupPolicy() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            Iterable policies = support.listPoliciesForGroup(this.testGroupId);
            boolean found = false;
            tm.out("Before", policies);
            for (CloudPolicy policy : policies) {
                if (!policy.getProviderPolicyId().equals(this.testPolicyId) || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Unable to find new group permission", (boolean)found);
            support.removeGroupPolicy(this.testGroupId, this.testPolicyId);
            policies = support.listPoliciesForGroup(this.testGroupId);
            tm.out("After", policies);
            found = false;
            for (CloudPolicy policy : policies) {
                if (!policy.getProviderPolicyId().equals(this.testPolicyId) || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"Test policy exists before the start of the test", (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            CloudGroup group = support.getGroup(this.testGroupId);
            Assert.assertNotNull((String)"The test group does not exist prior to running this test", (Object)group);
            tm.out("Before", group);
            support.removeGroup(this.testGroupId);
            group = support.getGroup(this.testGroupId);
            tm.out("After", group);
            Assert.assertNull((String)"The test group still exists after the removal", (Object)group);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void createUser() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityResources identity = DaseinTestManager.getIdentityResources();
        Assert.assertNotNull((String)"The tests failed to initialize a proper set of identity services", (Object)identity);
        String userId = identity.provisionUser(support, "provision", "dsncusr", new String[0]);
        tm.out("New User", userId);
        Assert.assertNotNull((String)"The newly created user ID may not be null", (Object)userId);
        CloudUser user = support.getUser(userId);
        Assert.assertNotNull((String)("No user exists in the cloud for the new ID " + userId), (Object)user);
        Assert.assertEquals((String)"The IDs for the requested user and the created user do not match", (Object)userId, (Object)user.getProviderUserId());
    }

    @Test
    public void joinGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null && this.testGroupId != null) {
            Iterable groups = support.listGroupsForUser(this.testUserId);
            boolean present = false;
            tm.out("Before", groups);
            for (CloudGroup group : groups) {
                if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                present = true;
                break;
            }
            Assert.assertFalse((String)"That user is already a member of the test group", (boolean)present);
            support.addUserToGroups(this.testUserId, new String[]{this.testGroupId});
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                groups = support.listGroupsForUser(this.testUserId);
                for (CloudGroup group : groups) {
                    if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                    present = true;
                    break;
                }
                if (present) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", groups);
            Assert.assertTrue((String)"The user is not a member of the target group after one minute", (boolean)present);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user/group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void leaveGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null && this.testGroupId != null) {
            Iterable groups = support.listGroupsForUser(this.testUserId);
            boolean present = false;
            tm.out("Before", groups);
            for (CloudGroup group : groups) {
                if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                present = true;
                break;
            }
            Assert.assertTrue((String)"The user is not a member of the target group and so cannot be tested for removal", (boolean)present);
            support.removeUserFromGroup(this.testUserId, this.testGroupId);
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                present = false;
                groups = support.listGroupsForUser(this.testUserId);
                for (CloudGroup group : groups) {
                    if (!this.testGroupId.equals(group.getProviderGroupId())) continue;
                    present = true;
                    break;
                }
                if (!present) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", groups);
            Assert.assertFalse((String)"That user remains a member of the group after one minute", (boolean)present);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user/group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void saveUserPolicy() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            Iterable policies = support.listPoliciesForUser(this.testUserId);
            boolean found = false;
            tm.out("Before", policies);
            for (CloudPolicy policy : policies) {
                if (!policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"Test policy exists before the start of the test", (boolean)found);
            String policyName = "DSN" + System.currentTimeMillis();
            String[] ids = support.saveUserPolicy(this.testUserId, policyName, CloudPermission.ALLOW, FirewallSupport.CREATE_FIREWALL, null);
            policies = support.listPoliciesForUser(this.testUserId);
            tm.out("After", policies);
            for (CloudPolicy policy : policies) {
                boolean matches = false;
                for (String id : ids) {
                    if (!id.equals(policy.getProviderPolicyId())) continue;
                    matches = true;
                    break;
                }
                if (!matches || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Unable to find new user permission", (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user exists for running the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeUserPolicy() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null && this.testPolicyId != null) {
            Iterable policies = support.listPoliciesForUser(this.testUserId);
            boolean found = false;
            tm.out("Before", policies);
            for (CloudPolicy policy : policies) {
                if (!policy.getProviderPolicyId().equals(this.testPolicyId) || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Unable to find user permission before removal", (boolean)found);
            support.removeUserPolicy(this.testUserId, this.testPolicyId);
            found = false;
            policies = support.listPoliciesForUser(this.testUserId);
            tm.out("After", policies);
            for (CloudPolicy policy : policies) {
                if (!policy.getProviderPolicyId().equals(this.testPolicyId) || !policy.getPermission().equals((Object)CloudPermission.ALLOW) || !FirewallSupport.CREATE_FIREWALL.equals((Object)policy.getAction()) || policy.getResourceId() != null) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"Test policy exists even after removal", (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user/policy exists for running the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeUser() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            CloudUser user = support.getUser(this.testUserId);
            Assert.assertNotNull((String)"The test user does not exist prior to running this test", (Object)user);
            tm.out("Before", user);
            support.removeUser(this.testUserId);
            user = support.getUser(this.testUserId);
            tm.out("After", user);
            Assert.assertNull((String)"The test user still exists after the removal", (Object)user);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user exists for running the test " + this.name.getMethodName()));
        }
    }
}

