/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.identity;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.identity.IdentityResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulKeypairTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testKeyId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulKeypairTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        IdentityResources id;
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("removeKeypair") && (id = DaseinTestManager.getIdentityResources()) != null) {
            this.testKeyId = id.getTestKeypairId("removed", true);
        }
    }

    @After
    public void after() {
        try {
            if (this.testKeyId != null) {
                tm.getProvider().getIdentityServices().getShellKeySupport().deleteKeypair(this.testKeyId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.testKeyId = null;
        tm.end();
    }

    @Test
    public void generateKeypair() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                if (Requirement.REQUIRED.equals((Object)support.getKeyImportSupport())) {
                    try {
                        SSHKeypair keypair = support.createKeypair("dsnkp" + System.currentTimeMillis() % 10000L);
                        this.testKeyId = keypair.getProviderKeypairId();
                        Assert.fail((String)"Keypair generation is not supported, but the request appears to have completed");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Caught operation not supported exception as expected");
                    }
                } else {
                    SSHKeypair keypair = support.createKeypair("dsnkp" + System.currentTimeMillis() % 10000L);
                    tm.out("Keypair", keypair);
                    Assert.assertNotNull((String)"The create option must not return a null value", (Object)keypair);
                    this.testKeyId = keypair.getProviderKeypairId();
                }
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }

    @Test
    public void removeKeypair() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                if (this.testKeyId != null) {
                    SSHKeypair keypair = support.getKeypair(this.testKeyId);
                    tm.out("Before", keypair != null ? "exists" : "doesn't exist");
                    support.deleteKeypair(this.testKeyId);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    keypair = support.getKeypair(this.testKeyId);
                    tm.out("After", keypair != null ? "exists" : "doesn't exist");
                    Assert.assertNull((String)"Keypair still exists after delete", (Object)keypair);
                    this.testKeyId = null;
                } else {
                    tm.warn("No test keypair was found for this test");
                }
            } else {
                tm.ok("No keypair support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }
}

