/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.identity;

import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.identity.CloudGroup;
import org.dasein.cloud.identity.CloudPolicy;
import org.dasein.cloud.identity.CloudUser;
import org.dasein.cloud.identity.IdentityAndAccessSupport;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessIAMTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testGroupId;
    private String testUserId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessIAMTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testGroupId = tm.getTestGroupId("stateless", false);
        this.testUserId = tm.getTestUserId("stateless", false, this.testGroupId);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Supports Access Controls", support.supportsAccessControls());
        tm.out("Supports API Access", support.supportsAPIAccess());
        tm.out("Supports Console Access", support.supportsConsoleAccess());
    }

    @Test
    public void getBogusGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CloudGroup group = support.getGroup(UUID.randomUUID().toString());
        tm.out("Bogus Group", group);
        Assert.assertNull((String)"A bogus group was found with a random UUID as an identifier", (Object)group);
    }

    @Test
    public void getGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            CloudGroup group = support.getGroup(this.testGroupId);
            tm.out("Group", group);
            Assert.assertNotNull((String)"No group was found under the test group ID", (Object)group);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running " + this.name.getMethodName()));
        }
    }

    private void assertGroup(@Nonnull CloudGroup group) {
        Assert.assertNotNull((String)"The group ID may not be null", (Object)group.getProviderGroupId());
        Assert.assertNotNull((String)"The owner account may not be null", (Object)group.getProviderOwnerId());
        Assert.assertNotNull((String)"The name may not be null", (Object)group.getName());
    }

    @Test
    public void groupContent() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            CloudGroup group = support.getGroup(this.testGroupId);
            Assert.assertNotNull((String)"No group was found under the test group ID", (Object)group);
            tm.out("Group ID", group.getProviderGroupId());
            tm.out("Name", group.getName());
            tm.out("Owner Account", group.getProviderOwnerId());
            tm.out("Path", group.getPath());
            this.assertGroup(group);
            Assert.assertEquals((String)"ID does not match requested group", (Object)this.testGroupId, (Object)group.getProviderGroupId());
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void listGroups() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable groups = support.listGroups(null);
        int count = 0;
        Assert.assertNotNull((String)"The groups listing may not be null regardless of subscription level or requested path base", (Object)groups);
        for (CloudGroup group : groups) {
            ++count;
            tm.out("Group", group);
        }
        tm.out("Total Group Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("Not subscribed to IAM services, so no groups exist");
            } else {
                tm.warn("No groups were returned so this test may be invalid");
            }
        }
        for (CloudGroup group : groups) {
            this.assertGroup(group);
        }
    }

    @Test
    public void listGroupPolicies() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            Iterable policies = support.listPoliciesForGroup(this.testGroupId);
            int count = 0;
            Assert.assertNotNull((String)"The policies listing may not be null regardless of subscription level or requested group", (Object)policies);
            for (CloudPolicy policy : policies) {
                ++count;
                tm.out(this.testGroupId + " Group Policy", policy);
            }
            tm.out("Total Group Policy Count in " + this.testGroupId, count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Not subscribed to IAM services, so no policies exist");
                } else {
                    tm.warn("No policies were returned so this test may be invalid");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void getBogusUser() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CloudUser user = support.getUser(UUID.randomUUID().toString());
        tm.out("Bogus User", user);
        Assert.assertNull((String)"A bogus user was found with a random UUID as an identifier", (Object)user);
    }

    @Test
    public void getUser() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            CloudUser user = support.getUser(this.testUserId);
            tm.out("User", user);
            Assert.assertNotNull((String)"No user was found under the test user ID", (Object)user);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user exists for running " + this.name.getMethodName()));
        }
    }

    private void assertUser(@Nonnull CloudUser user) {
        Assert.assertNotNull((String)"The user ID may not be null", (Object)user.getProviderUserId());
        Assert.assertNotNull((String)"The owner account may not be null", (Object)user.getProviderOwnerId());
        Assert.assertNotNull((String)"The user name may not be null", (Object)user.getUserName());
    }

    @Test
    public void userContent() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            CloudUser user = support.getUser(this.testUserId);
            Assert.assertNotNull((String)"No user was found under the test user ID", (Object)user);
            tm.out("User ID", user.getProviderUserId());
            tm.out("User Name", user.getUserName());
            tm.out("Owner Account", user.getProviderOwnerId());
            tm.out("Path", user.getPath());
            this.assertUser(user);
            Assert.assertEquals((String)"The ID for the returned user does not match the one requested", (Object)this.testUserId, (Object)user.getProviderUserId());
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void listUsersInPath() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable users = support.listUsersInPath(null);
        int count = 0;
        Assert.assertNotNull((String)"The users listing may not be null regardless of subscription level or requested path base", (Object)users);
        for (CloudUser user : users) {
            ++count;
            tm.out("User", user);
        }
        tm.out("Total User Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("Not subscribed to IAM services, so no users exist");
            } else {
                tm.warn("No users were returned so this test may be invalid");
            }
        }
        for (CloudUser user : users) {
            this.assertUser(user);
        }
    }

    @Test
    public void listUsersInGroup() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testGroupId != null) {
            Iterable users = support.listUsersInGroup(this.testGroupId);
            int count = 0;
            Assert.assertNotNull((String)"The users listing may not be null regardless of subscription level or requested group", (Object)users);
            for (CloudUser user : users) {
                ++count;
                tm.out(this.testGroupId + " User", user);
            }
            tm.out("Total User Count in " + this.testGroupId, count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Not subscribed to IAM services, so no users exist");
                } else {
                    tm.warn("No users were returned so this test may be invalid");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void listGroupsForUser() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            Iterable groups = support.listGroupsForUser(this.testUserId);
            int count = 0;
            Assert.assertNotNull((String)"The groups listing may not be null regardless of subscription level or requested user", (Object)groups);
            for (CloudGroup group : groups) {
                ++count;
                tm.out(this.testUserId + " Group", group);
            }
            tm.out("Total Group Count for " + this.testUserId, count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Not subscribed to IAM services, so no groups exist");
                } else {
                    tm.warn("No groups were returned so this test may be invalid");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test group exists for running " + this.name.getMethodName()));
        }
    }

    @Test
    public void listUserPolicies() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services == null) {
            tm.ok("Identity services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IdentityAndAccessSupport support = services.getIdentityAndAccessSupport();
        if (support == null) {
            tm.ok("Identity and access management is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testUserId != null) {
            Iterable policies = support.listPoliciesForUser(this.testUserId);
            int count = 0;
            Assert.assertNotNull((String)"The policies listing may not be null regardless of subscription level or requested user", (Object)policies);
            for (CloudPolicy policy : policies) {
                ++count;
                tm.out(this.testUserId + " User Policy", policy);
            }
            tm.out("Total Policy Count in " + this.testUserId, count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Not subscribed to IAM services, so no policies exist");
                } else {
                    tm.warn("No policies were returned so this test may be invalid");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to IAM services");
        } else {
            Assert.fail((String)("No test user exists for running " + this.name.getMethodName()));
        }
    }
}

