/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.identity;

import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessKeypairTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testKeyId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessKeypairTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testKeyId = tm.getTestKeypairId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                tm.out("Subscribed", support.isSubscribed());
                tm.out("Term for Keypair", support.getProviderTermForKeypair(Locale.getDefault()));
                tm.out("Key Import Req", support.getKeyImportSupport());
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }

    @Test
    public void getBogusKeypair() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                SSHKeypair keypair = support.getKeypair(UUID.randomUUID().toString());
                tm.out("Bogus Keypair", keypair);
                Assert.assertNull((String)"Found a bogus keypair when none should exist", (Object)keypair);
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }

    @Test
    public void getKeypair() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                if (this.testKeyId != null) {
                    SSHKeypair keypair = support.getKeypair(this.testKeyId);
                    tm.out("Keypair", keypair);
                    Assert.assertNotNull((String)"Failed to find the test keypair", (Object)keypair);
                } else {
                    tm.warn("No test key was specified, this test is probably invalid");
                }
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }

    @Test
    public void keypairContent() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                if (this.testKeyId != null) {
                    SSHKeypair keypair = support.getKeypair(this.testKeyId);
                    Assert.assertNotNull((String)"Failed to find the test keypair", (Object)keypair);
                    tm.out("Keypair ID", keypair.getProviderKeypairId());
                    tm.out("Name", keypair.getName());
                    tm.out("Owner Account", keypair.getProviderOwnerId());
                    tm.out("Region ID", keypair.getProviderRegionId());
                    tm.out("Fingerprint", keypair.getFingerprint());
                    tm.out("Public Key", keypair.getPublicKey());
                    tm.out("PrivateKey", keypair.getPrivateKey());
                    Assert.assertNotNull((String)"Keypair ID may not be null", (Object)keypair.getProviderKeypairId());
                    Assert.assertNotNull((String)"Keypair name may not be null", (Object)keypair.getName());
                    Assert.assertNotNull((String)"Keypair owning account may not be null", (Object)keypair.getProviderOwnerId());
                    Assert.assertEquals((String)"Keypair region must match current region context", (Object)tm.getContext().getRegionId(), (Object)keypair.getProviderRegionId());
                    if (keypair.getFingerprint() == null) {
                        tm.warn("A keypair really, really should have a fingerprint if supported by the cloud");
                    }
                } else {
                    tm.warn("No test key was specified, this test is probably invalid");
                }
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }

    @Test
    public void listKeypairs() throws CloudException, InternalException {
        IdentityServices services = tm.getProvider().getIdentityServices();
        if (services != null) {
            ShellKeySupport support = services.getShellKeySupport();
            if (support != null) {
                Collection keypairs = support.list();
                boolean found = false;
                int count = 0;
                Assert.assertNotNull((String)"The list of keypairs may not be null", (Object)keypairs);
                for (SSHKeypair keypair : keypairs) {
                    ++count;
                    tm.out("Keypair", keypair);
                    if (this.testKeyId == null || !this.testKeyId.equals(keypair.getProviderKeypairId())) continue;
                    found = true;
                }
                tm.out("Total Keypair Count", count);
                if (count < 1) {
                    tm.warn("No keypairs were found, so this test may have been invalid");
                }
                if (this.testKeyId != null) {
                    Assert.assertNotNull((String)"Unable to find the test keypair among the listed keypairs", (Object)found);
                } else {
                    tm.warn("No test key exists, so unable to validate key listing");
                }
            } else {
                tm.ok("No shell key support in this cloud");
            }
        } else {
            tm.ok("No identity services in this cloud");
        }
    }
}

