/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.DNSZone;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallCreateOptions;
import org.dasein.cloud.network.FirewallRuleCreateOptions;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.HealthCheckOptions;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LbType;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCreateOptions;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.network.NetworkFirewallSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.SSLCertificate;
import org.dasein.cloud.network.SSLCertificateCreateOptions;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.SubnetCreateOptions;
import org.dasein.cloud.network.SubnetState;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.compute.ComputeResources;

public class NetworkResources {
    private static final Logger logger = Logger.getLogger(NetworkResources.class);
    private static final Random random = new Random();
    public static final String TEST_CIDR = "209.98.98.98/32";
    public static final String TEST_HC_PATH = "/index.htm";
    public static final LoadBalancerHealthCheck.HCProtocol TEST_HC_PROTOCOL = LoadBalancerHealthCheck.HCProtocol.HTTP;
    public static final String TEST_HC_HOST = "localhost";
    public static final int TEST_HC_PORT = 8080;
    private CloudProvider provider;
    private final HashMap<String, String> testGeneralFirewalls = new HashMap();
    private final HashMap<String, String> testIps4Free = new HashMap();
    private final HashMap<String, String> testIps6Free = new HashMap();
    private final HashMap<String, String> testIps4VLAN = new HashMap();
    private final HashMap<String, String> testIps6VLAN = new HashMap();
    private final HashMap<String, String> testLBs = new HashMap();
    private final HashMap<String, String> testSSLCertificates = new HashMap();
    private final HashMap<String, String> testNetworkFirewalls = new HashMap();
    private final HashMap<String, String> testSubnets = new HashMap();
    private final HashMap<String, String> testInternetGateways = new HashMap();
    private final HashMap<String, String> testVLANs = new HashMap();
    private final HashMap<String, String> testRouteTables = new HashMap();
    private final HashMap<String, String> testVLANFirewalls = new HashMap();
    private final HashMap<String, String> testZones = new HashMap();
    private final String[] cidrs = new String[]{"192.168.1.0/28", "192.168.1.20/28", "192.168.1.40/28", "192.168.1.60/28", "192.168.1.80/28", "192.168.1.100/28", "192.168.1.120/28", "192.168.1.140/28", "192.168.1.160/28", "192.168.1.180/28", "192.168.1.200/28", "192.168.1.220/28", "192.168.1.240/28"};
    private Integer cidrCount = 0;

    public NetworkResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testGeneralFirewalls.remove("stateless");
        if (!this.testGeneralFirewalls.isEmpty()) {
            logger.info((Object)"Provisioned Network Resources:");
            header = true;
            count += this.testGeneralFirewalls.size();
            DaseinTestManager.out(logger, null, "---> Firewalls (Standard)", this.testGeneralFirewalls.size() + " " + this.testGeneralFirewalls);
        }
        this.testVLANFirewalls.remove("stateless");
        if (!this.testVLANFirewalls.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testVLANFirewalls.size();
            DaseinTestManager.out(logger, null, "---> Firewalls (VLAN)", this.testVLANFirewalls.size() + " " + this.testVLANFirewalls);
        }
        this.testNetworkFirewalls.remove("stateless");
        if (!this.testNetworkFirewalls.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testNetworkFirewalls.size();
            DaseinTestManager.out(logger, null, "---> Network Firewalls", this.testNetworkFirewalls.size() + " " + this.testNetworkFirewalls);
        }
        this.testIps4Free.remove("stateless");
        if (!this.testIps4Free.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testIps4Free.size();
            DaseinTestManager.out(logger, null, "---> Static IPs (Standard/IPv4)", this.testIps4Free.size() + " " + this.testIps4Free);
        }
        this.testIps6Free.remove("stateless");
        if (!this.testIps6Free.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testIps6Free.size();
            DaseinTestManager.out(logger, null, "---> Static IPs (Standard/IPv6)", this.testIps6Free.size() + " " + this.testIps6Free);
        }
        this.testIps4VLAN.remove("stateless");
        if (!this.testIps4VLAN.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testIps4VLAN.size();
            DaseinTestManager.out(logger, null, "---> Static IPs (VLAN/IPv4)", this.testIps4VLAN.size() + " " + this.testIps4VLAN);
        }
        this.testIps6VLAN.remove("stateless");
        if (!this.testIps6VLAN.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testIps6VLAN.size();
            DaseinTestManager.out(logger, null, "---> Static IPs (VLAN/IPv6)", this.testIps6VLAN.size() + " " + this.testIps6VLAN);
        }
        this.testSubnets.remove("stateless");
        if (!this.testSubnets.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testSubnets.size();
            DaseinTestManager.out(logger, null, "---> Subnets", this.testSubnets.size() + " " + this.testSubnets);
        }
        this.testVLANs.remove("stateless");
        if (!this.testVLANs.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testVLANs.size();
            DaseinTestManager.out(logger, null, "---> VLANs", this.testVLANs.size() + " " + this.testVLANs);
        }
        this.testZones.remove("stateless");
        if (!this.testZones.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testZones.size();
            DaseinTestManager.out(logger, null, "---> DNS Zones", this.testZones.size() + " " + this.testZones);
        }
        this.testLBs.remove("stateless");
        if (!this.testLBs.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
                header = true;
            }
            count += this.testLBs.size();
            DaseinTestManager.out(logger, null, "---> Load Balancers", this.testLBs.size() + " " + this.testLBs);
        }
        this.testSSLCertificates.remove("stateless");
        if (!this.testSSLCertificates.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Network Resources:");
            }
            count += this.testSSLCertificates.size();
            DaseinTestManager.out(logger, null, "---> SSL Certificates", this.testSSLCertificates.size() + " " + this.testSSLCertificates);
        }
        return count;
    }

    public int close() {
        int count;
        block156: {
            count = 0;
            try {
                FirewallSupport firewallSupport;
                NetworkFirewallSupport nfSupport;
                VLANSupport vlanSupport;
                IpAddressSupport ipSupport;
                LoadBalancerSupport lbSupport;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                NetworkServices networkServices = this.provider.getNetworkServices();
                if (networkServices == null) break block156;
                DNSSupport dnsSupport = networkServices.getDnsSupport();
                if (dnsSupport != null) {
                    try {
                        for (Map.Entry<String, String> entry : this.testZones.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            DNSZone zone = dnsSupport.getDnsZone(entry.getValue());
                            try {
                                if (zone != null) {
                                    try {
                                        for (DNSRecord record : dnsSupport.listDnsRecords(zone.getProviderDnsZoneId(), DNSRecordType.A, null)) {
                                            try {
                                                dnsSupport.deleteDnsRecords(new DNSRecord[]{record});
                                            }
                                            catch (Throwable ignore) {}
                                        }
                                    }
                                    catch (Throwable ignore) {
                                        // empty catch block
                                    }
                                    dnsSupport.deleteDnsZone(zone.getProviderDnsZoneId());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision test DNS zone " + entry.getValue() + ":" + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((lbSupport = networkServices.getLoadBalancerSupport()) != null) {
                    try {
                        for (Map.Entry<String, String> entry : this.testLBs.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            LoadBalancer lb = lbSupport.getLoadBalancer(entry.getValue());
                            try {
                                if (lb != null) {
                                    lbSupport.removeLoadBalancer(lb.getProviderLoadBalancerId());
                                    try {
                                        lbSupport.removeLoadBalancerHealthCheck(lb.getProviderLoadBalancerId());
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision test load balancer " + entry.getValue() + ":" + t.getMessage()));
                            }
                        }
                        for (Map.Entry<String, String> entry : this.testSSLCertificates.entrySet()) {
                            if ("stateless".equals(entry.getKey())) continue;
                            SSLCertificate sslCertificate = lbSupport.getSSLCertificate(entry.getValue());
                            try {
                                if (sslCertificate != null) {
                                    lbSupport.removeSSLCertificate(entry.getValue());
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision test SSL certificate " + entry.getValue() + ":" + t.getMessage()), t);
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((ipSupport = networkServices.getIpAddressSupport()) != null) {
                    IpAddress addr;
                    try {
                        for (Map.Entry<String, String> entry : this.testIps4Free.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            addr = ipSupport.getIpAddress(entry.getValue());
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromServer(entry.getValue());
                                }
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException ignore) {}
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromPool(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision static IP " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        for (Map.Entry<String, String> entry : this.testIps6Free.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            addr = ipSupport.getIpAddress(entry.getValue());
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromServer(entry.getValue());
                                }
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException ignore) {}
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromPool(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision static IP " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        for (Map.Entry<String, String> entry : this.testIps4VLAN.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            addr = ipSupport.getIpAddress(entry.getValue());
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromServer(entry.getValue());
                                }
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException ignore) {}
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromPool(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision static IP " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        for (Map.Entry<String, String> entry : this.testIps6VLAN.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            addr = ipSupport.getIpAddress(entry.getValue());
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromServer(entry.getValue());
                                }
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException ignore) {}
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            try {
                                if (addr != null) {
                                    ipSupport.releaseFromPool(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision static IP " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((vlanSupport = networkServices.getVlanSupport()) != null) {
                    try {
                        for (Map.Entry<String, String> entry : this.testVLANs.entrySet()) {
                            VLAN v;
                            if (entry.getKey().equals("stateless") || (v = vlanSupport.getVlan(entry.getValue())) == null) continue;
                            try {
                                if (!vlanSupport.isConnectedViaInternetGateway(v.getProviderVlanId())) continue;
                                vlanSupport.removeInternetGateway(v.getProviderVlanId());
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to remove internet gateway for test VLAN " + v + ":" + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((nfSupport = networkServices.getNetworkFirewallSupport()) != null) {
                    try {
                        for (Map.Entry<String, String> entry : this.testNetworkFirewalls.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            try {
                                Firewall f = nfSupport.getFirewall(entry.getValue());
                                if (f != null) {
                                    nfSupport.removeFirewall(new String[]{entry.getValue()});
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision network firewall " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if ((firewallSupport = networkServices.getFirewallSupport()) != null) {
                    try {
                        Firewall f;
                        for (Map.Entry<String, String> entry : this.testGeneralFirewalls.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            try {
                                f = firewallSupport.getFirewall(entry.getValue());
                                if (f != null) {
                                    firewallSupport.delete(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision standard firewall " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                        for (Map.Entry<String, String> entry : this.testVLANFirewalls.entrySet()) {
                            if (entry.getKey().equals("stateless")) continue;
                            try {
                                f = firewallSupport.getFirewall(entry.getValue());
                                if (f != null) {
                                    firewallSupport.delete(entry.getValue());
                                    ++count;
                                    continue;
                                }
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision VLAN firewall " + entry.getValue() + " post-test: " + t.getMessage()));
                            }
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if (vlanSupport == null) break block156;
                try {
                    for (Map.Entry<String, String> entry : this.testInternetGateways.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        InternetGateway ig = vlanSupport.getInternetGatewayById(entry.getValue());
                        if (ig != null) {
                            try {
                                vlanSupport.removeInternetGatewayById(entry.getValue());
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision internetgateway (1) " + entry.getValue() + " post-test: " + t.getMessage()));
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    vlanSupport.removeInternetGatewayById(entry.getValue());
                                    ++count;
                                }
                                catch (Throwable t2) {
                                    logger.warn((Object)("Failed to de-provision internetgateway (final) " + entry.getValue() + " post-test: " + t2.getMessage()));
                                }
                            }
                            continue;
                        }
                        ++count;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    for (Map.Entry<String, String> entry : this.testSubnets.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        Subnet s = vlanSupport.getSubnet(entry.getValue());
                        if (s != null) {
                            try {
                                vlanSupport.removeSubnet(entry.getValue());
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision subnet (1) " + entry.getValue() + " post-test: " + t.getMessage()));
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    vlanSupport.removeSubnet(entry.getValue());
                                    ++count;
                                }
                                catch (Throwable t2) {
                                    logger.warn((Object)("Failed to de-provision subnet (final) " + entry.getValue() + " post-test: " + t2.getMessage()));
                                }
                            }
                            continue;
                        }
                        ++count;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    for (Map.Entry<String, String> entry : this.testRouteTables.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        RoutingTable rtb = vlanSupport.getRoutingTable(entry.getValue());
                        if (rtb != null) {
                            try {
                                vlanSupport.removeRoutingTable(entry.getValue());
                                ++count;
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to de-provision routetable (1) " + entry.getValue() + " post-test: " + t.getMessage()));
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    vlanSupport.removeRoutingTable(entry.getValue());
                                    ++count;
                                }
                                catch (Throwable t2) {
                                    logger.warn((Object)("Failed to de-provision routetable (final) " + entry.getValue() + " post-test: " + t2.getMessage()));
                                }
                            }
                            continue;
                        }
                        ++count;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    for (Map.Entry<String, String> entry : this.testVLANs.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        VLAN v = vlanSupport.getVlan(entry.getValue());
                        if (v != null) {
                            try {
                                if (vlanSupport.isConnectedViaInternetGateway(v.getProviderVlanId())) {
                                    vlanSupport.removeInternetGateway(v.getProviderVlanId());
                                }
                            }
                            catch (Throwable t) {
                                logger.warn((Object)("Failed to remove internet gateway for test VLAN " + v + ":" + t.getMessage()));
                            }
                        } else {
                            ++count;
                            continue;
                        }
                        if (nfSupport != null) {
                            for (Firewall fw : nfSupport.listFirewalls()) {
                                if (!fw.getProviderVlanId().equals(entry.getValue())) continue;
                                try {
                                    nfSupport.removeFirewall(new String[]{fw.getProviderFirewallId()});
                                }
                                catch (Throwable t) {
                                    logger.warn((Object)("Failed to remove network firewall for test VLAN " + v + ": " + t.getMessage()));
                                }
                            }
                        }
                        if (firewallSupport != null) {
                            for (Firewall fw : firewallSupport.list()) {
                                if (!entry.getValue().equals(fw.getProviderFirewallId())) continue;
                                try {
                                    firewallSupport.delete(fw.getProviderFirewallId());
                                }
                                catch (Throwable t) {
                                    logger.warn((Object)("Failed to remove test VLAN firewall for VLAN " + v + ": " + t.getMessage()));
                                }
                            }
                        }
                        try {
                            for (Subnet subnet : vlanSupport.listSubnets(entry.getValue())) {
                                try {
                                    vlanSupport.removeSubnet(subnet.getProviderSubnetId());
                                }
                                catch (Throwable t) {
                                    logger.warn((Object)("Failed to de-provision subnet " + subnet.getProviderSubnetId() + " for test VLAN " + entry.getValue() + " post-test: " + t.getMessage()));
                                }
                            }
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision subnets for test VLAN " + entry.getValue() + " post-test: " + t.getMessage()));
                        }
                        try {
                            for (RoutingTable routeTable : vlanSupport.listRoutingTablesForVlan(entry.getValue())) {
                                try {
                                    vlanSupport.removeRoutingTable(routeTable.getProviderRoutingTableId());
                                }
                                catch (Throwable t) {
                                    logger.warn((Object)("Failed to de-provision route table " + routeTable.getProviderRoutingTableId() + " for test VLAN " + entry.getValue() + " post-test: " + t.getMessage()));
                                }
                            }
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision route tables for test VLAN " + entry.getValue() + " post-test: " + t.getMessage()));
                        }
                        try {
                            vlanSupport.removeVlan(entry.getValue());
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test VLAN " + entry.getValue() + " post-test: " + t.getMessage()));
                        }
                    }
                }
                catch (Throwable ignore) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return count;
    }

    @Nullable
    private String findStatelessDNSZone() {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            DNSSupport support = networkServices.getDnsSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    DNSZone defaultZone = null;
                    for (DNSZone zone : support.listDnsZones()) {
                        boolean hasRecord = false;
                        for (DNSRecordType type : DNSRecordType.values()) {
                            Iterable records = support.listDnsRecords(zone.getProviderDnsZoneId(), type, null);
                            if (!records.iterator().hasNext()) continue;
                            hasRecord = true;
                            break;
                        }
                        defaultZone = zone;
                        if (!hasRecord) continue;
                        break;
                    }
                    if (defaultZone != null) {
                        String id = defaultZone.getProviderDnsZoneId();
                        if (id != null) {
                            this.testZones.put("stateless", id);
                        }
                        return id;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessFirewall(boolean inVlan) {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            FirewallSupport support = networkServices.getFirewallSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Firewall defaultFirewall = null;
                    for (Firewall firewall : support.list()) {
                        String id;
                        if (firewall.getProviderVlanId() != null != inVlan && support.getCapabilities().requiresVLAN().equals((Object)Requirement.NONE)) continue;
                        if (firewall.isActive() && firewall.isAvailable() && (id = firewall.getProviderFirewallId()) != null && support.getRules(id).iterator().hasNext()) {
                            if (inVlan) {
                                this.testVLANFirewalls.put("stateless", id);
                            } else {
                                this.testGeneralFirewalls.put("stateless", id);
                            }
                            return firewall.getProviderFirewallId();
                        }
                        if (defaultFirewall == null) {
                            defaultFirewall = firewall;
                            continue;
                        }
                        if (!firewall.isActive() || !firewall.isAvailable() || defaultFirewall.isActive() && defaultFirewall.isAvailable()) continue;
                        defaultFirewall = firewall;
                    }
                    if (defaultFirewall != null) {
                        String id = defaultFirewall.getProviderFirewallId();
                        if (id != null) {
                            if (inVlan) {
                                this.testVLANFirewalls.put("stateless", id);
                            } else {
                                this.testGeneralFirewalls.put("stateless", id);
                            }
                        }
                        return id;
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessLoadBalancer() {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            LoadBalancerSupport support = networkServices.getLoadBalancerSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    LoadBalancer defaultLB = null;
                    for (LoadBalancer lb : support.listLoadBalancers()) {
                        LoadBalancerState s = lb.getCurrentState();
                        boolean hasEndpoints = false;
                        if (s.equals((Object)LoadBalancerState.ACTIVE)) {
                            defaultLB = lb;
                            hasEndpoints = support.listEndpoints(lb.getProviderLoadBalancerId()).iterator().hasNext();
                        } else if (defaultLB == null) {
                            defaultLB = lb;
                        }
                        if (!hasEndpoints) continue;
                        break;
                    }
                    if (defaultLB != null) {
                        this.testLBs.put("stateless", defaultLB.getProviderLoadBalancerId());
                        return defaultLB.getProviderLoadBalancerId();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessSSLCertificate() {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            LoadBalancerSupport support = networkServices.getLoadBalancerSupport();
            try {
                Iterator certificates;
                if (support != null && support.isSubscribed() && (certificates = support.listSSLCertificates().iterator()).hasNext()) {
                    SSLCertificate certificate = (SSLCertificate)certificates.next();
                    this.testSSLCertificates.put("stateless", certificate.getCertificateName());
                    return certificate.getCertificateName();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessNetworkFirewall() {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            NetworkFirewallSupport support = networkServices.getNetworkFirewallSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Firewall defaultFirewall = null;
                    for (Firewall firewall : support.listFirewalls()) {
                        String id;
                        if (firewall.isActive() && firewall.isAvailable() && (id = firewall.getProviderFirewallId()) != null && support.listRules(id).iterator().hasNext()) {
                            this.testNetworkFirewalls.put("stateless", id);
                            return firewall.getProviderFirewallId();
                        }
                        if (defaultFirewall == null) {
                            defaultFirewall = firewall;
                            continue;
                        }
                        if (!firewall.isActive() || !firewall.isAvailable() || defaultFirewall.isActive() && defaultFirewall.isAvailable()) continue;
                        defaultFirewall = firewall;
                    }
                    if (defaultFirewall != null) {
                        String id = defaultFirewall.getProviderFirewallId();
                        if (id != null) {
                            this.testNetworkFirewalls.put("stateless", id);
                        }
                        return id;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessIP(IPVersion version, boolean vlan) {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            IpAddressSupport ipSupport = networkServices.getIpAddressSupport();
            try {
                if (ipSupport != null && ipSupport.isSubscribed()) {
                    IpAddress address;
                    IpAddress defaultAddress = null;
                    Iterator i$ = ipSupport.listIpPool(version, false).iterator();
                    while (i$.hasNext() && (!(address = (IpAddress)i$.next()).isAssigned() && defaultAddress != null || vlan != (address.getProviderVlanId() != null) || !(defaultAddress = address).isAssigned())) {
                    }
                    if (defaultAddress != null) {
                        String id = defaultAddress.getProviderIpAddressId();
                        if (vlan) {
                            if (version.equals((Object)IPVersion.IPV4)) {
                                this.testIps4VLAN.put("stateless", id);
                            } else {
                                this.testIps6VLAN.put("stateless", id);
                            }
                        } else if (version.equals((Object)IPVersion.IPV4)) {
                            this.testIps4Free.put("stateless", id);
                        } else {
                            this.testIps6Free.put("stateless", id);
                        }
                        return id;
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessVLAN() {
        NetworkServices networkServices = this.provider.getNetworkServices();
        if (networkServices != null) {
            VLANSupport vlanSupport = networkServices.getVlanSupport();
            try {
                if (vlanSupport != null && vlanSupport.isSubscribed()) {
                    VLAN defaultVlan = null;
                    VLAN firstVlan = null;
                    Subnet defaultSubnet = null;
                    InternetGateway defaultInternetGateway = null;
                    RoutingTable defaultRouteTable = null;
                    for (VLAN vlan : vlanSupport.listVlans()) {
                        if (defaultVlan != null && !VLANState.AVAILABLE.equals((Object)vlan.getCurrentState())) continue;
                        Subnet foundSubnet = null;
                        if (vlan.getCidr().contains("192.168.1.") && !vlanSupport.getCapabilities().getSubnetSupport().equals((Object)Requirement.NONE)) {
                            for (Subnet subnet : vlanSupport.listSubnets(vlan.getProviderVlanId())) {
                                if (foundSubnet != null && !SubnetState.AVAILABLE.equals((Object)subnet.getCurrentState())) continue;
                                foundSubnet = subnet;
                                if (!SubnetState.AVAILABLE.equals((Object)subnet.getCurrentState())) continue;
                                InternetGateway foundInternetGateway = null;
                                if (!vlanSupport.isConnectedViaInternetGateway(vlan.getProviderVlanId())) continue;
                                for (InternetGateway igateway : vlanSupport.listInternetGateways(vlan.getProviderVlanId())) {
                                    if (foundInternetGateway != null || (foundInternetGateway = vlanSupport.getInternetGatewayById(igateway.getProviderInternetGatewayId())) == null || defaultRouteTable != null) continue;
                                    for (RoutingTable rtb : vlanSupport.listRoutingTablesForVlan(vlan.getProviderVlanId())) {
                                        defaultRouteTable = vlanSupport.getRoutingTable(rtb.getProviderRoutingTableId());
                                        defaultVlan = vlan;
                                        defaultSubnet = foundSubnet;
                                        defaultInternetGateway = foundInternetGateway;
                                    }
                                }
                            }
                        }
                        if (defaultVlan == null && vlan.getCidr().contains("192.168.1.")) {
                            defaultVlan = vlan;
                        }
                        if (firstVlan == null) {
                            firstVlan = vlan;
                        }
                        if (!VLANState.AVAILABLE.equals((Object)vlan.getCurrentState()) || defaultInternetGateway == null || defaultRouteTable == null || (foundSubnet == null || !SubnetState.AVAILABLE.equals((Object)foundSubnet.getCurrentState())) && !vlanSupport.getCapabilities().getSubnetSupport().equals((Object)Requirement.NONE)) continue;
                        break;
                    }
                    String id = null;
                    if (defaultVlan != null) {
                        id = defaultVlan.getProviderVlanId();
                        this.testVLANs.put("stateless", id);
                    } else if (firstVlan != null) {
                        id = firstVlan.getProviderVlanId();
                        this.testVLANs.put("stateless", id);
                    }
                    if (defaultSubnet != null) {
                        this.testSubnets.put("stateless", defaultSubnet.getProviderSubnetId());
                    }
                    if (defaultInternetGateway != null) {
                        this.testInternetGateways.put("stateless", defaultInternetGateway.getProviderInternetGatewayId());
                    }
                    if (defaultRouteTable != null) {
                        this.testRouteTables.put("stateless", defaultRouteTable.getProviderRoutingTableId());
                    }
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestFirewallId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId) {
        FirewallSupport support;
        NetworkServices services;
        HashMap<String, String> map;
        HashMap<String, String> hashMap = map = vlanId == null ? this.testGeneralFirewalls : this.testVLANFirewalls;
        if (label.equalsIgnoreCase("stateless")) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessFirewall(vlanId != null);
        }
        String id = map.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getFirewallSupport()) != null) {
            try {
                return this.provisionFirewall(label, vlanId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestLoadBalancerId(@Nonnull String label, @Nonnull String lbNamePrefix, boolean provisionIfNull, boolean withHealthCheck) {
        NetworkServices services;
        if (label.equalsIgnoreCase("stateless")) {
            for (Map.Entry<String, String> entry : this.testLBs.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessLoadBalancer();
        }
        String id = this.testLBs.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null) {
            try {
                return this.provisionLoadBalancer(label, lbNamePrefix, false, false, withHealthCheck);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestSSLCertificateName(@Nonnull String label, boolean provisionIfNull) {
        NetworkServices services;
        if (label.equalsIgnoreCase("stateless")) {
            for (Map.Entry<String, String> entry : this.testSSLCertificates.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessSSLCertificate();
        }
        String id = this.testSSLCertificates.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null) {
            try {
                return this.provisionSSLCertificate(label, null);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestNetworkFirewallId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId) {
        NetworkServices services;
        if (label.equalsIgnoreCase("stateless")) {
            for (Map.Entry<String, String> entry : this.testNetworkFirewalls.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessNetworkFirewall();
        }
        String id = this.testNetworkFirewalls.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null) {
            try {
                return this.provisionNetworkFirewall(label, vlanId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestStaticIpId(@Nonnull String label, boolean provisionIfNull, @Nullable IPVersion version, boolean inVlan, @Nullable String vlanId) {
        IpAddressSupport support;
        NetworkServices services;
        HashMap<String, String> map;
        if (version == null) {
            IpAddressSupport support2;
            NetworkServices services2 = this.provider.getNetworkServices();
            IpAddressSupport ipAddressSupport = support2 = services2 == null ? null : services2.getIpAddressSupport();
            if (support2 == null) {
                return null;
            }
            try {
                for (IPVersion v : support2.getCapabilities().listSupportedIPVersions()) {
                    String id = this.getTestStaticIpId(label, provisionIfNull, v, inVlan, vlanId);
                    if (id == null) continue;
                    return id;
                }
                return null;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        if (inVlan) {
            map = version.equals((Object)IPVersion.IPV4) ? this.testIps4VLAN : this.testIps6VLAN;
        } else {
            HashMap<String, String> hashMap = map = version.equals((Object)IPVersion.IPV4) ? this.testIps4Free : this.testIps6Free;
        }
        if (label.equals("stateless")) {
            for (Map.Entry entry : map.entrySet()) {
                String id;
                if (((String)entry.getKey()).startsWith("removed") || (id = (String)entry.getValue()) == null) continue;
                try {
                    IpAddress addr = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(id);
                    if (addr == null) continue;
                    return id;
                }
                catch (Throwable ignore) {
                }
            }
            return this.findStatelessIP(version, inVlan);
        }
        String id = (String)map.get(label);
        if (id != null) {
            try {
                IpAddress addr = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(id);
                if (addr != null) {
                    return id;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getIpAddressSupport()) != null) {
            try {
                if (inVlan) {
                    if (vlanId == null) {
                        vlanId = this.getTestVLANId("stateful", true, null);
                    }
                    return this.provisionAddress(support, label, version, vlanId);
                }
                return this.provisionAddress(support, label, version, null);
            }
            catch (Throwable t) {
                try {
                    if (support.isSubscribed()) {
                        logger.warn((Object)("Failed to provision test IP address under label " + label + ": " + t.getMessage()));
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public String getTestSubnetId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        return this.getTestSubnetId(label, "dsnlb", provisionIfNull, vlanId, preferredDataCenterId);
    }

    @Nullable
    public String getTestSubnetId(@Nonnull String label, @Nonnull String lbName, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        VLANSupport support;
        NetworkServices services;
        String id;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testSubnets.entrySet()) {
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            this.findStatelessVLAN();
        }
        if ((id = this.testSubnets.get(label)) != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getVlanSupport()) != null) {
            try {
                if (vlanId == null && (vlanId = this.getTestVLANId("stateful", true, preferredDataCenterId)) == null && (vlanId = this.getTestVLANId("stateless", false, preferredDataCenterId)) == null) {
                    return null;
                }
                id = this.provisionSubnet(support, label, vlanId, "dsnsub", preferredDataCenterId);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                return id;
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to provision test subnet for " + vlanId + ": " + t.getMessage()));
            }
        }
        return null;
    }

    @Nullable
    public String getTestInternetGatewayId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        VLANSupport support;
        NetworkServices services;
        String id;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testInternetGateways.entrySet()) {
                String id2;
                if (entry.getKey().startsWith("removed") || (id2 = entry.getValue()) == null) continue;
                return id2;
            }
        }
        if ((id = this.testInternetGateways.get(label)) != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getVlanSupport()) != null) {
            try {
                if (vlanId == null) {
                    vlanId = this.getTestVLANId("stateful", true, preferredDataCenterId);
                    if (vlanId == null && (vlanId = this.getTestVLANId("stateless", false, preferredDataCenterId)) == null) {
                        return null;
                    }
                } else {
                    String internetGatewayId = support.getAttachedInternetGatewayId(vlanId);
                    if (internetGatewayId != null) {
                        return internetGatewayId;
                    }
                }
                return this.provisionInternetGateway(support, label, vlanId);
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to provision test internet gateway for " + vlanId + ": " + t.getMessage()));
            }
        }
        return null;
    }

    @Nullable
    public String getTestVLANId(@Nonnull String label, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        VLANSupport support;
        NetworkServices services;
        String id = null;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testVLANs.entrySet()) {
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            id = this.findStatelessVLAN();
        }
        if (id != null) {
            return id;
        }
        id = this.testVLANs.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getVlanSupport()) != null) {
            try {
                return this.provisionVLAN(support, label, "dsnnet", preferredDataCenterId);
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getTestRoutingTableId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        String id;
        NetworkServices services = this.provider.getNetworkServices();
        if (services == null) {
        }
        VLANSupport support = services.getVlanSupport();
        if (support == null) {
        }
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testRouteTables.entrySet()) {
                if (entry.getKey().equals("removed")) continue;
                id = entry.getValue();
                try {
                    RoutingTable rtb = support.getRoutingTable(id);
                    if (rtb == null) continue;
                    if (vlanId == null) {
                        return id;
                    }
                    if (!rtb.getProviderVlanId().equalsIgnoreCase(vlanId)) continue;
                    return id;
                }
                catch (Exception e) {
                }
            }
        }
        id = this.testRouteTables.get(label);
        try {
            RoutingTable rtb = support.getRoutingTable(id);
            if (rtb != null) {
                if (vlanId == null) {
                    return id;
                }
                if (rtb.getProviderVlanId().equalsIgnoreCase(vlanId)) {
                    return id;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!provisionIfNull) {
        }
        try {
            if (vlanId != null) {
                return this.provisionRoutingTable(support, vlanId, label, "dsnrtb");
            }
            String vId = this.getTestVLANId(label, true, preferredDataCenterId);
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (vId != null) {
                return this.provisionRoutingTable(support, vId, label, "dsnrtb");
            }
        }
        finally {
            return null;
        }
    }

    @Nullable
    public String getTestZoneId(@Nonnull String label, boolean provisionIfNull) {
        DNSSupport support;
        NetworkServices services;
        if (label.equalsIgnoreCase("stateless")) {
            for (Map.Entry<String, String> entry : this.testZones.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessDNSZone();
        }
        String id = this.testZones.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getNetworkServices()) != null && (support = services.getDnsSupport()) != null) {
            try {
                return this.provisionDNSZone(support, label, "dasein", "org");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionAddress(@Nonnull IpAddressSupport support, @Nonnull String label, @Nullable IPVersion version, @Nullable String vlanId) throws CloudException, InternalException {
        if (version == null) {
            for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
                if (!support.getCapabilities().isRequestable(v)) continue;
                version = v;
                break;
            }
        }
        if (version == null) {
            throw new CloudException("No IP version is requestable");
        }
        HashMap<String, String> map = vlanId == null ? (version.equals((Object)IPVersion.IPV4) ? this.testIps4Free : this.testIps6Free) : (version.equals((Object)IPVersion.IPV4) ? this.testIps4VLAN : this.testIps6VLAN);
        String id = null;
        id = vlanId == null ? support.request(version) : (support.getCapabilities().identifyVlanForVlanIPRequirement().equals((Object)Requirement.NONE) ? support.requestForVLAN(version) : support.requestForVLAN(version, vlanId));
        HashMap<String, String> hashMap = map;
        synchronized (hashMap) {
            while (map.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            map.put(label, id);
        }
        return id;
    }

    @Nonnull
    public FirewallRuleCreateOptions constructRuleCreateOptions(int port, Direction direction, Permission permission) throws CloudException, InternalException {
        RuleTarget destinationEndpoint;
        RuleTarget sourceEndpoint;
        NetworkServices services = this.provider.getNetworkServices();
        if (services == null) {
            throw new OperationNotSupportedException("No network services in cloud");
        }
        FirewallSupport support = services.getFirewallSupport();
        if (support == null) {
            throw new OperationNotSupportedException("No firewall support in cloud");
        }
        if (!support.getCapabilities().supportsRules(direction, permission, false)) {
            throw new OperationNotSupportedException("Firewall rules are not supported for " + direction + "/" + permission);
        }
        if (direction.equals((Object)Direction.INGRESS)) {
            sourceEndpoint = RuleTarget.getCIDR((String)TEST_CIDR);
            destinationEndpoint = null;
        } else {
            destinationEndpoint = RuleTarget.getCIDR((String)TEST_CIDR);
            sourceEndpoint = null;
        }
        return FirewallRuleCreateOptions.getInstance((Direction)direction, (Permission)permission, (RuleTarget)sourceEndpoint, (Protocol)Protocol.TCP, (RuleTarget)destinationEndpoint, (int)port, (int)port);
    }

    @Nonnull
    public String provisionFirewall(@Nonnull String label, @Nullable String vlanId) throws CloudException, InternalException {
        return this.provisionFirewall(label, vlanId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionFirewall(@Nonnull String label, @Nullable String vlanId, @Nullable FirewallRuleCreateOptions firstRule) throws CloudException, InternalException {
        String tmp = String.valueOf(random.nextInt(10000));
        String name = "dsnfw" + tmp;
        String description = "Dasein Cloud Integration Test Firewall";
        FirewallCreateOptions options = vlanId == null ? (firstRule == null ? FirewallCreateOptions.getInstance((String)name, (String)description) : FirewallCreateOptions.getInstance((String)name, (String)description, (FirewallRuleCreateOptions[])new FirewallRuleCreateOptions[]{firstRule})) : (firstRule == null ? FirewallCreateOptions.getInstance((String)vlanId, (String)name, (String)description) : FirewallCreateOptions.getInstance((String)vlanId, (String)name, (String)description, (FirewallRuleCreateOptions[])new FirewallRuleCreateOptions[]{firstRule}));
        String id = options.build(this.provider, false);
        if (vlanId == null) {
            HashMap<String, String> hashMap = this.testGeneralFirewalls;
            synchronized (hashMap) {
                while (this.testGeneralFirewalls.containsKey(label)) {
                    label = label + random.nextInt(9);
                }
                this.testGeneralFirewalls.put(label, id);
            }
        }
        HashMap<String, String> hashMap = this.testVLANFirewalls;
        synchronized (hashMap) {
            while (this.testVLANFirewalls.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testVLANFirewalls.put(label, id);
        }
        return id;
    }

    @Nonnull
    public String provisionLoadBalancer(@Nonnull String label, @Nullable String namePrefix, boolean internal) throws CloudException, InternalException {
        return this.provisionLoadBalancer(label, namePrefix, internal, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionLoadBalancer(@Nonnull String label, @Nullable String namePrefix, boolean internal, boolean withHttps, boolean withHealthCheck) throws CloudException, InternalException {
        LoadBalancerCreateOptions options;
        NetworkServices services = this.provider.getNetworkServices();
        if (services == null) {
            throw new CloudException("This cloud does not support load balancers");
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            throw new CloudException("This cloud does not support load balancers");
        }
        String name = namePrefix == null ? "dsnlb" + random.nextInt(10000) : namePrefix + random.nextInt(10000);
        String description = "Dasein Cloud LB Test";
        if (!support.getCapabilities().isAddressAssignedByProvider() && support.getCapabilities().getAddressType().equals((Object)LoadBalancerAddressType.IP)) {
            IpAddressSupport ipSupport = services.getIpAddressSupport();
            if (ipSupport == null) {
                options = LoadBalancerCreateOptions.getInstance((String)name, (String)description);
            } else {
                IpAddress address = null;
                for (IPVersion version : ipSupport.getCapabilities().listSupportedIPVersions()) {
                    Iterator addrs = ipSupport.listIpPool(version, true).iterator();
                    if (!addrs.hasNext()) continue;
                    address = (IpAddress)addrs.next();
                    break;
                }
                if (address == null) {
                    for (IPVersion version : ipSupport.getCapabilities().listSupportedIPVersions()) {
                        if (!ipSupport.getCapabilities().isRequestable(version) || (address = ipSupport.getIpAddress(ipSupport.request(version))) == null) continue;
                        break;
                    }
                }
                options = address == null ? LoadBalancerCreateOptions.getInstance((String)name, (String)description) : LoadBalancerCreateOptions.getInstance((String)name, (String)description, (String)address.getProviderIpAddressId());
            }
        } else {
            options = LoadBalancerCreateOptions.getInstance((String)name, (String)description);
        }
        if (support.getCapabilities().identifyListenersOnCreateRequirement().equals((Object)Requirement.REQUIRED)) {
            int publicPort = 1024 + random.nextInt(10000);
            int privatePort = 1024 + random.nextInt(10000);
            if (!withHttps) {
                options.havingListeners(new LbListener[]{LbListener.getInstance((int)publicPort, (int)privatePort)});
            } else {
                String certificateName = this.provisionSSLCertificate("provision", "dsnssltest");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                options.havingListeners(new LbListener[]{LbListener.getInstance((LbProtocol)LbProtocol.HTTPS, (int)publicPort, (int)privatePort, (String)certificateName)});
            }
        }
        String[] dcIds = new String[2];
        String testSubnetId = null;
        if (support.getCapabilities().identifyEndpointsOnCreateRequirement().equals((Object)Requirement.REQUIRED)) {
            Iterable types = support.getCapabilities().listSupportedEndpointTypes();
            boolean vmBased = false;
            for (LbEndpointType t : types) {
                if (!t.equals((Object)LbEndpointType.VM)) continue;
                vmBased = true;
                break;
            }
            if (!internal) {
                options.asType(LbType.EXTERNAL);
            } else {
                options.asType(LbType.INTERNAL);
            }
            if (vmBased) {
                ComputeResources c = DaseinTestManager.getComputeResources();
                if (c != null) {
                    VirtualMachine vm;
                    String server1 = null;
                    if (!internal) {
                        server1 = c.getTestVmId("stateful", VmState.RUNNING, true, null);
                    } else {
                        String vlanId = this.getTestVLANId("stateful", true, null);
                        try {
                            Thread.sleep(750L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        VLANSupport vlanSupport = services.getVlanSupport();
                        if (vlanSupport == null) {
                            throw new InternalException("No VLAN support");
                        }
                        VLAN vlan = vlanSupport.getVlan(vlanId);
                        if (vlan == null) {
                            throw new CloudException("No such VLAN: " + vlanId);
                        }
                        String subnetId = this.getTestSubnetId("stateful", true, vlanId, vlan.getProviderDataCenterId());
                        try {
                            Thread.sleep(750L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        Subnet subnet = services.getVlanSupport().getSubnet(subnetId);
                        if (subnet == null) {
                            throw new CloudException("No such Subnet: " + subnetId);
                        }
                        testSubnetId = subnetId;
                        String productId = c.getTestVMProductId();
                        String imageId = c.getTestImageId("stateless", false);
                        VMLaunchOptions vmOptions = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnnetl" + System.currentTimeMillis() % 10000L), (String)("Dasein Network Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a network");
                        vmOptions.inVlan(null, vlan.getProviderDataCenterId(), subnet.getProviderSubnetId());
                        server1 = c.provisionVM(this.provider.getComputeServices().getVirtualMachineSupport(), "internalLbLaunch", vmOptions, vlan.getProviderDataCenterId());
                    }
                    if (server1 != null && (vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(server1)) != null) {
                        dcIds[0] = vm.getProviderDataCenterId();
                    }
                    String server2 = null;
                    if (!internal) {
                        String dcId;
                        Iterator it = this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId()).iterator();
                        String targetDC = dcIds[0];
                        if (it.hasNext() && !(dcId = ((DataCenter)it.next()).getProviderDataCenterId()).equals(dcIds[0])) {
                            dcIds[1] = dcId;
                            targetDC = dcId;
                        }
                        server2 = c.getTestVmId("stateful", VmState.RUNNING, true, targetDC);
                    }
                    if (server1 != null && server2 != null) {
                        options.withVirtualMachines(new String[]{server1, server2});
                    } else if (server1 != null) {
                        options.withVirtualMachines(new String[]{server1});
                    }
                }
            } else {
                options.withIpAddresses(new String[]{"207.32.82.72"});
            }
        }
        if (support.getCapabilities().isDataCenterLimited()) {
            if (dcIds[0] != null && dcIds[1] != null) {
                options.limitedTo(dcIds);
            } else if (dcIds[0] != null) {
                options.limitedTo(new String[]{dcIds[0]});
            } else if (dcIds[1] != null) {
                options.limitedTo(new String[]{dcIds[1]});
            } else {
                Iterator it = this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId()).iterator();
                if (it.hasNext()) {
                    options.limitedTo(new String[]{((DataCenter)it.next()).getProviderDataCenterId()});
                }
            }
        }
        if (internal && testSubnetId != null) {
            options.withProviderSubnetIds(new String[]{testSubnetId});
        }
        if (withHealthCheck) {
            options.withHealthCheckOptions(HealthCheckOptions.getInstance((String)name, (String)"lb desc", (String)name, (String)TEST_HC_HOST, (LoadBalancerHealthCheck.HCProtocol)TEST_HC_PROTOCOL, (int)8080, (String)TEST_HC_PATH, (int)60, (int)100, (int)3, (int)10));
        }
        String id = options.build(this.provider);
        HashMap<String, String> hashMap = this.testLBs;
        synchronized (hashMap) {
            while (this.testLBs.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testLBs.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionSSLCertificate(@Nonnull String label, @Nullable String namePrefix) throws CloudException, InternalException {
        NetworkServices services = this.provider.getNetworkServices();
        if (services == null) {
            throw new CloudException("This cloud does not support load balancers");
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            throw new CloudException("This cloud does not support load balancers");
        }
        String name = namePrefix == null ? "dsnssl" + random.nextInt(10000) : namePrefix + random.nextInt(10000);
        String testSslCertificateBody = "-----BEGIN CERTIFICATE-----\nMIIDdTCCAl2gAwIBAgIJAJ0yH+H1fw8nMA0GCSqGSIb3DQEBBQUAMFExCzAJBgNV\nBAYTAlVTMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME1RoZSBXZWF0\naGVyIENoYW5uZWwxDTALBgNVBAMMBHRlc3QwHhcNMTQwNDE4MTUyMzI2WhcNMjQw\nNDE1MTUyMzI2WjBRMQswCQYDVQQGEwJVUzEVMBMGA1UEBwwMRGVmYXVsdCBDaXR5\nMRwwGgYDVQQKDBNUaGUgV2VhdGhlciBDaGFubmVsMQ0wCwYDVQQDDAR0ZXN0MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyZc/utwao8R+vfCkTx50vNHl\n2aL7L4Gpm4bdHGU4LSmwaS0Q6eRob+bZEKb5Wfb0xmkx0Rl+VEkoxyVTxg8JtrIr\n8m63ohr24FH8fQpx2jZTyJKYLO94Ls2sTY4IJiYX6tnHOSQEnmk+BHwk7uTAI4Il\nTiY70tRCbUuIgei18jAR2FsevYoereotkukA0aD3n50JCpBNC4rgiCFZD4dP6tFx\nGUSKpCoxjH+pcW3txCV3op1JIK7nQ5L21vw4phSlOznoxO9QY/phqGQGorY7KxRi\ngvX6OjD6suRyrqKmOulBdTJP5Sqgrl/yET2Yhocs/rSGnaLA3Y7b6DkKts5O6wID\nAQABo1AwTjAdBgNVHQ4EFgQUVfdyopff30iphehCoyXsk1FJ85IwHwYDVR0jBBgw\nFoAUVfdyopff30iphehCoyXsk1FJ85IwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEANQBsY17sSckU+LRDwi3KdaCljkgVaCeRBxvu29jB4Vzhbagwya1u\nPhO2avn2VErsv8wj56qY68SM+GAb7Jl7ZY5V1us+YEy5zAoLj23bCMMjBUOOdNNx\nBeQx32D5lB3qKMiTNSJO6N3OsAp+gcAcwb63S4bpaGQlfX4gy4nh9H1kY3X0ZAty\nHip4sKXZgj9nJKtmIH7jP91NODfcwvRSdrElGU7rOiIy4f228tQhPMPkEB0CYlhT\npZUfKI90+uyjEQEc9Af11VNP3+g6CB3dgLkYOFStxG2eueTyz1V70b94dBGeMBYW\nZp1tE1iQ+jfkGFJuEiqsIMF6NAcjXFe/YA==\n-----END CERTIFICATE-----\n";
        String testSslCertificatePrivateKey = "-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEAyZc/utwao8R+vfCkTx50vNHl2aL7L4Gpm4bdHGU4LSmwaS0Q\n6eRob+bZEKb5Wfb0xmkx0Rl+VEkoxyVTxg8JtrIr8m63ohr24FH8fQpx2jZTyJKY\nLO94Ls2sTY4IJiYX6tnHOSQEnmk+BHwk7uTAI4IlTiY70tRCbUuIgei18jAR2Fse\nvYoereotkukA0aD3n50JCpBNC4rgiCFZD4dP6tFxGUSKpCoxjH+pcW3txCV3op1J\nIK7nQ5L21vw4phSlOznoxO9QY/phqGQGorY7KxRigvX6OjD6suRyrqKmOulBdTJP\n5Sqgrl/yET2Yhocs/rSGnaLA3Y7b6DkKts5O6wIDAQABAoIBACOO8kbbnDdW6aRH\nVjQ+gwjrXUfOX9A5ZtlwKIBhuk79E4j50gnvqBxU8+TkDwe3b+WvmIHxpT7oyLCX\n/PbqoCQBuY7ByNJnPzTCQW8s8Hg1LQIsGXuTofdfgA0OCJHyFjXuxB1oJQhsN+xC\nmaEp6FpbEol+ZP8DQdRVhnajvbRCRgWyO7sEYGRDvuYVo4Pn4kXFsIXajzA5ZnvJ\nU/VeicaPaj4T1uI2EDFDAZYLVd3x9vKop+8FKqhuZMhrSNbBoD+qucOcD7fZ3jjT\nZS8m4R3TkYLx0myLB0zOu0zARg0GUbMmIXpBk5IxwqIp6iZfXz8U0DKU//2OKiFC\nTmJoNwECgYEA9M4rfvBugItZzTQ+woPx84+MSirwJUU5ToklSpVSuQZE3nuucRV7\nbdQp0MGMYIFUvGVdwH9a/MUCYLtfCvsYbk0leTu6Ycb6h74TsIptIcGEZplyMOM3\n1Yt5F5VLPAmKBHRXXRrxQa2OWCGKuywsrz0HHAD8BGzNtyUka+dWoBsCgYEA0s8v\nalvmCgNKrnU9yM939WkAfAE330Dm8m9PVCGRnmXZ+ZpDQUjyveN9/9EUIjn2AR24\n1Svu5WjtezSXqJLWJYoYH9mCdKOE8WsTQl+Xk4zkJqQrniX0oYaZam9dBZ/TIYK4\nHz/K3qdpJUbDEW6xh+OaTIH2OaNJY32I2NC9GXECgYAb3awN0wiBEVuzhBLwyVwt\nQVXSy3hyhaK0UeAw0TaNYS1Ntf5xWOSn59KqtJ1qDs66cz9svhJ5W2Od5zY2Zcau\nJ5HwbuAUaTXzZauQGPG7Oe/8TdM1xWeBo1KxYIkj2GIhh6y6KGr18u+VEJxeGfUs\nLWI1ydbmGgyAoHW44qh1qQKBgCMJJAw9McJAQc001wvkzz8OMHJrkWmdU8S/EyQc\nYCM/Mjb1mG/lO9KrWGmHyhzWHTiaQ/nJz255Pd7YIsx1evnKNbA1aiUQeCvXa+AA\nGyT+qXxylH04OawOvridwYwJwAE1xHwNEh5nHGaBmDHxf7fh7+b/QnjZ1nyehHvk\nVUlBAoGBAPBNvBRDMAPEAaxl6QSxZD2O3dG51S+JEy0Xw7egiQlFEQTPiazkGqzc\npWusEXgU82S4R2DYhcCk3dJ1AsE1hexDXTvrBIK1q9yAUUEw9X9YPhfzAadULNcx\nSoUufwzG5X1lxMIzP95FAvFgOwGY1yqoFGLZrp5Gm37RBNqoAp7a\n-----END RSA PRIVATE KEY-----";
        SSLCertificateCreateOptions options = SSLCertificateCreateOptions.getInstance((String)"-----BEGIN CERTIFICATE-----\nMIIDdTCCAl2gAwIBAgIJAJ0yH+H1fw8nMA0GCSqGSIb3DQEBBQUAMFExCzAJBgNV\nBAYTAlVTMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME1RoZSBXZWF0\naGVyIENoYW5uZWwxDTALBgNVBAMMBHRlc3QwHhcNMTQwNDE4MTUyMzI2WhcNMjQw\nNDE1MTUyMzI2WjBRMQswCQYDVQQGEwJVUzEVMBMGA1UEBwwMRGVmYXVsdCBDaXR5\nMRwwGgYDVQQKDBNUaGUgV2VhdGhlciBDaGFubmVsMQ0wCwYDVQQDDAR0ZXN0MIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyZc/utwao8R+vfCkTx50vNHl\n2aL7L4Gpm4bdHGU4LSmwaS0Q6eRob+bZEKb5Wfb0xmkx0Rl+VEkoxyVTxg8JtrIr\n8m63ohr24FH8fQpx2jZTyJKYLO94Ls2sTY4IJiYX6tnHOSQEnmk+BHwk7uTAI4Il\nTiY70tRCbUuIgei18jAR2FsevYoereotkukA0aD3n50JCpBNC4rgiCFZD4dP6tFx\nGUSKpCoxjH+pcW3txCV3op1JIK7nQ5L21vw4phSlOznoxO9QY/phqGQGorY7KxRi\ngvX6OjD6suRyrqKmOulBdTJP5Sqgrl/yET2Yhocs/rSGnaLA3Y7b6DkKts5O6wID\nAQABo1AwTjAdBgNVHQ4EFgQUVfdyopff30iphehCoyXsk1FJ85IwHwYDVR0jBBgw\nFoAUVfdyopff30iphehCoyXsk1FJ85IwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B\nAQUFAAOCAQEANQBsY17sSckU+LRDwi3KdaCljkgVaCeRBxvu29jB4Vzhbagwya1u\nPhO2avn2VErsv8wj56qY68SM+GAb7Jl7ZY5V1us+YEy5zAoLj23bCMMjBUOOdNNx\nBeQx32D5lB3qKMiTNSJO6N3OsAp+gcAcwb63S4bpaGQlfX4gy4nh9H1kY3X0ZAty\nHip4sKXZgj9nJKtmIH7jP91NODfcwvRSdrElGU7rOiIy4f228tQhPMPkEB0CYlhT\npZUfKI90+uyjEQEc9Af11VNP3+g6CB3dgLkYOFStxG2eueTyz1V70b94dBGeMBYW\nZp1tE1iQ+jfkGFJuEiqsIMF6NAcjXFe/YA==\n-----END CERTIFICATE-----\n", null, (String)"-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEAyZc/utwao8R+vfCkTx50vNHl2aL7L4Gpm4bdHGU4LSmwaS0Q\n6eRob+bZEKb5Wfb0xmkx0Rl+VEkoxyVTxg8JtrIr8m63ohr24FH8fQpx2jZTyJKY\nLO94Ls2sTY4IJiYX6tnHOSQEnmk+BHwk7uTAI4IlTiY70tRCbUuIgei18jAR2Fse\nvYoereotkukA0aD3n50JCpBNC4rgiCFZD4dP6tFxGUSKpCoxjH+pcW3txCV3op1J\nIK7nQ5L21vw4phSlOznoxO9QY/phqGQGorY7KxRigvX6OjD6suRyrqKmOulBdTJP\n5Sqgrl/yET2Yhocs/rSGnaLA3Y7b6DkKts5O6wIDAQABAoIBACOO8kbbnDdW6aRH\nVjQ+gwjrXUfOX9A5ZtlwKIBhuk79E4j50gnvqBxU8+TkDwe3b+WvmIHxpT7oyLCX\n/PbqoCQBuY7ByNJnPzTCQW8s8Hg1LQIsGXuTofdfgA0OCJHyFjXuxB1oJQhsN+xC\nmaEp6FpbEol+ZP8DQdRVhnajvbRCRgWyO7sEYGRDvuYVo4Pn4kXFsIXajzA5ZnvJ\nU/VeicaPaj4T1uI2EDFDAZYLVd3x9vKop+8FKqhuZMhrSNbBoD+qucOcD7fZ3jjT\nZS8m4R3TkYLx0myLB0zOu0zARg0GUbMmIXpBk5IxwqIp6iZfXz8U0DKU//2OKiFC\nTmJoNwECgYEA9M4rfvBugItZzTQ+woPx84+MSirwJUU5ToklSpVSuQZE3nuucRV7\nbdQp0MGMYIFUvGVdwH9a/MUCYLtfCvsYbk0leTu6Ycb6h74TsIptIcGEZplyMOM3\n1Yt5F5VLPAmKBHRXXRrxQa2OWCGKuywsrz0HHAD8BGzNtyUka+dWoBsCgYEA0s8v\nalvmCgNKrnU9yM939WkAfAE330Dm8m9PVCGRnmXZ+ZpDQUjyveN9/9EUIjn2AR24\n1Svu5WjtezSXqJLWJYoYH9mCdKOE8WsTQl+Xk4zkJqQrniX0oYaZam9dBZ/TIYK4\nHz/K3qdpJUbDEW6xh+OaTIH2OaNJY32I2NC9GXECgYAb3awN0wiBEVuzhBLwyVwt\nQVXSy3hyhaK0UeAw0TaNYS1Ntf5xWOSn59KqtJ1qDs66cz9svhJ5W2Od5zY2Zcau\nJ5HwbuAUaTXzZauQGPG7Oe/8TdM1xWeBo1KxYIkj2GIhh6y6KGr18u+VEJxeGfUs\nLWI1ydbmGgyAoHW44qh1qQKBgCMJJAw9McJAQc001wvkzz8OMHJrkWmdU8S/EyQc\nYCM/Mjb1mG/lO9KrWGmHyhzWHTiaQ/nJz255Pd7YIsx1evnKNbA1aiUQeCvXa+AA\nGyT+qXxylH04OawOvridwYwJwAE1xHwNEh5nHGaBmDHxf7fh7+b/QnjZ1nyehHvk\nVUlBAoGBAPBNvBRDMAPEAaxl6QSxZD2O3dG51S+JEy0Xw7egiQlFEQTPiazkGqzc\npWusEXgU82S4R2DYhcCk3dJ1AsE1hexDXTvrBIK1q9yAUUEw9X9YPhfzAadULNcx\nSoUufwzG5X1lxMIzP95FAvFgOwGY1yqoFGLZrp5Gm37RBNqoAp7a\n-----END RSA PRIVATE KEY-----", (String)name, null);
        SSLCertificate sslCertificate = support.createSSLCertificate(options);
        String certificateName = sslCertificate.getCertificateName();
        HashMap<String, String> hashMap = this.testSSLCertificates;
        synchronized (hashMap) {
            while (this.testSSLCertificates.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testSSLCertificates.put(label, certificateName);
        }
        return certificateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionNetworkFirewall(@Nonnull String label, @Nullable String vlanId) throws CloudException, InternalException {
        NetworkServices services = this.provider.getNetworkServices();
        if (services == null) {
            throw new CloudException("This cloud does not support network firewalls");
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            throw new CloudException("This cloud does not support network firewalls");
        }
        if (vlanId == null && (vlanId = this.getTestVLANId("stateful", true, null)) == null) {
            throw new CloudException("No VLAN ID could be found");
        }
        String tmp = String.valueOf(random.nextInt(10000));
        String name = "dsnnetfw" + tmp;
        String description = "Dasein Cloud Integration Test NetworkFirewall";
        FirewallCreateOptions options = FirewallCreateOptions.getInstance((String)vlanId, (String)name, (String)description);
        String id = support.createFirewall(options);
        HashMap<String, String> hashMap = this.testNetworkFirewalls;
        synchronized (hashMap) {
            while (this.testNetworkFirewalls.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testNetworkFirewalls.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionSubnet(@Nonnull VLANSupport support, @Nonnull String label, @Nonnull String vlanId, @Nonnull String namePrefix, @Nullable String preferredDataCenterId) throws CloudException, InternalException {
        String id;
        Integer dc2;
        if (preferredDataCenterId == null && support.getCapabilities().isSubnetDataCenterConstrained()) {
            VLAN vlan = support.getVlan(vlanId);
            if (vlan == null) {
                throw new CloudException("No such VLAN: " + vlanId);
            }
            preferredDataCenterId = vlan.getProviderDataCenterId();
            if (preferredDataCenterId == null && (preferredDataCenterId = DaseinTestManager.getDefaultDataCenterId(true)) == null) {
                for (Integer dc2 : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                    if (!dc2.isActive() || !dc2.isAvailable()) continue;
                    preferredDataCenterId = dc2.getProviderDataCenterId();
                }
            }
        }
        SubnetCreateOptions options = preferredDataCenterId == null ? SubnetCreateOptions.getInstance((String)vlanId, (String)this.cidrs[this.cidrCount], (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Dasein Cloud Integration test subnet") : SubnetCreateOptions.getInstance((String)vlanId, (String)preferredDataCenterId, (String)this.cidrs[this.cidrCount], (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Dasein Cloud Integration test subnet");
        Integer i$ = this.cidrCount;
        dc2 = this.cidrCount = Integer.valueOf(this.cidrCount + 1);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("dsntestcase", "true");
        options.withMetaData(tags);
        options.withSupportedTraffic(new IPVersion[]{(IPVersion)support.getCapabilities().listSupportedIPVersions().iterator().next()});
        try {
            id = options.build(this.provider);
        }
        catch (CloudException e) {
            if (e.getMessage().contains("conflicts with another")) {
                return this.provisionSubnet(support, label, vlanId, namePrefix, preferredDataCenterId);
            }
            throw e;
        }
        HashMap<String, String> hashMap = this.testSubnets;
        synchronized (hashMap) {
            while (this.testSubnets.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testSubnets.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String provisionInternetGateway(@Nonnull VLANSupport support, @Nonnull String label, @Nonnull String vlanId) throws CloudException, InternalException {
        VLAN vlan;
        if (support.getCapabilities().isSubnetDataCenterConstrained() && (vlan = support.getVlan(vlanId)) == null) {
            throw new CloudException("No such VLAN: " + vlanId);
        }
        String id = support.createInternetGateway(vlanId);
        HashMap<String, String> hashMap = this.testInternetGateways;
        synchronized (hashMap) {
            while (this.testInternetGateways.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testInternetGateways.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionVLAN(@Nonnull VLANSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable String preferredDataCenterId) throws CloudException, InternalException {
        String id = support.createVlan("192.168.1.0/24", namePrefix + System.currentTimeMillis() % 10000L, "Test VLAN for the Dasein Cloud Integration tests", "example.com", new String[]{"192.168.1.1"}, new String[]{"192.168.1.1"}).getProviderVlanId();
        if (id == null) {
            throw new CloudException("No VLAN was created");
        }
        HashMap<String, String> hashMap = this.testVLANs;
        synchronized (hashMap) {
            while (this.testVLANs.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testVLANs.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionRoutingTable(@Nonnull VLANSupport support, @Nonnull String vlanId, @Nonnull String label, @Nonnull String namePrefix) throws CloudException, InternalException {
        String id = support.createRoutingTable(vlanId, namePrefix + System.currentTimeMillis() % 10000L, "Test Routing Table for the Dasein Cloud Integration tests");
        if (id == null) {
            throw new CloudException("No Routing Table was created");
        }
        HashMap<String, String> hashMap = this.testRouteTables;
        synchronized (hashMap) {
            while (this.testRouteTables.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testRouteTables.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionDNSZone(@Nonnull DNSSupport support, @Nonnull String label, @Nonnull String domainPrefix, @Nonnull String tld) throws CloudException, InternalException {
        String name = domainPrefix + System.currentTimeMillis() % 10000L + "." + tld;
        String id = support.createDnsZone(name, name, "Dasein Cloud Test Zone");
        HashMap<String, String> hashMap = this.testZones;
        synchronized (hashMap) {
            while (this.testZones.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testZones.put(label, id);
        }
        return id;
    }
}

