/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.DNSZone;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.network.NetworkResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulDNSTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private DNSRecord testRecord;
    private String testZoneId;
    private String testRecordName;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulDNSTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("removeZone")) {
            this.testZoneId = tm.getTestZoneId("removed", true);
        } else if (this.name.getMethodName().equals("addRecord")) {
            DNSSupport support;
            NetworkServices services;
            this.testZoneId = tm.getTestZoneId("stateful", true);
            if (this.testZoneId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getDnsSupport()) != null) {
                try {
                    DNSZone zone = support.getDnsZone(this.testZoneId);
                    if (zone != null) {
                        this.testRecordName = "dsn" + System.currentTimeMillis() + "." + zone.getDomainName();
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("removeRecord")) {
            this.testZoneId = tm.getTestZoneId("stateful", true);
            if (this.testZoneId != null) {
                NetworkServices services = tm.getProvider().getNetworkServices();
                if (services == null) {
                    tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
                    return;
                }
                DNSSupport support = services.getDnsSupport();
                if (support == null) {
                    tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
                    return;
                }
                try {
                    DNSZone zone = support.getDnsZone(this.testZoneId);
                    if (zone != null) {
                        this.testRecordName = "dsn" + System.currentTimeMillis() + "." + zone.getDomainName();
                    }
                    this.testRecord = support.addDnsRecord(this.testZoneId, DNSRecordType.A, this.testRecordName, 3600, new String[]{"210.10.10.10"});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void createZone() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources resources = DaseinTestManager.getNetworkResources();
        Assert.assertNotNull((String)"Failed to initialize network resources prior to test execution", (Object)resources);
        String zoneId = resources.provisionDNSZone(support, "stateful", "dasein", "org");
        tm.out("New DNS Zone", zoneId);
        Assert.assertNotNull((String)"No zone was provided for the newly created DNS zone", (Object)zoneId);
        DNSZone zone = support.getDnsZone(zoneId);
        Assert.assertNotNull((String)("No DNS zone exists for the new DNS ID " + zoneId), (Object)zone);
    }

    @Test
    public void removeZone() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testZoneId != null) {
            DNSZone zone = support.getDnsZone(this.testZoneId);
            tm.out("Before", zone);
            support.deleteDnsZone(this.testZoneId);
            zone = support.getDnsZone(this.testZoneId);
            tm.out("After", zone);
            Assert.assertNull((String)"DNS zone still exists after the deletion", (Object)zone);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void addRecord() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testZoneId != null && this.testRecordName != null) {
            DNSRecord record = support.addDnsRecord(this.testZoneId, DNSRecordType.A, this.testRecordName, 3600, new String[]{"210.10.10.10"});
            tm.out("New DNS Record", record);
            Assert.assertNotNull((String)"No DNS record was created for the test", (Object)record);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeRecord() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRecord != null) {
            support.deleteDnsRecords(new DNSRecord[]{this.testRecord});
            boolean found = false;
            for (DNSRecord record : support.listDnsRecords(this.testZoneId, DNSRecordType.A, null)) {
                Object[] values;
                Object[] testValues;
                if (!record.getName().equals(this.testRecord.getName()) || !Arrays.equals(testValues = this.testRecord.getValues(), values = record.getValues())) continue;
                found = true;
                break;
            }
            Assert.assertFalse((String)"The DNS record still exists in the system", (boolean)found);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }
}

