/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.compute.ComputeResources;
import org.dasein.cloud.test.network.NetworkResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulFirewallTests {
    private static DaseinTestManager tm;
    private static int port;
    @Rule
    public final TestName name = new TestName();
    private String testFirewallId;
    private String testRuleId;
    private String testVLANId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulFirewallTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        block29: {
            tm.begin(this.name.getMethodName());
            Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
            if (this.name.getMethodName().equals("createVLANFirewall") || this.name.getMethodName().equals("createVLANFirewallWithRule")) {
                this.testVLANId = tm.getTestVLANId("stateful", true, null);
            } else if (this.name.getMethodName().equals("launchVM")) {
                ComputeServices services = tm.getProvider().getComputeServices();
                try {
                    boolean vlan;
                    VirtualMachineSupport support = services == null ? null : services.getVirtualMachineSupport();
                    boolean bl = vlan = support != null && !support.getCapabilities().identifyVlanRequirement().equals((Object)Requirement.NONE);
                    if (vlan) {
                        this.testVLANId = tm.getTestVLANId("stateful", true, null);
                        if (this.testVLANId == null) {
                            this.testVLANId = tm.getTestVLANId("stateless", false, null);
                        }
                        this.testFirewallId = tm.getTestVLANFirewallId("stateful", true, this.testVLANId);
                        break block29;
                    }
                    this.testFirewallId = tm.getTestGeneralFirewallId("stateful", true);
                }
                catch (Throwable ignore) {}
            } else if (this.name.getMethodName().equals("removeFirewall")) {
                this.testFirewallId = tm.getTestAnyFirewallId("removed", true);
            } else if (this.name.getMethodName().startsWith("addGeneral")) {
                this.testFirewallId = tm.getTestGeneralFirewallId("stateful", true);
            } else if (this.name.getMethodName().startsWith("addVLAN")) {
                this.testFirewallId = tm.getTestVLANFirewallId("stateful", true, null);
            } else if (this.name.getMethodName().startsWith("revoke")) {
                FirewallSupport support;
                NetworkServices services;
                this.testFirewallId = this.name.getMethodName().startsWith("revokeGeneral") ? tm.getTestGeneralFirewallId("stateful", true) : tm.getTestVLANFirewallId("stateful", true, null);
                if (this.testFirewallId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getFirewallSupport()) != null) {
                    Permission permission = null;
                    Direction direction = null;
                    int p = port++;
                    if (this.name.getMethodName().contains("IngressAllow")) {
                        direction = Direction.INGRESS;
                        permission = Permission.ALLOW;
                    } else if (this.name.getMethodName().contains("IngressDeny")) {
                        direction = Direction.INGRESS;
                        permission = Permission.DENY;
                    } else if (this.name.getMethodName().contains("EgressAllow")) {
                        direction = Direction.EGRESS;
                        permission = Permission.ALLOW;
                    } else if (this.name.getMethodName().contains("EgressDeny")) {
                        direction = Direction.EGRESS;
                        permission = Permission.DENY;
                    }
                    if (direction != null && permission != null) {
                        RuleTarget destination;
                        RuleTarget source;
                        RuleTargetType type = RuleTargetType.CIDR;
                        if (this.name.getMethodName().contains("Global") && !this.name.getMethodName().contains("OldStyle")) {
                            type = RuleTargetType.GLOBAL;
                        }
                        if (direction.equals((Object)Direction.INGRESS)) {
                            source = this.getRandomEndpoint(type);
                            destination = RuleTarget.getGlobal((String)this.testFirewallId);
                        } else {
                            source = RuleTarget.getGlobal((String)this.testFirewallId);
                            destination = this.getRandomEndpoint(type);
                        }
                        try {
                            this.testRuleId = support.authorize(this.testFirewallId, direction, permission, source, Protocol.TCP, destination, p, p, 0);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testVLANId = null;
            this.testFirewallId = null;
            this.testRuleId = null;
        }
        finally {
            tm.end();
        }
    }

    @Nonnull
    private RuleTarget getRandomEndpoint(@Nonnull RuleTargetType type) {
        switch (type) {
            case CIDR: {
                return RuleTarget.getCIDR((String)"209.98.98.98/32");
            }
            case GLOBAL: {
                String id = tm.getTestAnyFirewallId("endpoint", true);
                if (id == null) break;
                return RuleTarget.getGlobal((String)id);
            }
        }
        Assert.fail((String)"Unable to generate an appropriate endpoint type");
        return null;
    }

    private void checkAddRule(Direction direction, Permission permission, boolean vlanTest, RuleTargetType type) throws CloudException, InternalException {
        RuleTarget destinationEndpoint;
        RuleTarget sourceEndpoint;
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        FirewallSupport support = services.getFirewallSupport();
        if (support == null) {
            tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId == null) {
            if (!support.getCapabilities().supportsFirewallCreation(vlanTest)) {
                tm.warn("Could not create a test firewall to verify rule adding, so this test is definitely not valid");
            } else if (support.getCapabilities().supportsRules(direction, permission, vlanTest)) {
                Assert.fail((String)"No test firewall even though these type of rules are supported");
            } else {
                tm.ok("Rule type " + direction + "/" + permission + " not supported");
            }
            return;
        }
        int p = port++;
        if (direction.equals((Object)Direction.INGRESS)) {
            sourceEndpoint = this.getRandomEndpoint(type);
            destinationEndpoint = RuleTarget.getGlobal((String)this.testFirewallId);
        } else {
            destinationEndpoint = this.getRandomEndpoint(type);
            sourceEndpoint = RuleTarget.getGlobal((String)this.testFirewallId);
        }
        boolean supported = false;
        for (RuleTargetType t : support.getCapabilities().listSupportedSourceTypes(vlanTest)) {
            if (!t.equals((Object)sourceEndpoint.getRuleTargetType())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            tm.ok("Source type " + sourceEndpoint.getRuleTargetType() + " is not supported");
            return;
        }
        supported = false;
        for (RuleTargetType t : support.getCapabilities().listSupportedDestinationTypes(vlanTest)) {
            if (!t.equals((Object)destinationEndpoint.getRuleTargetType())) continue;
            supported = true;
            break;
        }
        if (!supported) {
            tm.ok("Destination type " + destinationEndpoint.getRuleTargetType() + " is not supported");
            return;
        }
        if (support.getCapabilities().supportsRules(direction, permission, vlanTest)) {
            String ruleId = support.authorize(this.testFirewallId, direction, permission, sourceEndpoint, Protocol.TCP, destinationEndpoint, p, p, 0);
            boolean found = false;
            tm.out("New Rule", ruleId);
            for (FirewallRule rule : support.getRules(this.testFirewallId)) {
                if (!rule.getProviderRuleId().equals(ruleId)) continue;
                found = true;
                break;
            }
            tm.out("Listed", found);
            Assert.assertTrue((String)"Failed to identify new rule in the list of firewall rules", (boolean)found);
        } else {
            try {
                support.authorize(this.testFirewallId, direction, permission, sourceEndpoint, Protocol.TCP, destinationEndpoint, p, p, 0);
            }
            catch (OperationNotSupportedException e) {
                tm.ok("OperationNotSupportedException caught indicating lack of support for " + direction + "/" + permission + "/" + vlanTest);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkRemoveRule(Direction direction, Permission permission, boolean vlanTest, boolean oldStyle) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        FirewallSupport support = services.getFirewallSupport();
        if (support == null) {
            tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRuleId == null) {
            if (!support.getCapabilities().supportsRules(direction, permission, vlanTest)) {
                tm.ok("Rule type not supported");
                return;
            }
            RuleTargetType type = RuleTargetType.CIDR;
            if (this.name.getMethodName().contains("Global")) {
                type = RuleTargetType.GLOBAL;
            }
            boolean supported = false;
            if (direction.equals((Object)Direction.INGRESS)) {
                for (RuleTargetType t : support.getCapabilities().listSupportedSourceTypes(vlanTest)) {
                    if (!t.equals((Object)type)) continue;
                    supported = true;
                    break;
                }
            } else {
                for (RuleTargetType t : support.getCapabilities().listSupportedDestinationTypes(vlanTest)) {
                    if (!t.equals((Object)type)) continue;
                    supported = true;
                    break;
                }
            }
            if (!supported) {
                tm.ok("Rule targe type " + type + " is not supported");
                return;
            }
            Assert.fail((String)"No test rule exists even though these type of rules are supported");
        }
        if (!oldStyle) {
            support.revoke(this.testRuleId);
        } else {
            FirewallRule test = null;
            for (FirewallRule rule : support.getRules(this.testFirewallId)) {
                if (!rule.getProviderRuleId().equals(this.testRuleId)) continue;
                test = rule;
                break;
            }
            Assert.assertNotNull((String)("Test firewall rule cannot be found for " + this.testRuleId), test);
            if (direction.equals((Object)Direction.INGRESS)) {
                support.revoke(this.testFirewallId, direction, permission, test.getSource(), test.getProtocol(), test.getDestinationEndpoint(), test.getStartPort(), test.getEndPort());
            } else {
                RuleTarget dest = test.getDestinationEndpoint();
                String source = null;
                switch (dest.getRuleTargetType()) {
                    case CIDR: {
                        source = dest.getCidr();
                        break;
                    }
                    case GLOBAL: {
                        source = dest.getProviderFirewallId();
                        break;
                    }
                    case VLAN: {
                        source = dest.getProviderVlanId();
                        break;
                    }
                    case VM: {
                        source = dest.getProviderVirtualMachineId();
                        break;
                    }
                }
                junit.framework.Assert.assertNotNull((String)("Unknown target type: " + dest.getRuleTargetType()), (Object)source);
                support.revoke(this.testFirewallId, direction, permission, source, test.getProtocol(), test.getSourceEndpoint(), test.getStartPort(), test.getEndPort());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        boolean found = false;
        Iterator i$ = support.getRules(this.testFirewallId).iterator();
        while (true) {
            FirewallRule rule;
            if (!i$.hasNext()) {
                tm.out("Rule Present", found);
                Assert.assertFalse((String)"Found the test rule among the rules for the firewall post-removal", (boolean)found);
                return;
            }
            rule = (FirewallRule)i$.next();
            if (!rule.getProviderRuleId().equals(this.testRuleId)) continue;
            found = true;
        }
    }

    @Test
    public void createGeneralFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                NetworkResources net = DaseinTestManager.getNetworkResources();
                if (net != null) {
                    if (support.getCapabilities().supportsFirewallCreation(false)) {
                        String id = net.provisionFirewall("provisionKeypair", null);
                        tm.out("New Firewall", id);
                        Assert.assertNotNull((String)"No firewall was created by this test", (Object)id);
                    } else {
                        try {
                            net.provisionFirewall(this.name.getMethodName(), null);
                            Assert.fail((String)"Firewall provisioning completed even though general firewall creation is not supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                        }
                    }
                } else {
                    Assert.fail((String)("Network resources failed to initialize for " + tm.getProvider().getCloudName()));
                }
            } else {
                tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void createGeneralFirewallWithRule() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                NetworkResources net = DaseinTestManager.getNetworkResources();
                if (net != null) {
                    int p = port++;
                    if (support.getCapabilities().supportsFirewallCreation(false)) {
                        String id = net.provisionFirewall("provisionKeypair", null, net.constructRuleCreateOptions(p, Direction.INGRESS, Permission.ALLOW));
                        tm.out("New Firewall", id);
                        Assert.assertNotNull((String)"No firewall was created by this test", (Object)id);
                        Collection rules = support.getRules(id);
                        tm.out("Initial rules", rules);
                        Assert.assertNotNull((String)("Firewall rules are null post firewall create of " + id), (Object)rules);
                        boolean hasRule = false;
                        for (FirewallRule rule : support.getRules(id)) {
                            tm.out("\tRule", rule);
                            RuleTarget source = rule.getSourceEndpoint();
                            RuleTarget dest = rule.getDestinationEndpoint();
                            if (!source.getRuleTargetType().equals((Object)RuleTargetType.CIDR) || !dest.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) || !id.equals(dest.getProviderFirewallId()) || !"209.98.98.98/32".equals(source.getCidr())) continue;
                            hasRule = true;
                            break;
                        }
                        Assert.assertTrue((String)"The initial rule was not created with the test firewall", (boolean)hasRule);
                    } else {
                        try {
                            net.provisionFirewall(this.name.getMethodName(), null, net.constructRuleCreateOptions(p, Direction.INGRESS, Permission.ALLOW));
                            Assert.fail((String)"Firewall provisioning completed even though general firewall creation is not supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                        }
                    }
                } else {
                    Assert.fail((String)("Network resources failed to initialize for " + tm.getProvider().getCloudName()));
                }
            } else {
                tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void createVLANFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                NetworkResources net = DaseinTestManager.getNetworkResources();
                if (net != null) {
                    if (support.getCapabilities().supportsFirewallCreation(true)) {
                        if (this.testVLANId != null) {
                            String id = net.provisionFirewall("provision", this.testVLANId);
                            tm.out("New VLAN Firewall", id);
                            Assert.assertNotNull((String)"No VLAN firewall was created by this test", (Object)id);
                        } else {
                            Assert.fail((String)"Firewall creation in VLANs is supposedly supported, but there's not test VLAN ID");
                        }
                    } else {
                        String id = this.testVLANId == null ? UUID.randomUUID().toString() : this.testVLANId;
                        try {
                            net.provisionFirewall(this.name.getMethodName(), id);
                            Assert.fail((String)"Firewall provisioning completed even though VLAN firewall creation is not supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                        }
                    }
                } else {
                    Assert.fail((String)("Network resources failed to initialize for " + tm.getProvider().getCloudName()));
                }
            } else {
                tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void createVLANFirewallWithRule() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                NetworkResources net = DaseinTestManager.getNetworkResources();
                if (net != null) {
                    int p = port++;
                    if (support.getCapabilities().supportsFirewallCreation(true)) {
                        if (this.testVLANId != null) {
                            String id = net.provisionFirewall("provision", this.testVLANId, net.constructRuleCreateOptions(p, Direction.INGRESS, Permission.ALLOW));
                            tm.out("New VLAN Firewall", id);
                            Assert.assertNotNull((String)"No VLAN firewall was created by this test", (Object)id);
                            Collection rules = support.getRules(id);
                            tm.out("Initial rules", rules);
                            Assert.assertNotNull((String)("Firewall rules are null post firewall create of " + id), (Object)rules);
                            boolean hasRule = false;
                            for (FirewallRule rule : support.getRules(id)) {
                                tm.out("\tRule", rule);
                                RuleTarget source = rule.getSourceEndpoint();
                                RuleTarget dest = rule.getDestinationEndpoint();
                                if (!source.getRuleTargetType().equals((Object)RuleTargetType.CIDR) || !dest.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) || !id.equals(dest.getProviderFirewallId()) || !"209.98.98.98/32".equals(source.getCidr())) continue;
                                hasRule = true;
                                break;
                            }
                            Assert.assertTrue((String)"The initial rule was not created with the test firewall", (boolean)hasRule);
                        } else {
                            Assert.fail((String)"Firewall creation in VLANs is supposedly supported, but there's not test VLAN ID");
                        }
                    } else {
                        String id = this.testVLANId == null ? UUID.randomUUID().toString() : this.testVLANId;
                        try {
                            net.provisionFirewall(this.name.getMethodName(), id, net.constructRuleCreateOptions(p, Direction.INGRESS, Permission.ALLOW));
                            Assert.fail((String)"Firewall provisioning completed even though VLAN firewall creation is not supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                        }
                    }
                } else {
                    Assert.fail((String)("Network resources failed to initialize for " + tm.getProvider().getCloudName()));
                }
            } else {
                tm.ok("Firewalls are not supported in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void addGeneralIngressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.ALLOW, false, RuleTargetType.CIDR);
    }

    @Test
    public void addGeneralIngressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.DENY, false, RuleTargetType.CIDR);
    }

    @Test
    public void addGeneralEgressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.ALLOW, false, RuleTargetType.CIDR);
    }

    @Test
    public void addGeneralEgressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.DENY, false, RuleTargetType.CIDR);
    }

    @Test
    public void addVLANIngressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.ALLOW, true, RuleTargetType.CIDR);
    }

    @Test
    public void addVLANIngressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.DENY, true, RuleTargetType.CIDR);
    }

    @Test
    public void addVLANEgressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.ALLOW, true, RuleTargetType.CIDR);
    }

    @Test
    public void addVLANEgressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.DENY, true, RuleTargetType.CIDR);
    }

    @Test
    public void addGeneralIngressAllowGlobal() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.ALLOW, false, RuleTargetType.GLOBAL);
    }

    @Test
    public void revokeGeneralIngressAllow() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, false, false);
    }

    @Test
    public void revokeGeneralIngressDeny() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, false, false);
    }

    @Test
    public void revokeGeneralEgressAllow() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, false, false);
    }

    @Test
    public void revokeGeneralEgressDeny() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, false, false);
    }

    @Test
    public void revokeVLANIngressAllow() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, true, false);
    }

    @Test
    public void revokeVLANIngressDeny() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, true, false);
    }

    @Test
    public void revokeVLANEgressAllow() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, true, false);
    }

    @Test
    public void revokeVLANEgressDeny() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, true, false);
    }

    @Test
    public void revokeGeneralIngressAllowOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, false, true);
    }

    @Test
    public void revokeGeneralIngressDenyOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, false, true);
    }

    @Test
    public void revokeGeneralEgressAllowOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, false, true);
    }

    @Test
    public void revokeGeneralEgressDenyOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, false, true);
    }

    @Test
    public void revokeVLANIngressAllowOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, true, true);
    }

    @Test
    public void revokeVLANIngressDenyOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, true, true);
    }

    @Test
    public void revokeVLANEgressAllowOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, true, true);
    }

    @Test
    public void revokeVLANEgressDenyOldStyle() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, true, true);
    }

    @Test
    public void revokeGeneralIngressAllowOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, false, true);
    }

    @Test
    public void revokeGeneralIngressDenyOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, false, true);
    }

    @Test
    public void revokeGeneralEgressAllowOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, false, true);
    }

    @Test
    public void revokeGeneralEgressDenyOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, false, true);
    }

    @Test
    public void revokeVLANIngressAllowOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.ALLOW, true, true);
    }

    @Test
    public void revokeVLANIngressDenyOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.INGRESS, Permission.DENY, true, true);
    }

    @Test
    public void revokeVLANEgressAllowOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.ALLOW, true, true);
    }

    @Test
    public void revokeVLANEgressDenyOldStyleGlobal() throws CloudException, InternalException {
        this.checkRemoveRule(Direction.EGRESS, Permission.DENY, true, true);
    }

    @Test
    public void removeFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testFirewallId != null) {
                    if (support.getCapabilities().supportsFirewallDeletion()) {
                        Firewall firewall = support.getFirewall(this.testFirewallId);
                        tm.out("Before", firewall);
                        Assert.assertNotNull((String)"Test firewall no longer exists, cannot test removing it", (Object)firewall);
                        tm.out("Active", firewall.isActive());
                        support.delete(this.testFirewallId);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        firewall = support.getFirewall(this.testFirewallId);
                        tm.out("After", firewall);
                        tm.out("Active", firewall == null ? "false" : Boolean.valueOf(firewall.isActive()));
                        Assert.assertTrue((String)"The firewall remains available", (firewall == null || !firewall.isActive() ? 1 : 0) != 0);
                    } else {
                        try {
                            support.delete(this.testFirewallId);
                            Assert.fail((String)"Firewall deletion not supported but completed without error");
                        }
                        catch (OperationNotSupportedException e) {
                            tm.ok("Caught not supported exception for delete Firewall in cloud that does not support firewall deletion");
                        }
                    }
                } else if (!support.getCapabilities().supportsFirewallCreation(true) && !support.getCapabilities().supportsFirewallCreation(false)) {
                    tm.ok("Firewall creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test firewall for " + this.name.getMethodName()));
                } else {
                    tm.ok("Firewall support is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void launchVM() throws CloudException, InternalException {
        VirtualMachineSupport support;
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            support = services.getVirtualMachineSupport();
            if (support == null) {
                tm.ok("No virtual machine support in " + tm.getProvider().getCloudName());
                return;
            }
        } else {
            tm.ok("No compute services in " + tm.getProvider().getCloudName());
            return;
        }
        boolean inVlan = !support.getCapabilities().identifyVlanRequirement().equals((Object)Requirement.NONE);
        String testSubnetId = null;
        if (inVlan && this.testVLANId == null) {
            Assert.fail((String)"No test VLAN exists to test launching a VM behind a firewall");
        } else if (inVlan) {
            testSubnetId = tm.getTestSubnetId("stateful", true, this.testVLANId, null);
        }
        ComputeResources compute = DaseinTestManager.getComputeResources();
        if (compute != null) {
            String productId = tm.getTestVMProductId();
            Assert.assertNotNull((String)"Unable to identify a VM product for test launch", (Object)productId);
            String imageId = tm.getTestImageId("stateless", false);
            Assert.assertNotNull((String)"Unable to identify a test image for test launch", (Object)imageId);
            VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnnetl" + System.currentTimeMillis() % 10000L), (String)("Dasein Network Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a network");
            if (this.testFirewallId != null) {
                String dataCenterId;
                options.behindFirewalls(new String[]{this.testFirewallId});
                if (testSubnetId != null) {
                    Subnet subnet = tm.getProvider().getNetworkServices().getVlanSupport().getSubnet(testSubnetId);
                    Assert.assertNotNull((String)"Subnet went away before test could be executed", (Object)subnet);
                    dataCenterId = subnet.getProviderDataCenterId();
                    if (dataCenterId == null) {
                        for (DataCenter dc : tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId())) {
                            dataCenterId = dc.getProviderDataCenterId();
                        }
                    }
                    Assert.assertNotNull((String)"Could not identify a data center for VM launch", (Object)dataCenterId);
                    options.inDataCenter(dataCenterId);
                    options.inSubnet(null, dataCenterId, this.testVLANId, testSubnetId);
                } else if (this.testVLANId != null) {
                    VLAN vlan = tm.getProvider().getNetworkServices().getVlanSupport().getVlan(this.testVLANId);
                    Assert.assertNotNull((String)"VLAN went away before test could be executed", (Object)vlan);
                    dataCenterId = vlan.getProviderDataCenterId();
                    if (dataCenterId == null) {
                        for (DataCenter dc : tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId())) {
                            dataCenterId = dc.getProviderDataCenterId();
                        }
                    }
                    Assert.assertNotNull((String)"Could not identify a data center for VM launch", (Object)dataCenterId);
                    options.inDataCenter(dataCenterId);
                    options.inVlan(null, dataCenterId, this.testVLANId);
                }
            } else {
                FirewallSupport fw;
                NetworkServices net = tm.getProvider().getNetworkServices();
                FirewallSupport firewallSupport = fw = net == null ? null : net.getFirewallSupport();
                if (fw != null && fw.isSubscribed()) {
                    if (fw.getCapabilities().supportsFirewallCreation(inVlan)) {
                        Assert.fail((String)"No test firewall was established for testing");
                    } else {
                        tm.warn("Unable to test the ability to launch a VM behind a firewall due to lack of ability to create firewalls, test is invalid");
                    }
                } else {
                    tm.ok("Launching behind firewalls is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
                }
                return;
            }
            String vmId = compute.provisionVM(support, "fwLaunch", options, options.getDataCenterId());
            tm.out("Virtual Machine", vmId);
            Assert.assertNotNull((String)"No error received launching VM behind firewall, but there was no virtual machine", (Object)vmId);
            VirtualMachine vm = support.getVirtualMachine(vmId);
            Assert.assertNotNull((String)"Launched VM does not exist", (Object)vm);
            tm.out("Behind firewalls", Arrays.toString(vm.getProviderFirewallIds()));
            String[] fwIds = vm.getProviderFirewallIds();
            Assert.assertNotNull((String)"The VM firewalls should not be null", (Object)fwIds);
            Assert.assertEquals((String)"The number of firewalls is incorrect", (long)1L, (long)fwIds.length);
            Assert.assertEquals((String)"The firewall IDs do not match the test firewall", (Object)this.testFirewallId, (Object)fwIds[0]);
        }
    }

    static {
        port = 81;
    }
}

