/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.HealthCheckOptions;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.SSLCertificate;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.network.NetworkResources;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulLoadBalancerTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDataCenterId;
    private String testLoadBalancerId;
    private String testVirtualMachineId;
    private String testSSLCertificateName;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulLoadBalancerTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        block57: {
            NetworkServices services;
            tm.begin(this.name.getMethodName());
            Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
            try {
                this.testDataCenterId = System.getProperty("test.dataCenter");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                if (this.testDataCenterId == null) {
                    this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (this.name.getMethodName().equals("removeLoadBalancer")) {
                this.testLoadBalancerId = tm.getTestLoadBalancerId("removed", tm.getUserName() + "-dsnlb", true, false);
            } else if (this.name.getMethodName().equals("addIP") || this.name.getMethodName().equals("createLoadBalancerHealthCheck")) {
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true);
            } else if (this.name.getMethodName().equals("createLoadBalancerWithHealthCheck")) {
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true, true);
            } else if (this.name.getMethodName().equals("removeIP")) {
                LoadBalancerSupport support;
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true);
                services = tm.getProvider().getNetworkServices();
                if (services != null && (support = services.getLoadBalancerSupport()) != null) {
                    try {
                        support.removeIPEndpoints(this.testLoadBalancerId, new String[]{"197.41.20.2"});
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("addServer")) {
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true, true);
                LoadBalancer lb = null;
                NetworkServices net = tm.getProvider().getNetworkServices();
                try {
                    LoadBalancerSupport support;
                    if (net != null && (support = net.getLoadBalancerSupport()) != null) {
                        lb = support.getLoadBalancer(this.testLoadBalancerId);
                    }
                    if (lb != null) {
                        String[] ids = lb.getProviderDataCenterIds();
                        boolean found = false;
                        for (String dataCenterId : ids) {
                            if (!this.testDataCenterId.equals(dataCenterId)) continue;
                            found = true;
                        }
                        if (!found) {
                            Assert.fail((String)"Failed to find testDataCenterId in the results of lb.getProviderDataCenterIds()");
                        }
                        this.testVirtualMachineId = tm.getTestVMId("stateful-" + this.testLoadBalancerId + System.currentTimeMillis() % 10000L, VmState.RUNNING, true, this.testDataCenterId);
                    }
                }
                catch (Throwable ignore) {}
            } else if (this.name.getMethodName().equals("addDataCenter")) {
                LoadBalancerSupport support;
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true);
                if (this.testLoadBalancerId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getLoadBalancerSupport()) != null) {
                    try {
                        if (support.getCapabilities().isDataCenterLimited()) {
                            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
                            if (lb == null) break block57;
                            ArrayList regionDataCenters = new ArrayList();
                            String[] dcs = lb.getProviderDataCenterIds();
                            regionDataCenters.addAll(tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()));
                            if (dcs.length >= regionDataCenters.size()) {
                                support.removeDataCenters(this.testLoadBalancerId, new String[]{dcs[0]});
                                this.testDataCenterId = dcs[0];
                                break block57;
                            }
                            for (DataCenter dc : regionDataCenters) {
                                boolean included = false;
                                for (String id : dcs) {
                                    if (!id.equals(dc.getProviderDataCenterId())) continue;
                                    included = true;
                                    break;
                                }
                                if (included) continue;
                                this.testDataCenterId = dc.getProviderDataCenterId();
                                break block57;
                            }
                            break block57;
                        }
                        try {
                            this.testDataCenterId = System.getProperty("test.dataCenter");
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        try {
                            if (this.testDataCenterId == null) {
                                this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
                            }
                        }
                        catch (Throwable ignore) {
                        }
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("removeDataCenter")) {
                LoadBalancerSupport support;
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true);
                if (this.testLoadBalancerId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getLoadBalancerSupport()) != null) {
                    try {
                        if (support.getCapabilities().isDataCenterLimited()) {
                            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
                            if (lb != null) {
                                Iterator it = tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator();
                                String[] dcs = lb.getProviderDataCenterIds();
                                if (dcs.length >= 2) {
                                    this.testDataCenterId = dcs[0];
                                } else {
                                    while (dcs.length < 2) {
                                        this.testDataCenterId = ((DataCenter)it.next()).getProviderDataCenterId();
                                        support.addDataCenters(this.testLoadBalancerId, new String[]{this.testDataCenterId});
                                        if (dcs.length >= 1 || !it.hasNext()) continue;
                                        support.addDataCenters(this.testLoadBalancerId, new String[]{((DataCenter)it.next()).getProviderDataCenterId()});
                                    }
                                }
                            }
                            break block57;
                        }
                        this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
                    }
                    catch (Throwable ignore) {}
                }
            } else if (this.name.getMethodName().equals("removeServer")) {
                this.testLoadBalancerId = tm.getTestLoadBalancerId("stateful", tm.getUserName() + "-dsnlb", true, true);
                NetworkServices net = tm.getProvider().getNetworkServices();
                try {
                    LoadBalancerSupport support;
                    if (net == null || (support = net.getLoadBalancerSupport()) == null) break block57;
                    ArrayList<String> ids = new ArrayList<String>();
                    for (LoadBalancerEndpoint endpoint : support.listEndpoints(this.testLoadBalancerId)) {
                        if (!endpoint.getEndpointType().equals((Object)LbEndpointType.VM)) continue;
                        ids.add(endpoint.getEndpointValue());
                    }
                    if (ids.size() > 0) {
                        this.testVirtualMachineId = (String)ids.iterator().next();
                    } else {
                        this.testVirtualMachineId = tm.getTestVMId("stateful_" + this.testLoadBalancerId + System.currentTimeMillis() % 10000L, VmState.RUNNING, true, this.testDataCenterId);
                        if (this.testVirtualMachineId != null) {
                            support.addServers(this.testLoadBalancerId, new String[]{this.testVirtualMachineId});
                        }
                    }
                }
                catch (Throwable throwable) {}
            } else if (this.name.getMethodName().equals("removeSSLCertificate")) {
                this.testSSLCertificateName = tm.getTestSSLCertificateName("removed", true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testLoadBalancerId = null;
            this.testDataCenterId = null;
            this.testVirtualMachineId = null;
            this.testSSLCertificateName = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void createLoadBalancer() throws CloudException, InternalException {
        this.createLoadBalancer(false);
    }

    @Test
    public void createLoadBalancerWithHttpsListener() throws CloudException, InternalException {
        this.createLoadBalancer(true);
    }

    private void createLoadBalancer(boolean withHttpsListener) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        String id = network.provisionLoadBalancer("provision", tm.getUserName() + "-dsncrlbtest", false, withHttpsListener, false);
        tm.out("New Load Balancer", id);
        Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)id);
        LoadBalancer lb = support.getLoadBalancer(id);
        Assert.assertNotNull((String)"The newly created load balancer is null", (Object)lb);
    }

    @Test
    public void createLoadBalancerWithHealthCheck() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        String id = network.provisionLoadBalancer("provision", tm.getUserName() + "-dsncrlbtest", false, false, true);
        tm.out("New Load Balancer", id);
        Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)id);
        LoadBalancer lb = support.getLoadBalancer(id);
        Assert.assertNotNull((Object)String.format("Load Balancer %s failed to create.", id));
        LoadBalancerHealthCheck lbhc = support.getLoadBalancerHealthCheck(lb.getProviderLBHealthCheckId(), id);
        StatefulLoadBalancerTests.assertHealthCheck(id, support, lbhc);
    }

    @Test
    public void modifyHealthCheck() throws CloudException, InternalException {
        LoadBalancerHealthCheck lbhc;
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        HealthCheckOptions hcOpt = HealthCheckOptions.getInstance(null, null, null, null, (LoadBalancerHealthCheck.HCProtocol)LoadBalancerHealthCheck.HCProtocol.TCP, (int)9876, null, (int)10, (int)9, (int)5, (int)5);
        String lbId = null;
        String lbhcId = null;
        if (support.getCapabilities().healthCheckRequiresLoadBalancer()) {
            lbId = network.provisionLoadBalancer("provision", "dsnmodhctest", false, false, true);
            tm.out("New Load Balancer", lbId);
            Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)lbId);
            LoadBalancer lb = support.getLoadBalancer(lbId);
            Assert.assertNotNull((Object)String.format("Load Balancer %s failed to create.", lbId));
            hcOpt.withProviderLoadBalancerId(lbId);
            lbhcId = lb.getProviderLBHealthCheckId();
        } else {
            lbhc = support.createLoadBalancerHealthCheck(null, null, null, LoadBalancerHealthCheck.HCProtocol.HTTP, 8090, null, 20, 15, 2, 2);
            lbhcId = lbhc.getProviderLBHealthCheckId();
        }
        lbhc = support.getLoadBalancerHealthCheck(lbhcId, lbId);
        StatefulLoadBalancerTests.assertHealthCheck(lbId, support, lbhc);
        LoadBalancerHealthCheck lbhcModified = support.modifyHealthCheck(lbhcId, hcOpt);
        this.assertCompareOptionsWithLBHC(hcOpt, lbhcModified);
        lbhcModified = support.getLoadBalancerHealthCheck(lbhcId, lbId);
        this.assertCompareOptionsWithLBHC(hcOpt, lbhcModified);
    }

    private void assertCompareOptionsWithLBHC(HealthCheckOptions requested, LoadBalancerHealthCheck actual) {
        Assert.assertNotNull((String)"Health check may not be null", (Object)actual);
        Assert.assertEquals((String)"Failed to modify health check 'path'", (Object)requested.getPath(), (Object)actual.getPath());
        Assert.assertEquals((String)"Failed to modify health check 'protocol'", (Object)requested.getProtocol(), (Object)actual.getProtocol());
        Assert.assertEquals((String)"Failed to modify health check 'port'", (long)requested.getPort(), (long)actual.getPort());
        Assert.assertEquals((String)"Failed to modify health check 'interval'", (long)requested.getInterval(), (long)actual.getInterval());
        Assert.assertEquals((String)"Failed to modify health check 'timeout'", (long)requested.getTimeout(), (long)actual.getTimeout());
        Assert.assertEquals((String)"Failed to modify health check 'healthyCount'", (long)requested.getHealthyCount(), (long)actual.getHealthyCount());
        Assert.assertEquals((String)"Failed to modify health check 'unhealthyCount'", (long)requested.getUnhealthyCount(), (long)actual.getUnhealthyCount());
    }

    static void assertHealthCheck(String testLBId, LoadBalancerSupport support, LoadBalancerHealthCheck lbhc) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The LB health check 'ID' may not be null", (Object)lbhc.getProviderLBHealthCheckId());
        if (lbhc.getPath() != null) {
            Assert.assertEquals((String)"The LB health check 'path' is incorrect", (Object)"/index.htm", (Object)lbhc.getPath());
        }
        if (lbhc.getHost() != null) {
            Assert.assertEquals((String)"The LB health check 'host' is incorrect", (Object)"localhost", (Object)lbhc.getHost());
        }
        Assert.assertThat((String)"The LB health check 'healthyCount' should be greater than zero", (Object)lbhc.getHealthyCount(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((String)"The LB health check 'unhealthyCount' should be greater than zero", (Object)lbhc.getUnhealthyCount(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((String)"The LB health check 'port' should be greater than zero", (Object)lbhc.getPort(), (Matcher)Matchers.equalTo((Object)8080));
        Assert.assertNotNull((String)"The LB health check 'protocol' may not be null", (Object)lbhc.getProtocol());
        Assert.assertNotNull((String)"The LB health check 'providerLoadBalancerIds' may not be null", (Object)lbhc.getProviderLoadBalancerIds());
        if (support.getCapabilities().healthCheckRequiresLoadBalancer()) {
            Assert.assertThat((String)"The LB health check 'providerLoadBalancerIds' should have at least one element", (Object)lbhc.getProviderLoadBalancerIds().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        } else {
            Assert.assertEquals((String)"The LB health check 'providerLoadBalancerIds' should have 0 elements", (long)lbhc.getProviderLoadBalancerIds().size(), (long)0L);
        }
    }

    @Test
    public void createInternalLoadBalancer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        String id = network.provisionLoadBalancer("provision", tm.getUserName() + "-dsncrintlbtest", true);
        tm.out("New Internal Load Balancer", id);
        Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)id);
        LoadBalancer lb = support.getLoadBalancer(id);
        Assert.assertNotNull((String)"The newly created load balancer is null", (Object)lb);
    }

    @Test
    public void addDataCenter() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null && this.testDataCenterId != null) {
            if (support.getCapabilities().isDataCenterLimited()) {
                LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
                Assert.assertNotNull((String)"The test load balancer disappeared prior to the test", (Object)lb);
                tm.out("Before", Arrays.toString(lb.getProviderDataCenterIds()));
                support.addDataCenters(this.testLoadBalancerId, new String[]{this.testDataCenterId});
                lb = support.getLoadBalancer(this.testLoadBalancerId);
                Assert.assertNotNull((String)"The test load balancer no longer exists", (Object)lb);
                Object[] ids = lb.getProviderDataCenterIds();
                tm.out("After", Arrays.toString(ids));
                boolean ok = false;
                for (Object dc : ids) {
                    if (!((String)dc).equals(this.testDataCenterId)) continue;
                    ok = true;
                }
                Assert.assertTrue((String)"Failed to find the new data center among the load balancer data centers", (boolean)ok);
            } else {
                try {
                    support.addDataCenters(this.testLoadBalancerId, new String[]{this.testDataCenterId});
                    Assert.fail((String)"Should not be able to add data centers in a cloud that is not data center limited");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud is not data center limited");
                }
            }
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void addIP() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        String testIpAddress = "196.91.70.2";
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean ips = false;
        for (LbEndpointType t : support.getCapabilities().listSupportedEndpointTypes()) {
            if (!t.equals((Object)LbEndpointType.IP)) continue;
            ips = true;
            break;
        }
        if (this.testLoadBalancerId != null) {
            if (support.getCapabilities().supportsAddingEndpoints() && ips) {
                tm.out("Before", support.listEndpoints(this.testLoadBalancerId));
                support.addIPEndpoints(this.testLoadBalancerId, new String[]{testIpAddress});
                Iterable endpoints = support.listEndpoints(this.testLoadBalancerId);
                tm.out("After", endpoints);
                boolean ok = false;
                for (LoadBalancerEndpoint endpoint : endpoints) {
                    if (!endpoint.getEndpointType().equals((Object)LbEndpointType.IP) || !endpoint.getEndpointValue().equals(testIpAddress)) continue;
                    ok = true;
                }
                Assert.assertTrue((String)"Failed to find the new IP address among the load balancer endpoints", (boolean)ok);
            } else {
                try {
                    support.addIPEndpoints(this.testLoadBalancerId, new String[]{testIpAddress});
                    Assert.fail((String)"Should not be able to add endpoints in this cloud, but the operation completed");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud does not support adding IP addresses post-create");
                }
            }
        } else if (!ips) {
            tm.ok("Load balancers in this cloud do not support IP endpoints");
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void addServer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean vms = false;
        for (LbEndpointType t : support.getCapabilities().listSupportedEndpointTypes()) {
            if (!t.equals((Object)LbEndpointType.VM)) continue;
            vms = true;
            break;
        }
        if (this.testLoadBalancerId != null && this.testVirtualMachineId != null) {
            if (support.getCapabilities().supportsAddingEndpoints() && vms) {
                tm.out("Before", support.listEndpoints(this.testLoadBalancerId));
                support.addServers(this.testLoadBalancerId, new String[]{this.testVirtualMachineId});
                Iterable endpoints = support.listEndpoints(this.testLoadBalancerId);
                tm.out("After", endpoints);
                boolean ok = false;
                for (LoadBalancerEndpoint endpoint : endpoints) {
                    if (!endpoint.getEndpointType().equals((Object)LbEndpointType.VM) || !endpoint.getEndpointValue().equals(this.testVirtualMachineId)) continue;
                    ok = true;
                }
                Assert.assertTrue((String)"Failed to find the new server among the load balancer endpoints", (boolean)ok);
            } else {
                try {
                    support.addServers(this.testLoadBalancerId, new String[]{this.testVirtualMachineId});
                    Assert.fail((String)"Should not be able to add endpoints in this cloud, but the operation completed");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud does not support adding virtual machines post-create");
                }
            }
        } else if (!vms) {
            tm.ok("Load balancers in this cloud do not support virtual machine endpoints");
        } else if (support.isSubscribed()) {
            StringBuilder sb = new StringBuilder();
            if (this.testLoadBalancerId == null) {
                sb.append("No test load balancer for " + this.name.getMethodName()).append(". ");
            }
            if (this.testVirtualMachineId == null) {
                sb.append("No test VM for " + this.name.getMethodName()).append(".");
            }
            Assert.fail((String)sb.toString());
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void removeDataCenter() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null && this.testDataCenterId != null) {
            if (support.getCapabilities().isDataCenterLimited()) {
                LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
                Assert.assertNotNull((String)"The test load balancer disappeared during the test", (Object)lb);
                tm.out("Before", Arrays.toString(lb.getProviderDataCenterIds()));
                support.removeDataCenters(this.testLoadBalancerId, new String[]{this.testDataCenterId});
                lb = support.getLoadBalancer(this.testLoadBalancerId);
                Assert.assertNotNull((String)"The test load balancer no longer exists", (Object)lb);
                Object[] ids = lb.getProviderDataCenterIds();
                tm.out("After", Arrays.toString(ids));
                boolean ok = false;
                for (Object dc : ids) {
                    if (!((String)dc).equals(this.testDataCenterId)) continue;
                    ok = true;
                }
                Assert.assertFalse((String)"The test data center is still present among the load balancer data centers", (boolean)ok);
            } else {
                try {
                    support.removeDataCenters(this.testLoadBalancerId, new String[]{this.testDataCenterId});
                    Assert.fail((String)"Should not be able to remove data centers in a cloud that is not data center limited");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud is not data center limited");
                }
            }
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void removeIP() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean ips = false;
        for (LbEndpointType t : support.getCapabilities().listSupportedEndpointTypes()) {
            if (!t.equals((Object)LbEndpointType.IP)) continue;
            ips = true;
            break;
        }
        if (this.testLoadBalancerId != null) {
            if (support.getCapabilities().supportsAddingEndpoints() && ips) {
                tm.out("Before", support.listEndpoints(this.testLoadBalancerId));
                support.removeIPEndpoints(this.testLoadBalancerId, new String[]{"197.41.20.2"});
                Iterable endpoints = support.listEndpoints(this.testLoadBalancerId);
                tm.out("After", endpoints);
                boolean ok = false;
                for (LoadBalancerEndpoint endpoint : endpoints) {
                    if (!endpoint.getEndpointType().equals((Object)LbEndpointType.IP) || !endpoint.getEndpointValue().equals("197.41.20.2")) continue;
                    ok = true;
                }
                Assert.assertFalse((String)"The test IP endpoint still exists among the load balancer endpoints", (boolean)ok);
            } else {
                try {
                    support.removeIPEndpoints(this.testLoadBalancerId, new String[]{"197.41.20.2"});
                    Assert.fail((String)"Should not be able to remove endpoints in this cloud, but the operation completed");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud does not support removing IP addresses post-create");
                }
            }
        } else if (!ips) {
            tm.ok("Load balancers in this cloud do not support IP endpoints");
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void removeServer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean vms = false;
        for (LbEndpointType t : support.getCapabilities().listSupportedEndpointTypes()) {
            if (!t.equals((Object)LbEndpointType.VM)) continue;
            vms = true;
            break;
        }
        if (this.testLoadBalancerId != null && this.testVirtualMachineId != null) {
            if (support.getCapabilities().supportsAddingEndpoints() && vms) {
                tm.out("Before", support.listEndpoints(this.testLoadBalancerId));
                support.removeServers(this.testLoadBalancerId, new String[]{this.testVirtualMachineId});
                Iterable endpoints = support.listEndpoints(this.testLoadBalancerId);
                tm.out("After", endpoints);
                boolean ok = false;
                for (LoadBalancerEndpoint endpoint : support.listEndpoints(this.testLoadBalancerId)) {
                    if (!endpoint.getEndpointType().equals((Object)LbEndpointType.VM) || !endpoint.getEndpointValue().equals(this.testVirtualMachineId)) continue;
                    ok = true;
                }
                Assert.assertFalse((String)"The test virtual machine is still present among the load balancer endpoints", (boolean)ok);
            } else {
                try {
                    support.removeServers(this.testLoadBalancerId, new String[]{this.testVirtualMachineId});
                    Assert.fail((String)"Should not be able to remove endpoints in this cloud, but the operation completed");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException because this cloud does not support adding/removing virtual machines post-create");
                }
            }
        } else if (!vms) {
            tm.ok("Load balancers in this cloud do not support virtual machine endpoints");
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void removeLoadBalancer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null) {
            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
            tm.out("Before", lb == null ? LoadBalancerState.TERMINATED : lb.getCurrentState());
            Assert.assertNotNull((String)"The load balancer is null prior to the test", (Object)lb);
            support.removeLoadBalancer(this.testLoadBalancerId);
            lb = support.getLoadBalancer(this.testLoadBalancerId);
            LoadBalancerState s = lb == null ? LoadBalancerState.TERMINATED : lb.getCurrentState();
            tm.out("After", s);
            Assert.assertEquals((String)"The load balancer still exists after the test", (Object)LoadBalancerState.TERMINATED, (Object)s);
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
        } else {
            tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void createLoadBalancerHealthCheck() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerHealthCheck lbhc = support.createLoadBalancerHealthCheck(HealthCheckOptions.getInstance((String)"foobar", (String)"foobardesc", (String)this.testLoadBalancerId, (String)"www.mydomain.com", (LoadBalancerHealthCheck.HCProtocol)LoadBalancerHealthCheck.HCProtocol.HTTP, (int)80, (String)"/ping", (int)30, (int)3, (int)2, (int)2));
        if (support.getCapabilities().healthCheckRequiresLoadBalancer()) {
            if (this.testLoadBalancerId != null) {
                Assert.assertNotNull((String)"Could not create a healthcheck for loadbalancer", (Object)lbhc);
            } else if (support.isSubscribed()) {
                Assert.fail((String)("No test load balancer for " + this.name.getMethodName()));
            } else {
                tm.ok("Load balancer support is not subscribed so this test is not entirely valid");
            }
        } else {
            Assert.assertNotNull((String)"Could not create a standalone healthcheck", (Object)lbhc);
        }
        support.removeLoadBalancerHealthCheck("foobar");
    }

    @Test
    public void createSSLCertificate() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        String id = network.provisionSSLCertificate("provision", tm.getUserName() + "-dsnssltest");
        tm.out("New SSL certificate", id);
        Assert.assertNotNull((String)"The newly created SSL certificate ID was null", (Object)id);
        SSLCertificate certificate = support.getSSLCertificate(id);
        Assert.assertNotNull((String)"The newly created SSL certificate is null", (Object)certificate);
    }

    @Test
    public void removeSSLCertificate() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSSLCertificateName != null) {
            SSLCertificate certificate = support.getSSLCertificate(this.testSSLCertificateName);
            Assert.assertNotNull((String)"The SSL certificate is null prior to the test", (Object)certificate);
            support.removeSSLCertificate(this.testSSLCertificateName);
            certificate = support.getSSLCertificate(this.testSSLCertificateName);
            Assert.assertNull((String)"The SSL certificate still exists after removing", (Object)certificate);
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test SSL certificate for " + this.name.getMethodName()));
        } else {
            tm.ok("SSL certificate support is not subscribed so this test is not entirely valid");
        }
    }

    @Test
    public void listLoadBalancers() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        if (network == null) {
            Assert.fail((String)"Failed to initialize network capabilities for tests");
        }
        Iterable loadBalancerList = support.listLoadBalancers();
        int lbCount1 = 0;
        int lbCount2 = 0;
        for (LoadBalancer lb : loadBalancerList) {
            ++lbCount1;
        }
        String id1 = network.provisionLoadBalancer("provision", tm.getUserName() + "-dsncrlbtest1", false, false, true);
        tm.out("New Load Balancer", id1);
        Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)id1);
        String id2 = network.provisionLoadBalancer("provision", tm.getUserName() + "-dsncrlbtest1", false, false, true);
        tm.out("New Load Balancer", id2);
        Assert.assertNotNull((String)"The newly created load balancer ID was null", (Object)id2);
        boolean lb1_found = false;
        boolean lb2_found = false;
        loadBalancerList = support.listLoadBalancers();
        for (LoadBalancer lb : loadBalancerList) {
            ++lbCount2;
            if (lb.getName().equals(id1)) {
                LoadBalancerHealthCheck lbhc = support.getLoadBalancerHealthCheck(lb.getProviderLBHealthCheckId(), lb.getName());
                StatefulLoadBalancerTests.assertHealthCheck(id1, support, lbhc);
                lb1_found = true;
                continue;
            }
            if (!lb.getName().equals(id2)) continue;
            lb2_found = true;
        }
        Assert.assertEquals((String)"Failed to find LoadBalancer 1", (Object)true, (Object)lb1_found);
        Assert.assertEquals((String)"Failed to find LoadBalancer 2", (Object)true, (Object)lb2_found);
        Assert.assertEquals((String)"Second count of load balancers should have been 2 more than first", (long)(lbCount1 + 2), (long)lbCount2);
    }
}

