/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.NetworkFirewallSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.network.NetworkResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulNetworkFirewallTests {
    private static final Random random = new Random();
    private static DaseinTestManager tm;
    private static int port;
    @Rule
    public final TestName name = new TestName();
    private String testFirewallId;
    private String testRuleId;
    private String testSubnetId;
    private String testVLANId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulNetworkFirewallTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("createFirewall")) {
            this.testVLANId = tm.getTestVLANId("stateful", true, null);
        } else if (this.name.getMethodName().equals("removeFirewall")) {
            this.testFirewallId = tm.getTestNetworkFirewallId("removed", true, null);
        } else if (this.name.getMethodName().startsWith("add")) {
            this.testFirewallId = tm.getTestNetworkFirewallId("stateful", true, null);
        } else if (this.name.getMethodName().startsWith("revoke")) {
            NetworkFirewallSupport support;
            NetworkServices services;
            this.testFirewallId = tm.getTestNetworkFirewallId("stateful", true, null);
            if (this.testFirewallId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getNetworkFirewallSupport()) != null) {
                Permission permission = null;
                Direction direction = null;
                int p = port++;
                if (this.name.getMethodName().endsWith("IngressAllow")) {
                    direction = Direction.INGRESS;
                    permission = Permission.ALLOW;
                } else if (this.name.getMethodName().endsWith("IngressDeny")) {
                    direction = Direction.INGRESS;
                    permission = Permission.DENY;
                } else if (this.name.getMethodName().endsWith("EgressAllow")) {
                    direction = Direction.EGRESS;
                    permission = Permission.ALLOW;
                } else if (this.name.getMethodName().endsWith("EgressDeny")) {
                    direction = Direction.EGRESS;
                    permission = Permission.DENY;
                }
                if (direction != null && permission != null) {
                    RuleTarget destination;
                    RuleTarget source;
                    if (direction.equals((Object)Direction.INGRESS)) {
                        source = RuleTarget.getCIDR((String)"209.98.98.98/32");
                        destination = RuleTarget.getGlobal((String)this.testFirewallId);
                    } else {
                        source = RuleTarget.getGlobal((String)this.testFirewallId);
                        destination = RuleTarget.getCIDR((String)"209.98.98.98/32");
                    }
                    try {
                        this.testRuleId = support.authorize(this.testFirewallId, direction, permission, source, Protocol.TCP, destination, p, p, random.nextInt(50) + 1);
                    }
                    catch (Throwable ignore) {}
                }
            }
        } else if (this.name.getMethodName().equals("associateWithSubnet")) {
            NetworkFirewallSupport support;
            NetworkServices services;
            this.testFirewallId = tm.getTestNetworkFirewallId("stateful", true, null);
            if (this.testFirewallId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getNetworkFirewallSupport()) != null) {
                try {
                    Firewall fw = support.getFirewall(this.testFirewallId);
                    if (fw != null) {
                        this.testVLANId = fw.getProviderVlanId();
                        if (this.testVLANId != null) {
                            this.testSubnetId = tm.getTestSubnetId("stateful", true, this.testVLANId, null);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testVLANId = null;
            this.testFirewallId = null;
            this.testRuleId = null;
        }
        finally {
            tm.end();
        }
    }

    private void checkAddRule(Direction direction, Permission permission) throws CloudException, InternalException {
        RuleTarget destinationEndpoint;
        RuleTarget sourceEndpoint;
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId == null) {
            if (!support.getCapabilities().supportsNetworkFirewallCreation()) {
                tm.warn("Could not create a test firewall to verify rule adding, so this test is definitely not valid");
            } else {
                Assert.fail((String)"No test firewall even though these type of rules are supported");
            }
            return;
        }
        int p = port++;
        if (direction.equals((Object)Direction.INGRESS)) {
            sourceEndpoint = RuleTarget.getCIDR((String)"209.98.98.98/32");
            destinationEndpoint = RuleTarget.getGlobal((String)this.testFirewallId);
        } else {
            destinationEndpoint = RuleTarget.getCIDR((String)"209.98.98.98/32");
            sourceEndpoint = RuleTarget.getGlobal((String)this.testFirewallId);
        }
        String ruleId = support.authorize(this.testFirewallId, direction, permission, sourceEndpoint, Protocol.TCP, destinationEndpoint, p, p, 10);
        boolean found = false;
        tm.out("New Rule", ruleId);
        for (FirewallRule rule : support.listRules(this.testFirewallId)) {
            if (!rule.getProviderRuleId().equals(ruleId)) continue;
            found = true;
            break;
        }
        tm.out("Listed", found);
        Assert.assertTrue((String)"Failed to identify new rule in the list of firewall rules", (boolean)found);
    }

    private void checkRemoveRule() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRuleId == null) {
            Assert.fail((String)"No test rule exists even though these type of rules are supported");
        }
        support.revoke(this.testRuleId);
        boolean found = false;
        for (FirewallRule rule : support.listRules(this.testFirewallId)) {
            if (!rule.getProviderRuleId().equals(this.testRuleId)) continue;
            found = true;
        }
        tm.out("Rule Present", found);
        Assert.assertFalse((String)"Found the test rule among the rules for the network firewall post-removal", (boolean)found);
    }

    @Test
    public void createFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources net = DaseinTestManager.getNetworkResources();
        if (net != null) {
            if (support.getCapabilities().supportsNetworkFirewallCreation()) {
                if (this.testVLANId != null) {
                    String id = net.provisionNetworkFirewall("provisionKeypair", this.testVLANId);
                    tm.out("New Network Firewall", id);
                    Assert.assertNotNull((String)"No network firewall was created by this test", (Object)id);
                } else {
                    Assert.fail((String)"Network firewall creation is supposedly supported, but there's not a test VLAN ID");
                }
            } else {
                String id = this.testVLANId == null ? UUID.randomUUID().toString() : this.testVLANId;
                try {
                    net.provisionNetworkFirewall(this.name.getMethodName(), id);
                    Assert.fail((String)"Network firewall provisioning completed even though network firewall creation is not supported");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                }
            }
        } else {
            Assert.fail((String)("Network resources failed to initialize for " + tm.getProvider().getCloudName()));
        }
    }

    @Test
    public void addIngressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.ALLOW);
    }

    @Test
    public void addIngressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.INGRESS, Permission.DENY);
    }

    @Test
    public void addEgressAllow() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.ALLOW);
    }

    @Test
    public void addEgressDeny() throws CloudException, InternalException {
        this.checkAddRule(Direction.EGRESS, Permission.DENY);
    }

    @Test
    public void revokeIngressAllow() throws CloudException, InternalException {
        this.checkRemoveRule();
    }

    @Test
    public void revokeIngressDeny() throws CloudException, InternalException {
        this.checkRemoveRule();
    }

    @Test
    public void revokeEgressAllow() throws CloudException, InternalException {
        this.checkRemoveRule();
    }

    @Test
    public void revokeEgressDeny() throws CloudException, InternalException {
        this.checkRemoveRule();
    }

    @Test
    public void removeFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId != null) {
            Firewall firewall = support.getFirewall(this.testFirewallId);
            tm.out("Before", firewall);
            Assert.assertNotNull((String)"Test firewall no longer exists, cannot test removing it", (Object)firewall);
            tm.out("Active", firewall.isActive());
            support.removeFirewall(new String[]{this.testFirewallId});
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            firewall = support.getFirewall(this.testFirewallId);
            tm.out("After", firewall);
            tm.out("Active", firewall == null ? "false" : Boolean.valueOf(firewall.isActive()));
            Assert.assertTrue((String)"The firewall remains available", (firewall == null || !firewall.isActive() ? 1 : 0) != 0);
        } else {
            if (!support.getCapabilities().supportsNetworkFirewallCreation()) {
                tm.ok("Firewall creation/deletion is not supported in " + tm.getProvider().getCloudName());
            }
            if (support.isSubscribed()) {
                Assert.fail((String)("No test firewall for " + this.name.getMethodName()));
            } else {
                tm.ok("Firewall support is not subscribed so this test is not entirely valid");
            }
        }
    }

    @Test
    public void associateWithSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId != null) {
            if (this.testSubnetId != null) {
                Firewall firewall = support.getFirewall(this.testFirewallId);
                Assert.assertNotNull((String)"The test firewall no longer exists", (Object)firewall);
                tm.out("Before", Arrays.toString(firewall.getSubnetAssociations()));
                support.associateWithSubnet(this.testFirewallId, this.testSubnetId);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                firewall = support.getFirewall(this.testFirewallId);
                Assert.assertNotNull((String)"The test firewall no longer exists", (Object)firewall);
                tm.out("After", Arrays.toString(firewall.getSubnetAssociations()));
                boolean found = false;
                for (String association : firewall.getSubnetAssociations()) {
                    if (!association.equals(this.testSubnetId)) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((String)"Unable to find test subnet among the network firewall's subnet associations", (boolean)found);
            } else if (services.getVlanSupport() != null && services.getVlanSupport().getCapabilities().allowsNewSubnetCreation()) {
                Assert.fail((String)("Unable to identify a test subnet for the test " + this.name.getMethodName()));
            } else {
                tm.ok("No subnets are supported in this cloud for association tests");
            }
        } else {
            if (!support.getCapabilities().supportsNetworkFirewallCreation()) {
                tm.ok("Firewall creation/deletion is not supported in " + tm.getProvider().getCloudName());
            }
            if (support.isSubscribed()) {
                Assert.fail((String)("No test firewall for " + this.name.getMethodName()));
            } else {
                tm.ok("Firewall support is not subscribed so this test is not entirely valid");
            }
        }
    }

    static {
        port = 81;
    }
}

