/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.compute.ComputeResources;
import org.dasein.cloud.test.network.NetworkResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulStaticIPTests {
    private static final Random random = new Random();
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testIpAddressId;
    private String testRuleId;
    private String testVlanId;
    private String testVMId;
    private boolean inVlan;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulStaticIPTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        VLANSupport support;
        NetworkServices services;
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testVlanId = tm.getTestVLANId("stateful", true, null);
        if (this.testVlanId != null && (services = tm.getProvider().getNetworkServices()) != null) {
            support = services.getVlanSupport();
            try {
                if (support != null && support.getCapabilities().supportsInternetGatewayCreation() && !support.isConnectedViaInternetGateway(this.testVlanId)) {
                    support.createInternetGateway(this.testVlanId);
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (this.name.getMethodName().equals("releaseFromPool")) {
            this.testIpAddressId = tm.getTestStaticIpId("removed", true, null, false, null);
            if (this.testIpAddressId == null) {
                this.testIpAddressId = tm.getTestStaticIpId("removed", true, null, true, this.testVlanId);
            }
        } else if (this.name.getMethodName().startsWith("forward")) {
            this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, false, null);
            if (this.testIpAddressId == null) {
                this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, true, this.testVlanId);
            }
            this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, null);
        } else if (this.name.getMethodName().startsWith("stopForward")) {
            this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, false, null);
            if (this.testIpAddressId == null) {
                this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, true, this.testVlanId);
            }
            this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, null);
            if (this.testIpAddressId != null && this.testVMId != null && (services = tm.getProvider().getNetworkServices()) != null) {
                support = services.getIpAddressSupport();
                try {
                    IPVersion version;
                    IPVersion iPVersion = version = this.name.getMethodName().contains("IPv6") ? IPVersion.IPV6 : IPVersion.IPV4;
                    if (support != null && support.getCapabilities().isForwarding(version)) {
                        this.testRuleId = support.forward(this.testIpAddressId, 8000, Protocol.TCP, 9000, this.testVMId);
                    }
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("releaseFromVirtualMachine")) {
            this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, false, null);
            if (this.testIpAddressId == null) {
                this.testIpAddressId = tm.getTestStaticIpId("stateful", true, null, true, this.testVlanId);
            }
            this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, null);
            if (this.testVMId != null && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getIpAddressSupport()) != null) {
                try {
                    support.assign(this.testIpAddressId, this.testVMId);
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().startsWith("assignPost") || this.name.getMethodName().startsWith("forward") || this.name.getMethodName().equals("releaseFromServer")) {
            IPVersion version = IPVersion.IPV4;
            if (this.name.getMethodName().contains("IPv6")) {
                version = IPVersion.IPV6;
            }
            if (!this.name.getMethodName().endsWith("InVLAN")) {
                this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, null);
                if (this.testVMId != null) {
                    VirtualMachine vm = null;
                    try {
                        vm = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (vm != null && vm.getProviderVlanId() != null) {
                        this.inVlan = true;
                        this.testVMId = null;
                    } else if (vm != null) {
                        this.testIpAddressId = tm.getTestStaticIpId("stateful", true, version, false, null);
                    }
                }
            } else if (this.testVlanId != null) {
                String productId = tm.getTestVMProductId();
                String imageId = tm.getTestImageId("stateless", false);
                if (productId != null && imageId != null) {
                    VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnnetl" + System.currentTimeMillis() % 10000L), (String)("Dasein Network Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a network");
                    String vlanId = tm.getTestSubnetId("stateful", true, this.testVlanId, null);
                    String dataCenterId = null;
                    if (vlanId == null) {
                        vlanId = this.testVlanId;
                        try {
                            VLAN vlan = tm.getProvider().getNetworkServices().getVlanSupport().getVlan(this.testVlanId);
                            if (vlan != null) {
                                dataCenterId = vlan.getProviderDataCenterId();
                            }
                        }
                        catch (Throwable ignore) {}
                    } else {
                        try {
                            Subnet subnet = tm.getProvider().getNetworkServices().getVlanSupport().getSubnet(vlanId);
                            if (subnet != null) {
                                dataCenterId = subnet.getProviderDataCenterId();
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    if (dataCenterId == null) {
                        try {
                            for (DataCenter dc : tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId())) {
                                if (!dc.isActive() || !dc.isAvailable()) continue;
                                dataCenterId = dc.getProviderDataCenterId();
                                break;
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    assert (dataCenterId != null);
                    options.inDataCenter(dataCenterId);
                    options.inVlan(null, dataCenterId, vlanId);
                    ComputeResources compute = DaseinTestManager.getComputeResources();
                    if (compute != null) {
                        try {
                            this.testVMId = compute.provisionVM(tm.getProvider().getComputeServices().getVirtualMachineSupport(), "statefulvlan", options, dataCenterId);
                        }
                        catch (Throwable t) {
                            tm.warn("Unable to provision test VM with VLAN/subnet=" + vlanId + " in " + dataCenterId);
                        }
                    }
                }
                if (this.testVMId != null) {
                    try {
                        VirtualMachine vm = tm.getProvider().getComputeServices().getVirtualMachineSupport().getVirtualMachine(this.testVMId);
                        this.testVlanId = vm.getProviderVlanId();
                        this.testIpAddressId = tm.getTestStaticIpId("stateful" + this.testVlanId, true, version, true, this.testVlanId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            IpAddressSupport support;
            this.testVlanId = null;
            this.testVMId = null;
            NetworkServices services = tm.getProvider().getNetworkServices();
            if (services != null && (support = services.getIpAddressSupport()) != null) {
                if (this.testRuleId != null) {
                    try {
                        support.stopForward(this.testRuleId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                if (this.testIpAddressId != null) {
                    try {
                        support.releaseFromServer(this.testIpAddressId);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.testIpAddressId = null;
            this.testRuleId = null;
        }
        finally {
            tm.end();
        }
    }

    private void request(@Nonnull IPVersion version, boolean forVLAN) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkResources network = DaseinTestManager.getNetworkResources();
        Assert.assertNotNull((String)"Testing failed to initialize properly as there are no network resources", (Object)network);
        if (!support.isSubscribed()) {
            try {
                network.provisionAddress(support, "provision", version, null);
                Assert.fail((String)"The account is supposedly not subscribed to IP address support, but a request operation completed");
            }
            catch (CloudException expected) {
                tm.ok("Caught a cloud exception attempting to request an address of type " + version + " in an account where there is no subscription");
            }
        } else if (support.getCapabilities().isRequestable(version) && (!forVLAN || support.getCapabilities().supportsVLANAddresses(version))) {
            String addressId = !forVLAN ? network.provisionAddress(support, "provision", version, null) : network.provisionAddress(support, "provision", version, this.testVlanId);
            tm.out("New " + version + " Address", addressId);
            Assert.assertNotNull((String)"Requesting a new IP address may not result in a null address ID", (Object)addressId);
        } else {
            try {
                if (!forVLAN) {
                    network.provisionAddress(support, "provision", version, null);
                } else {
                    network.provisionAddress(support, "provision", version, UUID.randomUUID().toString());
                }
                Assert.fail((String)("Requesting addresses of " + version + " is supposedly not supported, but the operation completed"));
            }
            catch (OperationNotSupportedException expected) {
                tm.ok("Caught OperationNotSupportedException when attempting to request an IP address of version " + version);
            }
        }
    }

    @Test
    public void requestIPv4() throws CloudException, InternalException {
        this.request(IPVersion.IPV4, false);
    }

    @Test
    public void requestIPv6() throws CloudException, InternalException {
        this.request(IPVersion.IPV6, false);
    }

    @Test
    public void requestIPv4InVLAN() throws CloudException, InternalException {
        this.request(IPVersion.IPV4, true);
    }

    @Test
    public void requestIPv6inVLAN() throws CloudException, InternalException {
        this.request(IPVersion.IPV6, true);
    }

    private void assignPostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testIpAddressId == null) {
            if (!support.isSubscribed()) {
                tm.ok("No IP address subscription exists for this account in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName() + ", so this test is invalid");
            } else if (!support.getCapabilities().isAssignablePostLaunch(version)) {
                tm.ok("Unable to assign new IP addresses in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            } else if (!support.getCapabilities().isRequestable(version)) {
                tm.warn("Unable to provision new IP addresses in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName() + ", so this test is invalid");
            } else if (this.name.getMethodName().contains("VLAN") && !support.getCapabilities().supportsVLANAddresses(version)) {
                tm.ok("No VLAN IP addresses are supported");
            } else {
                Assert.fail((String)String.format("Unable to get a test %s address for running the test %s", version == IPVersion.IPV4 ? "IPv4" : "IPv6", this.name.getMethodName()));
            }
            return;
        }
        if (this.testVMId == null) {
            Assert.fail((String)("Unable to get a test VM for running the test " + this.name.getMethodName()));
        }
        if (support.getCapabilities().isAssignablePostLaunch(version)) {
            VirtualMachineSupport vmSupport = tm.getProvider().getComputeServices().getVirtualMachineSupport();
            IpAddress address = support.getIpAddress(this.testIpAddressId);
            Assert.assertNotNull((String)"The test IP address has gone away", (Object)address);
            Assert.assertNotNull((String)("No virtual machine support exists in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName()), (Object)vmSupport);
            VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
            Assert.assertNotNull((String)"The test virtual machine disappeared before the test could run", (Object)vm);
            tm.out("VM Before", address.getServerId());
            tm.out("Address Before", vm.getProviderAssignedIpAddressId());
            Assert.assertTrue((String)"The current assignment to the test virtual machine is the test IP address, cannot reasonably tests this", (!this.testIpAddressId.equals(vm.getProviderAssignedIpAddressId()) ? 1 : 0) != 0);
            support.assign(this.testIpAddressId, this.testVMId);
            long timeout = System.currentTimeMillis() + 600000L;
            while (System.currentTimeMillis() < timeout) {
                try {
                    vm = vmSupport.getVirtualMachine(this.testVMId);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                Assert.assertNotNull((String)"Virtual machine disappeared post-assignment", (Object)vm);
                try {
                    address = support.getIpAddress(this.testIpAddressId);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                Assert.assertNotNull((String)"IP address disappeared post-assignment", (Object)address);
                if (address.getServerId() != null && vm.getProviderAssignedIpAddressId() != null) break;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("VM After", address.getServerId());
            tm.out("Address After", vm.getProviderAssignedIpAddressId());
            Assert.assertEquals((String)"The IP address assigned to the virtual machine does not match the test IP address", (Object)this.testIpAddressId, (Object)vm.getProviderAssignedIpAddressId());
            Assert.assertEquals((String)"The virtual machine associated with the IP address does not match the test VM", (Object)this.testVMId, (Object)address.getServerId());
        } else {
            try {
                support.assign(this.testIpAddressId, this.testVMId);
                Assert.fail((String)"Assigning an IP address post-launch succeeded even though meta-data suggests it should not have");
            }
            catch (OperationNotSupportedException expected) {
                tm.ok("Caught OperationNotSupportedException when attempting to assign an IP to a VM post-launch when such assignments are not allowed");
            }
        }
    }

    @Test
    public void assignPostLaunchIPv4() throws CloudException, InternalException {
        if (this.inVlan) {
            tm.ok("VM is still launched in VLAN, skipping the test " + this.name.getMethodName());
            tm.skip();
        } else {
            this.assignPostLaunch(IPVersion.IPV4);
        }
    }

    @Test
    public void assignPostLaunchIPv6() throws CloudException, InternalException {
        if (this.inVlan) {
            tm.ok("VM is still launched in VLAN, skipping the test " + this.name.getMethodName());
            tm.skip();
        } else {
            this.assignPostLaunch(IPVersion.IPV6);
        }
    }

    @Test
    public void assignPostLaunchIPv4InVLAN() throws CloudException, InternalException {
        if (!this.inVlan) {
            tm.ok("VM is launched outside VLAN, skipping the test " + this.name.getMethodName());
            tm.skip();
        } else {
            this.assignPostLaunch(IPVersion.IPV4);
        }
    }

    @Test
    public void assignPostLaunchIPv6inVLAN() throws CloudException, InternalException {
        if (!this.inVlan) {
            tm.ok("VM is launched outside VLAN, skipping the test " + this.name.getMethodName());
            tm.skip();
        } else {
            this.assignPostLaunch(IPVersion.IPV6);
        }
    }

    @Test
    public void releaseFromPool() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testIpAddressId == null) {
            if (!support.getCapabilities().isRequestable(IPVersion.IPV4) && !support.getCapabilities().isRequestable(IPVersion.IPV6)) {
                tm.ok("Requesting/releasing addresses is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            } else {
                Assert.fail((String)"There is no test IP address to use in verifying the ability to release addresses from the pool");
            }
        } else {
            IpAddress address = support.getIpAddress(this.testIpAddressId);
            Assert.assertNotNull((String)("Test IP addresss " + this.testIpAddressId + " does not exist"), (Object)address);
            support.releaseFromPool(this.testIpAddressId);
            address = support.getIpAddress(this.testIpAddressId);
            tm.out("Result", address);
            Assert.assertNull((String)("The test IP address " + this.testIpAddressId + " still exists in the IP address pool"), (Object)address);
        }
    }

    @Test
    public void releaseFromVirtualMachine() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testIpAddressId == null) {
            if (!support.getCapabilities().isRequestable(IPVersion.IPV4) && !support.getCapabilities().isRequestable(IPVersion.IPV6)) {
                tm.ok("Requesting/releasing addresses is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            } else {
                Assert.fail((String)"There is no test IP address to use in verifying the ability to release addresses from a virtual machine");
            }
        } else {
            IpAddress address = support.getIpAddress(this.testIpAddressId);
            Assert.assertNotNull((String)("Test IP addresss " + address + " does not exist"), (Object)address);
            if (address.getServerId() != null) {
                VirtualMachineSupport vmSupport = tm.getProvider().getComputeServices().getVirtualMachineSupport();
                Assert.assertNotNull((String)"No virtual machine support", (Object)vmSupport);
                VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                Assert.assertNotNull((String)"Test virtual machine does not exist", (Object)vm);
                tm.out("VM Before", vm.getProviderAssignedIpAddressId());
                tm.out("Address Before", address.getServerId());
                support.releaseFromServer(this.testIpAddressId);
                long timeout = System.currentTimeMillis() + 600000L;
                while (System.currentTimeMillis() < timeout) {
                    try {
                        vm = vmSupport.getVirtualMachine(this.testVMId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    Assert.assertNotNull((String)"Virtual machine disappeared post-assignment", (Object)vm);
                    try {
                        address = support.getIpAddress(this.testIpAddressId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    Assert.assertNotNull((String)"IP address disappeared post-assignment", (Object)address);
                    if (address.getServerId() == null && vm.getProviderAssignedIpAddressId() == null) break;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                tm.out("VM After", vm.getProviderAssignedIpAddressId());
                tm.out("Address After", address.getServerId());
                Assert.assertNull((String)"The IP address assigned to the virtual machine is still set", (Object)vm.getProviderAssignedIpAddressId());
                Assert.assertNull((String)"The virtual machine associated with the IP address is still set", (Object)address.getServerId());
            } else if (!support.getCapabilities().isAssignablePostLaunch(address.getVersion())) {
                tm.ok("Dynamic IP address assignment is not supported");
            } else {
                Assert.fail((String)"IP address is not assigned to a virtual machine and thus this test cannot run");
            }
        }
    }

    private void forward(@Nonnull IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (support.getCapabilities().isForwarding(version)) {
            if (this.testIpAddressId != null) {
                Assert.assertNotNull((String)"Test VM is null", (Object)this.testVMId);
                int ext = 8000 + random.nextInt(1000);
                int prv = 9000 + random.nextInt(1000);
                this.testRuleId = support.forward(this.testIpAddressId, ext, Protocol.TCP, prv, this.testVMId);
                tm.out("New Rule", this.testRuleId);
                Assert.assertNotNull((String)"Forwarding must provide a rule ID", (Object)this.testRuleId);
                boolean found = false;
                for (IpForwardingRule rule : support.listRules(this.testIpAddressId)) {
                    if (!this.testRuleId.equals(rule.getProviderRuleId())) continue;
                    Assert.assertTrue((String)"Matching rule does not match address", (boolean)this.testIpAddressId.equals(rule.getAddressId()));
                    Assert.assertTrue((String)"Matching rule does not match virtual machine", (boolean)this.testVMId.equals(rule.getServerId()));
                    Assert.assertTrue((String)"Public ports do not match", (rule.getPublicPort() == ext ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Private ports do not match", (rule.getPrivatePort() == prv ? 1 : 0) != 0);
                    Assert.assertTrue((String)"Protocols do not match", (boolean)Protocol.TCP.equals((Object)rule.getProtocol()));
                    found = true;
                }
                Assert.assertTrue((String)"Did not find the newly created rule", (boolean)found);
            } else if (!support.getCapabilities().isRequestable(version)) {
                tm.warn("Could not run this test because IP addresses cannot be request and the test does not use existing IPs");
            } else {
                Assert.fail((String)"No test IP address was established for this test");
            }
        } else {
            tm.ok("IP address forwarding is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void forwardIPv4() throws CloudException, InternalException {
        this.forward(IPVersion.IPV4);
    }

    @Test
    public void forwardIPv6() throws CloudException, InternalException {
        this.forward(IPVersion.IPV6);
    }

    private void stopForward(IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (support.getCapabilities().isForwarding(version)) {
            if (this.testRuleId != null) {
                support.stopForward(this.testRuleId);
                long timeout = System.currentTimeMillis() + 600000L;
                boolean exists = true;
                while (timeout > System.currentTimeMillis()) {
                    boolean found = false;
                    for (IpForwardingRule rule : support.listRules(this.testIpAddressId)) {
                        if (!this.testRuleId.equals(rule.getProviderRuleId())) continue;
                        found = true;
                    }
                    exists = found;
                    if (!exists) break;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                tm.out("Rule Exists", exists);
                Assert.assertNotNull((String)"The target rule still exists among the forwarding rules", (Object)exists);
            } else if (!support.getCapabilities().isRequestable(version)) {
                tm.warn("Could not run this test because IP addresses cannot be request and the test does not use existing IPs");
            } else {
                Assert.fail((String)"No test IP address was established for this test");
            }
        } else {
            tm.ok("IP address forwarding is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void stopForwardIPv4() throws CloudException, InternalException {
        this.stopForward(IPVersion.IPV4);
    }

    @Test
    public void stopForwardIPv6() throws CloudException, InternalException {
        this.stopForward(IPVersion.IPV6);
    }
}

