/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Collection;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Route;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.compute.ComputeResources;
import org.dasein.cloud.test.network.NetworkResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulVLANTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testVLANId;
    private String testSubnetId;
    private String testInternetGatewayId;
    private String testRoutingTableId;
    private String testVLANVMId;
    private String testDataCenterId;
    private String[] cidrs = new String[]{"192.168.20.0/28", "192.168.40.0/28", "192.168.60.0/28", "192.168.80.0/28", "192.168.100.0/28"};

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulVLANTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        block64: {
            tm.begin(this.name.getMethodName());
            try {
                this.testDataCenterId = System.getProperty("test.dataCenter");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
            NetworkServices services = null;
            VLANSupport support = null;
            try {
                services = tm.getProvider().getNetworkServices();
                if (services != null) {
                    support = services.getVlanSupport();
                }
            }
            catch (Exception ignore) {
                tm.out("Before: Unable to initialize NetworkServices or VLANSupport");
                Assert.fail((String)"Require network services and vlan support to provision resources");
            }
            if (this.name.getMethodName().equals("provisionSubnet") || this.name.getMethodName().equals("provisionRoutingTable") || this.name.getMethodName().equals("launchVM") || this.name.getMethodName().equals("connectInternetGateway") || this.name.getMethodName().equals("removeInternetGateway") || this.name.getMethodName().equals("addRouteToVM") || this.name.getMethodName().equals("addRouteToNetworkInterface") || this.name.getMethodName().equals("addRouteToGateway") || this.name.getMethodName().equals("listInternetGateway")) {
                this.testVLANId = this.getVLANId(support, this.name.getMethodName(), null, null);
                try {
                    Integer count = 0;
                    while (count < 5) {
                        VLAN v = support.getVlan(this.testVLANId);
                        if (v != null && v.getCurrentState().equals((Object)VLANState.AVAILABLE)) {
                            count = 5;
                        } else {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        Integer ignore = count;
                        Integer n = count = Integer.valueOf(count + 1);
                    }
                }
                catch (Exception e) {
                    tm.out("Exception while getting vlan for " + this.name.getMethodName());
                }
            }
            if (this.name.getMethodName().equals("removeVLAN") || this.name.getMethodName().equals("removeSubnet") || this.name.getMethodName().equals("removeRoutingTable")) {
                this.testVLANId = this.getVLANId(support, this.name.getMethodName(), "removed", true);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.name.getMethodName().equals("removeRoutingTable") || this.name.getMethodName().equals("addRouteToVM") || this.name.getMethodName().equals("addRouteToNetworkInterface") || this.name.getMethodName().equals("addRouteToGateway")) {
                this.testRoutingTableId = tm.getTestRoutingTableId("stateful", false, this.testVLANId, null);
                if (this.testRoutingTableId == null) {
                    this.testRoutingTableId = tm.getTestRoutingTableId("stateful", true, this.testVLANId, null);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            if (this.name.getMethodName().equals("removeSubnet")) {
                this.testSubnetId = tm.getTestSubnetId("removed", true, this.testVLANId, null);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (this.testSubnetId == null) {
                    this.testSubnetId = tm.getTestSubnetId("stateless", false, this.testVLANId, null);
                }
                if (this.testSubnetId == null) {
                    this.testSubnetId = tm.getTestSubnetId("stateful", false, this.testVLANId, null);
                }
                if (this.testSubnetId == null) {
                    this.testSubnetId = tm.getTestSubnetId("stateful", true, this.testVLANId, null);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                if (this.testVLANId != null) {
                    try {
                        if (support != null && support.isConnectedViaInternetGateway(this.testVLANId)) {
                            support.removeInternetGateway(this.testVLANId);
                        }
                    }
                    catch (Throwable t) {
                        tm.out("Before: Unable to initialize test variables for " + this.name.getMethodName() + " because " + t.getMessage());
                    }
                }
            }
            if (this.name.getMethodName().equals("launchVM") && this.testVLANId != null) {
                this.testSubnetId = tm.getTestSubnetId("stateful", false, this.testVLANId, null);
                if (this.testSubnetId == null) {
                    this.testSubnetId = tm.getTestSubnetId("stateful", true, this.testVLANId, this.testDataCenterId);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            if (this.name.getMethodName().equals("connectInternetGateway") && this.testVLANId != null) {
                try {
                    if (support != null && support.isConnectedViaInternetGateway(this.testVLANId)) {
                        support.removeInternetGateway(this.testVLANId);
                    }
                }
                catch (Throwable t) {
                    tm.out("Before: Issue during initialization for " + this.name.getMethodName() + " because " + t.getMessage());
                }
            }
            if (this.name.getMethodName().equals("listInternetGateway")) {
                this.testInternetGatewayId = tm.getTestInternetGatewayId("stateful", true, this.testVLANId, null);
                if (this.testInternetGatewayId == null) {
                    this.testInternetGatewayId = tm.getTestInternetGatewayId("stateful", false, this.testVLANId, null);
                }
                if (this.testInternetGatewayId == null) {
                    this.testInternetGatewayId = tm.getTestInternetGatewayId("stateless", false, this.testVLANId, null);
                }
                if (this.testInternetGatewayId == null) {
                    this.testInternetGatewayId = tm.getTestInternetGatewayId("stateless", true, this.testVLANId, null);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.name.getMethodName().equals("removeInternetGateway") || this.name.getMethodName().equals("addRouteToGateway")) {
                this.testInternetGatewayId = tm.getTestInternetGatewayId("stateful", false, this.testVLANId, null);
                if (this.testInternetGatewayId == null) {
                    this.testInternetGatewayId = tm.getTestInternetGatewayId("stateful", true, this.testVLANId, null);
                }
            }
            if (this.name.getMethodName().equals("addRouteToVM") || this.name.getMethodName().equals("addRouteToNetworkInterface")) {
                try {
                    Route[] routes;
                    RoutingTable rtb;
                    if (support == null || this.testRoutingTableId == null || (rtb = support.getRoutingTable(this.testRoutingTableId)) == null) break block64;
                    this.testVLANVMId = tm.getTestVLANVMId("stateful", VmState.RUNNING, rtb.getProviderVlanId(), true, null);
                    if (this.testVLANVMId == null) {
                        this.testVLANVMId = tm.getTestVLANVMId("stateless", VmState.RUNNING, rtb.getProviderVlanId(), true, null);
                    }
                    if (this.testVLANVMId != null) {
                        try {
                            Integer count = 0;
                            ComputeServices cs = tm.getProvider().getComputeServices();
                            VirtualMachineSupport vs = cs.getVirtualMachineSupport();
                            while (count < 20) {
                                VirtualMachine vm = vs.getVirtualMachine(this.testVLANVMId);
                                if (vm.getCurrentState().equals((Object)VmState.RUNNING)) {
                                    count = 20;
                                } else {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException ignore) {
                                        // empty catch block
                                    }
                                }
                                Integer ignore = count;
                                Integer n = count = Integer.valueOf(count + 1);
                            }
                        }
                        catch (Exception e) {
                            tm.out("Exception while getting virtual machine for " + this.name.getMethodName());
                        }
                    } else {
                        tm.out("Unable to produce virtual machine for " + this.name.getMethodName());
                    }
                    for (Route rt : routes = rtb.getRoutes()) {
                        try {
                            VLAN v = support.getVlan(rtb.getProviderVlanId());
                            if (rt.getDestinationCidr().equalsIgnoreCase(v.getCidr())) continue;
                            support.removeRoute(this.testRoutingTableId, rt.getDestinationCidr());
                        }
                        catch (Exception e) {
                            tm.out("Before: Unable to initialize test variables for " + this.name.getMethodName() + " because " + e.getMessage());
                        }
                    }
                }
                catch (Throwable t) {
                    tm.out("Before: Unable to initialize test variables for " + this.name.getMethodName() + " because " + t.getMessage());
                }
            }
        }
    }

    @After
    public void after() {
        this.testVLANId = null;
        this.testSubnetId = null;
        tm.end();
    }

    private String getVLANId(VLANSupport support, String name, String label, Boolean provision) {
        String vId;
        if (label == null) {
            label = "stateful";
        }
        if (provision == null) {
            provision = false;
        }
        if ((vId = tm.getTestVLANId(label, provision, null)) == null) {
            vId = tm.getTestVLANId("stateful", true, null);
        }
        if (vId == null && (vId = tm.getTestVLANId("stateless", false, null)) == null) {
            vId = tm.getTestVLANId("stateless", true, null);
        }
        if (vId != null) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                VLAN v = support.getVlan(vId);
                if (v != null) {
                    return vId;
                }
                return null;
            }
            catch (Exception e) {
                tm.out("Before: Unable to get test VLAN for " + name);
                return null;
            }
        }
        tm.out("Before: Unable to get test VLAN for " + name);
        return null;
    }

    @Test
    public void provisionSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                boolean supported;
                boolean bl = supported = support.getCapabilities().allowsNewSubnetCreation() && support.isSubscribed();
                if (this.testVLANId != null) {
                    NetworkResources resources = DaseinTestManager.getNetworkResources();
                    if (resources != null) {
                        if (supported) {
                            VLAN vlan = support.getVlan(this.testVLANId);
                            Assert.assertNotNull((String)"The test VLAN does not exist", (Object)vlan);
                            String id = resources.provisionSubnet(support, "provisionKeypair", this.testVLANId, "dsnsub", vlan.getProviderDataCenterId());
                            tm.out("New Subnet", id);
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            Assert.assertNotNull((String)"Could not find the subnet in the cloud after provisioning", (Object)support.getSubnet(id));
                        } else {
                            try {
                                resources.provisionSubnet(support, "provisionKeypair", this.testVLANId, "dsnsubfail", null);
                                Assert.fail((String)"Subnet provisioning completed even though it isn't supported");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("Caught OperationNotSupportedException for " + this.name.getMethodName() + " as expected");
                            }
                        }
                    } else {
                        Assert.fail((String)"The network resources failed to initialize for testing");
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("No test VLAN was identified due to a lack of support for creating VLANs");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateful test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void provisionVLAN() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                boolean supported = support.getCapabilities().allowsNewVlanCreation() && support.isSubscribed();
                NetworkResources resources = DaseinTestManager.getNetworkResources();
                if (resources != null) {
                    if (supported) {
                        String id = resources.provisionVLAN(support, "provisionKeypair", "dnsvlan", null);
                        tm.out("New VLAN", id);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        Assert.assertNotNull((String)"Could not find the new VLAN in the cloud after creation", (Object)support.getVlan(id));
                    } else if (support.isSubscribed()) {
                        try {
                            resources.provisionVLAN(support, "provision", "dnsvlan", null);
                            Assert.fail((String)"VLAN provisioning completed even though it isn't supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException for " + this.name.getMethodName() + " as expected");
                        }
                    }
                } else {
                    Assert.fail((String)"The network resources failed to initialize for testing");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void provisionRoutingTable() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                boolean supported;
                boolean bl = supported = support.getCapabilities().allowsNewRoutingTableCreation() && support.isSubscribed();
                if (this.testVLANId != null) {
                    NetworkResources resources = DaseinTestManager.getNetworkResources();
                    if (resources != null) {
                        if (supported) {
                            VLAN vlan = support.getVlan(this.testVLANId);
                            Assert.assertNotNull((String)"The test VLAN does not exist", (Object)vlan);
                            String id = resources.provisionRoutingTable(support, vlan.getProviderVlanId(), "provisionKeypair", "dnsrtb");
                            tm.out("New Routing Table", id);
                            this.testRoutingTableId = id;
                            try {
                                Thread.sleep(3500L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            Assert.assertNotNull((String)"Could not find the new Routing Table in the cloud after creation", (Object)support.getRoutingTable(id));
                        } else if (support.isSubscribed()) {
                            try {
                                String id = resources.provisionRoutingTable(support, this.testVLANId, "provisionKeypair", "dnsrtb");
                                Assert.fail((String)"Route Table provisioning completed even though it isn't supported");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("Caught OperationNotSupportedException for " + this.name.getMethodName() + " as expected");
                            }
                        }
                    } else {
                        Assert.fail((String)"The network resources failed to initialize for testing");
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("No test VLAN was identified due to a lack of support for creating VLANs");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateful test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void removeVLAN() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    VLAN vlan = support.getVlan(this.testVLANId);
                    tm.out("Before", vlan);
                    Assert.assertNotNull((String)"Test VLAN no longer exists, cannot test removing it", (Object)vlan);
                    tm.out("State", vlan.getCurrentState());
                    support.removeVlan(this.testVLANId);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    vlan = support.getVlan(this.testVLANId);
                    tm.out("After", vlan);
                    tm.out("State", (Object)(vlan == null ? "DELETED" : vlan.getCurrentState()));
                    Assert.assertNull((String)"The VLAN remains available", (Object)vlan);
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("VLAN creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test VLAN for deletion test");
                } else {
                    tm.ok("VLAN service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void removeRoutingTable() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testRoutingTableId != null) {
                    RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Before", rtb);
                    Assert.assertNotNull((String)"Test route table no longer exists, cannot test removing it", (Object)rtb);
                    support.removeRoutingTable(this.testRoutingTableId);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("After", rtb);
                    Assert.assertNull((String)"The route table remains available", (Object)rtb);
                } else if (!support.getCapabilities().allowsNewRoutingTableCreation()) {
                    tm.ok("Route Table creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test route table for delete test");
                } else {
                    tm.ok("VLAN service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void removeSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null) {
                    Subnet subnet = support.getSubnet(this.testSubnetId);
                    tm.out("Before", subnet);
                    Assert.assertNotNull((String)"Test subnet no longer exists, cannot test removing it", (Object)subnet);
                    tm.out("State", subnet.getCurrentState());
                    support.removeSubnet(this.testSubnetId);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    subnet = support.getSubnet(this.testSubnetId);
                    tm.out("After", subnet);
                    tm.out("State", (Object)(subnet == null ? "DELETED" : subnet.getCurrentState()));
                    Assert.assertNull((String)"The subnet remains available", (Object)subnet);
                } else if (!support.getCapabilities().allowsNewSubnetCreation()) {
                    tm.ok("Subnet creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test subnet for deletion test");
                } else {
                    tm.ok("VLAN service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void launchVM() throws CloudException, InternalException {
        String dataCenterId;
        NetworkServices networkServices = tm.getProvider().getNetworkServices();
        if (networkServices == null) {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
            return;
        }
        VLANSupport vlanSupport = networkServices.getVlanSupport();
        if (vlanSupport == null) {
            tm.ok("No VLAN support in " + tm.getProvider().getCloudName());
            return;
        }
        ComputeServices computeServices = tm.getProvider().getComputeServices();
        if (computeServices == null) {
            tm.ok("No compute services in " + tm.getProvider().getCloudName());
            return;
        }
        VirtualMachineSupport vmSupport = computeServices.getVirtualMachineSupport();
        if (vmSupport == null) {
            tm.ok("No virtual machine support in " + tm.getProvider().getCloudName());
            return;
        }
        DataCenterServices dcServices = tm.getProvider().getDataCenterServices();
        ComputeResources compute = DaseinTestManager.getComputeResources();
        Assert.assertNotNull((String)"No compute resources for the tests, something is very wrong", (Object)compute);
        String productId = tm.getTestVMProductId();
        Assert.assertNotNull((String)"Unable to identify a VM product for test launch", (Object)productId);
        String imageId = tm.getTestImageId("stateless", false);
        Assert.assertNotNull((String)"Unable to identify a test image for test launch", (Object)imageId);
        VMLaunchOptions options = VMLaunchOptions.getInstance((String)productId, (String)imageId, (String)("dsnnetl" + System.currentTimeMillis() % 10000L), (String)("Dasein Network Launch " + System.currentTimeMillis()), (String)"Test launch for a VM in a network");
        if (this.testSubnetId != null) {
            tm.out("Subnet Id", this.testSubnetId);
            Subnet subnet = tm.getProvider().getNetworkServices().getVlanSupport().getSubnet(this.testSubnetId);
            Assert.assertNotNull((String)"Subnet went away before test could be executed", (Object)subnet);
            dataCenterId = subnet.getProviderDataCenterId();
            if (this.testDataCenterId != null) {
                dataCenterId = this.testDataCenterId;
            } else if (dataCenterId == null) {
                for (DataCenter dc : tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId())) {
                    dataCenterId = dc.getProviderDataCenterId();
                }
            }
            Assert.assertNotNull((String)"Could not identify a data center for VM launch", (Object)dataCenterId);
            options.inDataCenter(dataCenterId);
            options.inSubnet(null, dataCenterId, this.testVLANId, this.testSubnetId);
        } else if (this.testVLANId != null) {
            VLAN vlan = tm.getProvider().getNetworkServices().getVlanSupport().getVlan(this.testVLANId);
            Assert.assertNotNull((String)"VLAN went away before test could be executed", (Object)vlan);
            dataCenterId = vlan.getProviderDataCenterId();
            if (this.testDataCenterId != null) {
                dataCenterId = this.testDataCenterId;
            } else if (dataCenterId == null) {
                for (DataCenter dc : tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId())) {
                    dataCenterId = dc.getProviderDataCenterId();
                }
            }
            Assert.assertNotNull((String)"Could not identify a data center for VM launch", (Object)dataCenterId);
            options.inDataCenter(dataCenterId);
            options.inVlan(null, dataCenterId, this.testVLANId);
        } else {
            if (!tm.getProvider().getNetworkServices().getVlanSupport().getCapabilities().allowsNewVlanCreation()) {
                tm.ok("No test VLAN was identified due to a lack of support for creating VLANs");
            } else if (!vmSupport.getCapabilities().identifyVlanRequirement().equals((Object)Requirement.NONE)) {
                Assert.fail((String)"No test VLAN or subnet in which to launch a VM");
            } else {
                tm.ok("Launching into VLANs is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            }
            return;
        }
        String vmId = compute.provisionVM(vmSupport, "vlanLaunch", options, options.getDataCenterId());
        tm.out("Virtual Machine", vmId);
        Assert.assertNotNull((String)"No error received launching VM in VLAN/subnet, but there was no virtual machine", (Object)vmId);
        VirtualMachine vm = vmSupport.getVirtualMachine(vmId);
        long timeout = System.currentTimeMillis() + 300000L;
        while (timeout > System.currentTimeMillis() && vm != null && vm.getProviderVlanId() == null) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                vm = vmSupport.getVirtualMachine(vmId);
            }
            catch (Throwable ignore) {}
        }
        Assert.assertNotNull((String)"Launched VM does not exist", (Object)vm);
        tm.out("In VLAN", vm.getProviderVlanId());
        tm.out("In Subnet", vm.getProviderSubnetId());
        Assert.assertEquals((String)"The subnet for the launched VM does not match the target subnet", (Object)this.testSubnetId, (Object)vm.getProviderSubnetId());
        Assert.assertEquals((String)"The VLAN for the launched VM does not match the target VLAN", (Object)this.testVLANId, (Object)vm.getProviderVlanId());
    }

    @Test
    public void connectInternetGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    boolean connected = support.isConnectedViaInternetGateway(this.testVLANId);
                    NetworkResources resources = DaseinTestManager.getNetworkResources();
                    if (resources != null) {
                        if (support.getCapabilities().supportsInternetGatewayCreation()) {
                            tm.out("Before", connected);
                            Assert.assertFalse((String)"The VLAN is already connected via an internet gateway and thus this test cannot run", (boolean)connected);
                            resources.provisionInternetGateway(support, "provisionKeypair", this.testVLANId);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            connected = support.isConnectedViaInternetGateway(this.testVLANId);
                            tm.out("After", connected);
                            Assert.assertTrue((String)"The VLAN is not connected via an Internet Gateway", (boolean)connected);
                        } else {
                            try {
                                resources.provisionInternetGateway(support, "provisionKeypair", this.testVLANId);
                                Assert.fail((String)"Internet gateway creation completed even though it is not supported");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                            }
                        }
                    } else {
                        Assert.fail((String)"The network resources failed to initialize for testing");
                    }
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("VLAN creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test VLAN for " + this.name.getMethodName() + " test"));
                } else {
                    tm.ok("VLAN service is not subscribed so this test may not be entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listInternetGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    if (support.getCapabilities().supportsInternetGatewayCreation()) {
                        Collection igCollection = support.listInternetGateways(this.testVLANId);
                        Assert.assertTrue((String)"List internet gateways returned an empty collection", (igCollection.size() > 0 ? 1 : 0) != 0);
                    } else {
                        try {
                            support.listInternetGateways(this.testVLANId);
                            Assert.fail((String)"Internet gateway list completed even though Internet Gateway is not supported");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException as expected for " + this.name.getMethodName());
                        }
                    }
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("VLAN creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)("No test VLAN for " + this.name.getMethodName() + " test"));
                } else {
                    tm.ok("VLAN service is not subscribed so this test may not be entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void removeInternetGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    if (support.getCapabilities().supportsInternetGatewayCreation()) {
                        boolean connected = support.isConnectedViaInternetGateway(this.testVLANId);
                        tm.out("Before", connected);
                        if (connected) {
                            if (this.testInternetGatewayId != null) {
                                InternetGateway iGateway = support.getInternetGatewayById(this.testInternetGatewayId);
                                tm.out("Before", iGateway);
                                Assert.assertNotNull((String)"Test internet gateway no longer exists, cannot test removing it", (Object)iGateway);
                                String foundId = iGateway.getProviderInternetGatewayId();
                                Assert.assertNotNull((String)"The test internet gateway id was null", (Object)foundId);
                                String iGatewayIdByVlan = support.getAttachedInternetGatewayId(this.testVLANId);
                                Assert.assertTrue((String)"Gateway found by Id and Gateway found by VLAN do not match", (boolean)iGatewayIdByVlan.equalsIgnoreCase(foundId));
                                support.removeInternetGateway(this.testVLANId);
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                iGateway = support.getInternetGatewayById(this.testInternetGatewayId);
                                tm.out("After", iGateway);
                                Assert.assertNull((String)"The internet gateway remains available", (Object)iGateway);
                            } else {
                                tm.ok("No internet gateway with id " + this.testInternetGatewayId);
                            }
                        } else {
                            tm.ok("No internet gateway is connected to " + this.testVLANId);
                        }
                    } else if (!support.getCapabilities().supportsInternetGatewayCreation()) {
                        tm.ok("Internet Gateway creation/deletion is not supported in " + tm.getProvider().getCloudName());
                    }
                } else if (!support.getCapabilities().allowsNewVlanCreation()) {
                    tm.ok("VLAN creation/deletion is not supported in " + tm.getProvider().getCloudName());
                } else if (support.isSubscribed()) {
                    Assert.fail((String)"No test VLAN for deletion test");
                } else {
                    tm.ok("VLAN service is not subscribed so this test is not entirely valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void addRouteToVM() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            ComputeServices computeServices = tm.getProvider().getComputeServices();
            if (computeServices != null) {
                VLANSupport support = services.getVlanSupport();
                if (support != null) {
                    VirtualMachineSupport computeSupport = computeServices.getVirtualMachineSupport();
                    if (computeSupport != null) {
                        if (this.testRoutingTableId != null) {
                            if (this.testVLANVMId != null) {
                                RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                                tm.out("Route Table", rtb);
                                Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                                VirtualMachine vm = computeSupport.getVirtualMachine(this.testVLANVMId);
                                tm.out("Virtual Machine", vm);
                                Assert.assertNotNull((String)("Did not find the test virtual machine " + this.testVLANVMId), (Object)vm);
                                String successfulCidr = "";
                                for (String destinationCidr : this.cidrs) {
                                    try {
                                        support.addRouteToVirtualMachine(this.testRoutingTableId, IPVersion.IPV4, destinationCidr, vm.getProviderVirtualMachineId());
                                        successfulCidr = destinationCidr;
                                        break;
                                    }
                                    catch (Exception e) {
                                    }
                                }
                                if (!successfulCidr.equalsIgnoreCase("")) {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException ignore) {
                                        // empty catch block
                                    }
                                    rtb = support.getRoutingTable(this.testRoutingTableId);
                                    tm.out("Route Table", rtb);
                                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                                    Route[] routes = rtb.getRoutes();
                                    Boolean rightRoute = false;
                                    for (Route route : routes) {
                                        String vmId = route.getGatewayVirtualMachineId();
                                        String destCidr = route.getDestinationCidr();
                                        if (!destCidr.equalsIgnoreCase(successfulCidr) || vmId == null || !vmId.equalsIgnoreCase(vm.getProviderVirtualMachineId())) continue;
                                        rightRoute = true;
                                    }
                                    Assert.assertTrue((String)"The created route was not found in the route table", (boolean)rightRoute);
                                } else {
                                    Assert.fail((String)("Unable to add route for: " + this.name.getMethodName()));
                                }
                            } else if (computeSupport.isSubscribed()) {
                                Assert.fail((String)("No test virtual machine exists and thus no test could be run for " + this.name.getMethodName()));
                            }
                        } else if (!support.isSubscribed()) {
                            tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                        } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                            tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                        } else {
                            Assert.fail((String)("No test route table was found for running the stateful test: " + this.name.getMethodName()));
                        }
                    } else {
                        tm.ok("No virtual machine support in this cloud");
                    }
                } else {
                    tm.ok("No VLAN support in this cloud");
                }
            } else {
                tm.ok("No compute services in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void addRouteToNetworkInterface() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            ComputeServices computeServices = tm.getProvider().getComputeServices();
            if (computeServices != null) {
                VLANSupport support = services.getVlanSupport();
                if (support != null) {
                    VirtualMachineSupport computeSupport = computeServices.getVirtualMachineSupport();
                    if (computeSupport != null) {
                        if (this.testRoutingTableId != null) {
                            if (this.testVLANVMId != null) {
                                RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                                tm.out("Route Table", rtb);
                                Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                                VirtualMachine vm = computeSupport.getVirtualMachine(this.testVLANVMId);
                                tm.out("Virtual Machine", vm);
                                Assert.assertNotNull((String)("Did not find the test virtual machine " + this.testVLANVMId), (Object)vm);
                                String successfulCidr = "";
                                for (String destinationCidr : this.cidrs) {
                                    try {
                                        support.addRouteToNetworkInterface(this.testRoutingTableId, IPVersion.IPV4, destinationCidr, vm.getProviderNetworkInterfaceIds()[0]);
                                        successfulCidr = destinationCidr;
                                        break;
                                    }
                                    catch (Exception e) {
                                    }
                                }
                                if (!successfulCidr.equalsIgnoreCase("")) {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException ignore) {
                                        // empty catch block
                                    }
                                    rtb = support.getRoutingTable(this.testRoutingTableId);
                                    tm.out("Route Table", rtb);
                                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                                    Route[] routes = rtb.getRoutes();
                                    Boolean rightRoute = false;
                                    for (Route route : routes) {
                                        String eniId = route.getGatewayNetworkInterfaceId();
                                        String destCidr = route.getDestinationCidr();
                                        if (!destCidr.equalsIgnoreCase(successfulCidr) || eniId == null || !eniId.equalsIgnoreCase(vm.getProviderNetworkInterfaceIds()[0])) continue;
                                        rightRoute = true;
                                    }
                                    Assert.assertTrue((String)"The created route was not found in the route table", (boolean)rightRoute);
                                } else {
                                    Assert.fail((String)("Unable to add route for: " + this.name.getMethodName()));
                                }
                            } else if (computeSupport.isSubscribed()) {
                                Assert.fail((String)("No test virtual machine exists and thus no test could be run for " + this.name.getMethodName()));
                            }
                        } else if (!support.isSubscribed()) {
                            tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                        } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                            tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                        } else {
                            Assert.fail((String)("No test route table was found for running the stateful test: " + this.name.getMethodName()));
                        }
                    } else {
                        tm.ok("No virtual machine support in this cloud");
                    }
                } else {
                    tm.ok("No VLAN support in this cloud");
                }
            } else {
                tm.ok("No compute services in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void addRouteToGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testRoutingTableId != null && this.testInternetGatewayId != null) {
                    RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Route Table", rtb);
                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                    InternetGateway ig = support.getInternetGatewayById(this.testInternetGatewayId);
                    tm.out("Internet Gateway", ig);
                    Assert.assertNotNull((String)("Did not find the test internet gateway " + this.testInternetGatewayId), (Object)ig);
                    String successfulCidr = "";
                    for (String destinationCidr : this.cidrs) {
                        try {
                            support.addRouteToGateway(this.testRoutingTableId, IPVersion.IPV4, destinationCidr, this.testInternetGatewayId);
                            successfulCidr = destinationCidr;
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (!successfulCidr.equalsIgnoreCase("")) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        rtb = support.getRoutingTable(this.testRoutingTableId);
                        tm.out("Route Table", rtb);
                        Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                        Route[] routes = rtb.getRoutes();
                        Boolean rightRoute = false;
                        for (Route route : routes) {
                            String igId = route.getGatewayId();
                            String destCidr = route.getDestinationCidr();
                            if (!destCidr.equalsIgnoreCase(successfulCidr) || igId == null || !igId.equalsIgnoreCase(this.testInternetGatewayId)) continue;
                            rightRoute = true;
                        }
                        Assert.assertTrue((String)"The created route was not found in the route table", (boolean)rightRoute);
                    } else {
                        Assert.fail((String)("Unable to add route for: " + this.name.getMethodName()));
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                } else if (this.testRoutingTableId == null) {
                    Assert.fail((String)("No test route table was found for running the stateful test: " + this.name.getMethodName()));
                } else {
                    Assert.fail((String)("No test internet gateway was found for running the stateful test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }
}

