/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.DNSZone;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessDNSTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private DNSRecord testRecord;
    private String testZoneId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessDNSTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        DNSSupport support;
        NetworkServices services;
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testZoneId = tm.getTestZoneId("stateless", false);
        if (this.testZoneId != null && this.name.getMethodName().equals("recordContent") && (services = tm.getProvider().getNetworkServices()) != null && (support = services.getDnsSupport()) != null) {
            for (DNSRecordType type : DNSRecordType.values()) {
                try {
                    Iterator records = support.listDnsRecords(this.testZoneId, type, null).iterator();
                    if (!records.hasNext()) continue;
                    this.testRecord = (DNSRecord)records.next();
                    break;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for DNS Record", support.getProviderTermForRecord(Locale.getDefault()));
        tm.out("Term for DNS Zone", support.getProviderTermForZone(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for a DNS record may not be null", (Object)support.getProviderTermForRecord(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for a DNS zone may not be null", (Object)support.getProviderTermForZone(Locale.getDefault()));
    }

    @Test
    public void getBogusZone() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSZone zone = support.getDnsZone(UUID.randomUUID().toString());
        tm.out("Bogus DNS Zone", zone);
        Assert.assertNull((String)"Got a valid result back for the bogus zone ID", (Object)zone);
    }

    @Test
    public void getZone() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testZoneId != null) {
            DNSZone zone = support.getDnsZone(this.testZoneId);
            tm.out("DNS Zone", zone);
            Assert.assertNotNull((String)("No DNS zone was found matching the test DNS zone ID " + this.testZoneId), (Object)zone);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }

    private void assertDNSZone(@Nonnull DNSZone zone) {
        Assert.assertNotNull((String)"The DNS zone ID may not be null", (Object)zone.getProviderDnsZoneId());
        Assert.assertNotNull((String)"The DNS zone name may not be null", (Object)zone.getName());
        Assert.assertNotNull((String)"The DNS zone description may not be null", (Object)zone.getDescription());
        Assert.assertNotNull((String)"The owner account may not be null", (Object)zone.getProviderOwnerId());
        Assert.assertNotNull((String)"The domain name may not be null", (Object)zone.getDomainName());
        Assert.assertNotNull((String)"The nameservers list may be empty, but it may not be null", (Object)zone.getNameservers());
    }

    @Test
    public void zoneContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testZoneId != null) {
            DNSZone zone = support.getDnsZone(this.testZoneId);
            Assert.assertNotNull((String)("No DNS zone was found matching the test DNS zone ID " + this.testZoneId), (Object)zone);
            tm.out("DNS Zone ID", zone.getProviderDnsZoneId());
            tm.out("Name", zone.getName());
            tm.out("Owner Account", zone.getProviderOwnerId());
            tm.out("Domain Name", zone.getDomainName());
            tm.out("Nameservers", Arrays.toString(zone.getNameservers()));
            tm.out("Description", zone.getDescription());
            this.assertDNSZone(zone);
            Assert.assertEquals((String)"The DNS zone provided did not match the requested ID", (Object)this.testZoneId, (Object)zone.getProviderDnsZoneId());
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listZones() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable zones = support.listDnsZones();
        int count = 0;
        Assert.assertNotNull((String)"The list of DNS zones may not be null even if the account is not subscribed", (Object)zones);
        for (DNSZone zone : zones) {
            ++count;
            tm.out("DNS Zone", zone);
        }
        tm.out("Total DNS Zone Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("The account is not subscribed to DNS zones, so this test is invalid");
            } else {
                tm.warn("This test is likely invalid as no network firewalls were provided in the results for validation");
            }
        }
        for (DNSZone zone : zones) {
            this.assertDNSZone(zone);
        }
    }

    private void assertRecord(@Nonnull DNSRecord record) {
        Assert.assertNotNull((String)"The DNS record name may not be null", (Object)record.getName());
        Assert.assertNotNull((String)"The zone ID may not be null", (Object)record.getProviderZoneId());
        Assert.assertNotNull((String)"The DNS record type may not be null", (Object)record.getType());
        Assert.assertNotNull((String)"The record values may not be null", (Object)record.getValues());
        Assert.assertTrue((String)"There must be at least one value", (record.getValues().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The DNS record TTL must be greater than 0", (record.getTtl() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void recordContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRecord != null) {
            tm.out("Zone ID", this.testRecord.getProviderZoneId());
            tm.out("Name", this.testRecord.getName());
            tm.out("Type", this.testRecord.getType());
            tm.out("TTL", this.testRecord.getTtl());
            tm.out("Values", Arrays.toString(this.testRecord.getValues()));
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to DNS services in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)"No test record was in place");
        }
    }

    @Test
    public void listRecords() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        DNSSupport support = services.getDnsSupport();
        if (support == null) {
            tm.ok("DNS is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testZoneId != null) {
            int total = 0;
            for (DNSRecordType type : DNSRecordType.values()) {
                Iterable records = support.listDnsRecords(this.testZoneId, type, null);
                int count = 0;
                Assert.assertNotNull((String)"DNS records for any type may not be null", (Object)records);
                tm.out(type.name(), "");
                for (DNSRecord record : records) {
                    ++count;
                    tm.out(type.name(), record);
                }
                total += count;
                tm.out("Total " + type + " Records", count);
                for (DNSRecord record : records) {
                    this.assertRecord(record);
                }
            }
            tm.out("Total DNS Records", total);
            if (total < 1) {
                tm.warn("No DNS records were present in the test zone, so this test may not be valid");
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for DNS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("No test DNS zone exists for the test " + this.name.getMethodName()));
        }
    }
}

