/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallConstraints;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessFirewallTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testGeneralFirewallId;
    private String testVLANFirewallId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessFirewallTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testGeneralFirewallId = tm.getTestGeneralFirewallId("stateless", false);
        this.testVLANFirewallId = tm.getTestVLANFirewallId("stateless", false, null);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertFirewall(@Nonnull Firewall firewall, boolean vlan) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        FirewallSupport support = null;
        if (services != null) {
            support = services.getFirewallSupport();
        }
        Assert.assertNotNull((String)"The firewall ID may not be null", (Object)firewall.getProviderFirewallId());
        Assert.assertNotNull((String)"The firewall name may not be null", (Object)firewall.getName());
        Assert.assertNotNull((String)"The firewall description may not be null", (Object)firewall.getDescription());
        Assert.assertNotNull((String)"The firewall region may not be null", (Object)firewall.getRegionId());
        if (vlan) {
            Assert.assertNotNull((String)"The firewall VLAN may not be null", (Object)firewall.getProviderVlanId());
        } else if (support != null && support.getCapabilities().requiresVLAN().equals((Object)Requirement.NONE)) {
            Assert.assertNull((String)"The firewall VLAN must be null", (Object)firewall.getProviderVlanId());
        }
        Assert.assertNotNull((String)"The firewall tags may not be null", (Object)firewall.getTags());
        Assert.assertEquals((String)"The firewall is in the wrong region", (Object)tm.getContext().getRegionId(), (Object)firewall.getRegionId());
        Assert.assertNotNull((String)"The firewall rules may not be null", (Object)firewall.getRules());
    }

    private void assertRule(@Nonnull String fwId, @Nonnull FirewallRule rule) {
        Assert.assertNotNull((String)"The firewall rule ID may not be null", (Object)rule.getProviderRuleId());
        Assert.assertNotNull((String)"The firewall ID may not be null", (Object)rule.getFirewallId());
        Assert.assertEquals((String)"The firewall ID for the rule should match the firewall", (Object)fwId, (Object)rule.getFirewallId());
        Assert.assertTrue((String)"Precedence must be non-negative", (rule.getPrecedence() >= 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"The firewall rule direction must be non-null", (Object)rule.getDirection());
        Assert.assertNotNull((String)"The firewall permission must not be null", (Object)rule.getPermission());
        Assert.assertNotNull((String)"The firewall source must not be null", (Object)rule.getSourceEndpoint());
        Assert.assertNotNull((String)"The firewall destination must not be null", (Object)rule.getDestinationEndpoint());
        Assert.assertNotNull((String)"The firewall protocol must not be null", (Object)rule.getProtocol());
    }

    private void content(@Nonnull String id, @Nonnull Firewall firewall, boolean vlan) throws CloudException, InternalException {
        tm.out("Firewall ID", firewall.getProviderFirewallId());
        tm.out("Active", firewall.isActive());
        tm.out("Available", firewall.isAvailable());
        tm.out("Name", firewall.getName());
        tm.out("Region ID", firewall.getRegionId());
        tm.out("VLAN ID", firewall.getProviderVlanId());
        tm.out("Subnets", Arrays.toString(firewall.getSubnetAssociations()));
        tm.out("Rules", Arrays.toString(firewall.getRules().toArray()));
        Map tags = firewall.getTags();
        if (tags != null) {
            for (Map.Entry entry : tags.entrySet()) {
                tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        tm.out("Description", firewall.getDescription());
        this.assertFirewall(firewall, vlan);
        Assert.assertEquals((String)"The requested firewall ID does not match the actual firewall ID", (Object)id, (Object)firewall.getProviderFirewallId());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                tm.out("Subscribed", support.isSubscribed());
                tm.out("Term for Firewall", support.getCapabilities().getProviderTermForFirewall(Locale.getDefault()));
                tm.out("Supports Firewall Creation (General)", support.getCapabilities().supportsFirewallCreation(false));
                tm.out("Supports Firewall Creation (VLAN)", support.getCapabilities().supportsFirewallCreation(true));
                boolean general = false;
                boolean vlan = false;
                for (Direction direction : Direction.values()) {
                    for (Permission permission : Permission.values()) {
                        boolean b = support.getCapabilities().supportsRules(direction, permission, false);
                        if (b) {
                            general = true;
                        }
                        tm.out("Supports " + direction + "/" + permission + " (General)", b);
                        b = support.getCapabilities().supportsRules(direction, permission, true);
                        if (b) {
                            vlan = true;
                        }
                        tm.out("Supports " + direction + "/" + permission + " (VLAN)", b);
                    }
                }
                tm.out("Rule Precedence Req (General)", support.getCapabilities().identifyPrecedenceRequirement(false));
                tm.out("Rule Precedence Req (VLAN)", support.getCapabilities().identifyPrecedenceRequirement(true));
                tm.out("Zero Highest Precedence", support.getCapabilities().isZeroPrecedenceHighest());
                tm.out("Supported Directions (General)", support.getCapabilities().listSupportedDirections(false));
                tm.out("Supported Directions (VLAN)", support.getCapabilities().listSupportedDirections(true));
                tm.out("Supported Permissions (General)", support.getCapabilities().listSupportedPermissions(false));
                tm.out("Supported Permissions (VLAN)", support.getCapabilities().listSupportedPermissions(true));
                tm.out("Supported Source Types (General)", support.getCapabilities().listSupportedSourceTypes(false));
                tm.out("Supported Source Types (VLAN)", support.getCapabilities().listSupportedSourceTypes(true));
                tm.out("Supported Destination Types (General)", support.getCapabilities().listSupportedDestinationTypes(false));
                tm.out("Supported Destination Types (VLAN)", support.getCapabilities().listSupportedDestinationTypes(true));
                FirewallConstraints constraints = support.getCapabilities().getFirewallConstraintsForCloud();
                Assert.assertNotNull((String)"Firewall constraints may not be null", (Object)constraints);
                Iterable cfields = constraints.getConstraints();
                tm.out("Constrained fields", cfields);
                Assert.assertNotNull((String)"Firewall constraints may not define empty files (may be an empty list)", (Object)cfields);
                for (FirewallConstraints.Constraint c : FirewallConstraints.Constraint.values()) {
                    FirewallConstraints.Level l = constraints.getConstraintLevel(c);
                    tm.out("Constraint " + c.name(), l);
                    Assert.assertNotNull((String)("Constraint level may not be null, but it was for " + c), (Object)l);
                }
                if (!general) {
                    Assert.assertFalse((String)"General firewalls are not supported, so it makes no sense that you can create them", (boolean)support.getCapabilities().supportsFirewallCreation(false));
                }
                if (!vlan) {
                    Assert.assertFalse((String)"VLAN firewalls are not supported, so it makes no sense that you can create them", (boolean)support.getCapabilities().supportsFirewallCreation(true));
                }
                Assert.assertNotNull((String)"The provider term for firewall may not be null for any locale", (Object)Locale.getDefault());
                Assert.assertNotNull((String)"Requirement for precedence in general firewall rules may not be null", (Object)support.getCapabilities().identifyPrecedenceRequirement(false));
                Assert.assertNotNull((String)"Requirement for precedence in VLAN firewall rules may not be null", (Object)support.getCapabilities().identifyPrecedenceRequirement(true));
                Iterable types = support.getCapabilities().listSupportedSourceTypes(false);
                Assert.assertNotNull((String)"Supported source types for general firewall rules may not be null", (Object)types);
                if (general) {
                    Assert.assertTrue((String)"There must be at least one source type for general firewall rules", (boolean)types.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for general firewall rules, so no source types should exist", (boolean)types.iterator().hasNext());
                }
                types = support.getCapabilities().listSupportedSourceTypes(true);
                Assert.assertNotNull((String)"Supported source types for VLAN firewall rules may not be null", (Object)types);
                if (vlan) {
                    Assert.assertTrue((String)"There must be at least one source type for VLAN firewall rules", (boolean)types.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for VLAN firewall rules, so no source types should exist", (boolean)types.iterator().hasNext());
                }
                types = support.getCapabilities().listSupportedDestinationTypes(false);
                Assert.assertNotNull((String)"Supported destination types for general firewall rules may not be null", (Object)types);
                if (general) {
                    Assert.assertTrue((String)"There must be at least one destination type for general firewall rules", (boolean)types.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for general firewall rules, so no destination types should exist", (boolean)types.iterator().hasNext());
                }
                types = support.getCapabilities().listSupportedDestinationTypes(true);
                Assert.assertNotNull((String)"Supported destination types for VLAN firewall rules may not be null", (Object)types);
                if (vlan) {
                    Assert.assertTrue((String)"There must be at least one destination type for VLAN firewall rules", (boolean)types.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for VLAN firewall rules, so no destination types should exist", (boolean)types.iterator().hasNext());
                }
                Iterable directions = support.getCapabilities().listSupportedDirections(false);
                Assert.assertNotNull((String)"Supported directions for general firewall rules may not be null", (Object)directions);
                if (general) {
                    Assert.assertTrue((String)"There must be at least one direction available for general firewall rules", (boolean)directions.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for general firewall rules, so no directions should be enumerated", (boolean)directions.iterator().hasNext());
                }
                directions = support.getCapabilities().listSupportedDirections(true);
                Assert.assertNotNull((String)"Supported directions for VLAN firewall rules may not be null", (Object)directions);
                if (vlan) {
                    Assert.assertTrue((String)"There must be at least one direction available for VLAN firewall rules", (boolean)directions.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for VLAN firewall rules, so no directions should be enumerated", (boolean)directions.iterator().hasNext());
                }
                Iterable permissions = support.getCapabilities().listSupportedPermissions(false);
                Assert.assertNotNull((String)"Supported permissions for general firewall rules may not be null", (Object)permissions);
                if (general) {
                    Assert.assertTrue((String)"There must be at least one permission available for general firewall rules", (boolean)permissions.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for general firewall rules, so no permissions should be enumerated", (boolean)permissions.iterator().hasNext());
                }
                permissions = support.getCapabilities().listSupportedPermissions(true);
                Assert.assertNotNull((String)"Supported permissions for VLAN firewall rules may not be null", (Object)permissions);
                if (vlan) {
                    Assert.assertTrue((String)"There must be at least one permission available for VLAN firewall rules", (boolean)permissions.iterator().hasNext());
                } else {
                    Assert.assertFalse((String)"There is no support for VLAN firewall rules, so no permissions should be enumerated", (boolean)permissions.iterator().hasNext());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void getBogusFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                Firewall fw = support.getFirewall(UUID.randomUUID().toString());
                tm.out("Bogus Firewall", fw);
                Assert.assertNull((String)"Found a firewall for a bogus ID when none should have been found", (Object)fw);
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void getGeneralFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testGeneralFirewallId != null) {
                    Firewall fw = support.getFirewall(this.testGeneralFirewallId);
                    tm.out("General Firewall", fw);
                    Assert.assertNotNull((String)"Unable to find the test firewall", (Object)fw);
                } else if (support.getCapabilities().listSupportedDirections(false).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports general firewalls"));
                } else {
                    tm.ok("No general firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void vlanFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testVLANFirewallId != null) {
                    Firewall fw = support.getFirewall(this.testVLANFirewallId);
                    tm.out("VLAN Firewall", fw);
                    Assert.assertNotNull((String)"Unable to find the test firewall", (Object)fw);
                } else if (support.getCapabilities().listSupportedDirections(true).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports VLAN firewalls"));
                } else {
                    tm.ok("No VLAN firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void generalFirewallContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                boolean inVlan = support.getCapabilities().requiresVLAN().equals((Object)Requirement.REQUIRED);
                if (this.testGeneralFirewallId != null && !inVlan) {
                    Firewall fw = support.getFirewall(this.testGeneralFirewallId);
                    Assert.assertNotNull((String)"Unable to find the test firewall", (Object)fw);
                    this.content(this.testGeneralFirewallId, fw, inVlan);
                } else if (support.getCapabilities().listSupportedDirections(false).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports general firewalls"));
                } else {
                    tm.ok("No general firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void firewallConstraints() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testGeneralFirewallId != null) {
                    Firewall fw = support.getFirewall(this.testGeneralFirewallId);
                    Assert.assertNotNull((String)"Unable to find the test firewall", (Object)fw);
                    Map constraints = support.getActiveConstraintsForFirewall(this.testGeneralFirewallId);
                    tm.out("Firewall constraints (" + this.testGeneralFirewallId + "): ", constraints);
                    Assert.assertNotNull((String)("Unable to load firewall constraints for " + this.testGeneralFirewallId), (Object)constraints);
                } else if (support.getCapabilities().listSupportedDirections(false).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports general firewalls"));
                } else {
                    tm.ok("No general firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void vlanFirewallContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testVLANFirewallId != null) {
                    Firewall fw = support.getFirewall(this.testVLANFirewallId);
                    Assert.assertNotNull((String)"Unable to find the test firewall", (Object)fw);
                    this.content(this.testVLANFirewallId, fw, true);
                } else if (support.getCapabilities().listSupportedDirections(true).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports VLAN firewalls"));
                } else {
                    tm.ok("No VLAN firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listFirewalls() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                Collection firewalls = support.list();
                int count = 0;
                Assert.assertNotNull((String)"The list of firewalls may be empty, but it may never be null", (Object)firewalls);
                for (Firewall fw : firewalls) {
                    ++count;
                    tm.out("Firewall", fw);
                }
                tm.out("Total Firewall Count", count);
                if (support.isSubscribed() && count == 0) {
                    tm.warn("This test is likely invalid as no firewalls were provided in the results for validation");
                }
                if (count > 0) {
                    Iterator i$ = firewalls.iterator();
                    while (i$.hasNext()) {
                        Firewall fw;
                        this.assertFirewall(fw, (fw = (Firewall)i$.next()).getProviderVlanId() != null);
                    }
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listFirewallStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                Iterable firewalls = support.listFirewallStatus();
                int count = 0;
                Assert.assertNotNull((String)"The list of firewall status may be empty, but it may never be null", (Object)firewalls);
                for (ResourceStatus fw : firewalls) {
                    ++count;
                    tm.out("Firewall Status", fw);
                }
                tm.out("Total Firewall Status Count", count);
                if (support.isSubscribed() && count == 0) {
                    tm.warn("This test is likely invalid as no firewall status items were provided in the results for validation");
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void compareFirewallListAndStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Collection firewalls = support.list();
                Iterable status = support.listFirewallStatus();
                Assert.assertNotNull((String)"listFirewalls() must return at least an empty collections and may not be null", (Object)firewalls);
                Assert.assertNotNull((String)"listFirewallStatus() must return at least an empty collection and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (Firewall firewall : firewalls) {
                    current = (Map)map.get(firewall.getProviderFirewallId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(firewall.getProviderFirewallId(), current);
                    }
                    current.put("firewall", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean f = (Boolean)((Map)entry.getValue()).get("firewall");
                    Assert.assertTrue((String)("Status and firewall lists do not match for " + (String)entry.getKey()), (s != null && f != null && s != false && f != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No firewall support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listRulesForGeneralFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testGeneralFirewallId != null) {
                    Collection rules = support.getRules(this.testGeneralFirewallId);
                    int count = 0;
                    Assert.assertNotNull((String)"The rules associated with a firewall may be empty, but they may not be null", (Object)rules);
                    for (FirewallRule rule : rules) {
                        ++count;
                        tm.out("Rule for " + this.testGeneralFirewallId, rule);
                    }
                    if (count < 1) {
                        tm.warn("No rules were associated with this firewall, so the test may be invalid");
                    } else if (count > 0) {
                        for (FirewallRule rule : rules) {
                            this.assertRule(this.testGeneralFirewallId, rule);
                        }
                    }
                } else if (support.getCapabilities().listSupportedDirections(false).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports general firewalls"));
                } else {
                    tm.ok("No general firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listRulesForVLANFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                if (this.testVLANFirewallId != null) {
                    Collection rules = support.getRules(this.testVLANFirewallId);
                    int count = 0;
                    Assert.assertNotNull((String)"The rules associated with a firewall may be empty, but they may not be null", (Object)rules);
                    for (FirewallRule rule : rules) {
                        ++count;
                        tm.out("Rule for " + this.testVLANFirewallId, rule);
                    }
                    if (count < 1) {
                        tm.warn("No rules were associated with this firewall, so the test may be invalid");
                    } else if (count > 0) {
                        for (FirewallRule rule : rules) {
                            this.assertRule(this.testVLANFirewallId, rule);
                        }
                    }
                } else if (support.getCapabilities().listSupportedDirections(true).iterator().hasNext()) {
                    Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports VLAN firewalls"));
                } else {
                    tm.ok("No VLAN firewalls in " + tm.getProvider().getCloudName());
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void ruleContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            if (support != null) {
                for (Firewall fw : support.list()) {
                    Iterator rules;
                    String id = fw.getProviderFirewallId();
                    if (id == null || !(rules = support.getRules(id).iterator()).hasNext()) continue;
                    FirewallRule rule = (FirewallRule)rules.next();
                    tm.out("Rule ID", rule.getProviderRuleId());
                    tm.out("Firewall ID", rule.getFirewallId());
                    tm.out("Precedence", rule.getPrecedence());
                    tm.out("Permission", rule.getPermission());
                    tm.out("Direction", rule.getDirection());
                    tm.out("Source", rule.getSourceEndpoint());
                    tm.out("Protocol", rule.getProtocol());
                    tm.out("Destination", rule.getDestinationEndpoint());
                    tm.out("Start Port", rule.getStartPort());
                    tm.out("End Port", rule.getEndPort());
                    this.assertRule(id, rule);
                    return;
                }
                if (!support.isSubscribed()) {
                    tm.ok("This account is not subscribed for firewalls");
                } else if (support.getCapabilities().listSupportedDirections(false).iterator().hasNext() || support.getCapabilities().listSupportedDirections(true).iterator().hasNext()) {
                    tm.warn("No firewall rules exist in this cloud currently, so this test may not be valid");
                } else {
                    tm.ok("This cloud does not support any kind of firewall rules in this region");
                }
            } else {
                tm.ok("No firewall support in " + tm.getProvider().getCloudName());
            }
        } else {
            tm.ok("No network services in " + tm.getProvider().getCloudName());
        }
    }
}

