/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.SSLCertificate;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.network.NetworkResources;
import org.dasein.cloud.test.network.StatefulLoadBalancerTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessLoadBalancerTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testLoadBalancerId;
    private String testSslCertificateName;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessLoadBalancerTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testLoadBalancerId = tm.getTestLoadBalancerId("stateless", tm.getUserName() + "-dsnlb", false);
        this.testSslCertificateName = tm.getTestSSLCertificateName("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertListener(@Nonnull LoadBalancerSupport support, @Nonnull LbListener listener) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The listener algorithm may not be null", (Object)listener.getAlgorithm());
        boolean ok = false;
        for (LbAlgorithm algorithm : support.getCapabilities().listSupportedAlgorithms()) {
            if (!algorithm.equals((Object)listener.getAlgorithm())) continue;
            ok = true;
        }
        Assert.assertTrue((String)"The algorithm associated with this listener is not a supported algorithm", (boolean)ok);
        ok = false;
        Assert.assertNotNull((String)"The listener network protocol may not be null", (Object)listener.getNetworkProtocol());
        for (LbProtocol protocol : support.getCapabilities().listSupportedProtocols()) {
            if (!protocol.equals((Object)listener.getNetworkProtocol())) continue;
            ok = true;
        }
        Assert.assertTrue((String)"The network protocol associated with this listener is not a supported protocol", (boolean)ok);
        ok = false;
        Assert.assertNotNull((String)"The listener session persistence may not be null", (Object)listener.getPersistence());
        for (LbPersistence p : support.getCapabilities().listSupportedPersistenceOptions()) {
            if (!p.equals((Object)listener.getPersistence())) continue;
            ok = true;
        }
        Assert.assertTrue((String)"The session persistence option associated with this listener is not a supported option", (boolean)ok);
        if (listener.getPersistence().equals((Object)LbPersistence.COOKIE)) {
            Assert.assertNotNull((String)"When the session persistence is set to server cookie, a cookie value must be set", (Object)listener.getCookie());
        }
        if (LbProtocol.HTTP.equals((Object)listener.getNetworkProtocol())) {
            Assert.assertNull((String)"HTTP listener cannot have an SSL certificate", (Object)listener.getSslCertificateName());
        } else if (LbProtocol.HTTPS.equals((Object)listener.getNetworkProtocol())) {
            Assert.assertNotNull((String)"HTTPS listener must have an SSL certificate", (Object)listener.getSslCertificateName());
        }
    }

    private void assertLoadBalancer(@Nonnull LoadBalancerSupport support, @Nonnull LoadBalancer lb) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The load balancer ID may not be null", (Object)lb.getProviderLoadBalancerId());
        Assert.assertNotNull((String)"The load balancer state may not be null", (Object)lb.getCurrentState());
        Assert.assertNotNull((String)"The load balancer name may not be null", (Object)lb.getName());
        Assert.assertNotNull((String)"The load balancer description may not be null", (Object)lb.getDescription());
        Assert.assertNotNull((String)"The load balancer owner may not be null", (Object)lb.getProviderOwnerId());
        Assert.assertNotNull((String)"The load balancer region may not be null", (Object)lb.getProviderRegionId());
        Assert.assertEquals((String)"The load balancer region must match the region for this context", (Object)tm.getContext().getRegionId(), (Object)lb.getProviderRegionId());
        String[] dcs = lb.getProviderDataCenterIds();
        Assert.assertNotNull((String)"The list of data centers to which the load balancer is assigned may not be null", (Object)dcs);
        if (support.getCapabilities().isDataCenterLimited()) {
            Assert.assertTrue((String)"There must be at least one data center associated with the load balancer", (dcs.length > 0 ? 1 : 0) != 0);
        }
        Assert.assertNotNull((String)"The load balancer address type may not be null", (Object)lb.getAddressType());
        Assert.assertNotNull((String)"The load balancer address may not be null", (Object)lb.getAddress());
        int[] ports = lb.getPublicPorts();
        Assert.assertNotNull((String)"The list of public ports may notbe null", (Object)ports);
        IPVersion[] v = lb.getSupportedTraffic();
        Assert.assertNotNull((String)"The IP traffic associated with the load balancer must not be null", (Object)v);
        Assert.assertTrue((String)"There must be at least one IP version supported for the load balancer", (v.length > 0 ? 1 : 0) != 0);
        LbListener[] listeners = lb.getListeners();
        Assert.assertNotNull((String)"The list of listeners may not be null", (Object)listeners);
        if (support.getCapabilities().identifyListenersOnCreateRequirement().equals((Object)Requirement.REQUIRED)) {
            Assert.assertTrue((String)"There must be at least one public port associated with the load balancer", (ports.length > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"There must be at least one listener associated with the load balancer", (listeners.length > 0 ? 1 : 0) != 0);
        }
        for (LbListener listener : listeners) {
            this.assertListener(support, listener);
        }
    }

    private void assertSSLCertificate(@Nonnull SSLCertificate certificate, boolean isBodyRequired) throws CloudException, InternalException {
        if (isBodyRequired) {
            Assert.assertNotNull((String)"The SSL certificate body may not be null", (Object)certificate.getCertificateBody());
        }
        Assert.assertNotNull((String)"The SSL certificate ID may not be null", (Object)certificate.getCertificateName());
        Assert.assertNotNull((String)"The SSL certificate provider ID may not be null", (Object)certificate.getProviderCertificateId());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Load Balancer", support.getCapabilities().getProviderTermForLoadBalancer(Locale.getDefault()));
        tm.out("Data Center Limited", support.getCapabilities().isDataCenterLimited());
        tm.out("Address Type", support.getCapabilities().getAddressType());
        tm.out("Provider-assigned Address", support.getCapabilities().isAddressAssignedByProvider());
        tm.out("Endpoints on Create", support.getCapabilities().identifyEndpointsOnCreateRequirement());
        tm.out("Listeners on Create", support.getCapabilities().identifyListenersOnCreateRequirement());
        tm.out("Max Public Ports", support.getCapabilities().getMaxPublicPorts() == 0 ? "Unlimited" : String.valueOf(support.getCapabilities().getMaxPublicPorts()));
        tm.out("Endpoint Types", support.getCapabilities().listSupportedEndpointTypes());
        tm.out("Algorithms", support.getCapabilities().listSupportedAlgorithms());
        tm.out("Protocols", support.getCapabilities().listSupportedProtocols());
        tm.out("Persistence Options", support.getCapabilities().listSupportedPersistenceOptions());
        tm.out("Supported Traffic", support.getCapabilities().listSupportedIPVersions());
        tm.out("Supports Monitoring", support.getCapabilities().supportsMonitoring());
        tm.out("Can Add Endpoints", support.getCapabilities().supportsAddingEndpoints());
        tm.out("Supports Multiple IP Versions", support.getCapabilities().supportsMultipleTrafficTypes());
        Assert.assertNotNull((String)"The provider term for a load balancer may not be null", (Object)support.getCapabilities().getProviderTermForLoadBalancer(Locale.getDefault()));
        Assert.assertNotNull((String)"The address type may not be null", (Object)support.getCapabilities().getAddressType());
        if (LoadBalancerAddressType.DNS.equals((Object)support.getCapabilities().getAddressType())) {
            Assert.assertTrue((String)"DNS-based load balancers must have the load balancer address assigned by the cloud provider", (boolean)support.getCapabilities().isAddressAssignedByProvider());
        } else if (!support.getCapabilities().isAddressAssignedByProvider()) {
            IpAddressSupport ipSupport = services.getIpAddressSupport();
            Assert.assertNotNull((String)"If IP addresses are not assigned by a provider, there must be IP address support", (Object)ipSupport);
            boolean requestable = false;
            for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
                if (!ipSupport.getCapabilities().isRequestable(v)) continue;
                requestable = true;
                break;
            }
            Assert.assertTrue((String)"IP addresses must be requestable when IP addresses for load balancers are not provider assigned", (boolean)requestable);
        }
        Assert.assertNotNull((String)"The requirement level for having endpoints when creating a load balancer cannot be null", (Object)support.getCapabilities().identifyEndpointsOnCreateRequirement());
        Assert.assertNotNull((String)"The requirement level for having listeners when creating a load balancer cannot be null", (Object)support.getCapabilities().identifyListenersOnCreateRequirement());
        Assert.assertTrue((String)"The maximum number of public ports must be a positive number or 0 for unlimited", (support.getCapabilities().getMaxPublicPorts() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"There must be at least one supported endpoint type", (boolean)support.getCapabilities().listSupportedEndpointTypes().iterator().hasNext());
        Assert.assertTrue((String)"There must be at least one supported algorithm", (boolean)support.getCapabilities().listSupportedAlgorithms().iterator().hasNext());
        Assert.assertTrue((String)"There must be at least one supported protocol", (boolean)support.getCapabilities().listSupportedProtocols().iterator().hasNext());
        Assert.assertTrue((String)"There must be at least one supported persistence option", (boolean)support.getCapabilities().listSupportedPersistenceOptions().iterator().hasNext());
        Assert.assertTrue((String)"There must be at least one supported IP version", (boolean)support.getCapabilities().listSupportedIPVersions().iterator().hasNext());
        Assert.assertTrue((String)"If you are not creating endpoints at LB create, you need the ability to add them after load balancer creation", (support.getCapabilities().identifyEndpointsOnCreateRequirement().equals((Object)Requirement.REQUIRED) || support.getCapabilities().supportsAddingEndpoints() ? 1 : 0) != 0);
    }

    @Test
    public void getBogusLoadBalancer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancer lb = support.getLoadBalancer(UUID.randomUUID().toString());
        tm.out("Bogus Load Balancer", lb);
        Assert.assertNull((String)"Found a valid load balancer for a bogus load balancer ID", (Object)lb);
    }

    @Test
    public void getLoadBalancer() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null) {
            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
            tm.out("Load Balancer", lb);
            Assert.assertNotNull((String)"No load balancer was found for the test load balancer ID", (Object)lb);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for load balancers");
        } else {
            Assert.fail((String)("No test load balancer exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void loadBalancerContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null) {
            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
            Assert.assertNotNull((String)"No load balancer was found for the test load balancer ID", (Object)lb);
            tm.out("Load Balancer ID", lb.getProviderLoadBalancerId());
            tm.out("Current State", lb.getCurrentState());
            tm.out("Name", lb.getName());
            tm.out("Owner Account", lb.getProviderOwnerId());
            tm.out("Region ID", lb.getProviderRegionId());
            tm.out("Data Center IDs", Arrays.toString(lb.getProviderDataCenterIds()));
            tm.out("Created", new Date(lb.getCreationTimestamp()));
            tm.out("Address Type", lb.getAddressType());
            tm.out("Address", lb.getAddress());
            tm.out("Public Ports", Arrays.toString(lb.getPublicPorts()));
            tm.out("IP Versions", Arrays.toString(lb.getSupportedTraffic()));
            tm.out("Listeners", Arrays.toString(lb.getListeners()));
            tm.out("Description", lb.getDescription());
            this.assertLoadBalancer(support, lb);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for load balancers");
        } else {
            Assert.fail((String)("No test load balancer exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listEndpoints() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testLoadBalancerId != null) {
            LoadBalancer lb = support.getLoadBalancer(this.testLoadBalancerId);
            Assert.assertNotNull((String)"No load balancer was found for the test load balancer ID", (Object)lb);
            Iterable endpoints = support.listEndpoints(this.testLoadBalancerId);
            int count = 0;
            Assert.assertNotNull((String)"The list of load balancer endpoints may not be null", (Object)endpoints);
            if (support.getCapabilities().identifyEndpointsOnCreateRequirement().equals((Object)Requirement.REQUIRED)) {
                Assert.assertTrue((String)"There must be at least one endpoint associated with this load balancer", (boolean)endpoints.iterator().hasNext());
            }
            for (LoadBalancerEndpoint endpoint : endpoints) {
                ++count;
                tm.out("Endpoint", endpoint);
            }
            tm.out("Endpoint Count", count);
            if (count < 1) {
                tm.warn("Unable to test endpoints appropriately due to the lack of endpoints");
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for load balancers");
        } else {
            Assert.fail((String)("No test load balancer exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listLoadBalancers() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable loadBalancers = support.listLoadBalancers();
        int count = 0;
        Assert.assertNotNull((String)"The list of load balancers may not be null", (Object)loadBalancers);
        for (LoadBalancer lb : loadBalancers) {
            ++count;
            tm.out("Load Balancer", lb);
        }
        tm.out("Load Balancer Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The load balancer count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no load balancers were provided in the results for validation");
        }
        if (count > 0) {
            for (LoadBalancer lb : loadBalancers) {
                this.assertLoadBalancer(support, lb);
            }
        }
    }

    @Test
    public void listLoadBalancerStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable loadBalancers = support.listLoadBalancerStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of load balancers may not be null", (Object)loadBalancers);
        for (ResourceStatus lb : loadBalancers) {
            ++count;
            tm.out("Load Balancer Status", lb);
        }
        tm.out("Load Balancer Status Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The load balancer status count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no load balancer status was provided in the results for validation");
        }
    }

    @Test
    public void compareLoadBalancerListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Iterable loadBalancers = support.listLoadBalancers();
        Iterable status = support.listLoadBalancerStatus();
        Assert.assertNotNull((String)"listLoadBalancers() must return at least an empty collections and may not be null", (Object)loadBalancers);
        Assert.assertNotNull((String)"listLoadBalancerStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (LoadBalancer loadBalancer : loadBalancers) {
            current = (Map)map.get(loadBalancer.getProviderLoadBalancerId());
            if (current == null) {
                current = new HashMap();
                map.put(loadBalancer.getProviderLoadBalancerId(), current);
            }
            current.put("lb", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean l = (Boolean)((Map)entry.getValue()).get("lb");
            Assert.assertTrue((String)("Status and load balancer lists do not match for " + (String)entry.getKey()), (s != null && l != null && s != false && l != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }

    @Test
    public void getBogusSSLCertificate() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        SSLCertificate sslCertificate = support.getSSLCertificate(UUID.randomUUID().toString());
        tm.out("Bogus SSL certificate", sslCertificate);
        Assert.assertNull((String)"Found a valid SSL certificate for a bogus ID", (Object)sslCertificate);
    }

    @Test
    public void getSSLCertificate() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSslCertificateName != null) {
            SSLCertificate certificate = support.getSSLCertificate(this.testSslCertificateName);
            tm.out("SSL Certificate", certificate);
            Assert.assertNotNull((String)"No SSL certificate was found for the test ID", (Object)certificate);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for SSL certificates");
        } else {
            Assert.fail((String)("No test SSL certificate exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void sslCertificateContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testSslCertificateName != null) {
            SSLCertificate certificate = support.getSSLCertificate(this.testSslCertificateName);
            Assert.assertNotNull((String)"No SSL certificate was found for the test ID", (Object)certificate);
            tm.out("SSL certificate name", certificate.getCertificateName());
            tm.out("SSL certificate provider ID", certificate.getProviderCertificateId());
            tm.out("SSL certificate upload date", certificate.getCreatedTimestamp());
            tm.out("SSL certificate path", certificate.getPath());
            tm.out("SSL certificate chain", certificate.getCertificateChain());
            tm.out("SSL certificate body", certificate.getCertificateBody());
            this.assertSSLCertificate(certificate, true);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for SSL certificates");
        } else {
            Assert.fail((String)("No test SSL certificate exists for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listSSLCertificates() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("SSL certificates are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable certificates = support.listSSLCertificates();
        int count = 0;
        Assert.assertNotNull((String)"The list of SSL certificates may not be null", (Object)certificates);
        for (SSLCertificate certificate : certificates) {
            ++count;
            tm.out("SSL certificate", certificate);
        }
        tm.out("SSL certificates count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The SSL certificate count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no SSL certificates were provided in the results for validation");
        }
        if (count > 0) {
            for (SSLCertificate certificate : certificates) {
                this.assertSSLCertificate(certificate, false);
            }
        }
    }

    @Test
    public void listLoadBalancerHealthChecks() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        LoadBalancerSupport support = services.getLoadBalancerSupport();
        if (support == null) {
            tm.ok("Load balancers are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable healthChecks = support.listLBHealthChecks(null);
        int count = 0;
        Assert.assertNotNull((String)"The list of LB health checks may not be null", (Object)healthChecks);
        for (LoadBalancerHealthCheck lbhc : healthChecks) {
            ++count;
            tm.out("LB Health Check", lbhc);
        }
        tm.out("LB Health Check Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The LB health check count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no LB health checks were provided in the results for validation");
        }
        boolean found = false;
        for (LoadBalancerHealthCheck lbhc : healthChecks) {
            if (!"/index.htm".equals(lbhc.getPath()) || !NetworkResources.TEST_HC_PROTOCOL.equals((Object)lbhc.getProtocol()) || 8080 != lbhc.getPort()) continue;
            StatefulLoadBalancerTests.assertHealthCheck(this.testLoadBalancerId, support, lbhc);
            found = true;
            break;
        }
        Assert.assertTrue((String)"Unable to find the test load balancer in the returned list", (boolean)found);
    }
}

