/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.NetworkFirewallSupport;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessNetworkFirewallTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testFirewallId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessNetworkFirewallTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testFirewallId = tm.getTestNetworkFirewallId("stateless", false, null);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean subscribed = support.isSubscribed();
        tm.out("Subscribed", subscribed);
        tm.out("Term for Network Firewall", support.getCapabilities().getProviderTermForNetworkFirewall(Locale.getDefault()));
        tm.out("Precedence Requirement", support.getCapabilities().identifyPrecedenceRequirement());
        tm.out("Zero Precedence Highest", support.getCapabilities().isZeroPrecedenceHighest());
        tm.out("Supports Network Firewall Creation", support.getCapabilities().supportsNetworkFirewallCreation());
        Iterable sources = support.getCapabilities().listSupportedSourceTypes();
        tm.out("Source Types", sources);
        Iterable destinations = support.getCapabilities().listSupportedDestinationTypes();
        tm.out("Destination Types", destinations);
        Iterable directions = support.getCapabilities().listSupportedDirections();
        tm.out("Directions", directions);
        Iterable permissions = support.getCapabilities().listSupportedPermissions();
        tm.out("Permissions", permissions);
        Assert.assertNotNull((String)"The provider term for a network firewall may not be null", (Object)support.getCapabilities().getProviderTermForNetworkFirewall(Locale.getDefault()));
        Assert.assertNotNull((String)"Precedence requirement may not be null", (Object)support.getCapabilities().identifyPrecedenceRequirement());
        Assert.assertNotNull((String)"List of source types may not be null", (Object)sources);
        Assert.assertNotNull((String)"List of destination types may not be null", (Object)destinations);
        Assert.assertNotNull((String)"List of supported directions may not be null", (Object)directions);
        Assert.assertNotNull((String)"List of supported permissions may not be null", (Object)permissions);
        if (subscribed) {
            Assert.assertTrue((String)"There must be at least one source type", (boolean)sources.iterator().hasNext());
            Assert.assertTrue((String)"There must be at least one destination type", (boolean)destinations.iterator().hasNext());
            Assert.assertTrue((String)"There must be at least one supported direction", (boolean)directions.iterator().hasNext());
            Assert.assertTrue((String)"There must be at least one supported permission", (boolean)permissions.iterator().hasNext());
        }
    }

    @Test
    public void getBogusNetworkFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Firewall fw = support.getFirewall(UUID.randomUUID().toString());
        tm.out("Bogus Network Firewall", fw);
        Assert.assertNull((String)"Found a network firewall for a bogus ID when none should have been found", (Object)fw);
    }

    @Test
    public void getNetworkFirewall() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId != null) {
            Firewall fw = support.getFirewall(this.testFirewallId);
            tm.out("Network Firewall", fw);
            Assert.assertNotNull((String)("No network firewall was found for the test firewall ID " + this.testFirewallId), (Object)fw);
        } else if (!support.isSubscribed()) {
            tm.ok("Test was not run because this account is not subscribed for network firewalls");
        } else {
            Assert.fail((String)("No test network firewall exists for the test " + this.name.getMethodName()));
        }
    }

    private void assertFirewall(@Nonnull Firewall firewall) {
        Assert.assertNotNull((String)"The firewall ID may not be null", (Object)firewall.getProviderFirewallId());
        Assert.assertNotNull((String)"The firewall name may not be null", (Object)firewall.getName());
        Assert.assertNotNull((String)"The firewall description may not be null", (Object)firewall.getDescription());
        Assert.assertNotNull((String)"The firewall region may not be null", (Object)firewall.getRegionId());
        Assert.assertNotNull((String)"The firewall VLAN may not be null", (Object)firewall.getProviderVlanId());
        Assert.assertNotNull((String)"The firewall tags may not be null", (Object)firewall.getTags());
        Assert.assertEquals((String)"The firewall is in the wrong region", (Object)tm.getContext().getRegionId(), (Object)firewall.getRegionId());
    }

    @Test
    public void networkFirewallContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId != null) {
            Firewall firewall = support.getFirewall(this.testFirewallId);
            Assert.assertNotNull((String)"Unable to find the test firewall", (Object)firewall);
            tm.out("Firewall ID", firewall.getProviderFirewallId());
            tm.out("Active", firewall.isActive());
            tm.out("Available", firewall.isAvailable());
            tm.out("Name", firewall.getName());
            tm.out("Region ID", firewall.getRegionId());
            tm.out("VLAN ID", firewall.getProviderVlanId());
            tm.out("Subnets", Arrays.toString(firewall.getSubnetAssociations()));
            Map tags = firewall.getTags();
            if (tags != null) {
                for (Map.Entry entry : tags.entrySet()) {
                    tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            tm.out("Description", firewall.getDescription());
            this.assertFirewall(firewall);
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test firewall has been established, but " + tm.getProvider().getCloudName() + " supports network firewalls"));
        } else {
            tm.ok("No network firewalls in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listFirewalls() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Collection firewalls = support.listFirewalls();
        int count = 0;
        Assert.assertNotNull((String)"The list of firewalls may be empty, but it may never be null", (Object)firewalls);
        for (Firewall fw : firewalls) {
            ++count;
            tm.out("Network Firewall", fw);
        }
        tm.out("Total Network Firewall Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The network firewall count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no network firewalls were provided in the results for validation");
        }
        if (count > 0) {
            for (Firewall fw : firewalls) {
                this.assertFirewall(fw);
            }
        }
    }

    @Test
    public void listFirewallStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable firewalls = support.listFirewallStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of network firewall status may be empty, but it may never be null", (Object)firewalls);
        for (ResourceStatus fw : firewalls) {
            ++count;
            tm.out("Network Firewall Status", fw);
        }
        tm.out("Total Network Firewall Status Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The network firewall status count should be zero since this account is not subscribed to this service", (long)0L, (long)count);
        } else if (count == 0) {
            tm.warn("This test is likely invalid as no network firewall status items were provided in the results for validation");
        }
    }

    @Test
    public void compareFirewallListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Collection firewalls = support.listFirewalls();
        Iterable status = support.listFirewallStatus();
        Assert.assertNotNull((String)"listFirewalls() must return at least an empty collections and may not be null", (Object)firewalls);
        Assert.assertNotNull((String)"listFirewallStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (Firewall firewall : firewalls) {
            current = (Map)map.get(firewall.getProviderFirewallId());
            if (current == null) {
                current = new HashMap();
                map.put(firewall.getProviderFirewallId(), current);
            }
            current.put("firewall", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean f = (Boolean)((Map)entry.getValue()).get("firewall");
            Assert.assertTrue((String)("Status and network firewall lists do not match for " + (String)entry.getKey()), (s != null && f != null && s != false && f != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }

    private void assertRule(@Nonnull String fwId, @Nonnull FirewallRule rule) {
        Assert.assertNotNull((String)"The firewall rule ID may not be null", (Object)rule.getProviderRuleId());
        Assert.assertNotNull((String)"The firewall ID may not be null", (Object)rule.getFirewallId());
        Assert.assertEquals((String)"The firewall ID for the rule should match the firewall", (Object)fwId, (Object)rule.getFirewallId());
        Assert.assertTrue((String)"Precedence must be non-negative", (rule.getPrecedence() >= 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"The firewall rule direction must be non-null", (Object)rule.getDirection());
        Assert.assertNotNull((String)"The firewall permission must not be null", (Object)rule.getPermission());
        Assert.assertNotNull((String)"The firewall source must not be null", (Object)rule.getSourceEndpoint());
        Assert.assertNotNull((String)"The firewall destination must not be null", (Object)rule.getDestinationEndpoint());
        Assert.assertNotNull((String)"The firewall protocol must not be null", (Object)rule.getProtocol());
    }

    @Test
    public void listRules() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testFirewallId != null) {
            Iterable rules = support.listRules(this.testFirewallId);
            int count = 0;
            Assert.assertNotNull((String)"The rules associated with a network firewall may be empty, but they may not be null", (Object)rules);
            for (FirewallRule rule : rules) {
                ++count;
                tm.out("Rule for " + this.testFirewallId, rule);
            }
            if (count < 1) {
                tm.warn("No rules were associated with this network firewall, so the test may be invalid");
            } else if (count > 0) {
                for (FirewallRule rule : rules) {
                    this.assertRule(this.testFirewallId, rule);
                }
            }
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test network firewall has been established, but " + tm.getProvider().getCloudName() + " supports VLAN firewalls"));
        } else {
            tm.ok("No network firewalls in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void ruleContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        NetworkFirewallSupport support = services.getNetworkFirewallSupport();
        if (support == null) {
            tm.ok("Network firewalls are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        for (Firewall fw : support.listFirewalls()) {
            Iterator rules;
            String id = fw.getProviderFirewallId();
            if (id == null || !(rules = support.listRules(id).iterator()).hasNext()) continue;
            FirewallRule rule = (FirewallRule)rules.next();
            tm.out("Rule ID", rule.getProviderRuleId());
            tm.out("Firewall ID", rule.getFirewallId());
            tm.out("Precedence", rule.getPrecedence());
            tm.out("Permission", rule.getPermission());
            tm.out("Direction", rule.getDirection());
            tm.out("Source", rule.getSourceEndpoint());
            tm.out("Protocol", rule.getProtocol());
            tm.out("Destination", rule.getDestinationEndpoint());
            tm.out("Start Port", rule.getStartPort());
            tm.out("End Port", rule.getEndPort());
            this.assertRule(id, rule);
            return;
        }
        if (!support.isSubscribed()) {
            tm.ok("This account is not subscribed for firewalls");
        } else {
            tm.warn("No firewall rules exist in this cloud currently, so this test may not be valid");
        }
    }
}

