/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.net.Inet6Address;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessStaticIPTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testIpAddress;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessStaticIPTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    public static void assertVersion(IpAddress address, IPVersion version) {
        String ip = address.getRawAddress().getIpAddress();
        Assert.assertNotNull((String)("IP is null and thus not valid " + version), (Object)ip);
        if (version.equals((Object)IPVersion.IPV4)) {
            String[] parts = ip.split("\\.");
            if (parts.length == 4) {
                for (String p : parts) {
                    try {
                        int x = Integer.parseInt(p);
                        Assert.assertTrue((String)("Invalid quad " + p + " in IPv4 address"), (x > -1 && x < 256 ? 1 : 0) != 0);
                    }
                    catch (NumberFormatException e) {
                        Assert.fail((String)("Invalid quad " + p + " in IPv4 address"));
                    }
                }
            } else {
                Assert.fail((String)("IP " + ip + " is not a valid IPv4 address"));
            }
        } else {
            try {
                Assert.assertNotNull((String)("IP " + ip + " is not a valid IPv6 address"), (Object)Inet6Address.getByName(ip));
            }
            catch (Exception e) {
                Assert.fail((String)("IP " + ip + " is not a valid IPv6 address"));
            }
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().contains("IPv6")) {
            this.testIpAddress = tm.getTestStaticIpId("stateless", false, IPVersion.IPV6, false, null);
            if (this.testIpAddress == null) {
                tm.getTestStaticIpId("stateless", false, IPVersion.IPV6, true, null);
            }
        } else {
            this.testIpAddress = tm.getTestStaticIpId("stateless", false, IPVersion.IPV4, false, null);
            if (this.testIpAddress == null) {
                tm.getTestStaticIpId("stateless", false, IPVersion.IPV4, true, null);
            }
        }
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertContent(@Nonnull IpAddress address, @Nonnull IPVersion expectedVersion, boolean unassignedOnly) {
        Assert.assertNotNull((String)"The IP address version must not be null", (Object)address.getVersion());
        Assert.assertEquals((String)"The IP address version does not match the expected version", (Object)expectedVersion, (Object)address.getVersion());
        StatelessStaticIPTests.assertVersion(address, expectedVersion);
        Assert.assertNotNull((String)"The IP address ID may not be null", (Object)address.getProviderIpAddressId());
        Assert.assertNotNull((String)"The region ID associated with the IP address may not be null", (Object)address.getRegionId());
        Assert.assertNotNull((String)"Address type may not be null", (Object)address.getAddressType());
        if (unassignedOnly) {
            Assert.assertFalse((String)"Expected only available addresses", (boolean)address.isAssigned());
        }
        if (address.isAssigned()) {
            Assert.assertTrue((String)"Address indicates that it is assigned, but does not reflect what it is assigned to", (address.getProviderLoadBalancerId() != null || address.getServerId() != null || address.getProviderNetworkInterfaceId() != null ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"The address indicates that it is unassigned, but it shows itself as being attached to something", (address.getProviderLoadBalancerId() == null && address.getServerId() == null && address.getProviderNetworkInterfaceId() == null ? 1 : 0) != 0);
        }
        Assert.assertNotNull((String)"The raw address for the IP address may not be null", (Object)address.getRawAddress());
        Assert.assertEquals((String)"The deprecated getAddress() does not match the new getRawAddress().getIpAddress()", (Object)address.getRawAddress().getIpAddress(), (Object)address.getAddress());
    }

    private void list(IPVersion version, boolean unassignedOnly) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        IpAddressSupport support = services == null ? null : services.getIpAddressSupport();
        boolean supported = false;
        if (support == null) {
            tm.ok("Static IP address services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
            if (!v.equals((Object)version)) continue;
            supported = true;
            break;
        }
        Iterable addresses = support.listIpPool(version, unassignedOnly);
        int count = 0;
        for (IpAddress address : addresses) {
            ++count;
            tm.out(version + " Address", address);
        }
        tm.out("Total " + (unassignedOnly ? "Available " : "") + version + " Addresses", count);
        if (!supported) {
            Assert.assertEquals((String)"An unsupported protocol should return an empty list", (long)0L, (long)count);
        } else {
            for (IpAddress address : addresses) {
                this.assertContent(address, version, unassignedOnly);
            }
            if (count < 1) {
                tm.warn("There were no " + version + " addresses in the region; this test may not be valid");
            }
        }
    }

    private void listStatus(IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        IpAddressSupport support = services == null ? null : services.getIpAddressSupport();
        boolean supported = false;
        if (support == null) {
            tm.ok("Static IP address services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
            if (!v.equals((Object)version)) continue;
            supported = true;
            break;
        }
        Iterable addresses = support.listIpPoolStatus(version);
        int count = 0;
        for (ResourceStatus address : addresses) {
            ++count;
            tm.out(version + " Address Status", address);
        }
        tm.out("Total IP Address Status", count);
        if (!supported) {
            Assert.assertEquals((String)"An unsupported protocol should return an empty list", (long)0L, (long)count);
        } else if (count < 1) {
            tm.warn("There were no " + version + " addresses in the region; this test may not be valid");
        }
    }

    private void compareStatus(IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            IpAddressSupport support = services.getIpAddressSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Iterable addresses = support.listIpPool(version, false);
                Iterable status = support.listIpPoolStatus(version);
                Assert.assertNotNull((String)"listipPool() must return at least an empty collections and may not be null", (Object)addresses);
                Assert.assertNotNull((String)"listIpPoolStatus() must return at least an empty collection and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (IpAddress ipAddress : addresses) {
                    current = (Map)map.get(ipAddress.getProviderIpAddressId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(ipAddress.getProviderIpAddressId(), current);
                    }
                    current.put("address", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean a = (Boolean)((Map)entry.getValue()).get("address");
                    Assert.assertTrue((String)("Status and IP address lists do not match for " + (String)entry.getKey()), (s != null && a != null && s != false && a != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No IP address support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Static IP", support.getCapabilities().getProviderTermForIpAddress(Locale.getDefault()));
        tm.out("Specify VLAN for VLAN IP", support.getCapabilities().identifyVlanForVlanIPRequirement());
        Iterable versions = support.getCapabilities().listSupportedIPVersions();
        tm.out("IP Versions", versions);
        for (IPVersion v : IPVersion.values()) {
            tm.out("Requestable [" + v + "]", support.getCapabilities().isRequestable(v));
            tm.out("Assignable [" + v + "]", support.getCapabilities().isAssigned(v));
            tm.out("Assignable Post-launch [" + v + "]", support.getCapabilities().isAssignablePostLaunch(v));
            tm.out("Forwarding [" + v + "]", support.getCapabilities().isForwarding(v));
            tm.out("VLAN Addresses [" + v + "]", support.getCapabilities().supportsVLANAddresses(v));
        }
        Assert.assertNotNull((String)"IP versions may not be null", (Object)versions);
        Assert.assertTrue((String)"Static IP address support must provide support for at least one IP version", (boolean)versions.iterator().hasNext());
    }

    @Test
    public void getBogusAddress() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddress address = support.getIpAddress(UUID.randomUUID().toString());
        tm.out("Bogus Address", address);
        Assert.assertNull((String)"Found an address matching the bogus IP address ID", (Object)address);
    }

    @Test
    public void getAddress() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddress address = support.getIpAddress(this.testIpAddress);
        tm.out("Address", address);
        Assert.assertNotNull((String)("No IP address was found matching the test IP address ID " + this.testIpAddress), (Object)address);
    }

    @Test
    public void IPv4Content() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean supported = false;
        for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
            if (!v.equals((Object)IPVersion.IPV4)) continue;
            supported = true;
        }
        if (this.testIpAddress == null) {
            Assert.assertFalse((String)"IPv4 is supported, but there is not test IP address for this test", (boolean)supported);
            tm.ok("No support for IPv4 in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddress address = support.getIpAddress(this.testIpAddress);
        Assert.assertNotNull((String)("No IP address was found matching the test IP address ID " + this.testIpAddress), (Object)address);
        tm.out("Address ID", address.getProviderIpAddressId());
        tm.out("Assigned", address.isAssigned());
        tm.out("Reserved", address.isReserved());
        tm.out("Region ID", address.getRegionId());
        tm.out("Address", address.getRawAddress());
        tm.out("For VLAN", address.isForVlan());
        tm.out("VLAN", address.getProviderVlanId());
        tm.out("Virtual Machine ID", address.getServerId());
        tm.out("Load Balancer ID", address.getProviderLoadBalancerId());
        tm.out("NIC ID", address.getProviderNetworkInterfaceId());
        tm.out("Address Type", address.getAddressType());
        tm.out("IP Version", address.getVersion());
        this.assertContent(address, IPVersion.IPV4, false);
    }

    @Test
    public void IPv6Content() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        boolean supported = false;
        for (IPVersion v : support.getCapabilities().listSupportedIPVersions()) {
            if (!v.equals((Object)IPVersion.IPV6)) continue;
            supported = true;
        }
        if (this.testIpAddress == null) {
            Assert.assertFalse((String)"IPv6 is supported, but there is not test IP address for this test", (boolean)supported);
            tm.ok("No support for IPv6 in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddress address = support.getIpAddress(this.testIpAddress);
        Assert.assertNotNull((String)("No IP address was found matching the test IP address ID " + this.testIpAddress), (Object)address);
        tm.out("Address ID", address.getProviderIpAddressId());
        tm.out("Assigned", address.isAssigned());
        tm.out("Reserved", address.isReserved());
        tm.out("Region ID", address.getRegionId());
        tm.out("Address", address.getRawAddress());
        tm.out("For VLAN", address.isForVlan());
        tm.out("VLAN", address.getProviderVlanId());
        tm.out("Virtual Machine ID", address.getServerId());
        tm.out("Load Balancer ID", address.getProviderLoadBalancerId());
        tm.out("NIC ID", address.getProviderNetworkInterfaceId());
        tm.out("Address Type", address.getAddressType());
        tm.out("IP Version", address.getVersion());
        this.assertContent(address, IPVersion.IPV6, false);
    }

    @Test
    public void listAllIPv4() throws CloudException, InternalException {
        this.list(IPVersion.IPV4, false);
    }

    @Test
    public void listAllIPv6() throws CloudException, InternalException {
        this.list(IPVersion.IPV6, false);
    }

    @Test
    public void listAvailableIPv4() throws CloudException, InternalException {
        this.list(IPVersion.IPV4, true);
    }

    @Test
    public void listAvailableIPv6() throws CloudException, InternalException {
        this.list(IPVersion.IPV6, true);
    }

    @Test
    public void listIPv4Status() throws CloudException, InternalException {
        this.listStatus(IPVersion.IPV4);
    }

    @Test
    public void listIPv6Status() throws CloudException, InternalException {
        this.listStatus(IPVersion.IPV6);
    }

    @Test
    public void compareIPv4ListAndStatus() throws CloudException, InternalException {
        this.compareStatus(IPVersion.IPV4);
    }

    @Test
    public void compareIPv6ListAndStatus() throws CloudException, InternalException {
        this.compareStatus(IPVersion.IPV6);
    }

    private void listRules(@Nonnull IPVersion version) throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services == null) {
            tm.ok("Network services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        IpAddressSupport support = services.getIpAddressSupport();
        if (support == null) {
            tm.ok("Static IP addresses are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testIpAddress != null) {
            Iterable rules = support.listRules(this.testIpAddress);
            int count = 0;
            for (IpForwardingRule rule : rules) {
                ++count;
                tm.out("Rule", rule);
            }
            tm.out("Total Rule Count", count);
            if (count < 1) {
                if (support.getCapabilities().isForwarding(version)) {
                    tm.warn("No rules were found for the test address " + this.testIpAddress + " so this test is likely invalid");
                } else {
                    tm.ok("No rules were found in a cloud that doesn't support " + version + " forwarding");
                }
            } else if (!support.getCapabilities().isForwarding(version)) {
                Assert.fail((String)("At least one IP forwarding rule was included for a cloud in which " + version + " forwarding is not supported"));
            }
        } else if (support.getCapabilities().isForwarding(version)) {
            Assert.fail((String)("No test IP address exists for testing forwarding rules for " + version));
        } else {
            tm.ok("Forwarding for " + version + " is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listIPv4ForwardingRules() throws CloudException, InternalException {
        this.listRules(IPVersion.IPV4);
    }

    @Test
    public void listIPv6ForwardingRules() throws CloudException, InternalException {
        this.listRules(IPVersion.IPV6);
    }
}

