/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessVLANTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testSubnetId;
    private String testInternetGatewayId;
    private String testVLANId;
    private String testRoutingTableId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessVLANTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testVLANId = tm.getTestVLANId("stateless", false, null);
        if (this.testVLANId == null) {
            this.testVLANId = tm.getTestVLANId("stateless", true, null);
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.testSubnetId = tm.getTestSubnetId("stateless", false, null, null);
        if (this.testSubnetId == null) {
            this.testSubnetId = tm.getTestSubnetId("stateless", true, null, null);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.testInternetGatewayId = tm.getTestInternetGatewayId("stateless", false, null, null);
        if (this.testInternetGatewayId == null) {
            this.testInternetGatewayId = tm.getTestInternetGatewayId("stateless", true, null, null);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.testRoutingTableId = tm.getTestRoutingTableId("stateless", false, null, null);
        if (this.testRoutingTableId == null) {
            this.testRoutingTableId = tm.getTestRoutingTableId("stateless", true, null, null);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertSubnetContent(@Nonnull VLANSupport support, @Nonnull Subnet subnet, @Nullable String vlanId) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The subnet ID may not be null", (Object)subnet.getProviderSubnetId());
        Assert.assertNotNull((String)"The subnet owner may not be null", (Object)subnet.getProviderOwnerId());
        Assert.assertNotNull((String)"The subnet region ID may not be null", (Object)subnet.getProviderRegionId());
        Assert.assertNotNull((String)"The subnet VLAN ID may not be null", (Object)subnet.getProviderVlanId());
        if (support.getCapabilities().isSubnetDataCenterConstrained()) {
            Assert.assertNotNull((String)"The subnet data center ID may not be null when subnets are data center constrained", (Object)subnet.getProviderDataCenterId());
        }
        Assert.assertNotNull((String)"The subnet's current state may not be null", (Object)subnet.getCurrentState());
        Assert.assertNotNull((String)"The subnet name may not be null", (Object)subnet.getName());
        Assert.assertNotNull((String)"The subnet description may not be null", (Object)subnet.getDescription());
        Assert.assertEquals((String)"The subnet in question does not belong in the current region", (Object)tm.getContext().getRegionId(), (Object)subnet.getProviderRegionId());
        IPVersion[] traffic = subnet.getSupportedTraffic();
        Assert.assertNotNull((String)"The list of supported IP traffic may not be null", (Object)traffic);
        Assert.assertTrue((String)"The subnet must support at least one version of IP traffic", (traffic.length > 0 ? 1 : 0) != 0);
        if (!support.getCapabilities().allowsMultipleTrafficTypesOverSubnet()) {
            Assert.assertTrue((String)"The subnet can support exactly one version of IP traffic", (traffic.length == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"The count of available IP addresses must be -1 for unknown or non-negative", (subnet.getAvailableIpAddresses() >= -1 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"The list of allocation pools must not be null", (Object)subnet.getAllocationPools());
        Assert.assertNotNull((String)"The subnet CIDR may not be null", (Object)subnet.getCidr());
        Assert.assertNotNull((String)"The subnet meta-data tags may not be null", (Object)subnet.getTags());
        if (vlanId != null) {
            Assert.assertEquals((String)"The test VLAN ID does not match the VLAN of the subnet", (Object)vlanId, (Object)subnet.getProviderVlanId());
        }
    }

    private void assertInternetGatewayContent(@Nonnull InternetGateway internetGateway, @Nullable String vlanId) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The internet gateway ID may not be null", (Object)internetGateway.getProviderInternetGatewayId());
        Assert.assertNotNull((String)"The internet gateway owner may not be null", (Object)internetGateway.getProviderOwnerId());
        Assert.assertNotNull((String)"The internet gateway region ID may not be null", (Object)internetGateway.getProviderRegionId());
        Assert.assertNotNull((String)"The internet gateway VLAN ID may not be null", (Object)internetGateway.getProviderVlanId());
        Assert.assertEquals((String)"The internet gateway in question does not belong in the current region", (Object)tm.getContext().getRegionId(), (Object)internetGateway.getProviderRegionId());
        Assert.assertNotNull((String)"The internet gateway state cannot be null", (Object)internetGateway.getAttachmentState());
        if (vlanId != null) {
            Assert.assertEquals((String)"The test VLAN ID does not match the VLAN of the internet gateway", (Object)vlanId, (Object)internetGateway.getProviderVlanId());
        }
    }

    private void assertVLANContent(@Nonnull VLANSupport support, @Nonnull VLAN network) throws CloudException, InternalException {
        Assert.assertNotNull((String)"VLAN ID may not be null", (Object)network.getProviderVlanId());
        Assert.assertNotNull((String)"Account owner may not be null", (Object)network.getProviderOwnerId());
        Assert.assertNotNull((String)"Region ID may not be null", (Object)network.getProviderRegionId());
        if (support.getCapabilities().isVlanDataCenterConstrained()) {
            Assert.assertNotNull((String)"Data center ID may not be null when VLANs are data center constrained", (Object)network.getProviderDataCenterId());
        }
        Assert.assertNotNull((String)"VLAN state may not be null", (Object)network.getCurrentState());
        Assert.assertNotNull((String)"VLAN name may not be null", (Object)network.getName());
        Assert.assertNotNull((String)"VLAN description may not be null", (Object)network.getDescription());
        Assert.assertNotNull((String)"VLAN CIDR may not be null", (Object)network.getCidr());
        IPVersion[] traffic = network.getSupportedTraffic();
        Assert.assertNotNull((String)"VLAN supported network traffic may not be null", (Object)traffic);
        Assert.assertTrue((String)"The VLAN must support at least one version of IP traffic", (traffic.length > 0 ? 1 : 0) != 0);
        if (!support.getCapabilities().allowsMultipleTrafficTypesOverVlan()) {
            Assert.assertTrue((String)"The VLAN can support exactly one version of IP traffic", (traffic.length == 1 ? 1 : 0) != 0);
        }
        Assert.assertNotNull((String)"VLAN DNS servers may not be null", (Object)network.getDnsServers());
        Assert.assertNotNull((String)"VLAN NTP servers may not be null", (Object)network.getNtpServers());
        Assert.assertNotNull((String)"VLAN meta-data tags must not be null", (Object)network.getTags());
        Assert.assertEquals((String)"The VLAN in question does not belong in the current region", (Object)tm.getContext().getRegionId(), (Object)network.getProviderRegionId());
    }

    private void assertRouteTableContent(@Nonnull RoutingTable rtb) throws CloudException, InternalException {
        Assert.assertNotNull((String)"Routing Table ID may not be null", (Object)rtb.getProviderRoutingTableId());
        Assert.assertNotNull((String)"Account owner may not be null", (Object)rtb.getProviderOwnerId());
        Assert.assertNotNull((String)"Region ID may not be null", (Object)rtb.getProviderRegionId());
        Assert.assertNotNull((String)"Routing Table name may not be null", (Object)rtb.getName());
        Assert.assertNotNull((String)"Routing Table description may not be null", (Object)rtb.getDescription());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                tm.out("Subscribed", support.isSubscribed());
                tm.out("Term for VLAN", support.getCapabilities().getProviderTermForVlan(Locale.getDefault()));
                tm.out("Term for Subnet", support.getCapabilities().getProviderTermForSubnet(Locale.getDefault()));
                tm.out("Max VLAN Count", support.getCapabilities().getMaxVlanCount() == -2 ? "Unknown" : (support.getCapabilities().getMaxVlanCount() == -1 ? "Unlimited" : Integer.valueOf(support.getCapabilities().getMaxVlanCount())));
                tm.out("VLAN DC Constrained", support.getCapabilities().isVlanDataCenterConstrained());
                tm.out("Subnet DC Constrained", support.getCapabilities().isSubnetDataCenterConstrained());
                tm.out("Specify DC for Subnet", support.getCapabilities().identifySubnetDCRequirement());
                tm.out("Supports Subnets", support.getCapabilities().getSubnetSupport());
                tm.out("Allows VLAN Creation", support.getCapabilities().allowsNewVlanCreation());
                tm.out("Allows Subnet Creation", support.getCapabilities().allowsNewSubnetCreation());
                Iterable versions = support.getCapabilities().listSupportedIPVersions();
                tm.out("Supported Traffic", versions);
                tm.out("Multiple Traffic Types per VLAN", support.getCapabilities().allowsMultipleTrafficTypesOverVlan());
                tm.out("Multiple Traffic Types per Subnet", support.getCapabilities().allowsMultipleTrafficTypesOverSubnet());
                Assert.assertNotNull((String)"The term for a VLAN may not be null", (Object)support.getCapabilities().getProviderTermForVlan(Locale.getDefault()));
                Assert.assertNotNull((String)"The term for a subnet may not be null", (Object)support.getCapabilities().getProviderTermForSubnet(Locale.getDefault()));
                Assert.assertNotNull((String)"Specify DC for subnet may not be null", (Object)support.getCapabilities().identifySubnetDCRequirement());
                Assert.assertTrue((String)"isSubnetDataCenterConstrained() value conflicts with DC specification requirement", (support.getCapabilities().isSubnetDataCenterConstrained() || support.getCapabilities().identifySubnetDCRequirement().equals((Object)Requirement.NONE) ? 1 : 0) != 0);
                Assert.assertTrue((String)"The maximum VLAN count must be -2 (Unknown), -1 (Unlimited), or non-negative", (support.getCapabilities().getMaxVlanCount() >= -2 ? 1 : 0) != 0);
                Assert.assertNotNull((String)"Subnet requirement must be non-null", (Object)support.getCapabilities().getSubnetSupport());
                if (support.getCapabilities().allowsNewSubnetCreation()) {
                    Assert.assertTrue((String)"The cloud allows new subnet creation, but VLAN subnet requirement is NONE", (!support.getCapabilities().getSubnetSupport().equals((Object)Requirement.NONE) ? 1 : 0) != 0);
                }
                Assert.assertNotNull((String)"The supported IP versions list may not be null", (Object)versions);
                Assert.assertTrue((String)"There must be at least one IP version with supported traffic", (boolean)versions.iterator().hasNext());
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getBogusVLAN() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                VLAN network = support.getVlan(UUID.randomUUID().toString());
                tm.out("Bogus VLAN", network);
                Assert.assertNull((String)"Bogus network was supposed to be null, but got a valid VLAN", (Object)network);
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getVLAN() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    VLAN network = support.getVlan(this.testVLANId);
                    tm.out("VLAN", network);
                    Assert.assertNotNull((String)"The test VLAN was not found in the cloud", (Object)network);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void vlanContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    VLAN network = support.getVlan(this.testVLANId);
                    Assert.assertNotNull((String)"The test VLAN was not found in the cloud", (Object)network);
                    tm.out("VLAN ID", network.getProviderVlanId());
                    tm.out("Current State", network.getCurrentState());
                    tm.out("Name", network.getName());
                    tm.out("Owner Account", network.getProviderOwnerId());
                    tm.out("Region ID", network.getProviderRegionId());
                    tm.out("Data Center ID", network.getProviderDataCenterId());
                    tm.out("CIDR", network.getCidr());
                    tm.out("Network Type", network.getNetworkType());
                    tm.out("Supported Traffic", Arrays.toString(network.getSupportedTraffic()));
                    tm.out("Domain Name", network.getDomainName());
                    tm.out("DNS Servers", Arrays.toString(network.getDnsServers()));
                    tm.out("NTP Servers", Arrays.toString(network.getNtpServers()));
                    tm.out("Internet Gateway", support.isConnectedViaInternetGateway(this.testVLANId));
                    Map tags = network.getTags();
                    if (tags != null) {
                        for (Map.Entry entry : tags.entrySet()) {
                            tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    tm.out("Description", network.getDescription());
                    Assert.assertEquals((String)"The ID requested does not match the ID returned", (Object)this.testVLANId, (Object)network.getProviderVlanId());
                    this.assertVLANContent(support, network);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listVLANs() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                Iterable vlans = support.listVlans();
                int count = 0;
                Assert.assertNotNull((String)"The list of VLANs may not be null (though it can be empty)", (Object)vlans);
                for (VLAN vlan : vlans) {
                    ++count;
                    tm.out("VLAN", vlan);
                }
                tm.out("Total VLAN Count", count);
                if (!support.isSubscribed()) {
                    Assert.assertTrue((String)"The call to list VLANs returned VLANs even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No VLANs appeared in the list and thus the test may not be valid");
                }
                if (count > 0) {
                    for (VLAN vlan : support.listVlans()) {
                        this.assertVLANContent(support, vlan);
                    }
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listRoutingTablesForVlan() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    Iterable rtbs = support.listRoutingTablesForVlan(this.testVLANId);
                    int count = 0;
                    Assert.assertNotNull((String)"The list of Routing Tables may not be null (though it can be empty)", (Object)rtbs);
                    for (RoutingTable rtb : rtbs) {
                        ++count;
                        tm.out("Routing Table", rtb);
                    }
                    tm.out("Total Routing Table Count", count);
                    if (!support.isSubscribed()) {
                        Assert.assertTrue((String)"The call to list Route Tables returned Route Tables even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                    } else if (count == 0) {
                        tm.warn("No Route Tables appeared in the list and thus the test may not be valid");
                    }
                    if (count > 0) {
                        for (RoutingTable rtb : support.listRoutingTablesForVlan(this.testVLANId)) {
                            this.assertRouteTableContent(rtb);
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listRoutingTablesForSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null) {
                    Iterable rtbs = support.listRoutingTablesForSubnet(this.testSubnetId);
                    int count = 0;
                    Assert.assertNotNull((String)"The list of Routing Tables may not be null (though it can be empty)", (Object)rtbs);
                    for (RoutingTable rtb : rtbs) {
                        ++count;
                        tm.out("Routing Table", rtb);
                    }
                    tm.out("Total Routing Table Count", count);
                    if (!support.isSubscribed()) {
                        Assert.assertTrue((String)"The call to list Route Tables returned Route Tables even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                    } else if (count == 0) {
                        tm.warn("No Route Tables appeared in the list and thus the test may not be valid");
                    }
                    if (count > 0) {
                        for (RoutingTable rtb : support.listRoutingTablesForVlan(this.testVLANId)) {
                            this.assertRouteTableContent(rtb);
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN/Subnet was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test Subnet was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listVLANStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                Iterable vlans = support.listVlanStatus();
                int count = 0;
                Assert.assertNotNull((String)"The VLAN status list may not be null (though it can be empty)", (Object)vlans);
                for (ResourceStatus status : vlans) {
                    ++count;
                    tm.out("VLAN Status", status);
                }
                tm.out("Total VLAN Status Count", count);
                if (!support.isSubscribed()) {
                    Assert.assertTrue((String)"The call to list VLAN status returned VLANs even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                } else if (count == 0) {
                    tm.warn("No VLANs appeared in the status list and thus the test may not be valid");
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void compareVLANListAndStatus() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                Map<String, Boolean> current;
                HashMap map = new HashMap();
                Iterable vlans = support.listVlans();
                Iterable status = support.listVlanStatus();
                Assert.assertNotNull((String)"listVLANs() must return at least an empty collections and may not be null", (Object)vlans);
                Assert.assertNotNull((String)"listVLANStatus() must return at least an empty collection and may not be null", (Object)status);
                for (ResourceStatus resourceStatus : status) {
                    current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
                    if (current == null) {
                        current = new HashMap<String, Boolean>();
                        map.put(resourceStatus.getProviderResourceId(), current);
                    }
                    current.put("status", true);
                }
                for (VLAN vLAN : vlans) {
                    current = (Map)map.get(vLAN.getProviderVlanId());
                    if (current == null) {
                        current = new HashMap();
                        map.put(vLAN.getProviderVlanId(), current);
                    }
                    current.put("vlan", true);
                }
                for (Map.Entry entry : map.entrySet()) {
                    Boolean s = (Boolean)((Map)entry.getValue()).get("status");
                    Boolean v = (Boolean)((Map)entry.getValue()).get("vlan");
                    Assert.assertTrue((String)("Status and VLAN lists do not match for " + (String)entry.getKey()), (s != null && v != null && s != false && v != false ? 1 : 0) != 0);
                }
                tm.out("Matches");
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getBogusSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                Subnet subnet = support.getSubnet(UUID.randomUUID().toString());
                tm.out("Bogus Subnet", subnet);
                Assert.assertNull((String)"Bogus subnet was supposed to be null, but got a valid subnet", (Object)subnet);
            } else {
                tm.ok("No subnet support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null) {
                    Subnet subnet = support.getSubnet(this.testSubnetId);
                    tm.out("Subnet", subnet);
                    Assert.assertNotNull((String)"The test subnet was not found in the cloud", (Object)subnet);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test subnet was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getSubnetSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Subnets are not supported so there is no test for " + this.name.getMethodName());
                } else {
                    Assert.fail((String)("No test subnet was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getBogusRouteTable() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                RoutingTable rtb = support.getRoutingTable(UUID.randomUUID().toString());
                tm.out("Bogus Route Table", rtb);
                Assert.assertNull((String)"Bogus route table was supposed to be null, but got a valid route table", (Object)rtb);
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getRouteTable() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testRoutingTableId != null) {
                    RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Route Table", rtb);
                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                } else {
                    Assert.fail((String)("No test route table was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getBogusInternetGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                InternetGateway internetGateway = support.getInternetGatewayById(UUID.randomUUID().toString());
                tm.out("Bogus Internet Gateway", internetGateway);
                Assert.assertNull((String)"Bogus internet gateway was supposed to be null, but got a valid internet gateway", (Object)internetGateway);
            } else {
                tm.ok("No internet gateway support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void getInternetGateway() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testInternetGatewayId != null) {
                    InternetGateway iGateway = support.getInternetGatewayById(this.testInternetGatewayId);
                    tm.out("Internet Gateway", iGateway);
                    Assert.assertNotNull((String)"The test internet gateway was not found in the cloud", (Object)iGateway);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test internet gatway was identified for tests due to a lack of subscription to VLAN support");
                } else if (!support.getCapabilities().supportsInternetGatewayCreation()) {
                    tm.ok("Internet Gateways are not supported so there is no test for " + this.name.getMethodName());
                } else {
                    Assert.fail((String)("No test internet gateway was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void subnetContent() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null) {
                    Subnet subnet = support.getSubnet(this.testSubnetId);
                    Assert.assertNotNull((String)"The test subnet was not found in the cloud", (Object)subnet);
                    tm.out("Subnet ID", subnet.getProviderSubnetId());
                    tm.out("Current State", subnet.getCurrentState());
                    tm.out("Name", subnet.getName());
                    tm.out("Owner Account", subnet.getProviderOwnerId());
                    tm.out("Region ID", subnet.getProviderRegionId());
                    tm.out("Data Center ID", subnet.getProviderDataCenterId());
                    tm.out("VLAN ID", subnet.getProviderVlanId());
                    tm.out("CIDR", subnet.getCidr());
                    tm.out("Available IPs", subnet.getAvailableIpAddresses());
                    tm.out("Allocation Pools", Arrays.toString(subnet.getAllocationPools()));
                    tm.out("Gateway", subnet.getGateway());
                    tm.out("Supported Traffic", Arrays.toString(subnet.getSupportedTraffic()));
                    Map tags = subnet.getTags();
                    if (tags != null) {
                        for (Map.Entry entry : tags.entrySet()) {
                            tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    tm.out("Description", subnet.getDescription());
                    Assert.assertEquals((String)"The requested subnet ID does not match the ID of the subnet returned", (Object)this.testSubnetId, (Object)subnet.getProviderSubnetId());
                    this.assertSubnetContent(support, subnet, null);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test subnet was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getSubnetSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Subnets are not supported so there is no test for " + this.name.getMethodName());
                } else {
                    Assert.fail((String)("No test subnet was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listSubnets() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    Iterable subnets = support.listSubnets(this.testVLANId);
                    int count = 0;
                    Assert.assertNotNull((String)"The list of subnets may not be null (though it can be empty)", (Object)subnets);
                    for (Subnet subnet : subnets) {
                        ++count;
                        tm.out("Subnet", subnet);
                    }
                    tm.out("Total Subnet Count for " + this.testVLANId, count);
                    if (!support.isSubscribed()) {
                        Assert.assertTrue((String)"The call to list subnets returned subnets even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                    } else if (count == 0) {
                        tm.warn("No subnets appeared in the list and thus the test may not be valid");
                    }
                    if (count > 0) {
                        for (Subnet subnet : subnets) {
                            this.assertSubnetContent(support, subnet, this.testVLANId);
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listInternetGateways() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    Collection internetGateways = support.listInternetGateways(this.testVLANId);
                    int count = 0;
                    Assert.assertNotNull((String)"The list of internet gateways may not be null (though it can be empty)", (Object)internetGateways);
                    for (InternetGateway internetgateway : internetGateways) {
                        ++count;
                        tm.out("Internet Gateway", internetgateway);
                    }
                    tm.out("Total Internet Gateway Count for " + this.testVLANId, count);
                    if (!support.isSubscribed()) {
                        Assert.assertTrue((String)"The call to list internet gateways returned internet gateways even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                    } else if (count == 0) {
                        tm.warn("No internet gateways appeared in the list and thus the test may not be valid");
                    }
                    if (count > 0) {
                        for (InternetGateway internetgateway : internetGateways) {
                            this.assertInternetGatewayContent(internetgateway, this.testVLANId);
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void listResources() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testVLANId != null) {
                    Iterable resources = support.listResources(this.testVLANId);
                    int count = 0;
                    Assert.assertNotNull((String)"The list of VLAN resources may be empty, but it cannot be null", (Object)resources);
                    for (Networkable n : resources) {
                        ++count;
                        tm.out("VLAN Resource", n);
                    }
                    tm.out("Total VLAN Resource Count", count);
                    if (!support.isSubscribed()) {
                        Assert.assertTrue((String)"The call to list VLAN resources returned resources even though the account is marked as not subscribed", (count == 0 ? 1 : 0) != 0);
                    } else if (count == 0) {
                        tm.warn("No resources appeared in the list and thus the test may not be valid");
                    }
                } else if (!support.isSubscribed()) {
                    tm.ok("No test VLAN was identified for tests due to a lack of subscription to VLAN support");
                } else {
                    Assert.fail((String)("No test VLAN was found for running the stateless test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void assignRouteTableToSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null && this.testRoutingTableId != null) {
                    RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Route Table", rtb);
                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                    Subnet subnet = support.getSubnet(this.testSubnetId);
                    tm.out("Subnet", subnet);
                    Assert.assertNotNull((String)"The test subnet was not found in the cloud", (Object)subnet);
                    support.assignRoutingTableToSubnet(this.testSubnetId, this.testRoutingTableId);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Route Table", rtb);
                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                    tm.out("Route Table subnets", rtb.getProviderSubnetIds());
                    Assert.assertTrue((String)"The test route table subnets should not be empty", (rtb.getProviderSubnetIds().length > 0 ? 1 : 0) != 0);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                } else if (this.testSubnetId == null) {
                    Assert.fail((String)("No test subnet was found for running the stateful test: " + this.name.getMethodName()));
                } else {
                    Assert.fail((String)("No test route table was found for running the stateful test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }

    @Test
    public void disassociateRouteTableFromSubnet() throws CloudException, InternalException {
        NetworkServices services = tm.getProvider().getNetworkServices();
        if (services != null) {
            VLANSupport support = services.getVlanSupport();
            if (support != null) {
                if (this.testSubnetId != null && this.testRoutingTableId != null) {
                    RoutingTable rtb = support.getRoutingTable(this.testRoutingTableId);
                    tm.out("Route Table", rtb);
                    Assert.assertNotNull((String)"The test route table was not found in the cloud", (Object)rtb);
                    Subnet subnet = support.getSubnet(this.testSubnetId);
                    tm.out("Subnet", subnet);
                    Assert.assertNotNull((String)"The test subnet was not found in the cloud", (Object)subnet);
                    support.disassociateRoutingTableFromSubnet(this.testSubnetId, this.testRoutingTableId);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    rtb = support.getRoutingTable(this.testRoutingTableId);
                    Boolean match = false;
                    if (rtb != null) {
                        tm.out("Route Table subnets", rtb.getProviderSubnetIds());
                        String[] rtbSubArr = rtb.getProviderSubnetIds();
                        if (rtbSubArr != null) {
                            for (String subnetId : rtbSubArr) {
                                if (!subnetId.equals(this.testSubnetId)) continue;
                                match = true;
                            }
                        }
                    }
                    Assert.assertFalse((String)"The test route table subnets should not not contain test subnet id", (boolean)match);
                } else if (!support.isSubscribed()) {
                    tm.ok("No test route table was identified for tests due to a lack of subscription to VLAN support");
                } else if (support.getCapabilities().getRoutingTableSupport().equals((Object)Requirement.NONE)) {
                    tm.ok("Route Tables are not supported so there is no test for " + this.name.getMethodName());
                } else if (this.testSubnetId == null) {
                    Assert.fail((String)("No test subnet was found for running the stateful test: " + this.name.getMethodName()));
                } else {
                    Assert.fail((String)("No test route table was found for running the stateful test: " + this.name.getMethodName()));
                }
            } else {
                tm.ok("No VLAN support in this cloud");
            }
        } else {
            tm.ok("No network services in this cloud");
        }
    }
}

