/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.platform.MQCreateOptions;
import org.dasein.cloud.platform.MQSupport;
import org.dasein.cloud.platform.MessageQueue;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.platform.Topic;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.storage.StorageResources;

public class PlatformResources {
    private static final Logger logger = Logger.getLogger(PlatformResources.class);
    private static final Random random = new Random();
    private final HashMap<String, String> testCDNs = new HashMap();
    private final HashMap<String, String> testQueues = new HashMap();
    private final HashMap<String, String> testRDBMS = new HashMap();
    private final HashMap<String, String> testTopics = new HashMap();
    private CloudProvider provider;
    ExecutorService service = Executors.newCachedThreadPool();

    public PlatformResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    private boolean canRemove(@Nullable Database db) {
        if (db == null) {
            return true;
        }
        switch (db.getCurrentState()) {
            case DELETING: 
            case DELETED: 
            case AVAILABLE: 
            case STORAGE_FULL: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    public int close() {
        int count;
        block31: {
            count = 0;
            try {
                boolean done;
                RelationalDatabaseSupport rdbmsSupport;
                PushNotificationSupport pushSupport;
                MQSupport mqSupport;
                PlatformServices services = this.provider.getPlatformServices();
                if (services == null) break block31;
                ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
                CDNSupport cdnSupport = services.getCDNSupport();
                if (cdnSupport != null) {
                    for (Map.Entry<String, String> entry : this.testCDNs.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            Distribution d = cdnSupport.getDistribution(entry.getValue());
                            if (d != null) {
                                results.add(this.cleanCDN(cdnSupport, entry.getValue()));
                                ++count;
                                continue;
                            }
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test CDN " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                }
                if ((mqSupport = services.getMessageQueueSupport()) != null) {
                    for (Map.Entry<String, String> entry : this.testQueues.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            MessageQueue mq = mqSupport.getMessageQueue(entry.getValue());
                            if (mq != null) {
                                mqSupport.removeMessageQueue(mq.getProviderMessageQueueId(), "Dasein Cloud test clean-up");
                                ++count;
                                continue;
                            }
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test message queue " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                }
                if ((pushSupport = services.getPushNotificationSupport()) != null) {
                    for (Map.Entry<String, String> entry : this.testTopics.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            Topic topic = pushSupport.getTopic(entry.getValue());
                            if (topic != null) {
                                pushSupport.removeTopic(entry.getValue());
                                ++count;
                                continue;
                            }
                            ++count;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to de-provision test notification topic " + entry.getValue() + ": " + t.getMessage()));
                        }
                    }
                }
                if ((rdbmsSupport = services.getRelationalDatabaseSupport()) != null) {
                    for (Map.Entry<String, String> entry : this.testRDBMS.entrySet()) {
                        if (entry.getKey().equals("stateless")) continue;
                        try {
                            long l = System.currentTimeMillis() + 1200000L;
                            Database db = rdbmsSupport.getDatabase(entry.getValue());
                            while (l > System.currentTimeMillis() && !this.canRemove(db)) {
                                try {
                                    Thread.sleep(15000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    db = rdbmsSupport.getDatabase(db.getProviderDatabaseId());
                                }
                                catch (Throwable ignore) {}
                            }
                            if (db != null && !db.getCurrentState().equals((Object)DatabaseState.DELETED) && !db.getCurrentState().equals((Object)DatabaseState.DELETING)) {
                                rdbmsSupport.removeDatabase(entry.getValue());
                                ++count;
                                continue;
                            }
                            ++count;
                        }
                        catch (Throwable throwable) {
                            logger.warn((Object)("Failed to de-provision test relational database " + entry.getValue() + ": " + throwable.getMessage()));
                        }
                    }
                }
                block21: do {
                    done = true;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    for (Future future : results) {
                        if (future.isDone()) continue;
                        done = false;
                        continue block21;
                    }
                } while (!done);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return count;
    }

    private Future<Boolean> cleanCDN(final @Nonnull CDNSupport support, final @Nonnull String distributionId) {
        return this.service.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                support.delete(distributionId);
                return true;
            }
        });
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testRDBMS.remove("stateless");
        if (!this.testRDBMS.isEmpty()) {
            logger.info((Object)"Provisioned Platform Resources:");
            header = true;
            count += this.testRDBMS.size();
            DaseinTestManager.out(logger, null, "---> RDBMS Instances", this.testRDBMS.size() + " " + this.testRDBMS);
        }
        this.testCDNs.remove("stateless");
        if (!this.testCDNs.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Platform Resources:");
                header = true;
            }
            count += this.testCDNs.size();
            DaseinTestManager.out(logger, null, "---> CDN Distributions", this.testCDNs.size() + " " + this.testCDNs);
        }
        this.testQueues.remove("stateless");
        if (!this.testQueues.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Platform Resources:");
                header = true;
            }
            count += this.testQueues.size();
            DaseinTestManager.out(logger, null, "---> Message Queues", this.testQueues.size() + " " + this.testQueues);
        }
        this.testTopics.remove("stateless");
        if (!this.testTopics.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Platform Resources:");
            }
            count += this.testTopics.size();
            DaseinTestManager.out(logger, null, "---> Notification Topics", this.testTopics.size() + " " + this.testTopics);
        }
        return count;
    }

    @Nullable
    public String getTestDistributionId(@Nonnull String label, boolean provisionIfNull, @Nullable String origin) {
        CDNSupport support;
        PlatformServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testCDNs.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessDistribution();
        }
        String id = this.testCDNs.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getPlatformServices()) != null && (support = services.getCDNSupport()) != null) {
            try {
                return this.provisionDistribution(support, label, "Dasein CDN", origin);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestQueueId(@Nonnull String label, boolean provisionIfNull) {
        MQSupport mqSupport;
        PlatformServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testQueues.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessMQ();
        }
        String id = this.testQueues.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getPlatformServices()) != null && (mqSupport = services.getMessageQueueSupport()) != null) {
            try {
                return this.provisionMQ(mqSupport, label, "dsnmq");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestRDBMSId(@Nonnull String label, boolean provisionIfNull, @Nullable DatabaseEngine engine) {
        RelationalDatabaseSupport rdbmsSupport;
        PlatformServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testRDBMS.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessRDBMS();
        }
        String id = this.testRDBMS.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getPlatformServices()) != null && (rdbmsSupport = services.getRelationalDatabaseSupport()) != null) {
            try {
                return this.provisionRDBMS(rdbmsSupport, label, "dsnrdbms", engine);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestTopicId(@Nonnull String label, boolean provisionIfNull) {
        PushNotificationSupport support;
        PlatformServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testTopics.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessTopic();
        }
        String id = this.testTopics.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getPlatformServices()) != null && (support = services.getPushNotificationSupport()) != null) {
            try {
                return this.provisionTopic(support, label, "dsntopic");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessDistribution() {
        PlatformServices services = this.provider.getPlatformServices();
        if (services != null) {
            CDNSupport support = services.getCDNSupport();
            try {
                Iterator dists;
                if (support != null && support.isSubscribed() && (dists = support.list().iterator()).hasNext()) {
                    String id = ((Distribution)dists.next()).getProviderDistributionId();
                    this.testCDNs.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessMQ() {
        PlatformServices services = this.provider.getPlatformServices();
        if (services != null) {
            MQSupport mqSupport = services.getMessageQueueSupport();
            try {
                Iterator queues;
                if (mqSupport != null && mqSupport.isSubscribed() && (queues = mqSupport.listMessageQueues().iterator()).hasNext()) {
                    String id = ((MessageQueue)queues.next()).getProviderMessageQueueId();
                    this.testQueues.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessRDBMS() {
        PlatformServices services = this.provider.getPlatformServices();
        if (services != null) {
            RelationalDatabaseSupport rdbmsSupport = services.getRelationalDatabaseSupport();
            try {
                Iterator databases;
                if (rdbmsSupport != null && rdbmsSupport.isSubscribed() && (databases = rdbmsSupport.listDatabases().iterator()).hasNext()) {
                    String id = ((Database)databases.next()).getProviderDatabaseId();
                    this.testRDBMS.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String findStatelessTopic() {
        PlatformServices services = this.provider.getPlatformServices();
        if (services != null) {
            PushNotificationSupport support = services.getPushNotificationSupport();
            try {
                Iterator topics;
                if (support != null && support.isSubscribed() && (topics = support.listTopics().iterator()).hasNext()) {
                    String id = ((Topic)topics.next()).getProviderTopicId();
                    this.testTopics.put("stateless", id);
                    return id;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionDistribution(@Nonnull CDNSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable String origin) throws CloudException, InternalException {
        Blob bucket;
        StorageResources r;
        if (origin == null && (r = DaseinTestManager.getStorageResources()) != null && (bucket = r.getTestRootBucket(label, true, null)) != null) {
            origin = bucket.getBucketName();
        }
        if (origin == null) {
            origin = "http://localhost";
        }
        String id = support.create(origin, namePrefix + random.nextInt(10000), true, new String[]{"dsncdn" + random.nextInt(10000) + ".dasein.org"});
        HashMap<String, String> hashMap = this.testCDNs;
        synchronized (hashMap) {
            while (this.testCDNs.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testCDNs.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionMQ(@Nonnull MQSupport support, @Nonnull String label, @Nonnull String namePrefix) throws CloudException, InternalException {
        MQCreateOptions options = MQCreateOptions.getInstance((String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Test MQ auto-provisioned by Dasein Cloud integration tests");
        String id = support.createMessageQueue(options);
        HashMap<String, String> hashMap = this.testQueues;
        synchronized (hashMap) {
            while (this.testQueues.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testQueues.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionRDBMS(@Nonnull RelationalDatabaseSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable DatabaseEngine engine) throws CloudException, InternalException {
        String password = "a" + random.nextInt(100000000);
        while (password.length() < 20) {
            password = password + random.nextInt(10);
        }
        DatabaseProduct product = null;
        if (engine != null) {
            for (DatabaseProduct p : support.getDatabaseProducts(engine)) {
                if (product != null && !(product.getStandardHourlyRate() > p.getStandardHourlyRate())) continue;
                product = p;
            }
        } else {
            for (DatabaseEngine e : support.getDatabaseEngines()) {
                for (DatabaseProduct p : support.getDatabaseProducts(e)) {
                    if (product != null && !(product.getStandardHourlyRate() > p.getStandardHourlyRate())) continue;
                    product = p;
                }
            }
        }
        if (product == null) {
            throw new CloudException("No database product could be identified");
        }
        String version = support.getDefaultVersion(product.getEngine());
        String id = support.createFromScratch(namePrefix + System.currentTimeMillis() % 10000L, product, version, "dasein", password, 3000);
        if (id == null) {
            throw new CloudException("No database was generated");
        }
        HashMap<String, String> hashMap = this.testRDBMS;
        synchronized (hashMap) {
            while (this.testRDBMS.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testRDBMS.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionTopic(@Nonnull PushNotificationSupport support, @Nonnull String label, @Nonnull String namePrefix) throws CloudException, InternalException {
        String id = support.createTopic(namePrefix + random.nextInt(10000)).getProviderTopicId();
        HashMap<String, String> hashMap = this.testTopics;
        synchronized (hashMap) {
            while (this.testTopics.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testTopics.put(label, id);
        }
        return id;
    }
}

