/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.platform.PlatformResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulCDNTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDistributionId;
    private Blob testOrigin;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulCDNTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("removeDistribution")) {
            this.testOrigin = tm.getTestBucket(this.name.getMethodName(), true, true);
            if (this.testOrigin != null) {
                this.testDistributionId = tm.getTestDistributionId("removed", true, this.testOrigin.getBucketName());
            }
        } else if (this.name.getMethodName().equals("createDistribution")) {
            this.testOrigin = tm.getTestBucket(this.name.getMethodName(), true, true);
        } else {
            this.testOrigin = tm.getTestBucket("statefulCDN", true, true);
            if (this.testOrigin != null) {
                this.testDistributionId = tm.getTestDistributionId("stateful", true, this.testOrigin.getBucketName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testDistributionId = null;
            this.testOrigin = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void createDistribution() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testOrigin != null) {
            PlatformResources r = DaseinTestManager.getPlatformResources();
            if (r != null) {
                String id = r.provisionDistribution(support, "provision", "dsncdn", this.testOrigin.getBucketName());
                tm.out("Created", id);
                Assert.assertNotNull((String)("No ID was provided from the creation of a distribution from " + this.testOrigin), (Object)id);
                Distribution d = support.getDistribution(id);
                Assert.assertNotNull((String)("No distribution can be found under the new ID " + id), (Object)d);
            }
        } else if (!support.isSubscribed()) {
            tm.ok("CDN support is not subscribed so this test is not valid");
        } else {
            Assert.fail((String)"No test origin is in place so this test cannot be run");
        }
    }

    @Test
    public void changeName() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            Distribution d = support.getDistribution(this.testDistributionId);
            String newName = "Dasein New " + System.currentTimeMillis();
            Assert.assertNotNull((String)("No test distribution exists for the ID " + this.testDistributionId), (Object)d);
            tm.out("Before", d.getName());
            support.update(this.testDistributionId, newName, d.isActive(), d.getAliases());
            Distribution updated = support.getDistribution(this.testDistributionId);
            Assert.assertNotNull((String)"The distribution disappeared after update", (Object)updated);
            tm.out("After", updated.getName());
            Assert.assertEquals((String)"The distribution active state incorrectly changed after the update", (Object)d.isActive(), (Object)updated.isActive());
            TreeSet old = new TreeSet();
            TreeSet na = new TreeSet();
            Collections.addAll(old, d.getAliases());
            Collections.addAll(na, updated.getAliases());
            Assert.assertEquals((String)"The old aliases and new aliases have differing sizes", (long)old.size(), (long)na.size());
            Iterator oit = old.iterator();
            Iterator nit = na.iterator();
            while (oit.hasNext()) {
                Assert.assertEquals((String)"The old aliases and new aliases no longer match", oit.next(), nit.next());
            }
        } else if (!support.isSubscribed()) {
            tm.ok("CDN support is not subscribed so this test is not valid");
        } else {
            Assert.fail((String)"No test distribution is in place so this test cannot be run");
        }
    }

    @Test
    public void changeAliases() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            String[] stringArray;
            Distribution d = support.getDistribution(this.testDistributionId);
            Assert.assertNotNull((String)("No test distribution exists for the ID " + this.testDistributionId), (Object)d);
            String[] oldAliases = d.getAliases();
            if (oldAliases.length < 1) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "sp" + System.currentTimeMillis() + ".dasein.org";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = d.getAliases()[0];
                stringArray = stringArray3;
                stringArray3[1] = "sp" + System.currentTimeMillis() + ".dasein.org";
            }
            String[] newAliases = stringArray;
            tm.out("Before", Arrays.toString(d.getAliases()));
            support.update(this.testDistributionId, d.getName(), d.isActive(), newAliases);
            Distribution updated = support.getDistribution(this.testDistributionId);
            Assert.assertNotNull((String)"The distribution disappeared after update", (Object)updated);
            tm.out("After", Arrays.toString(updated.getAliases()));
            Assert.assertEquals((String)"The distribution name changed incorrectly after the update", (Object)d.getName(), (Object)updated.getName());
            Assert.assertEquals((String)"The distribution active state incorrectly changed after the update", (Object)d.isActive(), (Object)updated.isActive());
        } else if (!support.isSubscribed()) {
            tm.ok("CDN support is not subscribed so this test is not valid");
        } else {
            Assert.fail((String)"No test distribution is in place so this test cannot be run");
        }
    }

    @Test
    public void deactivate() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            Distribution d = support.getDistribution(this.testDistributionId);
            Assert.assertNotNull((String)("No test distribution exists for the ID " + this.testDistributionId), (Object)d);
            Assert.assertTrue((String)"The test distribution is not active, cannot activate it", (boolean)d.isActive());
            tm.out("Before", d.isActive());
            support.update(this.testDistributionId, d.getName(), false, d.getAliases());
            long timeout = System.currentTimeMillis() + 300000L;
            Distribution updated = null;
            while (System.currentTimeMillis() < timeout) {
                try {
                    updated = support.getDistribution(this.testDistributionId);
                    if (updated == null || !updated.isActive()) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
            Assert.assertNotNull((String)"The distribution disappeared after update", updated);
            tm.out("After", updated.isActive());
            Assert.assertEquals((String)"The distribution active state failed to change after deactivation", (Object)false, (Object)updated.isActive());
            Assert.assertEquals((String)"The distribution name changed incorrectly after the update", (Object)d.getName(), (Object)updated.getName());
            TreeSet old = new TreeSet();
            TreeSet na = new TreeSet();
            Collections.addAll(old, d.getAliases());
            Collections.addAll(na, updated.getAliases());
            Assert.assertEquals((String)"The old aliases and new aliases have differing sizes", (long)old.size(), (long)na.size());
            Iterator oit = old.iterator();
            Iterator nit = na.iterator();
            while (oit.hasNext()) {
                Assert.assertEquals((String)"The old aliases and new aliases no longer match", oit.next(), nit.next());
            }
        } else if (!support.isSubscribed()) {
            tm.ok("CDN support is not subscribed so this test is not valid");
        } else {
            Assert.fail((String)"No test distribution is in place so this test cannot be run");
        }
    }

    @Test
    public void removeDistribution() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            Distribution d = support.getDistribution(this.testDistributionId);
            tm.out("Before", d);
            Assert.assertNotNull((String)("No such test distribution: " + this.testDistributionId), (Object)d);
            support.delete(this.testDistributionId);
            d = support.getDistribution(this.testDistributionId);
            tm.out("After", d);
            Assert.assertTrue((String)"The test distribution still exists post-deletion", (d == null || !d.isActive() && !d.isDeployed() ? 1 : 0) != 0);
        } else if (!support.isSubscribed()) {
            tm.ok("CDN support is not subscribed so this test is not valid");
        } else {
            Assert.fail((String)"No test distribution is in place so this test cannot be run");
        }
    }
}

