/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulMQTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testQueueId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulMQTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equalsIgnoreCase("removeMessageQueue")) {
            this.testQueueId = tm.getTestQueueId("removed", true);
        } else if (!this.name.getMethodName().equalsIgnoreCase("createMessageQueue")) {
            this.testQueueId = tm.getTestQueueId("stateful", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testQueueId = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void createMessageQueue() throws CloudException, InternalException {
    }

    @Test
    public void removeMessageQueue() throws CloudException, InternalException {
    }

    @Test
    public void sendMessage() throws CloudException, InternalException {
    }

    @Test
    public void receiveMessage() throws CloudException, InternalException {
    }

    @Test
    public void receiveMessages() throws CloudException, InternalException {
    }
}

