/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.platform.Alarm;
import org.dasein.cloud.platform.AlarmFilterOptions;
import org.dasein.cloud.platform.AlarmUpdateOptions;
import org.dasein.cloud.platform.Metric;
import org.dasein.cloud.platform.MetricFilterOptions;
import org.dasein.cloud.platform.MonitoringSupport;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulMonitoringTests {
    private static final Logger logger = Logger.getLogger(StatefulMonitoringTests.class);
    private static final String DASEIN_PREFIX = "dasein-alarm-";
    private String provisionedAlarmName;
    private static DaseinTestManager tm;
    private String availableMetricName;
    private String availableMetricNamespace;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulMonitoringTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        String methodName = this.name.getMethodName();
        tm.begin(methodName);
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.setAvailableMetricProperties();
        if ("testListAlarms".equals(methodName)) {
            this.addTestAlarm();
        } else if ("testListAlarmsWithFilter".equals(methodName)) {
            this.addTestAlarm();
        } else if ("testRemoveAlarms".equals(methodName)) {
            this.addTestAlarm();
        } else if ("testEnableAlarmActions".equals(methodName)) {
            this.addTestAlarm();
        } else if ("testDisableAlarmActions".equals(methodName)) {
            this.addTestAlarm();
        } else {
            logger.debug((Object)("No pre-test work for: " + methodName));
        }
    }

    @After
    public void after() {
        try {
            if (this.provisionedAlarmName != null) {
                this.getSupport().removeAlarms(new String[]{this.provisionedAlarmName});
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)ex);
        }
        this.provisionedAlarmName = null;
        tm.end();
    }

    private void addTestAlarm() {
        MonitoringSupport support = this.getSupport();
        if (support == null || this.provisionedAlarmName != null) {
            return;
        }
        try {
            String alarmName = DASEIN_PREFIX + this.getRandomId();
            AlarmUpdateOptions options = AlarmUpdateOptions.getInstance((String)alarmName, (String)this.availableMetricNamespace, (String)this.availableMetricName, (String)"SampleCount", (String)"GreaterThanOrEqualToThreshold", (double)0.0, (int)60, (int)1);
            support.updateAlarm(options);
            this.provisionedAlarmName = alarmName;
        }
        catch (Throwable ex) {
            logger.warn((Object)ex);
        }
    }

    private void setAvailableMetricProperties() {
        MonitoringSupport support = this.getSupport();
        if (support == null || this.availableMetricName != null) {
            return;
        }
        try {
            Collection metrics = support.listMetrics(MetricFilterOptions.getInstance());
            Assert.assertTrue((String)"No metrics available to work with.", (metrics.size() > 0 ? 1 : 0) != 0);
            Metric firstMetric = (Metric)metrics.iterator().next();
            this.availableMetricName = firstMetric.getName();
            this.availableMetricNamespace = firstMetric.getNamespace();
        }
        catch (Throwable ex) {
            logger.warn((Object)ex);
        }
    }

    @Test
    public void testListMetrics() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support != null) {
            Collection metrics = support.listMetrics(MetricFilterOptions.getInstance());
            Assert.assertNotNull((Object)metrics);
            for (Metric metric : metrics) {
                this.assertMetric(metric);
            }
        } else {
            tm.ok("No MonitoringSupport in this cloud");
        }
    }

    @Test
    public void testListMetricsWithFilter() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support != null) {
            Collection metrics = support.listMetrics(MetricFilterOptions.getInstance().withMetricNamespace(this.availableMetricNamespace).withMetricName(this.availableMetricName));
            Assert.assertNotNull((Object)metrics);
            for (Metric metric : metrics) {
                this.assertMetric(metric);
                if (this.availableMetricNamespace != null) {
                    Assert.assertEquals((Object)this.availableMetricNamespace, (Object)metric.getNamespace());
                }
                Assert.assertEquals((Object)this.availableMetricName, (Object)metric.getName());
            }
        } else {
            tm.ok("No MonitoringSupport in this cloud");
        }
    }

    @Test
    public void testListMetricsWithBadFilter() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support != null) {
            Collection metrics = support.listMetrics(MetricFilterOptions.getInstance().withMetricName("asdf"));
            Assert.assertNotNull((Object)metrics);
            for (Metric metric : metrics) {
                this.assertMetric(metric);
                Assert.assertEquals((Object)this.availableMetricName, (Object)metric.getName());
            }
        } else {
            tm.ok("No MonitoringSupport in this cloud");
        }
    }

    @Test
    public void testListAlarms() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support != null) {
            Collection alarms = support.listAlarms(AlarmFilterOptions.getInstance());
            Assert.assertNotNull((Object)alarms);
            for (Alarm alarm : alarms) {
                this.assertAlarm(alarm);
            }
        } else {
            tm.ok("No MonitoringSupport in this cloud");
        }
    }

    @Test
    public void testListAlarmsWithFilter() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support != null) {
            Collection alarms = support.listAlarms(AlarmFilterOptions.getInstance().withAlarmNames(new String[]{this.provisionedAlarmName}));
            Assert.assertNotNull((Object)alarms);
            for (Alarm alarm : alarms) {
                this.assertAlarm(alarm);
            }
        } else {
            tm.ok("No MonitoringSupport in this cloud");
        }
    }

    @Test
    public void testAddAlarm() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No MonitoringSupport in this cloud");
            return;
        }
        try {
            String alarmName = DASEIN_PREFIX + this.getRandomId();
            AlarmUpdateOptions options = AlarmUpdateOptions.getInstance((String)alarmName, (String)this.availableMetricNamespace, (String)this.availableMetricName, (String)"SampleCount", (String)"GreaterThanOrEqualToThreshold", (double)0.0, (int)60, (int)1);
            support.updateAlarm(options);
            this.provisionedAlarmName = alarmName;
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    @Test
    public void testRemoveAlarms() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No MonitoringSupport in this cloud");
            return;
        }
        try {
            support.removeAlarms(new String[]{this.provisionedAlarmName});
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    @Test
    public void testEnableAlarmActions() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No MonitoringSupport in this cloud");
            return;
        }
        try {
            support.enableAlarmActions(new String[]{this.provisionedAlarmName});
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    @Test
    public void testDisableAlarmActions() throws CloudException, InternalException {
        MonitoringSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No MonitoringSupport in this cloud");
            return;
        }
        try {
            support.disableAlarmActions(new String[]{this.provisionedAlarmName});
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    private long getRandomId() {
        return System.currentTimeMillis() % 10000L;
    }

    private void assertMetric(Metric metric) {
        Assert.assertNotNull((Object)metric);
        Assert.assertNotNull((Object)metric.getName());
        if (metric.getMetadata() != null) {
            for (Map.Entry entry : metric.getMetadata().entrySet()) {
                Assert.assertNotNull(entry.getKey());
            }
        }
    }

    private void assertAlarm(Alarm alarm) {
        Assert.assertNotNull((Object)alarm);
        Assert.assertNotNull((Object)alarm.getName());
        Assert.assertNotNull((Object)alarm.getMetric());
        if (!alarm.isFunction()) {
            Assert.assertNotNull((Object)alarm.getStatistic());
            Assert.assertNotNull((Object)alarm.getComparisonOperator());
            Assert.assertNotNull((Object)alarm.getThreshold());
        }
        Assert.assertNotNull((Object)alarm.getProviderAlarmId());
        if (alarm.getProviderOKActionIds() != null) {
            for (String id : alarm.getProviderOKActionIds()) {
                Assert.assertNotNull((Object)id);
            }
        }
        if (alarm.getProviderAlarmActionIds() != null) {
            for (String id : alarm.getProviderAlarmActionIds()) {
                Assert.assertNotNull((Object)id);
            }
        }
        if (alarm.getProviderInsufficientDataActionIds() != null) {
            for (String id : alarm.getProviderInsufficientDataActionIds()) {
                Assert.assertNotNull((Object)id);
            }
        }
        if (alarm.getMetricMetadata() != null) {
            for (Map.Entry entry : alarm.getMetricMetadata().entrySet()) {
                Assert.assertNotNull(entry.getKey());
            }
        }
    }

    private MonitoringSupport getSupport() {
        PlatformServices services = this.getServices();
        if (services != null) {
            return services.getMonitoringSupport();
        }
        return null;
    }

    private PlatformServices getServices() {
        CloudProvider provider = tm.getProvider();
        return provider.getPlatformServices();
    }
}

