/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.DataFormat;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.platform.EndpointType;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.Topic;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.platform.PlatformResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulNotificationsTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testTopicId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulNotificationsTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("publish") || this.name.getMethodName().equals("subscribe")) {
            this.testTopicId = tm.getTestTopicId("stateful", true);
        } else if (this.name.getMethodName().equals("removeTopic")) {
            this.testTopicId = tm.getTestTopicId("removed", true);
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void createTopic() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PlatformResources r = DaseinTestManager.getPlatformResources();
        if (r == null) {
            Assert.fail((String)"Failed to initialize platform resources for all tests");
        }
        if (support.isSubscribed()) {
            String topicId = r.provisionTopic(support, "provision", "dsncreatetopic");
            tm.out("New Topic", topicId);
            Assert.assertNotNull((String)"Failed to create the notification topic though the request completed", (Object)topicId);
            Topic topic = support.getTopic(topicId);
            Assert.assertNotNull((String)"Failed to create the notification topic though an ID was provided", (Object)topic);
        } else {
            tm.ok("Push notification support is not subscribed so this test is not valid");
        }
    }

    @Test
    public void publish() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            support.publish(this.testTopicId, "Dasein Test Subject " + System.currentTimeMillis(), "This is a test");
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was created to support this stateful test.");
        }
    }

    @Test
    public void subscribe() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            support.subscribe(this.testTopicId, EndpointType.EMAIL, DataFormat.PLAINTEXT, "test@example.com");
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was created to support this stateful test.");
        }
    }

    @Test
    public void removeTopic() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            Topic topic = support.getTopic(this.testTopicId);
            tm.out("Before", topic);
            Assert.assertNotNull((String)"The test topic does not exist and thus removal cannot be tested", (Object)topic);
            support.removeTopic(this.testTopicId);
            topic = support.getTopic(this.testTopicId);
            tm.out("After", topic);
            Assert.assertNull((String)"The test topic still exists post-removal", (Object)topic);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was created to support this stateful test.");
        }
    }
}

