/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.Topic;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulPushNotificationTests {
    private static final Logger logger = Logger.getLogger(StatefulPushNotificationTests.class);
    private static final String DASEIN_PREFIX = "dasein-topic-";
    private String provisionedTopicId;
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulPushNotificationTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        String methodName = this.name.getMethodName();
        tm.begin(methodName);
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if ("testListTopics".equals(methodName)) {
            this.addTestTopic();
        } else if ("testGetTopic".equals(methodName)) {
            this.addTestTopic();
        } else if ("testRemoveTopic".equals(methodName)) {
            this.addTestTopic();
        } else {
            logger.debug((Object)("No pre-test work for: " + methodName));
        }
    }

    @After
    public void after() {
        try {
            if (this.provisionedTopicId != null) {
                this.getSupport().removeTopic(this.provisionedTopicId);
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)ex);
        }
        this.provisionedTopicId = null;
        tm.end();
    }

    private void addTestTopic() {
        PushNotificationSupport support = this.getSupport();
        if (support == null || this.provisionedTopicId != null) {
            return;
        }
        try {
            String topicName = DASEIN_PREFIX + this.getRandomId();
            Topic topic = support.createTopic(topicName);
            this.provisionedTopicId = topic.getProviderTopicId();
        }
        catch (Throwable ex) {
            logger.warn((Object)ex);
        }
    }

    @Test
    public void testListTopics() throws CloudException, InternalException {
        PushNotificationSupport support = this.getSupport();
        if (support != null) {
            Collection topics = support.listTopics();
            Assert.assertNotNull((Object)topics);
            for (Topic Topic2 : topics) {
                this.assertTopic(Topic2);
            }
        } else {
            tm.ok("No PushNotificationSupport in this cloud");
        }
    }

    @Test
    public void testGetTopic() throws CloudException, InternalException {
        PushNotificationSupport support = this.getSupport();
        if (support != null) {
            Topic topic = support.getTopic(this.provisionedTopicId);
            this.assertTopic(topic);
        } else {
            tm.ok("No PushNotificationSupport in this cloud");
        }
    }

    @Test
    public void testAddTopic() throws CloudException, InternalException {
        PushNotificationSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No PushNotificationSupport in this cloud");
            return;
        }
        try {
            String topicName = DASEIN_PREFIX + this.getRandomId();
            Topic topic = support.createTopic(topicName);
            this.provisionedTopicId = topic.getProviderTopicId();
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    @Test
    public void testRemoveTopic() throws CloudException, InternalException {
        PushNotificationSupport support = this.getSupport();
        if (support == null) {
            tm.ok("No PushNotificationSupport in this cloud");
            return;
        }
        try {
            support.removeTopic(this.provisionedTopicId);
        }
        catch (OperationNotSupportedException expected) {
            tm.ok("OperationNotSupportedException thrown.");
        }
    }

    private long getRandomId() {
        return System.currentTimeMillis() % 10000L;
    }

    private void assertTopic(Topic topic) {
        Assert.assertNotNull((Object)topic);
        Assert.assertNotNull((Object)topic.getProviderTopicId());
    }

    private PushNotificationSupport getSupport() {
        PlatformServices services = this.getServices();
        if (services != null) {
            return services.getPushNotificationSupport();
        }
        return null;
    }

    private PlatformServices getServices() {
        CloudProvider provider = tm.getProvider();
        return provider.getPlatformServices();
    }
}

