/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.platform.PlatformResources;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulRDBMSTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDatabaseId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulRDBMSTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("removeDatabase")) {
            this.testDatabaseId = tm.getTestRDBMSId("removed", true, null);
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void getDefaultVersions() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Iterable engines = support.getDatabaseEngines();
        for (DatabaseEngine engine : engines) {
            Iterable versions = support.getSupportedVersions(engine);
            for (String version : versions) {
            }
        }
    }

    @Test
    public void createDatabase() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        PlatformResources p = DaseinTestManager.getPlatformResources();
        if (p != null) {
            String id = p.provisionRDBMS(support, "provisionKeypair", "dsnrdbms", null);
            tm.out("New Database", id);
            Assert.assertNotNull((String)"No database was created by this test", (Object)id);
        } else {
            Assert.fail((String)"No platform resources were initialized for the test run");
        }
    }

    @Test
    public void removeDatabase() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDatabaseId != null) {
            long timeout = System.currentTimeMillis() + 1200000L;
            Database db = support.getDatabase(this.testDatabaseId);
            while (timeout > System.currentTimeMillis() && !this.canRemove(db)) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    db = support.getDatabase(db.getProviderDatabaseId());
                }
                catch (Throwable ignore) {}
            }
            Assert.assertNotNull((String)"The test database is not found", (Object)db);
            tm.out("Before", db.getCurrentState());
            support.removeDatabase(this.testDatabaseId);
            db = support.getDatabase(this.testDatabaseId);
            DatabaseState s = db == null ? DatabaseState.DELETED : db.getCurrentState();
            tm.out("After", s);
            Assert.assertTrue((String)"Database state must be one of DELETING or DELETED (or no database found)", (s.equals((Object)DatabaseState.DELETED) || s.equals((Object)DatabaseState.DELETING) ? 1 : 0) != 0);
        } else if (support.isSubscribed()) {
            Assert.fail((String)("No test database for " + this.name.getMethodName()));
        } else {
            tm.ok("RDBMS support is not subscribed so this test is not entirely valid");
        }
    }

    private boolean canRemove(@Nullable Database db) {
        if (db == null) {
            return true;
        }
        switch (db.getCurrentState()) {
            case DELETING: 
            case DELETED: 
            case AVAILABLE: 
            case STORAGE_FULL: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }
}

