/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessCDNTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDistributionId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessCDNTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testDistributionId = tm.getTestDistributionId("stateless", false, null);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertDistribution(@Nonnull Distribution distribution) throws CloudException, InternalException {
        Assert.assertNotNull((String)"The distribution ID may not be null", (Object)distribution.getProviderDistributionId());
        Assert.assertNotNull((String)"The distribution name may not be null", (Object)distribution.getName());
        Assert.assertNotNull((String)"The distribution's owner account may not be null", (Object)distribution.getProviderOwnerId());
        Assert.assertNotNull((String)"The distribution DNS name may not be null", (Object)distribution.getDnsName());
        Assert.assertNotNull((String)"The distribution location may not be null", (Object)distribution.getLocation());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for CDN Distribution", support.getProviderTermForDistribution(Locale.getDefault()));
    }

    @Test
    public void getBogusDistribution() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Distribution d = support.getDistribution(UUID.randomUUID().toString());
        tm.out("Bogus Distribution", d);
        Assert.assertNull((String)"Found a matching distribution for the randomly generated distribution ID", (Object)d);
    }

    @Test
    public void getDistribution() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            Distribution d = support.getDistribution(this.testDistributionId);
            tm.out("Distribution", d);
            Assert.assertNotNull((String)("No distribution was found matching the test ID " + this.testDistributionId), (Object)d);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to CDN support so this test is invalid");
        } else {
            Assert.fail((String)"No test distribution was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void distributionContent() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDistributionId != null) {
            Distribution d = support.getDistribution(this.testDistributionId);
            Assert.assertNotNull((String)("No distribution was found matching the test ID " + this.testDistributionId), (Object)d);
            tm.out("Distribution ID", d.getProviderDistributionId());
            tm.out("Active", d.isActive());
            tm.out("Deployed", d.isDeployed());
            tm.out("Name", d.getName());
            tm.out("Owner Account", d.getProviderOwnerId());
            tm.out("DNS Name", d.getDnsName());
            tm.out("Aliases", Arrays.toString(d.getAliases()));
            tm.out("Location", d.getLocation());
            tm.out("Log Directory", d.getLogDirectory());
            tm.out("Log Name", d.getLogName());
            this.assertDistribution(d);
            Assert.assertEquals((String)"The distribution ID from the result does not match the request", (Object)this.testDistributionId, (Object)d.getProviderDistributionId());
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to CDN support so this test is invalid");
        } else {
            Assert.fail((String)"No test distribution was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void listDistributions() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Collection dists = support.list();
        int count = 0;
        Assert.assertNotNull((String)"The list of distributions must be non-null, even if not supported or subscribed", (Object)dists);
        for (Distribution d : dists) {
            ++count;
            tm.out("Distribution", d);
        }
        tm.out("Total Distribution Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("No distribution subscription, so this test is not valid");
            } else {
                tm.warn("No distributions were returned, so this test is not valid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Distributions were returned for an account without a distribution subscription");
        }
        for (Distribution d : dists) {
            this.assertDistribution(d);
        }
    }

    @Test
    public void listDistributionStatus() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable dists = support.listDistributionStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of distribution status objects must be non-null, even if not supported or subscribed", (Object)dists);
        for (ResourceStatus d : dists) {
            ++count;
            tm.out("Distribution Status", d);
        }
        tm.out("Total Distribution Status Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("No distribution subscription, so this test is not valid");
            } else {
                tm.warn("No distribution status was returned, so this test is not valid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Distribution status objects were returned for an account without a distribution subscription");
        }
    }

    @Test
    public void compareDistributionListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        CDNSupport support = services.getCDNSupport();
        if (support == null) {
            tm.ok("CDN is not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Collection distributions = support.list();
        Iterable status = support.listDistributionStatus();
        Assert.assertNotNull((String)"list() must return at least an empty collections and may not be null", (Object)distributions);
        Assert.assertNotNull((String)"listDistributionStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (Distribution distribution : distributions) {
            current = (Map)map.get(distribution.getProviderDistributionId());
            if (current == null) {
                current = new HashMap();
                map.put(distribution.getProviderDistributionId(), current);
            }
            current.put("distribution", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean d = (Boolean)((Map)entry.getValue()).get("distribution");
            Assert.assertTrue((String)("Status and distribution lists do not match for " + (String)entry.getKey()), (s != null && d != null && s != false && d != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }
}

