/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.platform.MQSupport;
import org.dasein.cloud.platform.MessageQueue;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessMQTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testMQId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessMQTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testMQId = tm.getTestQueueId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertMessageQueue(MessageQueue q) {
        Assert.assertNotNull((String)"The message queue owner account may not be null", (Object)q.getProviderOwnerId());
        Assert.assertNotNull((String)"The message queue region may not be null", (Object)q.getProviderRegionId());
        Assert.assertNotNull((String)"The message queue ID may not be null", (Object)q.getProviderMessageQueueId());
        Assert.assertNotNull((String)"The message queue name may not be null", (Object)q.getName());
        Assert.assertNotNull((String)"The message queue description may not be null", (Object)q.getDescription());
        Assert.assertNotNull((String)"The message queue state may not be null", (Object)q.getCurrentState());
        Assert.assertNotNull((String)"The message queue delay may not be null", (Object)q.getDelay());
        Assert.assertNotNull((String)"The message queue tags may not be null", (Object)q.getTags());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Message Queue", support.getProviderTermForMessageQueue(Locale.getDefault()));
    }

    @Test
    public void getBogusQueue() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MessageQueue q = support.getMessageQueue(UUID.randomUUID().toString());
        tm.out("Bogus Message Queue", q);
        Assert.assertNull((String)"Found a matching message queue for the randomly generated MQ ID", (Object)q);
    }

    @Test
    public void getQueue() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testMQId != null) {
            MessageQueue q = support.getMessageQueue(this.testMQId);
            tm.out("Message Queue", q);
            Assert.assertNotNull((String)("No message queue was found matching the test ID " + this.testMQId), (Object)q);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to MQ support so this test is invalid");
        } else {
            Assert.fail((String)"No test message queue was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void queueContent() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testMQId != null) {
            MessageQueue q = support.getMessageQueue(this.testMQId);
            Assert.assertNotNull((String)("No message queue was found matching the test ID " + this.testMQId), (Object)q);
            tm.out("MQ ID", q.getProviderMessageQueueId());
            tm.out("Current State", q.getCurrentState());
            tm.out("Name", q.getName());
            tm.out("Owner Account", q.getProviderOwnerId());
            tm.out("Region ID", q.getProviderRegionId());
            tm.out("Endpoint", q.getEndpoint());
            tm.out("Delay", q.getDelay());
            tm.out("Retention Period", q.getRetentionPeriod());
            tm.out("Visibility Timeout", q.getVisibilityTimeout());
            tm.out("Max Message Size", q.getMaximumMessageSize());
            Map tags = q.getTags();
            if (tags != null) {
                for (Map.Entry entry : tags.entrySet()) {
                    tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            tm.out("Description", q.getDescription());
            this.assertMessageQueue(q);
            Assert.assertEquals((String)"The message queue ID from the result does not match the request", (Object)this.testMQId, (Object)q.getProviderMessageQueueId());
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to MQ support so this test is invalid");
        } else {
            Assert.fail((String)"No test message queue was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void listQueues() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable queues = support.listMessageQueues();
        int count = 0;
        Assert.assertNotNull((String)"The list of message queues must be non-null, even if not supported or subscribed", (Object)queues);
        for (MessageQueue q : queues) {
            ++count;
            tm.out("Message Queue", q);
        }
        tm.out("Total MQ Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("No message queue subscription, so this test is not valid");
            } else {
                tm.warn("No message queues were returned, so this test is not valid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Message queues were returned for an account without a message queue subscription");
        }
        for (MessageQueue q : queues) {
            this.assertMessageQueue(q);
        }
    }

    @Test
    public void listQueueStatus() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable queues = support.listMessageQueueStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of message queue status objects must be non-null, even if not supported or subscribed", (Object)queues);
        for (ResourceStatus q : queues) {
            ++count;
            tm.out("MQ Status", q);
        }
        tm.out("Total MQ Status Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("No message queue subscription, so this test is not valid");
            } else {
                tm.warn("No message queue status was returned, so this test is not valid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Message queue status objects were returned for an account without a message queue subscription");
        }
    }

    @Test
    public void compareQueueListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        MQSupport support = services.getMessageQueueSupport();
        if (support == null) {
            tm.ok("Message queues are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Iterable queues = support.listMessageQueues();
        Iterable status = support.listMessageQueueStatus();
        Assert.assertNotNull((String)"listMessageQueues() must return at least an empty collections and may not be null", (Object)queues);
        Assert.assertNotNull((String)"listMessageQueueStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (MessageQueue messageQueue : queues) {
            current = (Map)map.get(messageQueue.getProviderMessageQueueId());
            if (current == null) {
                current = new HashMap();
                map.put(messageQueue.getProviderMessageQueueId(), current);
            }
            current.put("queue", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean q = (Boolean)((Map)entry.getValue()).get("queue");
            Assert.assertTrue((String)("Status and message queue lists do not match for " + (String)entry.getKey()), (s != null && q != null && s != false && q != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }
}

