/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.Subscription;
import org.dasein.cloud.platform.Topic;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessNotificationsTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testTopicId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessNotificationsTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testTopicId = tm.getTestTopicId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertSubscription(@Nonnull Subscription subscription) {
        Assert.assertNotNull((String)"The subscription ID may not be null", (Object)subscription.getProviderSubscriptionId());
        Assert.assertEquals((String)"The topic does not match the one it should match", (Object)this.testTopicId, (Object)subscription.getProviderTopicId());
        Assert.assertNotNull((String)"The subscription owner account may not be null", (Object)subscription.getProviderOwnerId());
        Assert.assertEquals((String)"The region ID of the returned subscription does not match the current context", (Object)tm.getContext().getRegionId(), (Object)subscription.getProviderRegionId());
        Assert.assertNotNull((String)"The name may not be null", (Object)subscription.getName());
        Assert.assertNotNull((String)"The description may not be null", (Object)subscription.getDescription());
        Assert.assertNotNull((String)"The data format may not be null", (Object)subscription.getDataFormat());
        Assert.assertNotNull((String)"The endpoint may not be null", (Object)subscription.getEndpoint());
        Assert.assertNotNull((String)"The endpoint type may not be null", (Object)subscription.getEndpointType());
    }

    private void assertTopic(@Nonnull Topic topic) {
        Assert.assertNotNull((String)"The topic ID may not be null", (Object)topic.getProviderTopicId());
        Assert.assertNotNull((String)"The topic name may not be null", (Object)topic.getName());
        Assert.assertNotNull((String)"The topic description may not be null", (Object)topic.getDescription());
        Assert.assertNotNull((String)"The topic owner account may not be null", (Object)topic.getProviderOwnerId());
        Assert.assertEquals((String)"The region ID of the returned topic does not match the current context", (Object)tm.getContext().getRegionId(), (Object)topic.getProviderRegionId());
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Topic", support.getProviderTermForTopic(Locale.getDefault()));
        tm.out("Term for Subscription", support.getProviderTermForSubscription(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for a topic may not be null", (Object)support.getProviderTermForTopic(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for a subscription may not be null", (Object)support.getProviderTermForSubscription(Locale.getDefault()));
    }

    @Test
    public void getBogusTopic() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Topic topic = support.getTopic(UUID.randomUUID().toString());
        tm.out("Bogus Topic", topic);
        Assert.assertNull((String)"The bogus topic was non-null", (Object)topic);
    }

    @Test
    public void getTopic() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            Topic topic = support.getTopic(this.testTopicId);
            tm.out("Topic", topic);
            Assert.assertNotNull((String)"The test topic was not found in the cloud", (Object)topic);
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void topicContent() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            Topic topic = support.getTopic(this.testTopicId);
            Assert.assertNotNull((String)"The test topic was not found in the cloud", (Object)topic);
            tm.out("Topic ID", topic.getProviderTopicId());
            tm.out("Active", topic.isActive());
            tm.out("Name", topic.getName());
            tm.out("Owner Account", topic.getProviderOwnerId());
            tm.out("Region ID", topic.getProviderRegionId());
            tm.out("Description", topic.getDescription());
            this.assertTopic(topic);
            Assert.assertEquals((String)"The ID of the returned topic does not match the requested ID", (Object)this.testTopicId, (Object)topic.getProviderTopicId());
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was found to support this stateless test. Please create one and run again.");
        }
    }

    @Test
    public void listTopics() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Collection topics = support.listTopics();
        int count = 0;
        Assert.assertNotNull((String)"The list of topics may not be null", (Object)topics);
        for (Topic topic : topics) {
            ++count;
            tm.out("Topic", topic);
        }
        tm.out("Total Topic Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("The topic count was 0 as it should be in an unsubscribed account");
            } else {
                tm.warn("No topics were identified in the account so this test is potentially invalid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Found topics in the account even though it is marked as unsubscribed");
        }
        for (Topic topic : topics) {
            this.assertTopic(topic);
        }
    }

    @Test
    public void listTopicStatus() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable topics = support.listTopicStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of topics may not be null", (Object)topics);
        for (ResourceStatus topic : topics) {
            ++count;
            tm.out("Topic Status", topic);
        }
        tm.out("Total Topic Status Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("The topic status count was 0 as it should be in an unsubscribed account");
            } else {
                tm.warn("No topic status objects were identified in the account so this test is potentially invalid");
            }
        } else if (!support.isSubscribed()) {
            Assert.fail((String)"Found topic status instances in the account even though it is marked as unsubscribed");
        }
    }

    @Test
    public void compareTopicListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Collection topics = support.listTopics();
        Iterable status = support.listTopicStatus();
        Assert.assertNotNull((String)"listTopics() must return at least an empty collections and may not be null", (Object)topics);
        Assert.assertNotNull((String)"listTopicStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (Topic topic : topics) {
            current = (Map)map.get(topic.getProviderTopicId());
            if (current == null) {
                current = new HashMap();
                map.put(topic.getProviderTopicId(), current);
            }
            current.put("topic", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean t = (Boolean)((Map)entry.getValue()).get("topic");
            Assert.assertTrue((String)("Status and topic lists do not match for " + (String)entry.getKey()), (s != null && t != null && s != false && t != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }

    @Test
    public void listSubscriptions() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        PushNotificationSupport support = services.getPushNotificationSupport();
        if (support == null) {
            tm.ok("Push notifications are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testTopicId != null) {
            Collection list = support.listSubscriptions(this.testTopicId);
            int count = 0;
            Assert.assertNotNull((String)"The list of subscriptions may not be null", (Object)list);
            for (Subscription subscription : list) {
                ++count;
                tm.out("Subscription", subscription);
            }
            tm.out("Total Subscription Count to " + this.testTopicId, count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("The susbcription count was 0 as it should be in an unsubscribed account");
                } else {
                    tm.warn("No subscriptions were identified for the test topic in the account so this test is potentially invalid");
                }
            } else if (!support.isSubscribed()) {
                Assert.fail((String)"Found subscriptions in the account even though it is marked as unsubscribed");
            }
            for (Subscription subscription : list) {
                this.assertSubscription(subscription);
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to push notifications support so this test is invalid");
        } else {
            Assert.fail((String)"No test topic was found to support this stateless test. Please create one and run again.");
        }
    }
}

