/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.platform;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessRDBMSTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDatabaseId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessRDBMSTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testDatabaseId = tm.getTestRDBMSId("stateless", false, null);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Database", support.getProviderTermForDatabase(Locale.getDefault()));
        tm.out("Term for Database Snapshot", support.getProviderTermForSnapshot(Locale.getDefault()));
        tm.out("Supports Firewall Rules", support.isSupportsFirewallRules());
        tm.out("High Availability Support", support.isSupportsHighAvailability());
        tm.out("Low Availability Support", support.isSupportsLowAvailability());
        tm.out("Maintenance Window Support", support.isSupportsMaintenanceWindows());
        tm.out("Supports Snapshots", support.isSupportsSnapshots());
        Iterable engines = support.getDatabaseEngines();
        if (engines != null) {
            for (DatabaseEngine engine : engines) {
                tm.out("Default Version [" + engine + "]", support.getDefaultVersion(engine));
            }
            for (DatabaseEngine engine : engines) {
                tm.out("Supported Versions [" + engine + "]", support.getSupportedVersions(engine));
            }
        }
        Assert.assertNotNull((String)"The provider term for a database may not be null", (Object)support.getProviderTermForDatabase(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for a database snapshot may not be null", (Object)support.getProviderTermForSnapshot(Locale.getDefault()));
        for (DatabaseEngine engine : support.getDatabaseEngines()) {
            Iterable products = support.getDatabaseProducts(engine);
            Iterable versions = support.getSupportedVersions(engine);
            Assert.assertNotNull((String)("The list of database products for " + engine + " may not be null, even if not supported"), (Object)products);
            Assert.assertNotNull((String)("The list of supported database versions for " + engine + " may not be null, even if not supported"), (Object)versions);
            if (!support.isSubscribed() || engines == null) continue;
            for (DatabaseEngine supported : engines) {
                if (!supported.equals((Object)engine)) continue;
                Assert.assertTrue((String)("There must be at least one supported version for every supported database engine (" + engine + " missing)"), (boolean)versions.iterator().hasNext());
            }
        }
        if (engines != null) {
            for (DatabaseEngine engine : engines) {
                Assert.assertNotNull((String)("The default version for a supported database engine (" + engine + ") cannot be null"), (Object)support.getDefaultVersion(engine));
            }
        }
    }

    @Test
    public void listDatabaseEngines() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Iterable engines = support.getDatabaseEngines();
        int count = 0;
        Assert.assertNotNull((String)"The list of database engines may not be null", (Object)engines);
        for (DatabaseEngine engine : engines) {
            ++count;
            tm.out("RDBMS Engine", engine);
        }
        tm.out("Total Database Engine Count", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("This account is not subscribed to RDBMS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            } else {
                Assert.fail((String)"There must be at least one supported database engine");
            }
        }
    }

    @Test
    public void listDatabaseProducts() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Iterable engines = support.getDatabaseEngines();
        for (DatabaseEngine engine : DatabaseEngine.values()) {
            Iterable products = support.getDatabaseProducts(engine);
            int count = 0;
            Assert.assertNotNull((String)"The list of database products may not be null, even if the engine is not supported", (Object)products);
            for (DatabaseProduct product : products) {
                ++count;
                tm.out("RDBMS Product [" + engine + "]", product);
            }
            tm.out("Total " + engine + " Database Product Count", count);
            boolean supported = false;
            for (DatabaseEngine dbe : engines) {
                if (!dbe.equals((Object)engine)) continue;
                supported = true;
                break;
            }
            if (count >= 1) continue;
            if (!support.isSubscribed()) {
                tm.ok("This account is not subscribed to RDBMS support in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
                continue;
            }
            if (!supported) continue;
            Assert.fail((String)("There must be at least one product for each supported database engine (missing one for " + engine + ")"));
        }
    }

    @Test
    public void getBogusDatabase() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Database database = support.getDatabase(UUID.randomUUID().toString());
        tm.out("Bogus Database", database);
        Assert.assertNull((String)"The random UUID resulted in a database being returned, should be null", (Object)database);
    }

    @Test
    public void getDatabase() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDatabaseId != null) {
            Database database = support.getDatabase(this.testDatabaseId);
            tm.out("Database", database);
            Assert.assertNotNull((String)"The test database returned null", (Object)database);
        } else if (!support.isSubscribed()) {
            tm.ok("This account is not subscribed to relational database support in " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)"No test database has been identified for this test");
        }
    }

    private void assertDatabase(@Nonnull Database db) {
        Assert.assertNotNull((String)"Database ID is null", (Object)db.getProviderDatabaseId());
        Assert.assertNotNull((String)"Status is null", (Object)db.getCurrentState());
        Assert.assertNotNull((String)"Name is null", (Object)db.getName());
        Assert.assertNotNull((String)"Product is null", (Object)db.getProductSize());
        Assert.assertNotNull((String)"Region is null", (Object)db.getProviderRegionId());
        Assert.assertNotNull((String)"Engine is null", (Object)db.getEngine());
        Assert.assertEquals((String)"Region must match the current region", (Object)tm.getContext().getRegionId(), (Object)db.getProviderRegionId());
    }

    @Test
    public void databaseContent() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testDatabaseId != null) {
            Database db = support.getDatabase(this.testDatabaseId);
            Assert.assertNotNull((String)"The test database returned null", (Object)db);
            tm.out("RDBMS ID", db.getProviderDatabaseId());
            tm.out("Current State", db.getCurrentState());
            tm.out("Name", db.getName());
            tm.out("Created", new Date(db.getCreationTimestamp()));
            tm.out("Owner Account", db.getProviderOwnerId());
            tm.out("Region ID", db.getProviderRegionId());
            tm.out("Data Center ID", db.getProviderDataCenterId());
            tm.out("Product", db.getProductSize());
            tm.out("Engine", db.getEngine());
            tm.out("High Availability", db.isHighAvailability());
            tm.out("Location", db.getHostName() + ":" + db.getHostPort());
            tm.out("Storage", db.getAllocatedStorageInGb() + " GB");
            tm.out("Recovery Point", new Date(db.getRecoveryPointTimestamp()));
            tm.out("Snapshot Window", db.getSnapshotWindow());
            tm.out("Snapshot Retention", new TimePeriod((Number)db.getSnapshotRetentionInDays(), (TimePeriodUnit)TimePeriod.DAY));
            tm.out("Maintenance Window", db.getMaintenanceWindow());
            tm.out("Admin User", db.getAdminUser());
            tm.out("Configuration", db.getConfiguration());
            this.assertDatabase(db);
        } else if (!support.isSubscribed()) {
            tm.ok("This account is not subscribed to relational database support in " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)"No test database has been identified for this test");
        }
    }

    @Test
    public void listDatabases() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Iterable databases = support.listDatabases();
        int count = 0;
        Assert.assertNotNull((String)"The list of databases may not be null, even if not subscribed", (Object)databases);
        for (Database db : databases) {
            ++count;
            tm.out("Database", db);
        }
        tm.out("Total Database Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The database count must be zero since the account is not subscribed", (long)0L, (long)count);
        } else if (count < 1) {
            tm.warn("This test is likely invalid as no databases were provided in the results for validation");
        }
        for (Database db : databases) {
            this.assertDatabase(db);
        }
    }

    @Test
    public void listDatabaseStatus() throws CloudException, InternalException {
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        Iterable databases = support.listDatabaseStatus();
        int count = 0;
        Assert.assertNotNull((String)"The list of databases may not be null, even if not subscribed", (Object)databases);
        for (ResourceStatus db : databases) {
            ++count;
            tm.out("Database Status", db);
        }
        tm.out("Total Database Status Count", count);
        if (!support.isSubscribed()) {
            Assert.assertEquals((String)"The database status count must be zero since the account is not subscribed", (long)0L, (long)count);
        } else if (count < 1) {
            tm.warn("This test is likely invalid as no database status items were provided in the results for validation");
        }
    }

    @Test
    public void compareDatabaseListAndStatus() throws CloudException, InternalException {
        Map<String, Boolean> current;
        PlatformServices services = tm.getProvider().getPlatformServices();
        if (services == null) {
            tm.ok("Platform services are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        RelationalDatabaseSupport support = services.getRelationalDatabaseSupport();
        if (support == null) {
            tm.ok("Relational database support is not implemented for " + tm.getContext().getRegionId() + " in " + tm.getProvider().getCloudName());
            return;
        }
        HashMap map = new HashMap();
        Iterable databases = support.listDatabases();
        Iterable status = support.listDatabaseStatus();
        Assert.assertNotNull((String)"listDatabases() must return at least an empty collections and may not be null", (Object)databases);
        Assert.assertNotNull((String)"listDatabaseStatus() must return at least an empty collection and may not be null", (Object)status);
        for (ResourceStatus resourceStatus : status) {
            current = (HashMap<String, Boolean>)map.get(resourceStatus.getProviderResourceId());
            if (current == null) {
                current = new HashMap<String, Boolean>();
                map.put(resourceStatus.getProviderResourceId(), current);
            }
            current.put("status", true);
        }
        for (Database database : databases) {
            current = (Map)map.get(database.getProviderDatabaseId());
            if (current == null) {
                current = new HashMap();
                map.put(database.getProviderDatabaseId(), current);
            }
            current.put("database", true);
        }
        for (Map.Entry entry : map.entrySet()) {
            Boolean s = (Boolean)((Map)entry.getValue()).get("status");
            Boolean d = (Boolean)((Map)entry.getValue()).get("database");
            Assert.assertTrue((String)("Status and database lists do not match for " + (String)entry.getKey()), (s != null && d != null && s != false && d != false ? 1 : 0) != 0);
        }
        tm.out("Matches");
    }
}

