/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.storage.StorageResources;
import org.dasein.util.uom.storage.Storage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulObjectStoreTests {
    private static final String LINE_ONE = "1: Test";
    private static final String LINE_TWO = "2: Done.";
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private Blob testObject;
    private Blob testBucket;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulObjectStoreTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        if (this.name.getMethodName().equals("removeRootBucket")) {
            this.testBucket = tm.getTestBucket("removed", true, true);
        } else if (this.name.getMethodName().equals("removeChildBucket")) {
            this.testBucket = tm.getTestBucket("removed" + this.name.getMethodName(), false, true);
        } else if (this.name.getMethodName().equals("createChildBucket")) {
            this.testBucket = tm.getTestBucket("stateful", true, true);
        } else if (this.name.getMethodName().equals("downloadRoot")) {
            BlobStoreSupport support;
            StorageServices services;
            StorageResources resources = DaseinTestManager.getStorageResources();
            if (resources != null && (services = tm.getProvider().getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
                try {
                    this.testObject = resources.provisionRootObject(support, "download", "dsndl", LINE_ONE, LINE_TWO);
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("downloadChild")) {
            BlobStoreSupport support;
            StorageServices services;
            StorageResources resources;
            this.testBucket = tm.getTestBucket("stateful", true, true);
            if (this.testBucket != null && (resources = DaseinTestManager.getStorageResources()) != null && (services = tm.getProvider().getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
                try {
                    this.testObject = resources.provisionChildObject(support, "download", this.testBucket.getBucketName(), "dsndl", LINE_ONE, LINE_TWO);
                }
                catch (Throwable ignore) {
                    tm.out("No testObject for downloadChild - exception: " + ignore.getLocalizedMessage());
                }
            }
        } else if (this.name.getMethodName().equals("uploadChild")) {
            this.testBucket = tm.getTestBucket("stateful", true, true);
        } else if (this.name.getMethodName().equals("removeRootObject")) {
            this.testObject = tm.getTestObject("removed", true, true);
        } else if (this.name.getMethodName().equals("removeChildObject")) {
            this.testObject = tm.getTestObject("removed" + this.name.getMethodName(), false, true);
        } else if (this.name.getMethodName().equals("clear")) {
            BlobStoreSupport support;
            StorageServices services;
            StorageResources resources = DaseinTestManager.getStorageResources();
            if (resources != null && (services = tm.getProvider().getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
                try {
                    this.testBucket = resources.provisionRootBucket(support, "removed2", "dsnbkt", false, true);
                    this.testObject = resources.provisionChildObject(support, "removed2", this.testBucket.getBucketName(), "dsnobj", new String[0]);
                }
                catch (Throwable ignore) {}
            }
        } else if (this.name.getMethodName().equals("objectSize")) {
            this.testObject = tm.getTestObject("stateful", false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.testBucket = null;
            this.testObject = null;
        }
        finally {
            tm.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFile(@Nonnull File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            Assert.assertEquals((String)"The first line of the downloaded file does not match", (Object)LINE_ONE, (Object)reader.readLine());
            Assert.assertEquals((String)"The second line of the downloaded file does not match", (Object)LINE_TWO, (Object)reader.readLine());
            Assert.assertEquals((String)"There are extra lines in the downloaded file", null, (Object)reader.readLine());
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void createRootBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        StorageResources resources = DaseinTestManager.getStorageResources();
        Assert.assertNotNull((String)"Failed to initialize storage resources for all tests", (Object)resources);
        Blob bucket = resources.provisionRootBucket(support, "provision", "dsnbkt", false, true);
        tm.out("Created", bucket);
        Assert.assertNotNull((String)"The newly created bucket is not supposed to be null", (Object)bucket);
    }

    @Test
    public void createChildBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testBucket != null) {
            StorageResources resources = DaseinTestManager.getStorageResources();
            Assert.assertNotNull((String)"Failed to initialize storage resources for all tests", (Object)resources);
            if (support.allowsNestedBuckets()) {
                Blob bucket = resources.provisionChildBucket(support, "provision", this.testBucket.getBucketName(), "dsnbkt", false, true);
                tm.out("Created", bucket);
                Assert.assertNotNull((String)"The newly created bucket is not supposed to be null", (Object)bucket);
            } else {
                try {
                    resources.provisionRootBucket(support, "provision", this.testBucket.getBucketName() + "/dsnbkt", false, true);
                    Assert.fail((String)"Creating a nested bucket succeeded in a cloud that does not support nesting");
                }
                catch (OperationNotSupportedException expected) {
                    tm.ok("Caught OperationNotSupportedException when trying to nest a bucket in a bucket in a cloud that does not support nesting");
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket or object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeRootBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testBucket != null) {
            Blob bucket = support.getBucket(this.testBucket.getBucketName());
            tm.out("Before", bucket);
            Assert.assertNotNull((String)"Bucket does not exist so test cannot function properly", (Object)bucket);
            support.removeBucket(bucket.getBucketName());
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    bucket = support.getBucket(bucket.getBucketName());
                    if (bucket == null) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", bucket);
            Assert.assertNull((String)("The system timed out before the cloud reflected any deletion of the root bucket " + this.testBucket.getBucketName()), (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket or object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeChildBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testBucket != null) {
            Blob bucket = support.getBucket(this.testBucket.getBucketName());
            tm.out("Before", bucket);
            Assert.assertNotNull((String)"Bucket does not exist so test cannot function properly", (Object)bucket);
            support.removeBucket(bucket.getBucketName());
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    bucket = support.getBucket(bucket.getBucketName());
                    if (bucket == null) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", bucket);
            Assert.assertNull((String)("The system timed out before the cloud reflected any deletion of the child bucket " + this.testBucket.getBucketName()), (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsNestedBuckets()) {
            tm.ok("Nested buckets are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket or object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void uploadRoot() throws CloudException, InternalException, IOException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (support.isSubscribed()) {
            StorageResources resources = DaseinTestManager.getStorageResources();
            if (resources != null) {
                if (support.allowsRootObjects()) {
                    Blob blob = resources.provisionRootObject(support, "upload", "dsnobj", LINE_ONE, LINE_TWO);
                    tm.out("Uploaded", blob);
                    Assert.assertNotNull((String)"Uploaded blob returned a null object", (Object)blob);
                } else {
                    try {
                        resources.provisionRootObject(support, "upload", "dsnobj", LINE_ONE, LINE_TWO);
                        Assert.fail((String)"Uploading a root object succeeded in a cloud that does not allow root objects");
                    }
                    catch (OperationNotSupportedException expected) {
                        tm.ok("Caught OperationNotSupportedException attempting to upload a root object in a cloud that does not allow root objects");
                    }
                }
            } else {
                Assert.fail((String)"Failed to initialize storage resources for all tests");
            }
        } else {
            tm.ok("Not subscribed to object storage so this test is not valid");
        }
    }

    @Test
    public void uploadChild() throws CloudException, InternalException, IOException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testBucket != null) {
            StorageResources resources = DaseinTestManager.getStorageResources();
            if (resources != null) {
                Blob blob = resources.provisionChildObject(support, "upload", this.testBucket.getBucketName(), "dsnobj", LINE_ONE, LINE_TWO);
                tm.out("Uploaded", blob);
                Assert.assertNotNull((String)"Uploaded blob returned a null object", (Object)blob);
            } else {
                Assert.fail((String)"Failed to initialize storage resources for all tests");
            }
        } else if (!support.isSubscribed()) {
            tm.ok("Not subscribed to object storage so this test is not valid");
        } else {
            Assert.fail((String)"No test bucket exists for validating uploads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadRoot() throws CloudException, InternalException, IOException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testObject != null) {
            File targetFile = File.createTempFile("dsndl", ".dl");
            try {
                FileTransfer task = support.download(null, this.testObject.getObjectName(), targetFile);
                while (!task.isComplete()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (task.getTransferError() != null) {
                    throw new CloudException(task.getTransferError());
                }
                tm.out("Downloaded", targetFile.length() + " bytes");
                this.assertFile(targetFile);
            }
            finally {
                if (targetFile.exists()) {
                    targetFile.delete();
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsRootObjects()) {
            tm.ok("Root objects are not allowed in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadChild() throws CloudException, InternalException, IOException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testObject != null) {
            File targetFile = File.createTempFile("dsndl", ".dl");
            try {
                FileTransfer task = support.download(this.testObject.getBucketName(), this.testObject.getObjectName(), targetFile);
                while (!task.isComplete()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (task.getTransferError() != null) {
                    throw new CloudException(task.getTransferError());
                }
                tm.out("Downloaded", targetFile.length() + " bytes");
                this.assertFile(targetFile);
            }
            finally {
                if (targetFile.exists()) {
                    targetFile.delete();
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeRootObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testObject != null) {
            Blob object = support.getObject(this.testObject.getBucketName(), this.testObject.getObjectName());
            tm.out("Before", object);
            Assert.assertNotNull((String)"The test object does not really exist", (Object)object);
            support.removeObject(object.getBucketName(), object.getObjectName());
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    object = support.getObject(object.getBucketName(), object.getObjectName());
                    if (object == null) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", object);
            Assert.assertNull((String)("The system timed out before the cloud reflected any deletion of the root object " + this.testObject.getObjectName()), (Object)object);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsRootObjects()) {
            tm.ok("Root objects are not allowed in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void removeChildObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testObject != null) {
            Blob object = support.getObject(this.testObject.getBucketName(), this.testObject.getObjectName());
            tm.out("Before", object);
            Assert.assertNotNull((String)"The test object does not really exist", (Object)object);
            support.removeObject(object.getBucketName(), object.getObjectName());
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    object = support.getObject(object.getBucketName(), object.getObjectName());
                    if (object == null) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", object);
            Assert.assertNull((String)("The system timed out before the cloud reflected any deletion of the child object " + this.testObject.getBucketName() + "/" + this.testObject.getObjectName()), (Object)object);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void clear() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testBucket != null) {
            Blob bucket = support.getBucket(this.testBucket.getBucketName());
            tm.out("Before", bucket);
            Assert.assertNotNull((String)"Bucket does not exist so test cannot function properly", (Object)bucket);
            support.clearBucket(bucket.getBucketName());
            long timeout = System.currentTimeMillis() + 60000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    bucket = support.getBucket(bucket.getBucketName());
                    if (bucket == null) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {}
            }
            tm.out("After", bucket);
            Assert.assertNull((String)("The system timed out before the cloud reflected any deletion of the root bucket " + this.testBucket.getBucketName()), (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket or object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void objectSize() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getBlobStoreSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testObject != null) {
            Storage size = support.getObjectSize(this.testObject.getBucketName(), this.testObject.getObjectName());
            tm.out("Size", size);
            Assert.assertNotNull((String)"The size may not be null", (Object)size);
            Assert.assertTrue((String)"The object size must be non-negative", (size.longValue() > -1L ? 1 : 0) != 0);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }
}

