/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import junit.framework.Assert;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.OfflineStoreRequest;
import org.dasein.cloud.storage.OfflineStoreRequestAction;
import org.dasein.cloud.storage.OfflineStoreRequestStatus;
import org.dasein.cloud.storage.OfflineStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulOfflineStoreTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulOfflineStoreTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
    }

    @After
    public void after() {
        tm.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void buckets() throws Exception {
        OfflineStoreSupport offlineStore = this.getSupportOrBail();
        if (offlineStore == null) {
            return;
        }
        ArrayList<String> createdBuckets = new ArrayList<String>();
        String bucketPrefix = "testbkt" + UUID.randomUUID().toString();
        try {
            String bucket1 = bucketPrefix + "_1";
            createdBuckets.add(bucket1);
            Blob bucketBlob1 = offlineStore.createBucket(bucket1, false);
            String bucket2 = bucketPrefix + "_2";
            createdBuckets.add(bucket2);
            Blob bucketBlob2 = offlineStore.createBucket(bucket2, false);
            String bucket3 = bucketPrefix + "_3";
            createdBuckets.add(bucket3);
            Blob bucketBlob3 = offlineStore.createBucket(bucket3, false);
            Assert.assertTrue((boolean)offlineStore.exists(bucket1));
            Assert.assertFalse((boolean)offlineStore.exists(bucketPrefix + "NOTTHISONE"));
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob1, offlineStore.getBucket(bucket1));
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob2, offlineStore.getBucket(bucket2));
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob3, offlineStore.getBucket(bucket3));
            HashMap<String, Blob> blobs = new HashMap<String, Blob>();
            for (Blob blob : offlineStore.list(null)) {
                Assert.assertNotNull((Object)blob.getBucketName());
                if (!blob.getBucketName().startsWith(bucketPrefix)) continue;
                Assert.assertFalse((boolean)blobs.containsKey(blob.getBucketName()));
                blobs.put(blob.getBucketName(), blob);
            }
            Assert.assertEquals((int)3, (int)blobs.size());
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob1, (Blob)blobs.get(bucket1));
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob2, (Blob)blobs.get(bucket2));
            StatefulOfflineStoreTests.assertBlobEquals(bucketBlob3, (Blob)blobs.get(bucket3));
        }
        finally {
            for (String bucket : createdBuckets) {
                offlineStore.removeBucket(bucket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requests() throws Exception {
        OfflineStoreSupport offlineStore = this.getSupportOrBail();
        if (offlineStore == null) {
            return;
        }
        for (Blob bucketBlob : offlineStore.list(null)) {
            String bucket = bucketBlob.getBucketName();
            try {
                OfflineStoreRequest listRequest = offlineStore.createListRequest(bucket);
                StatefulOfflineStoreTests.assertListRequest(bucket, listRequest);
                OfflineStoreRequest gotRequest = offlineStore.getRequest(bucket, listRequest.getRequestId());
                StatefulOfflineStoreTests.assertListRequest(bucket, gotRequest);
                Assert.assertNotNull((Object)bucketBlob.getSize());
                long size = bucketBlob.getSize().longValue();
                Assert.assertTrue((size >= 0L ? 1 : 0) != 0);
                tm.out("Successfully made list request for bucket " + bucket + " (size: " + size + ")");
            }
            catch (CloudException e) {
                Assert.assertEquals((int)404, (int)e.getHttpCode());
                tm.out("Couldn't make list request for bucket (too new): " + bucket);
            }
        }
        String newBucket = "testbkt" + UUID.randomUUID().toString();
        boolean failed = false;
        try {
            offlineStore.createBucket(newBucket, false);
            offlineStore.createListRequest(newBucket);
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                failed = true;
            }
        }
        finally {
            offlineStore.removeBucket(newBucket);
        }
        Assert.assertTrue((String)"Expected list request creation to fail on a new bucket", (boolean)failed);
    }

    private static void assertListRequest(String bucket, OfflineStoreRequest listRequest) {
        Assert.assertEquals((String)bucket, (String)listRequest.getBucketName());
        Assert.assertNull((Object)listRequest.getObjectName());
        Assert.assertNotNull((Object)listRequest.getRequestId());
        Assert.assertEquals((Object)OfflineStoreRequestStatus.IN_PROGRESS, (Object)listRequest.getStatus());
        Assert.assertEquals((Object)OfflineStoreRequestAction.LIST, (Object)listRequest.getAction());
    }

    private static void assertBlobEquals(Blob expected, Blob actual) {
        Assert.assertEquals((String)expected.getBucketName(), (String)actual.getBucketName());
        Assert.assertEquals((String)expected.getLocation(), (String)actual.getLocation());
    }

    private OfflineStoreSupport getSupportOrBail() {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return null;
        }
        OfflineStoreSupport support = services.getOfflineStorageSupport();
        if (support == null) {
            tm.ok("No offline storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return null;
        }
        return support;
    }
}

