/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.storage;

import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessObjectStoreTests {
    private static final Random random = new Random();
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private Blob testChildBucket;
    private Blob testChildObject;
    private Blob testRootBucket;
    private Blob testRootObject;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessObjectStoreTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        BlobStoreSupport support;
        StorageServices services;
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testRootBucket = tm.getTestBucket("stateless", true, false);
        this.testChildBucket = tm.getTestBucket("stateless", false, false);
        this.testRootObject = tm.getTestObject("stateless", true, false);
        this.testChildObject = tm.getTestObject("stateless", false, false);
        if (this.testChildObject != null && this.name.getMethodName().equals("childObjectContent") && (services = tm.getProvider().getStorageServices()) != null && (support = services.getOnlineStorageSupport()) != null) {
            try {
                this.testRootBucket = support.getBucket(this.testChildObject.getBucketName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Bucket", support.getProviderTermForBucket(Locale.getDefault()));
        tm.out("Term for Object", support.getProviderTermForObject(Locale.getDefault()));
        tm.out("Bucket Naming Rules", support.getBucketNameRules());
        tm.out("Object Naming Rules", support.getObjectNameRules());
        tm.out("Public Bucket Sharing", support.allowsPublicSharing());
        tm.out("Root Objects", support.allowsRootObjects());
        tm.out("Nested Buckets", support.allowsNestedBuckets());
        tm.out("Max Buckets", support.getMaxBuckets());
        tm.out("Max Object Size", support.getMaxObjectSize());
        tm.out("Max Objects/Bucket", support.getMaxObjectsPerBucket());
        Assert.assertNotNull((String)"The provider term for a bucket may not be null in any locale", (Object)support.getProviderTermForBucket(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for an object may not be null in any locale", (Object)support.getProviderTermForObject(Locale.getDefault()));
        Assert.assertNotNull((String)"The bucket naming rules may not be null", (Object)support.getBucketNameRules());
        Assert.assertNotNull((String)"The object naming rules may not be null", (Object)support.getObjectNameRules());
        Assert.assertTrue((String)"The maximum number of buckets must be -2, -1, or non-negative", (support.getMaxBuckets() >= -2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The maximum number of objects per bucket must be -2, -1, or non-negative", (support.getMaxObjectsPerBucket() >= -2 ? 1 : 0) != 0);
    }

    private void assertBlob(@Nonnull BlobStoreSupport support, @Nonnull Blob item, @Nullable Blob parent, @Nullable Boolean container) throws CloudException, InternalException {
        if (container != null) {
            Assert.assertEquals((String)"The value for isContainer() does not match", (Object)container, (Object)item.isContainer());
        }
        if (item.isContainer()) {
            Assert.assertNull((String)"Object name must be null for buckets", (Object)item.getObjectName());
            Assert.assertNotNull((String)"The bucket name may not be null for buckets", (Object)item.getBucketName());
        } else {
            Assert.assertNotNull((String)"The object name may not be null for objects", (Object)item.getObjectName());
        }
        if (parent == null) {
            if (!item.isContainer()) {
                Assert.assertTrue((String)"This cloud does not support root objects, but a root object was found", (boolean)support.allowsRootObjects());
                Assert.assertNull((String)"The parent bucket must be null for root objects", (Object)item.getBucketName());
            }
        } else if (item.isContainer()) {
            Assert.assertTrue((String)("This cloud does not support nested buckets, but a nested bucket was found in " + parent.getBucketName()), (boolean)support.allowsNestedBuckets());
        }
        Assert.assertTrue((String)"The object creation date must be non-negative", (item.getCreationTimestamp() >= 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)"The region ID may not be null", (Object)item.getProviderRegionId());
        Assert.assertEquals((String)"The region ID must match the current context", (Object)tm.getContext().getRegionId(), (Object)item.getProviderRegionId());
        Assert.assertNotNull((String)"The object/bucket location may not be null", (Object)item.getLocation());
        if (container != null && container.booleanValue()) {
            Assert.assertNull((String)"Containers do not have a size", (Object)item.getSize());
        } else if (container != null) {
            Assert.assertNotNull((String)"Objects must have a size", (Object)item.getSize());
        }
    }

    private void out(Blob blob) {
        tm.out("Bucket", blob.getBucketName());
        tm.out("Object", blob.getObjectName());
        tm.out("Created", new Date(blob.getCreationTimestamp()));
        tm.out("Region ID", blob.getProviderRegionId());
        tm.out("Container", blob.isContainer());
        tm.out("Location", blob.getLocation());
        tm.out("Size", blob.getSize());
    }

    @Test
    public void listItemsUnderRoot() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Iterable items = support.list(null);
        int count = 0;
        Assert.assertNotNull((String)"Items returned may not be null", (Object)items);
        for (Blob item : items) {
            ++count;
            tm.out("Item", item);
        }
        tm.out("Total Root Items", count);
        if (count < 1) {
            if (!support.isSubscribed()) {
                tm.ok("Account is not subscribed for object storage, so this test may not be not valid");
            } else {
                tm.warn("No items were returned, so it is impossible to verify the validity of this test");
            }
        } else {
            for (Blob item : items) {
                this.assertBlob(support, item, null, null);
            }
        }
    }

    @Test
    public void getBogusRootBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Blob bucket = support.getBucket(UUID.randomUUID().toString().replaceAll("-", String.valueOf(random.nextInt(9))).substring(0, 15));
        tm.out("Bogus Bucket", bucket);
        Assert.assertNull((String)"Fetched an actual bucket for the bogus ID requested", (Object)bucket);
    }

    @Test
    public void getRootBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            Blob bucket = support.getBucket(this.testRootBucket.getBucketName());
            tm.out("Bucket", bucket);
            Assert.assertNotNull((String)"The test bucket does not exist in the target cloud", (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void rootBucketContent() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            Blob bucket = support.getBucket(this.testRootBucket.getBucketName());
            Assert.assertNotNull((String)"The test bucket does not exist in the target cloud", (Object)bucket);
            this.out(bucket);
            this.assertBlob(support, bucket, null, true);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void existsBogusBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            boolean exists = support.exists(UUID.randomUUID().toString());
            tm.out("Exists", exists);
            Assert.assertFalse((String)"The bucket does exists even though it does not exist", (boolean)exists);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void existsBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            boolean exists = support.exists(this.testRootBucket.getBucketName());
            tm.out("Exists", exists);
            Assert.assertTrue((String)"The bucket does not exist even though it exists", (boolean)exists);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listItemsUnderRootBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            Iterable items = support.list(this.testRootBucket.getBucketName());
            int count = 0;
            Assert.assertNotNull((String)"Items returned may not be null", (Object)items);
            for (Blob item : items) {
                ++count;
                tm.out("Item", item);
            }
            tm.out("Total Items in " + this.testRootBucket.getBucketName(), count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Account is not subscribed for object storage, so this test may not be not valid");
                } else {
                    tm.warn("No items were returned, so it is impossible to verify the validity of this test");
                }
            } else {
                for (Blob item : items) {
                    this.assertBlob(support, item, this.testRootBucket, null);
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void getBogusRootObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (!support.allowsRootObjects()) {
            tm.ok("Root objects are not allowed in " + tm.getProvider().getCloudName());
            return;
        }
        Blob object = support.getObject(null, UUID.randomUUID().toString());
        tm.out("Bogus Object", object);
        Assert.assertNull((String)"Fetched an actual object for the bogus ID requested", (Object)object);
    }

    @Test
    public void getRootObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootObject != null) {
            Blob object = support.getObject(null, this.testRootObject.getObjectName());
            tm.out("Object", object);
            Assert.assertNotNull((String)"The test object does not exist in the target cloud", (Object)object);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsRootObjects()) {
            tm.ok("Root objects are not allowed in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void rootObjectContent() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootObject != null) {
            Blob object = support.getObject(null, this.testRootObject.getObjectName());
            Assert.assertNotNull((String)"The test object does not exist in the target cloud", (Object)object);
            this.out(object);
            this.assertBlob(support, object, null, false);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsRootObjects()) {
            tm.ok("Root objects are not allowed in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test object for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void getBogusChildBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testRootBucket != null) {
            Blob bucket = support.getBucket(this.testRootBucket + "/" + UUID.randomUUID().toString().replaceAll("-", String.valueOf(random.nextInt(9))).substring(0, 15));
            tm.out("Bogus Bucket", bucket);
            Assert.assertNull((String)"Fetched an actual bucket for the bogus ID requested", (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void getChildBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testChildBucket != null) {
            Blob bucket = support.getBucket(this.testChildBucket.getBucketName());
            tm.out("Bucket", bucket);
            Assert.assertNotNull((String)"The test bucket does not exist in the target cloud", (Object)bucket);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsNestedBuckets()) {
            tm.ok("Nested buckets are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void childBucketContent() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testChildBucket != null) {
            Blob bucket = support.getBucket(this.testChildBucket.getBucketName());
            Assert.assertNotNull((String)"The test bucket does not exist in the target cloud", (Object)bucket);
            this.out(bucket);
            this.assertBlob(support, bucket, null, true);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsNestedBuckets()) {
            tm.ok("Nested buckets are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void listItemsUnderChildBucket() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testChildBucket != null) {
            Iterable items = support.list(this.testChildBucket.getBucketName());
            int count = 0;
            Assert.assertNotNull((String)"Items returned may not be null", (Object)items);
            for (Blob item : items) {
                ++count;
                tm.out("Item", item);
            }
            tm.out("Total Items in " + this.testChildBucket.getBucketName(), count);
            if (count < 1) {
                if (!support.isSubscribed()) {
                    tm.ok("Account is not subscribed for object storage, so this test may not be not valid");
                } else {
                    tm.warn("No items were returned, so it is impossible to verify the validity of this test");
                }
            } else {
                for (Blob item : items) {
                    this.assertBlob(support, item, this.testChildBucket, null);
                }
            }
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else if (!support.allowsNestedBuckets()) {
            tm.ok("Nested buckets are not supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void getBogusChildObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        Blob object = support.getObject(this.testRootBucket.getBucketName(), UUID.randomUUID().toString());
        tm.out("Bogus Object", object);
        Assert.assertNull((String)"Fetched an actual object for the bogus ID requested", (Object)object);
    }

    @Test
    public void getChildObject() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testChildObject != null) {
            Blob object = support.getObject(this.testChildObject.getBucketName(), this.testChildObject.getObjectName());
            tm.out("Object", object);
            Assert.assertNotNull((String)"The test object does not exist in the target cloud", (Object)object);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket for the test " + this.name.getMethodName()));
        }
    }

    @Test
    public void childObjectContent() throws CloudException, InternalException {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        BlobStoreSupport support = services.getOnlineStorageSupport();
        if (support == null) {
            tm.ok("No object storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return;
        }
        if (this.testChildObject != null && this.testRootBucket != null) {
            Blob object = support.getObject(this.testChildObject.getBucketName(), this.testChildObject.getObjectName());
            Assert.assertNotNull((String)"The test object does not exist in the target cloud", (Object)object);
            this.out(object);
            this.assertBlob(support, object, this.testRootBucket, false);
        } else if (!support.isSubscribed()) {
            tm.ok("No subscription to object storage in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
        } else {
            Assert.fail((String)("Unable to establish a test bucket or object for the test " + this.name.getMethodName()));
        }
    }
}

