/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.storage;

import java.util.Locale;
import junit.framework.Assert;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.OfflineStoreRequest;
import org.dasein.cloud.storage.OfflineStoreRequestAction;
import org.dasein.cloud.storage.OfflineStoreRequestStatus;
import org.dasein.cloud.storage.OfflineStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessOfflineStoreTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessOfflineStoreTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        OfflineStoreSupport support = this.getSupportOrBail();
        if (support == null) {
            return;
        }
        tm.out("Subscribed", support.isSubscribed());
        tm.out("Term for Bucket", support.getProviderTermForBucket(Locale.getDefault()));
        tm.out("Term for Object", support.getProviderTermForObject(Locale.getDefault()));
        tm.out("Bucket Naming Rules", support.getBucketNameRules());
        tm.out("Object Naming Rules", support.getObjectNameRules());
        tm.out("Public Bucket Sharing", support.allowsPublicSharing());
        tm.out("Root Objects", support.allowsRootObjects());
        tm.out("Nested Buckets", support.allowsNestedBuckets());
        tm.out("Max Buckets", support.getMaxBuckets());
        tm.out("Max Object Size", support.getMaxObjectSize());
        tm.out("Max Objects/Bucket", support.getMaxObjectsPerBucket());
        Assert.assertNotNull((String)"The provider term for a bucket may not be null in any locale", (Object)support.getProviderTermForBucket(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for an object may not be null in any locale", (Object)support.getProviderTermForObject(Locale.getDefault()));
        Assert.assertNotNull((String)"The bucket naming rules may not be null", (Object)support.getBucketNameRules());
        Assert.assertNotNull((String)"The object naming rules may not be null", (Object)support.getObjectNameRules());
        Assert.assertTrue((String)"The maximum number of buckets must be -2, -1, or non-negative", (support.getMaxBuckets() >= -2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The maximum number of objects per bucket must be -2, -1, or non-negative", (support.getMaxObjectsPerBucket() >= -2 ? 1 : 0) != 0);
    }

    @Test
    public void listBuckets() throws Exception {
        OfflineStoreSupport offlineStore = this.getSupportOrBail();
        if (offlineStore == null) {
            return;
        }
        Iterable buckets = offlineStore.list(null);
        Assert.assertNotNull((Object)buckets);
        for (Blob bucket : buckets) {
            Assert.assertNotNull((Object)bucket);
            Assert.assertNotNull((Object)bucket.getBucketName());
            Assert.assertNotNull((Object)bucket.getLocation());
            Assert.assertNull((Object)bucket.getObjectName());
        }
    }

    @Test
    public void listRequests() throws Exception {
        OfflineStoreSupport offlineStore = this.getSupportOrBail();
        if (offlineStore == null) {
            return;
        }
        boolean listedSomething = false;
        for (Blob bucketBlob : offlineStore.list(null)) {
            String bucket = bucketBlob.getBucketName();
            for (OfflineStoreRequest request : offlineStore.listRequests(bucket)) {
                Assert.assertEquals((String)bucket, (String)request.getBucketName());
                Assert.assertNotNull((Object)request.getRequestId());
                Assert.assertNotNull((Object)request.getStatus());
                if (request.getAction() != OfflineStoreRequestAction.LIST || request.getStatus() != OfflineStoreRequestStatus.SUCCEEDED) continue;
                Iterable listRequestResult = offlineStore.getListRequestResult(bucket, request.getRequestId());
                tm.out("Got results of list request " + request.getRequestId());
                for (Blob blob : listRequestResult) {
                    if (blob == null) continue;
                    tm.out("Found blob in offline storage list for bucket " + bucket + ": " + blob + " (size: " + blob.getSize() + ")");
                    Assert.assertNotNull((Object)blob.getObjectName());
                    Assert.assertNotNull((Object)blob.getBucketName());
                    Assert.assertNotNull((Object)blob.getSize());
                }
                Assert.assertNotNull((Object)listRequestResult);
                listedSomething = true;
            }
        }
        if (!listedSomething) {
            tm.warn("There were no existing list requests to read output from!");
        }
    }

    private OfflineStoreSupport getSupportOrBail() {
        StorageServices services = tm.getProvider().getStorageServices();
        if (services == null) {
            tm.ok("No storage services are supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return null;
        }
        OfflineStoreSupport support = services.getOfflineStorageSupport();
        if (support == null) {
            tm.ok("No offline storage is supported in " + tm.getContext().getRegionId() + " of " + tm.getProvider().getCloudName());
            return null;
        }
        return support;
    }
}

