/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.storage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.test.DaseinTestManager;

public class StorageResources {
    private static final Logger logger = Logger.getLogger(StorageResources.class);
    private static final Random random = new Random();
    private final HashMap<String, Blob> testChildBuckets = new HashMap();
    private final HashMap<String, Blob> testChildObjects = new HashMap();
    private final HashMap<String, Blob> testRootBuckets = new HashMap();
    private final HashMap<String, Blob> testRootObjects = new HashMap();
    private CloudProvider provider;

    public StorageResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    public int close() {
        int count = 0;
        try {
            BlobStoreSupport support;
            StorageServices services = this.provider.getStorageServices();
            if (services != null && (support = services.getBlobStoreSupport()) != null) {
                Blob blob;
                String object;
                String bucket;
                for (Map.Entry<String, Blob> entry : this.testRootObjects.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        bucket = entry.getValue().getBucketName();
                        object = entry.getValue().getObjectName();
                        if (object == null) continue;
                        blob = support.getObject(bucket, object);
                        if (blob != null) {
                            support.removeObject(bucket, object);
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to remove test root object " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
                for (Map.Entry<String, Blob> entry : this.testChildObjects.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        bucket = entry.getValue().getBucketName();
                        object = entry.getValue().getObjectName();
                        if (object == null) continue;
                        blob = support.getObject(bucket, object);
                        if (blob != null) {
                            support.removeObject(bucket, object);
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to remove test child object " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
                for (Map.Entry<String, Blob> entry : this.testChildBuckets.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        Blob blob2;
                        bucket = entry.getValue().getBucketName();
                        if (bucket == null) {
                            bucket = entry.getValue().getObjectName();
                            if (bucket == null) {
                                continue;
                            }
                        } else {
                            bucket = bucket + "/" + entry.getValue().getObjectName();
                        }
                        if ((blob2 = support.getBucket(bucket)) != null) {
                            support.removeBucket(bucket);
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to remove test child bucket " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
                for (Map.Entry<String, Blob> entry : this.testRootBuckets.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        Blob blob3 = support.getBucket(entry.getValue().getBucketName());
                        if (blob3 != null) {
                            support.removeBucket(entry.getValue().getBucketName());
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to remove test root bucket " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.provider.close();
        return count;
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testRootBuckets.remove("stateless");
        if (!this.testRootBuckets.isEmpty()) {
            logger.info((Object)"Provisioned Storage Resources:");
            header = true;
            count += this.testRootBuckets.size();
            DaseinTestManager.out(logger, null, "---> Root Buckets", this.testRootBuckets.size() + " " + this.testRootBuckets);
        }
        this.testRootObjects.remove("stateless");
        if (!this.testRootObjects.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Storage Resources:");
                header = true;
            }
            count += this.testRootObjects.size();
            DaseinTestManager.out(logger, null, "---> Root Objects", this.testRootObjects.size() + " " + this.testRootObjects);
        }
        this.testChildBuckets.remove("stateless");
        if (!this.testChildBuckets.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Storage Resources:");
                header = true;
            }
            count += this.testChildBuckets.size();
            DaseinTestManager.out(logger, null, "---> Child Buckets", this.testChildBuckets.size() + " " + this.testChildBuckets);
        }
        this.testChildObjects.remove("stateless");
        if (!this.testChildObjects.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Storage Resources:");
            }
            count += this.testChildObjects.size();
            DaseinTestManager.out(logger, null, "---> Child Objects", this.testChildObjects.size() + " " + this.testChildObjects);
        }
        return count;
    }

    @Nullable
    public Blob getTestRootBucket(@Nonnull String label, boolean provisionIfNull, @Nullable String namePrefix) {
        BlobStoreSupport support;
        StorageServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, Blob> entry : this.testRootBuckets.entrySet()) {
                Blob bucket;
                if (entry.getKey().startsWith("removed") || (bucket = entry.getValue()) == null) continue;
                return bucket;
            }
            return this.findStatelessRootBucket();
        }
        Blob bucket = this.testRootBuckets.get(label);
        if (bucket != null) {
            return bucket;
        }
        if (provisionIfNull && (services = this.provider.getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
            try {
                return this.provisionRootBucket(support, label, namePrefix == null ? "dsnbkt" : namePrefix, false, true);
            }
            catch (Throwable t) {
                logger.warn((Object)("Unable to provision root test bucket: " + t.getMessage()));
            }
        }
        return null;
    }

    @Nullable
    public Blob getTestChildBucket(@Nonnull String label, boolean provisionIfNull, @Nullable String parentBucket, @Nullable String namePrefix) {
        BlobStoreSupport support;
        StorageServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, Blob> entry : this.testChildBuckets.entrySet()) {
                Blob bucket;
                if (entry.getKey().startsWith("removed") || (bucket = entry.getValue()) == null) continue;
                return bucket;
            }
            return this.findStatelessChildBucket();
        }
        Blob bucket = this.testChildBuckets.get(label);
        if (bucket != null) {
            return bucket;
        }
        if (provisionIfNull && (services = this.provider.getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
            try {
                if (parentBucket == null) {
                    Blob parent = this.getTestRootBucket(label, true, null);
                    if (parent == null) {
                        return null;
                    }
                    parentBucket = parent.getBucketName();
                    if (parentBucket == null) {
                        return null;
                    }
                }
                return this.provisionChildBucket(support, label, parentBucket, namePrefix == null ? "dsnbkt" : namePrefix, false, true);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob getTestRootObject(@Nonnull String label, boolean provisionIfNull, @Nullable String namePrefix) {
        BlobStoreSupport support;
        StorageServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, Blob> entry : this.testRootObjects.entrySet()) {
                Blob bucket;
                if (entry.getKey().startsWith("removed") || (bucket = entry.getValue()) == null) continue;
                return bucket;
            }
            return this.findStatelessRootObject();
        }
        Blob object = this.testRootObjects.get(label);
        if (object != null) {
            return object;
        }
        if (provisionIfNull && (services = this.provider.getStorageServices()) != null && (support = services.getBlobStoreSupport()) != null) {
            try {
                return this.provisionRootObject(support, label, namePrefix == null ? "dsnobj" : namePrefix, new String[0]);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob getTestChildObject(@Nonnull String label, boolean provisionIfNull, @Nullable String parentBucket, @Nullable String namePrefix) {
        BlobStoreSupport support;
        StorageServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, Blob> entry : this.testChildObjects.entrySet()) {
                Blob bucket;
                if (entry.getKey().startsWith("removed") || (bucket = entry.getValue()) == null) continue;
                return bucket;
            }
            return this.findStatelessChildObject();
        }
        Blob object = this.testChildObjects.get(label);
        if (object != null) {
            return object;
        }
        if (provisionIfNull && (services = this.provider.getStorageServices()) != null && (support = services.getOnlineStorageSupport()) != null) {
            try {
                if (parentBucket == null) {
                    Blob parent = this.getTestRootBucket("stateful", true, null);
                    if (parent == null) {
                        return null;
                    }
                    parentBucket = parent.getBucketName();
                    if (parentBucket == null) {
                        return null;
                    }
                }
                return this.provisionChildObject(support, label, parentBucket, namePrefix == null ? "dsnobj" : namePrefix, new String[0]);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob findStatelessChildBucket() {
        StorageServices services = this.provider.getStorageServices();
        if (services != null) {
            BlobStoreSupport support = services.getOnlineStorageSupport();
            try {
                if (support != null && support.allowsNestedBuckets() && support.isSubscribed()) {
                    Iterable roots = support.list(null);
                    for (Blob root : roots) {
                        if (!root.isContainer()) continue;
                        Iterable options = support.list(root.getBucketName());
                        for (Blob option : options) {
                            if (!option.isContainer()) continue;
                            this.testChildBuckets.put("stateless", option);
                            return option;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob findStatelessRootBucket() {
        StorageServices services = this.provider.getStorageServices();
        if (services != null) {
            BlobStoreSupport support = services.getBlobStoreSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Iterable options = support.list(null);
                    Blob defaultBlob = null;
                    for (Blob option : options) {
                        if (!option.isContainer()) continue;
                        Iterable children = support.list(option.getBucketName());
                        if (children.iterator().hasNext()) {
                            this.testRootBuckets.put("stateless", option);
                            return option;
                        }
                        if (defaultBlob != null) continue;
                        defaultBlob = option;
                    }
                    if (defaultBlob != null) {
                        this.testRootBuckets.put("stateless", defaultBlob);
                        return defaultBlob;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob findStatelessChildObject() {
        StorageServices services = this.provider.getStorageServices();
        if (services != null) {
            BlobStoreSupport support = services.getBlobStoreSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Iterable roots = support.list(null);
                    for (Blob root : roots) {
                        if (!root.isContainer()) continue;
                        Iterable options = support.list(root.getBucketName());
                        for (Blob option : options) {
                            if (option.isContainer()) continue;
                            this.testChildObjects.put("stateless", option);
                            return option;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob findStatelessRootObject() {
        StorageServices services = this.provider.getStorageServices();
        if (services != null) {
            BlobStoreSupport support = services.getBlobStoreSupport();
            try {
                if (support != null && support.allowsRootObjects() && support.isSubscribed()) {
                    Iterable options = support.list(null);
                    for (Blob option : options) {
                        if (option.isContainer()) continue;
                        this.testRootObjects.put("stateless", option);
                        return option;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob provisionRootBucket(@Nonnull BlobStoreSupport support, @Nonnull String label, @Nonnull String namePrefix, boolean useName, boolean findFreeName) throws CloudException, InternalException {
        String name = useName ? namePrefix : namePrefix + random.nextInt(10000);
        Blob blob = support.createBucket(name, findFreeName);
        HashMap<String, Blob> hashMap = this.testRootBuckets;
        synchronized (hashMap) {
            while (this.testRootBuckets.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testRootBuckets.put(label, blob);
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob provisionChildBucket(@Nonnull BlobStoreSupport support, @Nonnull String label, @Nonnull String parentBucket, @Nonnull String namePrefix, boolean useName, boolean findFreeName) throws CloudException, InternalException {
        String name = useName ? namePrefix : namePrefix + random.nextInt(10000);
        Blob blob = support.createBucket(parentBucket + "/" + name, findFreeName);
        HashMap<String, Blob> hashMap = this.testChildBuckets;
        synchronized (hashMap) {
            while (this.testChildBuckets.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testChildBuckets.put(label, blob);
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob provisionRootObject(@Nonnull BlobStoreSupport support, @Nonnull String label, @Nonnull String namePrefix, String ... lines) throws CloudException, InternalException {
        try {
            File file = File.createTempFile("dsntst", "txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            if (lines == null) {
                writer.write("This is a test of Dasein Cloud");
                writer.newLine();
            } else {
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            writer.flush();
            writer.close();
            Blob blob = support.upload(file, null, namePrefix + random.nextInt(10000) + ".txt");
            HashMap<String, Blob> hashMap = this.testChildObjects;
            synchronized (hashMap) {
                while (this.testChildObjects.containsKey(label)) {
                    label = label + random.nextInt(9);
                }
                this.testChildObjects.put(label, blob);
            }
            return blob;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob provisionChildObject(@Nonnull BlobStoreSupport support, @Nonnull String label, @Nonnull String parentBucket, @Nonnull String namePrefix, String ... lines) throws CloudException, InternalException {
        try {
            File file = File.createTempFile("dsntst", "txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            if (lines == null) {
                writer.write("This is a test of Dasein Cloud");
                writer.newLine();
            } else {
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            writer.flush();
            writer.close();
            Blob blob = support.upload(file, parentBucket, namePrefix + random.nextInt(10000) + ".txt");
            HashMap<String, Blob> hashMap = this.testChildObjects;
            synchronized (hashMap) {
                while (this.testChildObjects.containsKey(label)) {
                    label = label + random.nextInt(9);
                }
                this.testChildObjects.put(label, blob);
            }
            return blob;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

