/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudMethod;

public class VDCServices
implements DataCenterServices {
    private vCloud provider;

    VDCServices(vCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataCenter getDataCenter(@Nonnull String providerDataCenterId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getDataCenter");
        try {
            for (Region region : this.listRegions()) {
                for (DataCenter dc : this.listDataCenters(region.getProviderRegionId())) {
                    if (!providerDataCenterId.equals(dc.getProviderDataCenterId())) continue;
                    DataCenter dataCenter = dc;
                    return dataCenter;
                }
            }
            DataCenter dataCenter = null;
            return dataCenter;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "VDC";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "Org";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getRegion");
        try {
            for (Region region : this.listRegions()) {
                if (!providerRegionId.equals(region.getProviderRegionId())) continue;
                Region region2 = region;
                return region2;
            }
            Region region = null;
            return region;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        if (!providerRegionId.equals(ctx.getRegionId())) {
            return Collections.emptyList();
        }
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listDataCenters");
        try {
            Collection<DataCenter> collection = new vCloudMethod(this.provider).listDataCenters();
            return collection;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listRegions");
        try {
            List<Region> list = Collections.singletonList(new vCloudMethod(this.provider).getRegion());
            return list;
        }
        finally {
            APITrace.end();
        }
    }
}

