/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class DiskCapabilities
extends AbstractCapabilities<vCloud>
implements VolumeCapabilities {
    public DiskCapabilities(vCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.STOPPED);
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.STOPPED);
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 5; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                ids.add(i + ":" + j);
            }
        }
        return ids;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.OPTIONAL;
    }
}

