/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.vcloud.vCloud;

public class TemplateCapabilities
extends AbstractCapabilities<vCloud>
implements ImageCapabilities {
    public TemplateCapabilities(vCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canBundle(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canImage(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.STOPPED) || fromState.equals((Object)VmState.PAUSED) || fromState.equals((Object)VmState.SUSPENDED);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass imageClass) {
        return "template";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass imageClass) {
        return "template";
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VMDK);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return type.equals((Object)MachineImageType.VOLUME);
    }

    public boolean supportsImageSharing() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageSharingWithPublic() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass imageClass) throws CloudException, InternalException {
        return imageClass.equals((Object)ImageClass.MACHINE);
    }
}

