/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudMethod;

public class VMSupportCapabilities
extends AbstractCapabilities<vCloud>
implements VirtualMachineCapabilities {
    public VMSupportCapabilities(vCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.STOPPED);
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.SUSPENDED);
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.TERMINATED);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getMaximumVirtualMachineCount");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            int n = method.getVMQuota();
            return n;
        }
        finally {
            APITrace.end();
        }
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        if (!state.equals((Object)VmState.RUNNING)) {
            return 0;
        }
        return 100;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "VM";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)32).constrainedBy(new char[]{' ', '-', '_', '.', ',', '[', ']', '(', ')', '{', '}', '~'});
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"architectures", Architecture.class, (CacheLevel)CacheLevel.CLOUD);
        List<Architecture> list = cache.get(this.getContext());
        if (list == null) {
            list = Collections.unmodifiableList(Arrays.asList(Architecture.I32, Architecture.I64));
            cache.put(this.getContext(), list);
        }
        return list;
    }
}

