/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.compute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vcloud.compute.VMSupportCapabilities;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudException;
import org.dasein.cloud.vcloud.vCloudMethod;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class vAppSupport
extends AbstractVMSupport<vCloud> {
    private static final Logger logger = vCloud.getLogger(vAppSupport.class);
    public static final String PARENT_VAPP_ID = "parentVAppId";
    private VMSupportCapabilities capabilities;

    vAppSupport(@Nonnull vCloud provider) {
        super((CloudProvider)provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.deploy");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String xml = method.get("vApp", vmId);
            if (xml != null) {
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                NodeList nodes = doc.getElementsByTagName(nsString + "VApp");
                block3: for (int i = 0; i < nodes.getLength(); ++i) {
                    NodeList links = nodes.item(i).getChildNodes();
                    for (int j = 0; j < links.getLength(); ++j) {
                        Node href;
                        Node rel;
                        Node node = links.item(j);
                        nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                        if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("deploy") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                        String endpoint = href.getNodeValue().trim();
                        String action = method.getAction(endpoint);
                        StringBuilder payload = new StringBuilder();
                        payload.append("<DeployVAppParams powerOn=\"false\" xmlns=\"http://www.vmware.com/vcloud/v1.5\"/>");
                        method.waitFor(method.post(action, endpoint, method.getMediaTypeForActionDeployVApp(), payload.toString()));
                        continue block3;
                    }
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new VMSupportCapabilities((vCloud)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getProduct");
        try {
            VirtualMachineProduct product = super.getProduct(productId);
            if (product == null && productId.startsWith("custom")) {
                String[] parts = productId.split(":");
                product = new VirtualMachineProduct();
                product.setProviderProductId(productId);
                if (parts.length == 3) {
                    product.setCpuCount(Integer.parseInt(parts[1]));
                    product.setRamSize(new Storage((Number)Integer.parseInt(parts[2]), (StorageUnit)Storage.MEGABYTE));
                } else {
                    product.setCpuCount(1);
                    product.setRamSize(new Storage((Number)512, (StorageUnit)Storage.MEGABYTE));
                }
                product.setName(productId);
                product.setDescription(productId);
            }
            VirtualMachineProduct virtualMachineProduct = product;
            return virtualMachineProduct;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private String getVDC(@Nonnull String vappId) throws CloudException, InternalException {
        NodeList nodes;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vappId);
        if (xml == null || xml.equals("")) {
            return null;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
            return null;
        }
        Node node = nodes.item(0);
        NodeList elements = node.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node href;
            Node type;
            Node rel;
            Node n = elements.item(i);
            nsString = n.getNodeName().contains(":") ? n.getNodeName().substring(0, n.getNodeName().indexOf(":") + 1) : "";
            if (!n.getNodeName().equalsIgnoreCase(nsString + "Link") || !n.hasAttributes() || (rel = n.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equals("up") || (type = n.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(method.getMediaTypeForVDC()) || (href = n.getAttributes().getNamedItem("href")) == null) continue;
            return ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getVirtualMachine");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            String xml = method.get("vApp", vmId);
            if (xml != null && !xml.equals("")) {
                NodeList vmNodes;
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                if ((vmNodes = doc.getElementsByTagName(nsString + "Vm")).getLength() < 1) {
                    VirtualMachine virtualMachine = null;
                    return virtualMachine;
                }
                Node vmNode = vmNodes.item(0);
                NodeList vmElements = vmNode.getChildNodes();
                String vdc = null;
                String parentVapp = null;
                for (int i = 0; i < vmElements.getLength(); ++i) {
                    Node href;
                    Node type;
                    Node rel;
                    Node n = vmElements.item(i);
                    nsString = n.getNodeName().contains(":") ? n.getNodeName().substring(0, n.getNodeName().indexOf(":") + 1) : "";
                    if (!n.getNodeName().equalsIgnoreCase(nsString + "Link") || !n.hasAttributes() || (rel = n.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equals("up") || (type = n.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(method.getMediaTypeForVApp()) || (href = n.getAttributes().getNamedItem("href")) == null) continue;
                    parentVapp = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
                    vdc = this.getVDC(parentVapp);
                }
                if (vdc != null) {
                    VirtualMachine virtualMachine = this.toVirtualMachine(vdc, parentVapp, vmNode, ((vCloud)this.getProvider()).getNetworkServices().getVlanSupport().listVlans());
                    return virtualMachine;
                }
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.isSubscribed");
        try {
            boolean bl = ((vCloud)this.getProvider()).testContext() != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public VirtualMachine launch(final @Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"launchVM");
        final String pw = withLaunchOptions.getBootstrapPassword();
        try {
            VirtualMachine vm;
            String vmId;
            boolean multipleVMs;
            VLAN vlan;
            final String fullname = withLaunchOptions.getHostName();
            String basename = this.validateHostName(withLaunchOptions.getHostName());
            if (basename.length() > 15) {
                throw new CloudException("The maximum name length is 15: '" + basename + "' is " + basename.length());
            }
            String vdcId = withLaunchOptions.getDataCenterId();
            if (vdcId == null) {
                for (DataCenter dc : ((vCloud)this.getProvider()).getDataCenterServices().listDataCenters(this.getContext().getRegionId())) {
                    if (!dc.isActive() || !dc.isAvailable()) continue;
                    vdcId = dc.getProviderDataCenterId();
                    break;
                }
            }
            if (vdcId == null) {
                throw new CloudException("Unable to identify a target data center for deploying VM");
            }
            final VirtualMachineProduct product = this.getProduct(withLaunchOptions.getStandardProductId());
            final vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            final MachineImage img = ((vCloud)this.getProvider()).getComputeServices().getImageSupport().getImage(withLaunchOptions.getMachineImageId());
            if (img == null) {
                throw new CloudException("No such image: " + withLaunchOptions.getMachineImageId());
            }
            StringBuilder xml = new StringBuilder();
            xml.append("<InstantiateVAppTemplateParams xmlns:ovf=\"http://schemas.dmtf.org/ovf/envelope/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"").append(withLaunchOptions.getFriendlyName()).append(" Parent vApp\" xmlns=\"http://www.vmware.com/vcloud/v1.5\" deploy=\"false\" powerOn=\"false\">");
            xml.append("<Description>").append(img.getProviderMachineImageId()).append("</Description>");
            String vlanId = withLaunchOptions.getVlanId();
            if (vlanId == null || vlanId.trim().isEmpty()) {
                String defaultVlanName = (String)img.getTag("defaultVlanName");
                String defaultVlanNameDHCP = (String)img.getTag("defaultVlanNameDHCP");
                if (defaultVlanName != null && !defaultVlanName.trim().isEmpty()) {
                    Iterable<VLAN> vlans = ((vCloud)this.getProvider()).getNetworkServices().getVlanSupport().listVlans();
                    for (VLAN vlan2 : vlans) {
                        if (!defaultVlanName.equalsIgnoreCase(vlan2.getName())) continue;
                        vlanId = vlan2.getProviderVlanId();
                    }
                    if (vlanId == null) {
                        throw new CloudException("Could not locate default vlan '" + defaultVlanName + "'");
                    }
                } else {
                    if (defaultVlanNameDHCP != null && !defaultVlanNameDHCP.trim().isEmpty()) {
                        throw new CloudException("No vlan selected and the default is DHCP-based which is not supported");
                    }
                    throw new CloudException("No vlan specified and no default.");
                }
            }
            if ((vlan = ((vCloud)this.getProvider()).getNetworkServices().getVlanSupport().getVlan(vlanId)) == null) {
                throw new CloudException("Failed to find vlan " + vlanId);
            }
            String vAppTemplateUrl = method.toURL("vAppTemplate", img.getProviderMachineImageId());
            xml.append("<Source href=\"").append(vAppTemplateUrl).append("\"/>");
            xml.append("<AllEULAsAccepted>true</AllEULAsAccepted>");
            xml.append("</InstantiateVAppTemplateParams>");
            if (logger.isDebugEnabled()) {
                try {
                    method.parseXML(xml.toString());
                    logger.debug((Object)"XML passes");
                }
                catch (Throwable t) {
                    logger.error((Object)("XML parse failure: " + t.getMessage()));
                }
            }
            String instantiateResponse = method.post("instantiateVApp", vdcId, xml.toString());
            try {
                method.waitFor(instantiateResponse);
            }
            catch (CloudException e) {
                logger.error((Object)"Error waiting for instantiateVApp task to complete", (Throwable)e);
                throw new CloudException("Error waiting for instantiateVApp task to complete");
            }
            Document composeDoc = method.parseXML(instantiateResponse);
            String docElementTagName = composeDoc.getDocumentElement().getTagName();
            final String nsString = docElementTagName.contains(":") ? docElementTagName.substring(0, docElementTagName.indexOf(":") + 1) : "";
            NodeList vapps = composeDoc.getElementsByTagName(nsString + "VApp");
            if (vapps.getLength() < 1) {
                throw new CloudException("The instantiation operation succeeded, but no vApp was present");
            }
            Node vapp = vapps.item(0);
            Node href = vapp.getAttributes().getNamedItem("href");
            String vappId = ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
            String vAppResponse = method.get("vApp", vappId);
            if (vAppResponse == null) {
                try {
                    this.undeploy(vappId);
                    method.delete("vApp", vappId);
                }
                catch (Throwable t) {
                    logger.error((Object)("Problem backing out after vApp went away: " + t.getMessage()));
                }
                throw new CloudException("vApp went away");
            }
            final Document doc = method.parseXML(vAppResponse);
            NodeList vmNodes = doc.getElementsByTagName(nsString + "Vm");
            boolean bl = multipleVMs = vmNodes.getLength() > 1;
            if (multipleVMs) {
                if (basename.length() > 13) {
                    try {
                        vCloudMethod dmethod = new vCloudMethod((vCloud)this.getProvider());
                        dmethod.delete("vApp", vappId);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Problem cleaning up vApp " + vappId + ": " + t.getMessage()));
                    }
                    throw new CloudException("Because there are multiple VMs in this vApp, the maximum name length is 13: '" + basename + "' is " + basename.length());
                }
                if (fullname.length() > 126) {
                    try {
                        vCloudMethod dmethod = new vCloudMethod((vCloud)this.getProvider());
                        dmethod.delete("vApp", vappId);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Problem cleaning up vApp " + vappId + ": " + t.getMessage()));
                    }
                    throw new CloudException("Because there are multiple VMs in this vApp, the maximum name length is 126: '" + basename + "' is " + basename.length());
                }
            } else {
                if (basename.length() > 15) {
                    throw new CloudException("The maximum name length is 15: '" + basename + "' is " + basename.length());
                }
                if (fullname.length() > 128) {
                    throw new CloudException("The maximum name length is 128: '" + basename + "' is " + basename.length());
                }
            }
            if ((vmId = this.parseVmId(vmNodes)) == null) {
                logger.error((Object)"Grabbed the vApp response before the VM was included - retrying");
                vmId = this.retryListvApp(method, vappId, nsString);
                if (vmId == null) {
                    try {
                        this.undeploy(vappId);
                        method.delete("vApp", vappId);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Problem backing out after no virtual machines exist in response: " + t.getMessage()));
                    }
                    throw new CloudException("No virtual machines exist in response");
                }
            }
            if ((vm = this.getVirtualMachine(vmId)) == null) {
                try {
                    this.undeploy(vappId);
                    method.delete("vApp", vappId);
                }
                catch (Throwable t) {
                    logger.error((Object)("Problem backing out after failing to identify VM in response: " + t.getMessage()));
                }
                throw new CloudException("Unable to identify VM " + vmId + ".");
            }
            final String fvmId = vmId;
            Thread t = new Thread(){

                @Override
                public void run() {
                    Node vapp;
                    Node href;
                    try {
                        HashMap<String, Object> metadata = withLaunchOptions.getMetaData();
                        if (metadata == null) {
                            metadata = new HashMap<String, Object>();
                        }
                        metadata.put("dsnImageId", img.getProviderMachineImageId());
                        metadata.put("dsnCreated", String.valueOf(System.currentTimeMillis()));
                        method.postMetaData("vApp", fvmId, metadata);
                    }
                    catch (Throwable warn) {
                        logger.warn((Object)("Error updating meta-data on launch: " + warn.getMessage()));
                    }
                    NodeList vapps = doc.getElementsByTagName(nsString + "VApp");
                    if (vapps.getLength() < 1) {
                        logger.error((Object)"The instantiation operation succeeded, but no vApp was present");
                    }
                    if ((href = (vapp = vapps.item(0)).getAttributes().getNamedItem("href")) != null) {
                        String vAppGetResponse;
                        Document vAppDoc;
                        String vAppResponse;
                        String vappId = ((vCloud)vAppSupport.this.getProvider()).toID(href.getNodeValue().trim());
                        try {
                            vAppResponse = method.get("vApp", vappId);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error getting vApp " + vappId), (Throwable)e);
                            return;
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error getting vApp " + vappId), (Throwable)e);
                            return;
                        }
                        if (vAppResponse == null || vAppResponse.equals("")) {
                            logger.error((Object)("vApp " + vappId + " went away"));
                        }
                        try {
                            vAppDoc = method.parseXML(vAppResponse);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error parsing vApp " + vappId + " xml: "), (Throwable)e);
                            return;
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error parsing vApp " + vappId + " xml: "), (Throwable)e);
                            return;
                        }
                        String docElementTagName = vAppDoc.getDocumentElement().getTagName();
                        String nsString2 = "";
                        if (docElementTagName.contains(":")) {
                            nsString2 = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                        }
                        if ((vapps = vAppDoc.getElementsByTagName(nsString2 + "VApp")).getLength() < 1) {
                            logger.error((Object)("No VApp in vApp request for " + vappId));
                        }
                        vapp = vapps.item(0);
                        NodeList tasks = vapp.getChildNodes();
                        for (int i = 0; i < tasks.getLength(); ++i) {
                            Node task = tasks.item(i);
                            nsString2 = task.getNodeName().contains(":") ? task.getNodeName().substring(0, task.getNodeName().indexOf(":") + 1) : "";
                            if (!task.getNodeName().equalsIgnoreCase(nsString2 + "Task") || (href = task.getAttributes().getNamedItem("href")) == null) continue;
                            try {
                                method.waitFor(href.getNodeValue().trim());
                                continue;
                            }
                            catch (CloudException e) {
                                logger.error((Object)"Error waiting for task to complete.", (Throwable)e);
                            }
                        }
                        try {
                            vAppGetResponse = method.get("vApp", vappId);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error getting vApp " + vappId), (Throwable)e);
                            return;
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error getting vApp " + vappId), (Throwable)e);
                            return;
                        }
                        if (vAppGetResponse == null) {
                            logger.error((Object)"vApp went away");
                        }
                        try {
                            vAppDoc = method.parseXML(vAppGetResponse);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error parsing vApp " + vappId + " xml: "), (Throwable)e);
                            return;
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error parsing vApp " + vappId + " xml: "), (Throwable)e);
                            return;
                        }
                        docElementTagName = vAppDoc.getDocumentElement().getTagName();
                        nsString2 = "";
                        if (docElementTagName.contains(":")) {
                            nsString2 = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                        }
                        if ((vapps = vAppDoc.getElementsByTagName(nsString2 + "VApp")).getLength() < 1) {
                            logger.error((Object)"vApp went away");
                        }
                        vapp = vapps.item(0);
                        NodeList attributes = vapp.getChildNodes();
                        String vmId = null;
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            Node attribute = attributes.item(i);
                            nsString2 = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                            if (attribute.getNodeName().equals(nsString2 + "Children") && attribute.hasChildNodes()) {
                                NodeList children = attribute.getChildNodes();
                                int count = 1;
                                for (int j = 0; j < children.getLength(); ++j) {
                                    Node vm = children.item(j);
                                    nsString2 = vm.getNodeName().contains(":") ? vm.getNodeName().substring(0, vm.getNodeName().indexOf(":") + 1) : "";
                                    if (!vm.getNodeName().equalsIgnoreCase(nsString2 + "Vm") || !vm.hasAttributes() || (href = vm.getAttributes().getNamedItem("href")) == null) continue;
                                    String suffix = multipleVMs ? "-" + count : "";
                                    ++count;
                                    String vmUrl = href.getNodeValue().trim();
                                    vmId = ((vCloud)vAppSupport.this.getProvider()).toID(vmUrl);
                                    StringBuilder guestXml = new StringBuilder();
                                    guestXml.append("<GuestCustomizationSection xmlns=\"http://www.vmware.com/vcloud/v1.5\" ");
                                    guestXml.append(" xmlns:ovf=\"http://schemas.dmtf.org/ovf/envelope/1\" ovf:required=\"false\">");
                                    guestXml.append("<Info xmlns=\"http://schemas.dmtf.org/ovf/envelope/1\">Specifies Guest OS Customization Settings</Info>");
                                    guestXml.append("<Enabled>true</Enabled>");
                                    guestXml.append("<ChangeSid>").append(String.valueOf(img.getPlatform().isWindows())).append("</ChangeSid>");
                                    guestXml.append("<VirtualMachineId>").append(UUID.randomUUID().toString()).append("</VirtualMachineId>");
                                    guestXml.append("<JoinDomainEnabled>false</JoinDomainEnabled>");
                                    guestXml.append("<UseOrgSettings>false</UseOrgSettings>");
                                    guestXml.append("<AdminPasswordEnabled>true</AdminPasswordEnabled>");
                                    if (pw != null) {
                                        guestXml.append("<AdminPassword>").append(vCloud.escapeXml(pw)).append("</AdminPassword>");
                                    } else {
                                        guestXml.append("<AdminPasswordAuto>true</AdminPasswordAuto>");
                                    }
                                    guestXml.append("<ResetPasswordRequired>false</ResetPasswordRequired>");
                                    String userData = withLaunchOptions.getUserData();
                                    if (userData != null && userData.length() > 0) {
                                        guestXml.append("<CustomizationScript>").append(vCloud.escapeXml(userData)).append("</CustomizationScript>");
                                    } else {
                                        String customizationScript = vAppSupport.this.parseCustomizationScript(vm);
                                        if (customizationScript != null) {
                                            guestXml.append("<CustomizationScript>").append(vCloud.escapeXml(customizationScript)).append("</CustomizationScript>");
                                        }
                                    }
                                    guestXml.append("<ComputerName>").append(vCloud.escapeXml(vAppSupport.this.validateHostName(withLaunchOptions.getHostName() + suffix))).append("</ComputerName>");
                                    guestXml.append("</GuestCustomizationSection>");
                                    try {
                                        method.waitFor(method.put("guestCustomizationSection", vmUrl + "/guestCustomizationSection", method.getMediaTypeForGuestCustomizationSection(), guestXml.toString()));
                                    }
                                    catch (CloudException e) {
                                        logger.error((Object)("Error configuring guest for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    catch (InternalException e) {
                                        logger.error((Object)("Error configuring guest for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    StringBuilder vmXml = new StringBuilder();
                                    vmXml.append("<vcloud:Vm xmlns:vcloud=\"http://www.vmware.com/vcloud/v1.5\" ");
                                    vmXml.append("name=\"").append(vCloud.escapeXml(fullname + suffix)).append("\">");
                                    vmXml.append("<vcloud:Description>").append(withLaunchOptions.getDescription()).append("</vcloud:Description>");
                                    vmXml.append("</vcloud:Vm>");
                                    try {
                                        method.waitFor(method.put("", vmUrl, method.getMediaTypeForVM(), vmXml.toString()));
                                    }
                                    catch (CloudException e) {
                                        logger.error((Object)("Error configuring vm for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    catch (InternalException e) {
                                        logger.error((Object)("Error configuring vm for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    if (product == null) break;
                                    StringBuilder xml = new StringBuilder();
                                    xml.append("<vcloud:Item xmlns:vcloud=\"http://www.vmware.com/vcloud/v1.5\" xmlns:rasd=\"http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData\" vcloud:type=\"application/vnd.vmware.vcloud.rasdItem+xml\" vcloud:href=\"").append(vmUrl).append("/virtualHardwareSection/cpu\">");
                                    xml.append("<rasd:AllocationUnits>hertz * 10^6</rasd:AllocationUnits>");
                                    xml.append("<rasd:Description>Number of Virtual CPUs</rasd:Description>");
                                    xml.append("<rasd:ElementName>").append(String.valueOf(product.getCpuCount())).append(" virtual CPU(s)</rasd:ElementName>");
                                    xml.append("<rasd:InstanceID>1</rasd:InstanceID>");
                                    xml.append("<rasd:Reservation>0</rasd:Reservation>");
                                    xml.append("<rasd:ResourceType>3</rasd:ResourceType>");
                                    xml.append("<rasd:VirtualQuantity>").append(String.valueOf(product.getCpuCount())).append("</rasd:VirtualQuantity>");
                                    xml.append("<rasd:Weight>0</rasd:Weight>");
                                    xml.append("<vcloud:Link href=\"").append(vmUrl).append("/virtualHardwareSection/cpu\" rel=\"edit\" type=\"application/vnd.vmware.vcloud.rasdItem+xml\"/>");
                                    xml.append("</vcloud:Item>");
                                    try {
                                        method.waitFor(method.put("virtualHardwareSection/cpu", vmUrl + "/virtualHardwareSection/cpu", method.getMediaTypeForRasdItem(), xml.toString()));
                                    }
                                    catch (CloudException e) {
                                        logger.error((Object)("Error configuring virtual hardware cpu for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    catch (InternalException e) {
                                        logger.error((Object)("Error configuring virtual hardware cpu for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    xml = new StringBuilder();
                                    xml.append("<vcloud:Item xmlns:vcloud=\"http://www.vmware.com/vcloud/v1.5\" xmlns:rasd=\"http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData\" vcloud:type=\"application/vnd.vmware.vcloud.rasdItem+xml\" vcloud:href=\"").append(vmUrl).append("/virtualHardwareSection/memory\">");
                                    xml.append("<rasd:AllocationUnits>byte * 2^20</rasd:AllocationUnits>");
                                    xml.append("<rasd:Description>Memory Size</rasd:Description>");
                                    xml.append("<rasd:ElementName>").append(product.getRamSize().toString()).append("</rasd:ElementName>");
                                    xml.append("<rasd:InstanceID>2</rasd:InstanceID>");
                                    xml.append("<rasd:Reservation>0</rasd:Reservation>");
                                    xml.append("<rasd:ResourceType>4</rasd:ResourceType>");
                                    xml.append("<rasd:VirtualQuantity>").append(String.valueOf(product.getRamSize().intValue())).append("</rasd:VirtualQuantity>");
                                    xml.append("<rasd:Weight>0</rasd:Weight>");
                                    xml.append("<vcloud:Link href=\"").append(vmUrl).append("/virtualHardwareSection/memory\" rel=\"edit\" type=\"application/vnd.vmware.vcloud.rasdItem+xml\"/>");
                                    xml.append("</vcloud:Item>");
                                    try {
                                        method.waitFor(method.put("virtualHardwareSection/memory", vmUrl + "/virtualHardwareSection/memory", method.getMediaTypeForRasdItem(), xml.toString()));
                                    }
                                    catch (CloudException e) {
                                        logger.error((Object)("Error configuring virtual hardware memory for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    catch (InternalException e) {
                                        logger.error((Object)("Error configuring virtual hardware memory for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    if (vlan == null) break;
                                    xml = new StringBuilder();
                                    xml.append("<NetworkConnectionSection href=\"").append(vmUrl).append("/networkConnectionSection/").append("\" ");
                                    xml.append("xmlns=\"http://www.vmware.com/vcloud/v1.5\" ");
                                    xml.append(" type=\"").append(method.getMediaTypeForNetworkConnectionSection()).append("\">");
                                    xml.append("<Info xmlns=\"http://schemas.dmtf.org/ovf/envelope/1\">Specifies the available VM network connections</Info>");
                                    xml.append("<PrimaryNetworkConnectionIndex>0</PrimaryNetworkConnectionIndex>");
                                    xml.append("<NetworkConnection network=\"").append(vCloud.escapeXml(vlan.getName())).append("\">");
                                    xml.append("<NetworkConnectionIndex>0</NetworkConnectionIndex>");
                                    xml.append("<IsConnected>true</IsConnected>");
                                    xml.append("<IpAddressAllocationMode>POOL</IpAddressAllocationMode>");
                                    xml.append("</NetworkConnection>");
                                    xml.append("</NetworkConnectionSection>");
                                    try {
                                        method.waitFor(method.put("networkConnectionSection", vmUrl + "/networkConnectionSection", method.getMediaTypeForNetworkConnectionSection(), xml.toString()));
                                        break;
                                    }
                                    catch (CloudException e) {
                                        logger.error((Object)("Error configuring virtual hardware for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                    catch (InternalException e) {
                                        logger.error((Object)("Error configuring virtual hardware for vApp " + vappId), (Throwable)e);
                                        return;
                                    }
                                }
                            }
                            if (vmId != null) break;
                        }
                        if (vmId == null) {
                            logger.error((Object)("No virtual machines exist in " + vappId));
                        }
                        try {
                            vAppSupport.this.deploy(vappId);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error deploying vApp " + vappId), (Throwable)e);
                            return;
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error deploying vApp " + vappId), (Throwable)e);
                            return;
                        }
                        try {
                            vAppSupport.this.startVapp(vappId, true);
                        }
                        catch (CloudException e) {
                            logger.error((Object)("Error starting vApp " + vappId), (Throwable)e);
                        }
                        catch (InternalException e) {
                            logger.error((Object)("Error starting vApp " + vappId), (Throwable)e);
                        }
                    }
                }
            };
            t.setName("Configure vCloud VM " + vm.getProviderVirtualMachineId());
            t.setDaemon(true);
            t.start();
            vm.setProviderMachineImageId(img.getProviderMachineImageId());
            if (pw != null) {
                vm.setRootPassword(pw);
            }
            VirtualMachine virtualMachine = vm;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    private String parseVmId(NodeList vmNodes) {
        String vmId = "";
        Node vmNode = vmNodes.item(0);
        if (vmNode != null && vmNode.hasAttributes()) {
            Node vmHref = vmNode.getAttributes().getNamedItem("href");
            if (vmHref != null) {
                String vmUrl = vmHref.getNodeValue().trim();
                vmId = ((vCloud)this.getProvider()).toID(vmUrl);
            } else {
                vmId = null;
            }
        } else {
            vmId = null;
        }
        return vmId;
    }

    private String retryListvApp(vCloudMethod method, String vappId, String nsString) throws CloudException, InternalException {
        String retryResponse = method.get("vApp", vappId);
        Document retryDoc = method.parseXML(retryResponse);
        String vmId = this.parseVmId(retryDoc.getElementsByTagName(nsString + "Vm"));
        return vmId;
    }

    private String parseCustomizationScript(@Nonnull Node vm) {
        NodeList attributes = vm.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!attribute.getNodeName().equalsIgnoreCase("GuestCustomizationSection") || !attribute.hasChildNodes()) continue;
            NodeList elements = attribute.getChildNodes();
            for (int j = 0; j < elements.getLength(); ++j) {
                String customizationScript;
                Node element = elements.item(j);
                if (!element.getNodeName().equalsIgnoreCase("CustomizationScript") || !element.hasChildNodes() || (customizationScript = element.getFirstChild().getNodeValue().trim()) == null) continue;
                return customizationScript;
            }
        }
        return null;
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVMProducts");
        try {
            block17: {
                block16: {
                    cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)("products" + architecture.name()), VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
                    products = cache.get(this.getContext());
                    if (products != null) break block17;
                    list = new ArrayList<VirtualMachineProduct>();
                    resource = ((vCloud)this.getProvider()).getVMProductsResource();
                    input = vAppSupport.class.getResourceAsStream(resource);
                    if (input == null) ** GOTO lbl63
                    reader = new BufferedReader(new InputStreamReader(input));
                    json = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        json.append(line);
                        json.append("\n");
                    }
                    arr = new JSONArray(json.toString());
                    toCache = null;
                    for (i = 0; i < arr.length(); ++i) {
                        productSet = arr.getJSONObject(i);
                        if (!productSet.has("cloud")) continue;
                        cloud = productSet.getString("cloud");
                        if (!productSet.has("provider")) continue;
                        provider = productSet.getString("provider");
                        if (!productSet.has("products")) continue;
                        if (toCache == null || provider.equals("default") && cloud.equals("default")) {
                            toCache = productSet;
                        }
                        if (!provider.equalsIgnoreCase(((vCloud)this.getProvider()).getProviderName()) || !cloud.equalsIgnoreCase(((vCloud)this.getProvider()).getCloudName())) continue;
                        toCache = productSet;
                        break;
                    }
                    if (toCache != null) break block16;
                    vAppSupport.logger.warn((Object)"No products were defined");
                    i = Collections.emptyList();
                    return i;
                }
                try {
                    block18: {
                        plist = toCache.getJSONArray("products");
                        for (i = 0; i < plist.length(); ++i) {
                            product = plist.getJSONObject(i);
                            supported = false;
                            if (product.has("architectures")) {
                                architectures = product.getJSONArray("architectures");
                                for (j = 0; j < architectures.length(); ++j) {
                                    a = architectures.getString(j);
                                    if (!architecture.name().equals(a)) continue;
                                    supported = true;
                                    break;
                                }
                            }
                            if (!supported) continue;
                            if (product.has("excludesRegions")) {
                                regions = product.getJSONArray("excludesRegions");
                                for (j = 0; j < regions.length(); ++j) {
                                    r = regions.getString(j);
                                    if (!r.equals(this.getContext().getRegionId())) continue;
                                    supported = false;
                                    break;
                                }
                            }
                            if (!supported || (prd = this.toProduct(product)) == null) continue;
                            list.add(prd);
                        }
                        break block18;
lbl63:
                        // 1 sources

                        vAppSupport.logger.warn((Object)("No standard products resource exists for " + resource));
                    }
                    products = list;
                    cache.put(this.getContext(), products);
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            var4_4 = products;
            return var4_4;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"architectures", Architecture.class, (CacheLevel)CacheLevel.CLOUD);
        ArrayList<Architecture> list = cache.get(this.getContext());
        if (list == null) {
            ArrayList<Architecture> a = new ArrayList<Architecture>();
            a.add(Architecture.I32);
            a.add(Architecture.I64);
            list = a;
            cache.put(this.getContext(), Collections.unmodifiableList(a));
        }
        return list;
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        ((vCloud)this.getProvider()).hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<VirtualMachine>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<VirtualMachine> iterator) throws Exception {
                try {
                    APITrace.begin((CloudProvider)vAppSupport.this.getProvider(), (String)"VM.listVirtualMachines");
                    try {
                        Iterable<VLAN> vlans = ((vCloud)vAppSupport.this.getProvider()).getNetworkServices().getVlanSupport().listVlans();
                        vCloudMethod method = new vCloudMethod((vCloud)vAppSupport.this.getProvider());
                        for (DataCenter dc : method.listDataCenters()) {
                            NodeList vdcs;
                            String xml = method.get("vdc", dc.getProviderDataCenterId());
                            if (xml == null || xml.equals("")) continue;
                            Document doc = method.parseXML(xml);
                            String docElementTagName = doc.getDocumentElement().getTagName();
                            String nsString = "";
                            if (docElementTagName.contains(":")) {
                                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                            }
                            if ((vdcs = doc.getElementsByTagName(nsString + "Vdc")).getLength() <= 0) continue;
                            NodeList attributes = vdcs.item(0).getChildNodes();
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                Node attribute = attributes.item(i);
                                nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                                if (!attribute.getNodeName().equalsIgnoreCase(nsString + "ResourceEntities") || !attribute.hasChildNodes()) continue;
                                NodeList resources = attribute.getChildNodes();
                                for (int j = 0; j < resources.getLength(); ++j) {
                                    Node type;
                                    Node resource = resources.item(j);
                                    if (!resource.getNodeName().equalsIgnoreCase(nsString + "ResourceEntity") || !resource.hasAttributes() || (type = resource.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().equalsIgnoreCase(method.getMediaTypeForVApp())) continue;
                                    Node href = resource.getAttributes().getNamedItem("href");
                                    vAppSupport.this.loadVmsFor(dc.getProviderDataCenterId(), ((vCloud)vAppSupport.this.getProvider()).toID(href.getNodeValue().trim()), (Jiterator<VirtualMachine>)iterator, vlans);
                                }
                            }
                        }
                    }
                    finally {
                        APITrace.end();
                    }
                }
                finally {
                    ((vCloud)vAppSupport.this.getProvider()).release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    private void loadVmsFor(@Nonnull String vdcId, @Nonnull String id, @Nonnull Jiterator<VirtualMachine> vms, @Nonnull Iterable<VLAN> vlans) throws InternalException, CloudException {
        NodeList vapps;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", id);
        if (xml == null || xml.equals("")) {
            return;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((vapps = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
            return;
        }
        NodeList attributes = vapps.item(0).getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
            if (!attribute.getNodeName().equals(nsString + "Children") || !attribute.hasChildNodes()) continue;
            NodeList children = attribute.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                VirtualMachine vm;
                Node vmNode = children.item(j);
                if (!vmNode.getNodeName().equalsIgnoreCase(nsString + "Vm") || !vmNode.hasAttributes() || (vm = this.toVirtualMachine(vdcId, id, vmNode, vlans)) == null) continue;
                vms.push((Object)vm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        block7: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.reboot");
            try {
                Node vmNode;
                NodeList nodes;
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                String xml = method.get("vApp", vmId);
                if (xml == null) break block7;
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() > 0) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node href;
                        Node rel;
                        Node node = nodes.item(i);
                        nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                        if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("power:reboot") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                        String endpoint = href.getNodeValue().trim();
                        String action = method.getAction(endpoint);
                        method.post(action, endpoint, null, null);
                        break block7;
                    }
                    break block7;
                }
                nodes = doc.getElementsByTagName(nsString + "Vm");
                if (nodes.getLength() <= 0 || (vmNode = nodes.item(0)) == null || !vmNode.hasChildNodes()) break block7;
                NodeList links = vmNode.getChildNodes();
                for (int i = 0; i < links.getLength(); ++i) {
                    Node href;
                    Node rel;
                    Node link = links.item(i);
                    if (!link.getNodeName().equalsIgnoreCase(nsString + "Link") || !link.hasAttributes() || (rel = link.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("power:reboot") || (href = link.getAttributes().getNamedItem("href")) == null) continue;
                    String endpoint = href.getNodeValue().trim();
                    String action = method.getAction(endpoint);
                    method.post(action, endpoint, null, null);
                    break;
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.resume");
        try {
            this.startVapp(vmId, true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.start");
        try {
            this.startVapp(vmId, true);
        }
        finally {
            APITrace.end();
        }
    }

    private void startVapp(@Nonnull String vappId, boolean wait) throws CloudException, InternalException {
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vappId);
        if (xml != null) {
            NodeList nodes;
            Document doc = method.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
                nodes = doc.getElementsByTagName(nsString + "Vm");
            }
            block0: for (int i = 0; i < nodes.getLength(); ++i) {
                NodeList links = nodes.item(i).getChildNodes();
                for (int j = 0; j < links.getLength(); ++j) {
                    Node href;
                    Node rel;
                    Node node = links.item(j);
                    nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                    if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("power:powerOn") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                    String endpoint = href.getNodeValue().trim();
                    String action = method.getAction(endpoint);
                    String task = method.post(action, endpoint, null, null);
                    if (!wait) continue block0;
                    method.waitFor(task);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String vmId, boolean force) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.stop");
        try {
            this.stopVappOrVm(vmId, force);
        }
        finally {
            APITrace.end();
        }
    }

    private void stopVappOrVm(@Nonnull String id, boolean force) throws CloudException, InternalException {
        NodeList nodes;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", id);
        if (xml == null) {
            throw new CloudException("No information returned for ID: " + id);
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() >= 1) {
            if (force) {
                this.undeploy(id);
            } else {
                this.undeploy(id, "shutdown");
            }
            return;
        }
        nodes = doc.getElementsByTagName(nsString + "Vm");
        String vAppId = this.parseParentVappId(nodes, method);
        if (vAppId == null) {
            throw new CloudException("No parent vApp ID found for: " + id);
        }
        this.stopVappOrOneVm(vAppId, id, force);
    }

    private void stopVappOrOneVm(String vAppId, String vmId, boolean force) throws CloudException, InternalException {
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vAppId);
        if (xml == null) {
            throw new CloudException("No information returned for ID: " + vAppId);
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        NodeList nodes = doc.getElementsByTagName(nsString + "VApp");
        NodeList attributes = nodes.item(0).getChildNodes();
        int count = 0;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
            if (!attribute.getNodeName().equals(nsString + "Children") || !attribute.hasChildNodes()) continue;
            NodeList children = attribute.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node vmNode = children.item(j);
                if (!vmNode.getNodeName().equalsIgnoreCase(nsString + "Vm") || !vmNode.hasAttributes()) continue;
                ++count;
            }
        }
        String powerAction = null;
        if (!force) {
            powerAction = "shutdown";
        }
        if (count > 1) {
            this.undeploy(vmId, powerAction);
        } else if (count == 1) {
            this.undeploy(vAppId, powerAction);
        } else {
            throw new CloudException("Expected at least one VM");
        }
    }

    private void stop(String vAppId, @Nonnull String vmId, boolean force, boolean wait, boolean killByVM) throws CloudException, InternalException {
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vmId);
        if (xml != null) {
            NodeList nodes;
            Document doc = method.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
                nodes = doc.getElementsByTagName(nsString + "Vm");
            }
            block0: for (int i = 0; i < nodes.getLength(); ++i) {
                NodeList links = nodes.item(i).getChildNodes();
                for (int j = 0; j < links.getLength(); ++j) {
                    String task;
                    String action;
                    String endpoint;
                    Node href;
                    Node node = links.item(j);
                    nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                    if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes()) continue;
                    Node rel = node.getAttributes().getNamedItem("rel");
                    if (force && rel != null && rel.getNodeValue().trim().equalsIgnoreCase("power:powerOff")) {
                        href = node.getAttributes().getNamedItem("href");
                        if (href == null) continue;
                        endpoint = href.getNodeValue().trim();
                        action = method.getAction(endpoint);
                        task = method.post(action, endpoint, null, null);
                        if (!wait) continue block0;
                        method.waitFor(task);
                        continue block0;
                    }
                    if (force || rel == null || !rel.getNodeValue().trim().equalsIgnoreCase("power:shutdown") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                    endpoint = href.getNodeValue().trim();
                    action = method.getAction(endpoint);
                    task = method.post(action, endpoint, null, null);
                    if (!wait) continue block0;
                    method.waitFor(task);
                    continue block0;
                }
            }
        }
    }

    private String parseParentVappId(NodeList nodes, vCloudMethod method) {
        String nsString = "";
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeList links = nodes.item(i).getChildNodes();
            for (int j = 0; j < links.getLength(); ++j) {
                Node href;
                Node type;
                Node rel;
                Node node = links.item(j);
                nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("up") || (type = node.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(method.getMediaTypeForVApp()) || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                return ((vCloud)this.getProvider()).toID(href.getNodeValue().trim());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.suspend");
        try {
            this.suspendVapp(vmId);
        }
        finally {
            APITrace.end();
        }
    }

    private void suspendVapp(@Nonnull String vappId) throws CloudException, InternalException {
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vappId);
        if (xml != null) {
            NodeList nodes;
            Document doc = method.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
                nodes = doc.getElementsByTagName(nsString + "Vm");
            }
            block0: for (int i = 0; i < nodes.getLength(); ++i) {
                NodeList links = nodes.item(i).getChildNodes();
                for (int j = 0; j < links.getLength(); ++j) {
                    Node href;
                    Node rel;
                    Node node = links.item(j);
                    nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                    if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("power:suspend") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                    String endpoint = href.getNodeValue().trim();
                    String action = method.getAction(endpoint);
                    method.post(action, endpoint, null, null);
                    continue block0;
                }
            }
        }
    }

    public void terminate(@Nonnull String vmId, @Nullable String explanation) throws InternalException, CloudException {
        this.terminate(vmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String vmId) throws InternalException, CloudException {
        block10: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.terminate");
            try {
                VirtualMachine vm = this.getVirtualMachine(vmId);
                if (vm == null) {
                    throw new CloudException("No such virtual machine: " + vmId);
                }
                String vappId = (String)vm.getTag(PARENT_VAPP_ID);
                Jiterator vms = new Jiterator();
                boolean contains = false;
                int count = 0;
                this.loadVmsFor(vm.getProviderDataCenterId(), vappId, (Jiterator<VirtualMachine>)vms, ((vCloud)this.getProvider()).getNetworkServices().getVlanSupport().listVlans());
                for (VirtualMachine v : vms) {
                    ++count;
                    if (!v.getProviderVirtualMachineId().equals(vmId)) continue;
                    contains = true;
                    break;
                }
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                if (count == 1 && contains) {
                    try {
                        this.undeploy(vappId);
                    }
                    catch (Throwable t) {
                        logger.error((Object)t.getMessage());
                    }
                    method.delete("vApp", vappId);
                    break block10;
                }
                try {
                    this.undeploy(vmId);
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage());
                }
                method.delete("vApp", vmId);
            }
            finally {
                APITrace.end();
            }
        }
    }

    @Nullable
    private VirtualMachineProduct toProduct(@Nonnull JSONObject json) throws InternalException {
        VirtualMachineProduct prd = new VirtualMachineProduct();
        try {
            if (!json.has("id")) {
                return null;
            }
            prd.setProviderProductId(json.getString("id"));
            if (json.has("name")) {
                prd.setName(json.getString("name"));
            } else {
                prd.setName(prd.getProviderProductId());
            }
            if (json.has("description")) {
                prd.setDescription(json.getString("description"));
            } else {
                prd.setDescription(prd.getName());
            }
            if (json.has("cpuCount")) {
                prd.setCpuCount(json.getInt("cpuCount"));
            } else {
                prd.setCpuCount(1);
            }
            if (json.has("rootVolumeSizeInGb")) {
                prd.setRootVolumeSize(new Storage((Number)json.getInt("rootVolumeSizeInGb"), (StorageUnit)Storage.GIGABYTE));
            } else {
                prd.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            }
            if (json.has("ramSizeInMb")) {
                prd.setRamSize(new Storage((Number)json.getInt("ramSizeInMb"), (StorageUnit)Storage.MEGABYTE));
            } else {
                prd.setRamSize(new Storage((Number)512, (StorageUnit)Storage.MEGABYTE));
            }
            if (json.has("standardHourlyRates")) {
                JSONArray rates = json.getJSONArray("standardHourlyRates");
                for (int i = 0; i < rates.length(); ++i) {
                    JSONObject rate = rates.getJSONObject(i);
                    if (!rate.has("rate")) continue;
                    prd.setStandardHourlyRate((float)rate.getDouble("rate"));
                }
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return prd;
    }

    @Nonnull
    private VmState toState(@Nonnull String status) throws CloudException {
        try {
            int s = Integer.parseInt(status);
            switch (s) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    return VmState.PENDING;
                }
                case 3: {
                    return VmState.SUSPENDED;
                }
                case 4: {
                    return VmState.RUNNING;
                }
                case 8: {
                    return VmState.STOPPED;
                }
            }
            logger.warn((Object)("DEBUG: Unknown vCloud status string for " + this.getContext().getAccountNumber() + ": " + status));
            return VmState.PENDING;
        }
        catch (NumberFormatException e) {
            logger.error((Object)("DEBUG: Invalid status from vCloud for " + this.getContext().getAccountNumber() + ": " + status));
            return VmState.PENDING;
        }
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nonnull String vdcId, @Nonnull String parentVAppId, @Nonnull Node vmNode, @Nonnull Iterable<VLAN> vlans) throws CloudException, InternalException {
        VirtualMachine vm;
        block54: {
            Platform p;
            Node n = vmNode.getAttributes().getNamedItem("href");
            vm = new VirtualMachine();
            vm.setProviderMachineImageId("unknown");
            vm.setArchitecture(Architecture.I64);
            vm.setClonable(true);
            vm.setCreationTimestamp(0L);
            vm.setCurrentState(VmState.PENDING);
            vm.setImagable(true);
            vm.setLastBootTimestamp(0L);
            vm.setLastPauseTimestamp(0L);
            vm.setPausable(false);
            vm.setPersistent(true);
            vm.setPlatform(Platform.UNKNOWN);
            vm.setProviderOwnerId(this.getContext().getAccountNumber());
            vm.setRebootable(true);
            vm.setProviderRegionId(this.getContext().getRegionId());
            vm.setProviderDataCenterId(vdcId);
            if (n != null) {
                vm.setProviderVirtualMachineId(((vCloud)this.getProvider()).toID(n.getNodeValue().trim()));
            }
            if ((n = vmNode.getAttributes().getNamedItem("status")) != null) {
                vm.setCurrentState(this.toState(n.getNodeValue().trim()));
            }
            String vmName = null;
            String computerName = null;
            n = vmNode.getAttributes().getNamedItem("name");
            if (n != null) {
                vmName = n.getNodeValue().trim();
            }
            NodeList attributes = vmNode.getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node element;
                int j;
                NodeList elements;
                Node attribute = attributes.item(i);
                if (attribute.getNodeName().equalsIgnoreCase("Description") && attribute.hasChildNodes()) {
                    vm.setDescription(attribute.getFirstChild().getNodeValue().trim());
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase("GuestCustomizationSection") && attribute.hasChildNodes()) {
                    elements = attribute.getChildNodes();
                    String adminPassword = null;
                    for (j = 0; j < elements.getLength(); ++j) {
                        element = elements.item(j);
                        if (element.getNodeName().equalsIgnoreCase("AdminPassword") && element.hasChildNodes()) {
                            adminPassword = element.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!element.getNodeName().equalsIgnoreCase("ComputerName") || !element.hasChildNodes()) continue;
                        computerName = element.getFirstChild().getNodeValue().trim();
                    }
                    if (adminPassword == null) continue;
                    vm.setRootUser(vm.getPlatform().isWindows() ? "administrator" : "root");
                    vm.setRootPassword(adminPassword);
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase("DateCreated") && attribute.hasChildNodes()) {
                    vCloud cfr_ignored_0 = (vCloud)this.getProvider();
                    vm.setCreationTimestamp(vCloud.parseTime(attribute.getFirstChild().getNodeValue().trim()));
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase("NetworkConnectionSection") && attribute.hasChildNodes()) {
                    elements = attribute.getChildNodes();
                    TreeSet<String> addrs = new TreeSet<String>();
                    block8: for (j = 0; j < elements.getLength(); ++j) {
                        Node net;
                        element = elements.item(j);
                        if (!element.getNodeName().equalsIgnoreCase("NetworkConnection")) continue;
                        if (element.hasChildNodes()) {
                            NodeList parts = element.getChildNodes();
                            Boolean connected = null;
                            String addr = null;
                            for (int k = 0; k < parts.getLength(); ++k) {
                                Node part = parts.item(k);
                                if (part.getNodeName().equalsIgnoreCase("IpAddress") && part.hasChildNodes()) {
                                    addr = part.getFirstChild().getNodeValue().trim();
                                }
                                if (!part.getNodeName().equalsIgnoreCase("IsConnected") || !part.hasChildNodes()) continue;
                                connected = part.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                            }
                            if ((connected == null || connected.booleanValue()) && addr != null) {
                                addrs.add(addr);
                            }
                        }
                        if (!element.hasAttributes() || (net = element.getAttributes().getNamedItem("network")) == null) continue;
                        String netNameOrId = net.getNodeValue().trim();
                        boolean compat = ((vCloud)this.getProvider()).isCompat();
                        for (VLAN vlan : vlans) {
                            boolean matches = false;
                            if (!compat && vlan.getProviderVlanId().equals(netNameOrId)) {
                                matches = true;
                            } else if (compat && vlan.getProviderVlanId().equals("/network/" + netNameOrId)) {
                                matches = true;
                            } else if (vlan.getName().equals(netNameOrId)) {
                                matches = true;
                            }
                            if (!matches) continue;
                            vm.setProviderVlanId(vlan.getProviderVlanId());
                            continue block8;
                        }
                    }
                    if (addrs.size() <= 0) continue;
                    if (addrs.size() == 1) {
                        RawAddress a = new RawAddress((String)addrs.iterator().next());
                        if (a.isPublicIpAddress()) {
                            vm.setPublicAddresses(new RawAddress[]{a});
                            continue;
                        }
                        vm.setPrivateAddresses(new RawAddress[]{a});
                        continue;
                    }
                    ArrayList<RawAddress> pub = new ArrayList<RawAddress>();
                    ArrayList<RawAddress> priv = new ArrayList<RawAddress>();
                    for (String addr : addrs) {
                        RawAddress r = new RawAddress(addr);
                        if (r.isPublicIpAddress()) {
                            pub.add(r);
                            continue;
                        }
                        priv.add(r);
                    }
                    if (priv.size() > 0) {
                        vm.setPrivateAddresses(priv.toArray(new RawAddress[priv.size()]));
                    }
                    if (pub.size() <= 0) continue;
                    vm.setPublicAddresses(pub.toArray(new RawAddress[pub.size()]));
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase("ovf:OperatingSystemSection") && attribute.hasChildNodes()) {
                    NodeList os = attribute.getChildNodes();
                    for (int j2 = 0; j2 < os.getLength(); ++j2) {
                        Node osdesc = os.item(j2);
                        if (!osdesc.getNodeName().equalsIgnoreCase("ovf:Description") || !osdesc.hasChildNodes()) continue;
                        String desc = osdesc.getFirstChild().getNodeValue();
                        vm.setPlatform(Platform.guess((String)desc));
                        if (!desc.contains("32") && (!desc.contains("x86") || desc.contains("64"))) continue;
                        vm.setArchitecture(Architecture.I32);
                    }
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase("ovf:VirtualHardwareSection") || !attribute.hasChildNodes()) continue;
                NodeList hardware = attribute.getChildNodes();
                int memory = 0;
                int cpu = 0;
                for (int j3 = 0; j3 < hardware.getLength(); ++j3) {
                    Node item = hardware.item(j3);
                    if (!item.getNodeName().equalsIgnoreCase("ovf:item") || !item.hasChildNodes()) continue;
                    NodeList bits = item.getChildNodes();
                    String rt = null;
                    int qty = 0;
                    for (int k = 0; k < bits.getLength(); ++k) {
                        Node bit = bits.item(k);
                        if (bit.getNodeName().equalsIgnoreCase("rasd:ResourceType") && bit.hasChildNodes()) {
                            rt = bit.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!bit.getNodeName().equalsIgnoreCase("rasd:VirtualQuantity") || !bit.hasChildNodes()) continue;
                        try {
                            qty = Integer.parseInt(bit.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                    }
                    if (rt == null) continue;
                    if (rt.equals("3")) {
                        cpu = qty;
                        continue;
                    }
                    if (!rt.equals("4")) continue;
                    memory = qty;
                }
                VirtualMachineProduct product = null;
                for (VirtualMachineProduct prd : this.listProducts(Architecture.I64)) {
                    if (prd.getCpuCount() != cpu || memory != prd.getRamSize().intValue()) continue;
                    product = prd;
                    break;
                }
                if (product == null) {
                    vm.setProductId("custom:" + cpu + ":" + memory);
                    continue;
                }
                vm.setProductId(product.getProviderProductId());
            }
            if (vm.getProviderVirtualMachineId() == null) {
                return null;
            }
            if (vmName != null) {
                vm.setName(vmName);
            } else if (computerName != null) {
                vm.setName(computerName);
            } else {
                vm.setName(vm.getProviderVirtualMachineId());
            }
            if (vm.getDescription() == null) {
                vm.setDescription(vm.getName());
            }
            if ((p = vm.getPlatform()) == null || p.equals((Object)Platform.UNKNOWN) || p.equals((Object)Platform.UNIX)) {
                p = Platform.guess((String)(vm.getName() + " " + vm.getDescription()));
                if (Platform.UNIX.equals((Object)vm.getPlatform())) {
                    if (p.isUnix()) {
                        vm.setPlatform(p);
                    }
                } else {
                    vm.setPlatform(p);
                }
            }
            try {
                String t;
                vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
                String xml = method.get("vApp", vm.getProviderVirtualMachineId() + "/metadata");
                if (xml == null || xml.equals("")) break block54;
                method.parseMetaData((Taggable)vm, xml);
                if (vm.getCreationTimestamp() < 1L && (t = (String)vm.getTag("dsnCreated")) != null) {
                    try {
                        vm.setCreationTimestamp(Long.parseLong(t));
                    }
                    catch (Throwable parseWarning) {
                        if (logger.isDebugEnabled()) {
                            logger.warn((Object)"Failed to parse creation timestamp.", parseWarning);
                        }
                        logger.warn((Object)"Failed to parse creation timestamp.");
                    }
                }
                t = (String)vm.getTag("dsnImageId");
                logger.debug((Object)("dsnImageId = " + t));
                if (t != null && "unknown".equals(vm.getProviderMachineImageId())) {
                    vm.setProviderMachineImageId(t);
                    logger.debug((Object)("Set provider machine image to " + t));
                }
            }
            catch (Throwable warning) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)"Failed to get and parse vm metadata.", warning);
                }
                logger.warn((Object)"Failed to get and parse vm metadata.");
            }
        }
        vm.setTag(PARENT_VAPP_ID, parentVAppId);
        return vm;
    }

    public void undeploy(@Nonnull String vmId) throws CloudException, InternalException {
        this.undeploy(vmId, null);
    }

    public void undeploy(@Nonnull String vmId, String powerAction) throws CloudException, InternalException {
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("vApp", vmId);
        if (xml != null) {
            NodeList nodes;
            Document doc = method.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((nodes = doc.getElementsByTagName(nsString + "VApp")).getLength() < 1) {
                nodes = doc.getElementsByTagName(nsString + "Vm");
            }
            block4: for (int i = 0; i < nodes.getLength(); ++i) {
                NodeList links = nodes.item(i).getChildNodes();
                for (int j = 0; j < links.getLength(); ++j) {
                    Node href;
                    Node rel;
                    Node node = links.item(j);
                    nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                    if (!node.getNodeName().equalsIgnoreCase(nsString + "Link") || !node.hasAttributes() || (rel = node.getAttributes().getNamedItem("rel")) == null || !rel.getNodeValue().trim().equalsIgnoreCase("undeploy") || (href = node.getAttributes().getNamedItem("href")) == null) continue;
                    String endpoint = href.getNodeValue().trim();
                    String action = method.getAction(endpoint);
                    StringBuilder payload = new StringBuilder();
                    if (powerAction == null) {
                        payload.append("<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1.5\"/>");
                    } else {
                        payload.append("<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1.5\"><UndeployPowerAction>");
                        payload.append(powerAction);
                        payload.append("</UndeployPowerAction></UndeployVAppParams>");
                    }
                    try {
                        method.waitFor(method.post(action, endpoint, method.getMediaTypeForActionUndeployVApp(), payload.toString()));
                        continue block4;
                    }
                    catch (vCloudException e) {
                        if (e.getProviderCode().contains("BUSY_ENTITY")) {
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            this.undeploy(vmId);
                            return;
                        }
                        throw e;
                    }
                }
            }
        }
    }

    @Nonnull
    private String validateHostName(@Nonnull String src) {
        StringBuilder str = new StringBuilder();
        src = src.toLowerCase();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (str.length() < 1) {
                if (!Character.isLetterOrDigit(c)) continue;
                str.append(c);
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                str.append(c);
                continue;
            }
            if (c == '-') {
                str.append(c);
                continue;
            }
            if (c != ' ') continue;
            str.append('-');
        }
        if (str.length() < 1) {
            str.append("unnamed");
        }
        return str.toString();
    }
}

