/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vcloud.network.HybridVLANCapabilities;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudMethod;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HybridVLANSupport
extends AbstractVLANSupport {
    private volatile transient HybridVLANCapabilities capabilities;
    private vCloud provider;

    HybridVLANSupport(@Nonnull vCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nonnull String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        return super.createVlan(cidr, name, description, domainName, dnsServers, ntpServers);
    }

    public VLANCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new HybridVLANCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "network interface";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.getVlan");
        try {
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            for (DataCenter dc : method.listDataCenters()) {
                VLAN vlan = this.toVlan(dc.getProviderDataCenterId(), vlanId);
                if (vlan == null) continue;
                VLAN vLAN = vlan;
                return vLAN;
            }
            VLAN vLAN = null;
            return vLAN;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.isSubscribed");
        try {
            boolean bl = this.getProvider().testContext() != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String s) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlans");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"networks", VLAN.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)5, (TimePeriodUnit)TimePeriod.MINUTE));
            Iterable cached = cache.get(this.getContext());
            if (cached != null) {
                Iterable iterable = cached;
                return iterable;
            }
            vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
            ArrayList<VLAN> vlans = new ArrayList<VLAN>();
            for (DataCenter dc : method.listDataCenters()) {
                NodeList vdcs;
                String xml = method.get("vdc", dc.getProviderDataCenterId());
                if (xml == null || xml.equals("")) continue;
                Document doc = method.parseXML(xml);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                if ((vdcs = doc.getElementsByTagName(nsString + "Vdc")).getLength() <= 0) continue;
                NodeList attributes = vdcs.item(0).getChildNodes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                    if (!attribute.getNodeName().equalsIgnoreCase(nsString + "AvailableNetworks") || !attribute.hasChildNodes()) continue;
                    NodeList resources = attribute.getChildNodes();
                    for (int j = 0; j < resources.getLength(); ++j) {
                        Node resource = resources.item(j);
                        if (!resource.getNodeName().equalsIgnoreCase(nsString + "Network") || !resource.hasAttributes()) continue;
                        Node href = resource.getAttributes().getNamedItem("href");
                        VLAN vlan = this.toVlan(dc.getProviderDataCenterId(), ((vCloud)this.getProvider()).toID(href.getNodeValue().trim()));
                        if (vlan == null) continue;
                        vlans.add(vlan);
                    }
                }
            }
            cache.put(this.getContext(), vlans);
            ArrayList<VLAN> arrayList = vlans;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeInternetGatewayById(@Nonnull String s) throws CloudException, InternalException {
    }

    @Nullable
    private VLAN toVlan(@Nonnull String vdcId, @Nonnull String id) throws InternalException, CloudException {
        NodeList nets;
        vCloudMethod method = new vCloudMethod((vCloud)this.getProvider());
        String xml = method.get("network", id);
        if (xml == null || xml.equals("")) {
            return null;
        }
        Document doc = method.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((nets = doc.getElementsByTagName(nsString + "OrgVdcNetwork")).getLength() < 1 && (nets = doc.getElementsByTagName(nsString + "OrgNetwork")).getLength() < 1 && (nets = doc.getElementsByTagName(nsString + "Network")).getLength() < 1) {
            return null;
        }
        Node netNode = nets.item(0);
        if (netNode.getNodeName().contains(":")) {
            nsString = netNode.getNodeName().substring(0, netNode.getNodeName().indexOf(":") + 1);
        }
        NodeList attributes = netNode.getChildNodes();
        VLAN vlan = new VLAN();
        vlan.setProviderVlanId(id);
        vlan.setProviderDataCenterId(vdcId);
        vlan.setProviderRegionId(this.getContext().getRegionId());
        vlan.setProviderOwnerId(this.getContext().getAccountNumber());
        vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        vlan.setCurrentState(VLANState.AVAILABLE);
        Node n = netNode.getAttributes().getNamedItem(nsString + "name");
        if (n != null) {
            vlan.setName(n.getNodeValue().trim());
            vlan.setDescription(n.getNodeValue().trim());
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        String gateway = null;
        String netmask = null;
        boolean shared = false;
        String fenceMode = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
            if (attribute.getNodeName().equals(nsString + "Description") && attribute.hasChildNodes()) {
                shared = attribute.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                continue;
            }
            if (attribute.getNodeName().equals(nsString + "IsShared") && attribute.hasChildNodes()) {
                vlan.setDescription(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (attribute.getNodeName().equals(nsString + "Features") && attribute.hasChildNodes()) {
                NodeList list = attribute.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node feature = list.item(j);
                    if (!feature.getNodeName().equalsIgnoreCase(nsString + "FenceMode") || !feature.hasChildNodes()) continue;
                    fenceMode = feature.getFirstChild().getNodeValue().trim();
                }
                continue;
            }
            if (!attribute.getNodeName().equals(nsString + "Configuration") || !attribute.hasChildNodes()) continue;
            NodeList scopesList = attribute.getChildNodes();
            String[] dns = new String[10];
            String ipStart = null;
            String ipEnd = null;
            String domain = null;
            Boolean enabled = null;
            for (int j = 0; j < scopesList.getLength(); ++j) {
                Node scopesNode = scopesList.item(j);
                nsString = scopesNode.getNodeName().contains(":") ? scopesNode.getNodeName().substring(0, scopesNode.getNodeName().indexOf(":") + 1) : "";
                if (scopesNode.getNodeName().equalsIgnoreCase(nsString + "FenceMode") && scopesNode.hasChildNodes()) {
                    fenceMode = scopesNode.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if ((scopesNode.getNodeName().equalsIgnoreCase(nsString + "IpScope") || scopesNode.getNodeName().equalsIgnoreCase(nsString + "IpScopes")) && scopesNode.hasChildNodes()) {
                    Node scope = null;
                    if (scopesNode.getNodeName().equalsIgnoreCase(nsString + "IpScope")) {
                        scope = scopesNode;
                    } else {
                        NodeList scopes = scopesNode.getChildNodes();
                        for (int k = 0; k < scopes.getLength(); ++k) {
                            Node node = scopes.item(k);
                            nsString = node.getNodeName().contains(":") ? node.getNodeName().substring(0, node.getNodeName().indexOf(":") + 1) : "";
                            if (!node.getNodeName().equalsIgnoreCase(nsString + "IpScope")) continue;
                            scope = node;
                            break;
                        }
                    }
                    if (scope == null) continue;
                    NodeList saList = scope.getChildNodes();
                    block6: for (int l = 0; l < saList.getLength(); ++l) {
                        Node sa = saList.item(l);
                        nsString = sa.getNodeName().contains(":") ? sa.getNodeName().substring(0, sa.getNodeName().indexOf(":") + 1) : "";
                        if (sa.getNodeName().equalsIgnoreCase(nsString + "Gateway") && sa.hasChildNodes()) {
                            gateway = sa.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (sa.getNodeName().equalsIgnoreCase(nsString + "Netmask") && sa.hasChildNodes()) {
                            netmask = sa.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (sa.getNodeName().equalsIgnoreCase(nsString + "DnsSuffix") && sa.hasChildNodes()) {
                            domain = sa.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (sa.getNodeName().startsWith(nsString + "Dns") && sa.hasChildNodes()) {
                            String ns = sa.getFirstChild().getNodeValue().trim();
                            if (sa.getNodeName().equals(ns + "Dns")) {
                                dns[0] = ns;
                                continue;
                            }
                            try {
                                int idx = Integer.parseInt(sa.getNodeName().substring(3));
                                dns[idx] = ns;
                                continue;
                            }
                            catch (NumberFormatException e) {
                                int z = 0;
                                while (i < dns.length) {
                                    if (dns[z] == null) {
                                        dns[z] = ns;
                                        continue block6;
                                    }
                                    ++z;
                                }
                                continue;
                            }
                        }
                        if (sa.getNodeName().equalsIgnoreCase(nsString + "IsEnabled") && sa.hasChildNodes()) {
                            enabled = sa.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                            continue;
                        }
                        if (!sa.getNodeName().equalsIgnoreCase(nsString + "IpRanges") || !sa.hasChildNodes()) continue;
                        NodeList rangesList = sa.getChildNodes();
                        for (int m = 0; m < rangesList.getLength(); ++m) {
                            Node ranges = rangesList.item(m);
                            if (ranges.getNodeName().contains(":")) {
                                nsString = ranges.getNodeName().substring(0, ranges.getNodeName().indexOf(":") + 1);
                            }
                            if (!ranges.getNodeName().equalsIgnoreCase(nsString + "IpRanges") || !ranges.hasChildNodes()) continue;
                            NodeList rangeList = ranges.getChildNodes();
                            for (int o = 0; o < rangeList.getLength(); ++o) {
                                Node range = rangeList.item(o);
                                if (range.getNodeName().contains(":")) {
                                    nsString = range.getNodeName().substring(0, range.getNodeName().indexOf(":") + 1);
                                }
                                if (!range.getNodeName().equalsIgnoreCase(nsString + "IpRange") || !range.hasChildNodes()) continue;
                                NodeList addresses = range.getChildNodes();
                                for (int p = 0; p < addresses.getLength(); ++p) {
                                    Node address = addresses.item(p);
                                    if (address.getNodeName().equalsIgnoreCase(nsString + "StartAddress") && address.hasChildNodes()) {
                                        ipStart = address.getFirstChild().getNodeValue().trim();
                                        continue;
                                    }
                                    if (!address.getNodeName().equalsIgnoreCase(nsString + "EndAddress") || !address.hasChildNodes()) continue;
                                    ipEnd = address.getFirstChild().getNodeValue().trim();
                                }
                            }
                        }
                    }
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase(nsString + "Gateway") && attribute.hasChildNodes()) {
                    gateway = attribute.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase(nsString + "Netmask") || !attribute.hasChildNodes()) continue;
                netmask = attribute.getFirstChild().getNodeValue().trim();
            }
            ArrayList<String> dnsServers = new ArrayList<String>();
            for (String ns : dns) {
                if (ns == null) continue;
                dnsServers.add(ns);
            }
            vlan.setDnsServers(dnsServers.toArray(new String[dnsServers.size()]));
            vlan.setCurrentState(enabled == null || enabled != false ? VLANState.AVAILABLE : VLANState.PENDING);
            if (domain != null) {
                vlan.setDomainName(domain);
            }
            if (ipStart != null) {
                tags.put("ipStart", ipStart);
            }
            if (ipEnd == null) continue;
            tags.put("ipEnd", ipEnd);
        }
        if (fenceMode != null) {
            tags.put("fenceMode", fenceMode);
        }
        if (gateway != null) {
            tags.put("gateway", gateway);
        }
        if (netmask != null) {
            tags.put("netmask", netmask);
        }
        if (netmask != null && gateway != null) {
            vlan.setCidr(netmask, gateway);
        }
        tags.put("shared", String.valueOf(shared));
        if (vlan.getName() == null) {
            vlan.setName(vlan.getProviderVlanId());
        }
        if (vlan.getDescription() == null) {
            vlan.setDescription(vlan.getName());
        }
        vlan.setTags(tags);
        return vlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeVlan");
        try {
            super.removeVlan(vlanId);
        }
        finally {
            APITrace.end();
        }
    }
}

