/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud;

import java.util.Calendar;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.vcloud.ISO8601;
import org.dasein.cloud.vcloud.VDCServices;
import org.dasein.cloud.vcloud.compute.vCloudComputeServices;
import org.dasein.cloud.vcloud.network.vCloudNetworkServices;
import org.dasein.cloud.vcloud.vCloudMethod;

public class vCloud
extends AbstractCloud {
    private static final Logger logger = vCloud.getLogger(vCloud.class);
    public static final String ISO8601_PATTERN = "yyy-MM-dd'T'HH:mm:ss.SSSZ";

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    public static Logger getLogger(Class<?> cls) {
        String pkg = vCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("aws") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.vcloud.std." + pkg + vCloud.getLastItem(cls.getName())));
    }

    public static Logger getWireLogger(Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.vcloud.wire." + vCloud.getLastItem(cls.getPackage().getName()) + "." + vCloud.getLastItem(cls.getName())));
    }

    public static String escapeXml(String nonxml) {
        StringBuilder str = new StringBuilder();
        block9: for (int i = 0; i < nonxml.length(); ++i) {
            char c = nonxml.charAt(i);
            switch (c) {
                case '&': {
                    str.append("&amp;");
                    continue block9;
                }
                case '>': {
                    str.append("&gt;");
                    continue block9;
                }
                case '<': {
                    str.append("&lt;");
                    continue block9;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block9;
                }
                case '[': {
                    str.append("&#091;");
                    continue block9;
                }
                case ']': {
                    str.append("&#093;");
                    continue block9;
                }
                case '!': {
                    str.append("&#033;");
                    continue block9;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloudName();
        return name == null ? "Private vCloud Cloud" : name;
    }

    @Nonnull
    public vCloudComputeServices getComputeServices() {
        return new vCloudComputeServices(this);
    }

    @Nonnull
    public VDCServices getDataCenterServices() {
        return new VDCServices(this);
    }

    @Nonnull
    public vCloudNetworkServices getNetworkServices() {
        return new vCloudNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getProviderName();
        return name == null ? "VMware" : name;
    }

    @Nullable
    public String[] getVersionPreference() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("versionPreference"));
        if (value == null) {
            value = System.getProperty("vCloudVersionPreference");
        }
        if (value == null) {
            return null;
        }
        if (value.contains(",")) {
            return value.trim().split(",");
        }
        return new String[]{value};
    }

    @Nonnull
    public String getVMProductsResource() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("vmproducts"));
        if (value == null) {
            value = System.getProperty("vcloud.vmproducts");
        }
        if (value == null) {
            value = "/org/dasein/cloud/vcloud/vmproducts.json";
        }
        return value;
    }

    public boolean isCompat() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("compat"));
        if (value == null) {
            value = System.getProperty("vCloudCompat");
        }
        return value != null && value.equalsIgnoreCase("true");
    }

    public boolean isInsecure() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("insecure"));
        if (value == null) {
            value = System.getProperty("insecure");
        }
        return value != null && value.equalsIgnoreCase("true");
    }

    @Nonnegative
    public static long parseTime(@Nullable String time) throws CloudException {
        if (time == null || time.length() < 1) {
            return 0L;
        }
        Calendar cal = ISO8601.parse(time);
        if (cal == null) {
            return 0L;
        }
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testContext() {
        APITrace.begin((CloudProvider)this, (String)"testContext");
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                logger.warn((Object)"No context exists for testing");
                String string = null;
                return string;
            }
            vCloudMethod method = new vCloudMethod(this);
            method.authenticate(true);
            String string = ctx.getAccountNumber();
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String toID(@Nonnull String url) {
        String[] parts = url.split("/");
        if (parts.length > 2) {
            if (this.isCompat()) {
                return "/" + parts[parts.length - 2] + "/" + parts[parts.length - 1];
            }
            return parts[parts.length - 1];
        }
        return url;
    }

    @Nonnull
    public String toString() {
        ProviderContext ctx = this.getContext();
        return this.getProviderName() + " - " + this.getCloudName() + (ctx == null ? "" : " [" + ctx.getAccountNumber() + "]");
    }
}

